/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import progress.message.zclient.EMsgTooBigException;
import progress.message.zclient.SessionConfig;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;

    public ByteArrayDataSource(InputStream is, String type) throws IOException {
        int len;
        this.type = type;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int totalRead = 0;
        while ((len = is.read(buf)) >= 0) {
            if (SessionConfig.MAX_MSG_SIZE > 0 && (totalRead += len) > SessionConfig.MAX_MSG_SIZE) {
                throw new EMsgTooBigException(-1, SessionConfig.MAX_MSG_SIZE);
            }
            os.write(buf, 0, len);
        }
        this.data = os.toByteArray();
    }

    public ByteArrayDataSource(byte[] data, String type) {
        this.type = type;
        this.data = data;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("No data.");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("getOutputStream() not supported.");
    }

    public String getContentType() {
        return this.type;
    }

    public void setContentType(String type) {
        this.type = type;
    }

    public String getName() {
        return "";
    }

    public byte[] getContentBytes() {
        return this.data;
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.data);
    }
}

