/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.direct;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpOutResponse;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.HttpServiceException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public class DirectHttpOutResponse
extends HttpOutResponse {
    @Override
    public void buildResponse(HttpOutResponse response, URLConnection connection, HttpOutboundHandler handler) throws HttpServiceException {
        int responseCode = response.getResponseCode();
        if (connection != null) {
            String contentType;
            String key = null;
            String value = null;
            int i = 1;
            while (true) {
                key = connection.getHeaderFieldKey(i);
                value = connection.getHeaderField(i);
                if (key == null || value == null) break;
                if ("Content-Type".equalsIgnoreCase(key)) {
                    response.setProperty("Content-Type", value);
                } else if ("Content-Length".equalsIgnoreCase(key)) {
                    response.setProperty("Content-Length", value);
                } else {
                    response.setProperty(key, value);
                }
                ++i;
            }
            int len = response.getContentLength();
            if (len < 0) {
                len = connection.getContentLength();
                response.setProperty("Content-Length", Integer.toString(len));
            }
            if ((contentType = response.getContentType()) == null && (contentType = connection.getContentType()) != null) {
                response.setProperty("Content-Type", contentType);
            }
        }
        response.createMessage(handler.getContentMappings());
        if (connection == null) {
            return;
        }
        try {
            InputStream is = null;
            is = HttpOutboundHandler.isHttpErrorCode(responseCode) && !HttpHelper.isHttps(connection) ? ((HttpURLConnection)connection).getErrorStream() : connection.getInputStream();
            response.handleContent(is, response.getContentLength());
        }
        catch (Exception e) {
            throw new HttpServiceException(e);
        }
    }
}

