/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.soap;

import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.PropertyBadValueException;
import com.sonicsw.net.http.PropertyMissingException;
import com.sonicsw.net.http.direct.DirectHttpInConfig;
import com.sonicsw.net.http.direct.DirectHttpInRequest;
import com.sonicsw.net.http.soap.SonicSoapVerifier;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.SOAPPart;
import progress.message.jclient.Header;
import progress.message.jclient.Message;
import progress.message.jclient.Part;
import progress.message.jimpl.xmessage.MultipartMessage;

public class SoapHttpInRequest
extends DirectHttpInRequest {
    protected SOAPMessage m_soapMessage = null;
    private String m_soapVersion = "SOAP 1.1";

    public SoapHttpInRequest(HttpServletRequest req) {
        super(req);
    }

    @Override
    protected Message handleMessage(DirectHttpInConfig config) throws JMSException, PropertyBadValueException, PropertyMissingException, MessageHandlingException {
        this.createSoapMessage();
        return this.createJMSMessage(config);
    }

    public Message createJMSMessage(DirectHttpInConfig config) throws JMSException, PropertyBadValueException, PropertyMissingException, MessageHandlingException {
        Hashtable contentMaps = config.getContentMappings();
        this.createMessage(contentMaps);
        this.handleCommonProperties(config);
        this.handleContent(null);
        this.m_message.setStringProperty("X-HTTP-SOAPVersion", this.getSoapVersion());
        return this.m_message;
    }

    public SOAPMessage createSoapMessage() throws MessageHandlingException {
        try {
            InputStream in = this.getInputStream();
            int contentLength = this.getContentLength();
            String contentType = this.getContentType();
            this.m_charset = this.getCharacterEncoding();
            SonicSoapVerifier verifier = new SonicSoapVerifier(in, contentType);
            this.m_soapMessage = verifier.getSoapMessage();
            this.setSoapVersion(verifier.getSoapVersionString());
            return this.m_soapMessage;
        }
        catch (Exception e) {
            throw new MessageHandlingException(e.getMessage());
        }
    }

    @Override
    protected Message createMessage(Hashtable contentMaps) throws PropertyMissingException, PropertyBadValueException, JMSException, MessageHandlingException {
        String messageType = "XML";
        try {
            int attCount = this.m_soapMessage.countAttachments();
            if (attCount > 0) {
                messageType = "MULTIPART";
            } else {
                String contentType = this.getProperty("Content-Type", false);
                messageType = this.contentTypeToMessageType(contentType, contentMaps, "XML");
            }
        }
        catch (Exception e) {
            throw new MessageHandlingException("Failed to decode SOAP content");
        }
        return super.createMessage(messageType, "Content-Type");
    }

    private void handleContent(byte[] soapcontent) throws PropertyBadValueException, JMSException, MessageHandlingException {
        try {
            if (this.m_multipart) {
                progress.message.jclient.MultipartMessage mMessage = (progress.message.jclient.MultipartMessage)this.m_message;
                SOAPPart p0 = (SOAPPart)this.m_soapMessage.getSOAPPart();
                this.handleMessagePart0(mMessage, p0);
                Iterator iterator = this.m_soapMessage.getAttachments();
                while (iterator.hasNext()) {
                    AttachmentPart ap = (AttachmentPart)iterator.next();
                    this.handleMessagePart(mMessage, ap);
                }
                ((MultipartMessage)mMessage).marshal();
            } else {
                org.apache.axis.Message axisMessage = (org.apache.axis.Message)this.m_soapMessage;
                String contentString = axisMessage.getSOAPPartAsString();
                if (this.m_message instanceof BytesMessage) {
                    ((BytesMessage)this.m_message).writeBytes(contentString.getBytes());
                } else {
                    ((TextMessage)this.m_message).setText(contentString);
                }
            }
        }
        catch (Exception e) {
            throw new MessageHandlingException("Failed to decode SOAP content");
        }
    }

    private void handleMessagePart(progress.message.jclient.MultipartMessage multiMessage, AttachmentPart mimePart) throws JMSException, MessageHandlingException {
        try {
            Part messagePart = multiMessage.createPart(mimePart.getDataHandler());
            multiMessage.addPart(messagePart);
            Header msgHeader = messagePart.getHeader();
            String contentID = mimePart.getContentId();
            msgHeader.setContentId(mimePart.getContentId());
            Iterator iterator = mimePart.getNonMatchingMimeHeaders(this.getIgnoreInMimePart());
            SoapHttpInRequest.copyHttpPartToMGram(iterator, msgHeader);
        }
        catch (Exception e) {
            throw new MessageHandlingException("Failed to handle a MIME Message Part");
        }
    }

    private void handleMessagePart0(progress.message.jclient.MultipartMessage multiMessage, SOAPPart part0) throws JMSException, MessageHandlingException {
        if (part0 == null) {
            throw new MessageHandlingException("Failed to handle a MIME Message Part");
        }
        try {
            String str = part0.getAsString();
            DataHandler dh = new DataHandler((Object)str, "text/xml");
            Part messagePart = multiMessage.createPart(dh);
            multiMessage.addPart(messagePart);
            Header msgHeader = messagePart.getHeader();
            String contentID = part0.getContentId();
            msgHeader.setContentId(part0.getContentId());
            Iterator iterator = part0.getNonMatchingMimeHeaders(this.getIgnoreInMimePart());
            SoapHttpInRequest.copyHttpPartToMGram(iterator, msgHeader);
        }
        catch (Exception e) {
            throw new MessageHandlingException("Failed to handle a MIME Message Part");
        }
    }

    private static void copyHttpPartToMGram(Iterator iterator, Header msgHeader) throws JMSException {
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            msgHeader.setHeaderField(mimeHeader.getName(), mimeHeader.getValue());
            HttpConstants.DEBUG("Copying " + mimeHeader.getName() + "=" + mimeHeader.getValue() + " from HTTP part to MGRAM part", 1);
        }
    }

    public final void setSoapVersion(String version) {
        if (version != null) {
            this.m_soapVersion = version;
        }
    }

    public String getSoapVersion() {
        return this.m_soapVersion;
    }

    public SOAPMessage getSoapMessage() {
        return this.m_soapMessage;
    }
}

