/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.policy;

import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.policy.RMPolicyToken;
import java.util.ArrayList;
import org.apache.ws.policy.PrimitiveAssertion;

public class RMProcessorContext {
    public static final int NONE = 0;
    public static final int START = 1;
    public static final int COMMIT = 2;
    public static final int ABORT = 3;
    private static final String[] ACTION_NAMES = new String[]{"NONE", "START", "COMMIT", "ABORT"};
    private ArrayList tokenStack = new ArrayList();
    private int tokenStackPointer = 0;
    private ArrayList pedStack = new ArrayList();
    private int pedStackPointer = 0;
    private PrimitiveAssertion assertion = null;
    private int action = 0;

    public int getAction() {
        return this.action;
    }

    public void setAction(int act) {
        this.action = act;
    }

    public PrimitiveAssertion getAssertion() {
        return this.assertion;
    }

    public void setAssertion(PrimitiveAssertion asrt) {
        this.assertion = asrt;
    }

    public void pushRMToken(RMPolicyToken spt) {
        this.tokenStack.add(this.tokenStackPointer, spt);
        ++this.tokenStackPointer;
    }

    public RMPolicyToken popRMToken() {
        if (this.tokenStackPointer > 0) {
            --this.tokenStackPointer;
            return (RMPolicyToken)this.tokenStack.get(this.tokenStackPointer);
        }
        return null;
    }

    public RMPolicyToken readCurrentPolicyToken() {
        if (this.tokenStackPointer > 0) {
            return (RMPolicyToken)this.tokenStack.get(this.tokenStackPointer - 1);
        }
        return null;
    }

    public void pushRMPolicy(RMPolicy ped) {
        this.pedStack.add(this.pedStackPointer, ped);
        ++this.pedStackPointer;
    }

    public RMPolicy popRMPolicy() {
        if (this.pedStackPointer > 0) {
            --this.pedStackPointer;
            return (RMPolicy)this.pedStack.get(this.pedStackPointer);
        }
        return null;
    }

    public RMPolicy readCurrentRMPolicy() {
        if (this.pedStackPointer > 0) {
            return (RMPolicy)this.pedStack.get(this.pedStackPointer - 1);
        }
        return null;
    }

    public RMPolicy commitRMPolicy() {
        if (this.pedStackPointer > 1) {
            --this.pedStackPointer;
            RMPolicy ped = (RMPolicy)this.pedStack.get(this.pedStackPointer);
            --this.pedStackPointer;
            this.pedStack.add(this.pedStackPointer, ped);
            ++this.pedStackPointer;
            return ped;
        }
        return null;
    }
}

