/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.policy;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.policy.RMPolicyProcessor;
import com.sonicsw.ws.rm.policy.WSRMPConstants;
import com.sonicsw.wsp.WSPUtils;
import org.apache.ws.policy.Policy;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.xmlsoap.schemas.ws.x2004.x09.policy.OperatorContentType;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyDocument;
import org.xmlsoap.schemas.ws.x2005.x02.rm.policy.RMAssertionDocument;

public class WSRMPUtils {
    public static XmlObject getRMAssertion(PolicyDocument pdoc) {
        XmlObject rma = null;
        if (WSPUtils.isSingleton(pdoc)) {
            rma = WSPUtils.getFirstAssertion(WSPUtils.getSingletonAll(pdoc), WSRMPConstants.QN_RM_POLICY);
        }
        return rma;
    }

    public static XmlObject[] getRMAssertions(OperatorContentType content) {
        XmlObject[] assertions = null;
        assertions = content.selectPath(WSPUtils.childElementXPath(WSRMPConstants.QN_RM_POLICY));
        return assertions;
    }

    public static RMPolicy convertRMPolicy(XmlObject rma) {
        XmlObject bri;
        RMPolicy rmpol = new RMPolicy();
        if (rma == null) {
            return rmpol;
        }
        XmlObject ai = WSRMPUtils.getAcknowledgementInterval(rma);
        if (ai != null) {
            rmpol.setAcknowledgementInterval(WSRMPUtils.getMillisecondsAttrValue(ai));
        }
        if ((bri = WSRMPUtils.getBaseRetransmissionInterval(rma)) != null) {
            rmpol.setBaseRetransmissionInterval(WSRMPUtils.getMillisecondsAttrValue(bri));
        }
        rmpol.setExponentialBackoff(WSRMPUtils.getExponentialBackoff(rma));
        XmlObject it = WSRMPUtils.getInactivityTimeout(rma);
        if (it != null) {
            rmpol.setInactivityTimeout(WSRMPUtils.getMillisecondsAttrValue(it));
        }
        return rmpol;
    }

    public static RMPolicy convertRMPolicy(RMAssertionDocument.RMAssertion rma) {
        RMAssertionDocument.RMAssertion.InactivityTimeout it;
        RMAssertionDocument.RMAssertion.ExponentialBackoff eb;
        RMAssertionDocument.RMAssertion.BaseRetransmissionInterval bri;
        RMPolicy rmpol = new RMPolicy();
        if (rma == null) {
            return rmpol;
        }
        rmpol.setRMPolicyRequired(true);
        RMAssertionDocument.RMAssertion.AcknowledgementInterval ai = rma.getAcknowledgementInterval();
        if (ai != null && ai.getMilliseconds() != null) {
            rmpol.setAcknowledgementInterval(ai.getMilliseconds().longValue());
        }
        if ((bri = rma.getBaseRetransmissionInterval()) != null && bri.getMilliseconds() != null) {
            rmpol.setBaseRetransmissionInterval(bri.getMilliseconds().longValue());
        }
        if ((eb = rma.getExponentialBackoff()) != null) {
            rmpol.setExponentialBackoff(true);
        }
        if ((it = rma.getInactivityTimeout()) != null && it.getMilliseconds() != null) {
            rmpol.setInactivityTimeout(it.getMilliseconds().longValue());
        }
        return rmpol;
    }

    public static RMPolicy convertRMPolicy(Policy rma) {
        RMPolicy rmpol = new RMPolicy();
        if (rma == null) {
            return rmpol;
        }
        RMPolicyProcessor processor = new RMPolicyProcessor();
        if (processor.setup() && processor.processPolicy(rma) && (rmpol = processor.rmProcessorContext.readCurrentRMPolicy()).isRMPolicyRequired()) {
            DebugObjects.getPolicyDebug().debug("Policy present and required: " + rmpol.toString());
        }
        return rmpol;
    }

    private static String getTextContent(XmlObject xobj) {
        XmlCursor c = xobj.newCursor();
        c.toFirstChild();
        String text = c.getTextValue();
        c.dispose();
        return text;
    }

    private static long getAttributeLongValue(XmlObject attr) {
        String textValue = WSRMPUtils.getTextContent(attr);
        return Long.parseLong(textValue);
    }

    private static long getMillisecondsAttrValue(XmlObject xobj) {
        XmlObject attrObj = xobj.selectAttribute("", "Milliseconds");
        return WSRMPUtils.getAttributeLongValue(attrObj);
    }

    private static XmlObject getAcknowledgementInterval(XmlObject xobj) {
        XmlObject[] aiObjs = xobj.selectChildren(WSRMPConstants.QN_ACK_INTERVAL);
        return WSRMPUtils.retrieveObject(aiObjs);
    }

    private static XmlObject getBaseRetransmissionInterval(XmlObject xobj) {
        XmlObject[] briObjs = xobj.selectChildren(WSRMPConstants.QN_BASE_RTX_INTERVAL);
        return WSRMPUtils.retrieveObject(briObjs);
    }

    private static boolean getExponentialBackoff(XmlObject rma) {
        XmlObject[] ebObjs = rma.selectChildren(WSRMPConstants.QN_EXP_BACKOFF);
        return ebObjs.length > 0;
    }

    private static XmlObject getInactivityTimeout(XmlObject xobj) {
        XmlObject[] itObjs = xobj.selectChildren(WSRMPConstants.QN_INACTIVITY_TIMEOUT);
        return WSRMPUtils.retrieveObject(itObjs);
    }

    private static XmlObject retrieveObject(XmlObject[] itObjs) {
        if (itObjs != null && itObjs.length > 0) {
            return itObjs[0];
        }
        return null;
    }
}

