/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.protocol;

import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.Expires;
import com.sonicsw.ws.rm.protocol.IElement;
import com.sonicsw.ws.rm.protocol.Identifier;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.MessageElement;

public class Offer
extends MessageElement
implements IElement {
    private Constants RMConstants;
    private MessageElement offerElement;
    private Identifier identifier;
    private Expires expires;

    public Offer(Constants constants) {
        this.RMConstants = constants;
        this.offerElement = new MessageElement(this.RMConstants.getNSURI(), "Offer");
    }

    public Offer(MessageElement headerElement) {
        this.offerElement = headerElement;
        Iterator iterator = headerElement.getChildElements();
        while (iterator.hasNext()) {
            MessageElement childElement = (MessageElement)iterator.next();
            if (childElement.getName().equals("Identifier")) {
                this.identifier = new Identifier(childElement);
            }
            if (!childElement.getName().equals("Expires")) continue;
            this.expires = new Expires(childElement);
        }
    }

    @Override
    public MessageElement getSoapElement() throws SOAPException {
        this.offerElement.detachAllChildren();
        this.offerElement.addChildElement((SOAPElement)this.identifier.getSoapElement());
        if (this.expires != null) {
            this.offerElement.addChildElement((SOAPElement)this.expires.getSoapElement());
        }
        return this.offerElement;
    }

    public MessageElement toSOAPEnvelope(MessageElement msgElement) throws SOAPException {
        msgElement.addChildElement((SOAPElement)this.getSoapElement());
        return msgElement;
    }

    @Override
    public void addChildElement(MessageElement element) throws SOAPException {
        this.offerElement.addChildElement((SOAPElement)element);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Expires getExpires() {
        return this.expires;
    }

    public void setIdentifier(Identifier identifer) {
        this.identifier = identifer;
    }

    public void setExpires(Expires e) {
        this.expires = e;
    }
}

