/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.util.xml;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class SonicNamespaceReducer
extends ProxyReceiver {
    private NamespaceBinding[] namespaces = new NamespaceBinding[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;

    public SonicNamespaceReducer(Receiver nextReceiver) {
        super(nextReceiver);
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.nextReceiver.startElement(elemName, typeCode, location, properties);
        this.countStack[this.depth] = 0;
        if (++this.depth >= this.countStack.length) {
            int[] newstack = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, newstack, 0, this.depth);
            this.countStack = newstack;
        }
        if ((properties & 0x40) == 0) {
            this.namespace((NamespaceBindingSet)elemName.getNamespaceBinding(), 0);
        }
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        for (NamespaceBinding namespaceBinding : namespaceBindings) {
            if (!this.isNeeded(namespaceBinding)) continue;
            this.addToStack(namespaceBinding);
            int n = this.depth - 1;
            this.countStack[n] = this.countStack[n] + 1;
            this.nextReceiver.namespace((NamespaceBindingSet)namespaceBinding, properties);
        }
    }

    private boolean isNeeded(NamespaceBinding namespaceBinding) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceBinding.getURI())) {
            return false;
        }
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            if (this.namespaces[i].equals((Object)namespaceBinding)) {
                return false;
            }
            if (!this.namespaces[i].getPrefix().equals(namespaceBinding.getPrefix())) continue;
            return false;
        }
        return !namespaceBinding.equals((Object)NamespaceBinding.DEFAULT_UNDECLARATION);
    }

    private void addToStack(NamespaceBinding namespaceBinding) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            NamespaceBinding[] newlist = new NamespaceBinding[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, newlist, 0, this.namespacesSize);
            this.namespaces = newlist;
        }
        this.namespaces[this.namespacesSize++] = namespaceBinding;
    }

    public void endElement() throws XPathException {
        if (this.depth-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        int nscount = this.countStack[this.depth];
        this.namespacesSize -= nscount;
        this.nextReceiver.endElement();
    }
}

