/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.wspa;

import com.sonicsw.net.http.ws.WSDLHelper;
import com.sonicsw.wsdl.WSDLContext;
import com.sonicsw.wsdl.WSDLUtils;
import com.sonicsw.wsdl.extensions.wsp.WSPConstants;
import com.sonicsw.wsdl.extensions.wsp.WSPPolicyReference;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wsp.SecurityPolicy2002Exception;
import com.sonicsw.wsp.WSPUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.SAXException;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyDocument;

public class WSPAUtils {
    public static PolicyDocument getServicePolicy(WSDLContext wctx, Service svc) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        PolicyDocument policy = WSPUtils.newPolicyDocument();
        WSPPolicyReference[] svcPolicyRefs = WSPAUtils.getPolicyReferences(svc);
        PolicyDocument[] svcPolicyDocs = WSPUtils.dereference(wctx, svcPolicyRefs);
        return WSPUtils.merge(svcPolicyDocs);
    }

    public static PolicyDocument getEndpointPolicy(WSDLContext wctx, Port port) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        WSPPolicyReference[] portPolicyRefs = WSPAUtils.getPolicyReferences(port);
        PolicyDocument[] portPolicyDocs = WSPUtils.dereference(wctx, portPolicyRefs);
        PolicyDocument combinedPortPolicies = WSPUtils.merge(portPolicyDocs);
        WSPPolicyReference[] bindingPolicyRefs = WSPAUtils.getPolicyReferences(port.getBinding());
        PolicyDocument[] bindingPolicyDocs = WSPUtils.dereference(wctx, bindingPolicyRefs);
        PolicyDocument combinedBindingPolicies = WSPUtils.merge(bindingPolicyDocs);
        PolicyDocument[] portTypePolicyDocs = WSPAUtils.getPolicyDocuments(wctx, (AttributeExtensible)port.getBinding().getPortType());
        PolicyDocument combinedPortTypePolicies = WSPUtils.merge(portTypePolicyDocs);
        PolicyDocument endpointSubjectPolicy = WSPUtils.merge(combinedPortPolicies, WSPUtils.merge(combinedBindingPolicies, combinedPortTypePolicies));
        return endpointSubjectPolicy;
    }

    public static PolicyDocument getOperationPolicy(WSDLContext wctx, BindingOperation bindingOp) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        WSPPolicyReference[] bindingOpPolicyRefs = WSPAUtils.getPolicyReferences(bindingOp);
        PolicyDocument[] bindingOpPolicyRefDocs = WSPUtils.dereference(wctx, bindingOpPolicyRefs);
        PolicyDocument combinedBindingOpRefPolicies = WSPUtils.merge(bindingOpPolicyRefDocs);
        PolicyDocument[] bindingOpPolicies = WSPAUtils.getPolicyDocuments(wctx, (AttributeExtensible)bindingOp);
        PolicyDocument combinedBindingOpPolicies = WSPUtils.merge(bindingOpPolicies);
        PolicyDocument[] opPolicies = new PolicyDocument[]{};
        Operation op = bindingOp.getOperation();
        if (op != null) {
            opPolicies = WSPAUtils.getPolicyDocuments(wctx, (AttributeExtensible)op);
        }
        PolicyDocument combinedOpPolicies = WSPUtils.merge(opPolicies);
        PolicyDocument operationSubjectPolicy = WSPUtils.merge(combinedBindingOpRefPolicies, WSPUtils.merge(combinedBindingOpPolicies, combinedOpPolicies));
        return operationSubjectPolicy;
    }

    public static PolicyDocument getInputMessagePolicy(WSDLContext wctx, BindingInput bin, Input in) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        PolicyDocument policy = WSPUtils.newPolicyDocument();
        WSPPolicyReference[] bindingInputPolicyRefs = WSPAUtils.getPolicyReferences(bin);
        PolicyDocument[] bindingInputPolicyDocs = WSPUtils.dereference(wctx, bindingInputPolicyRefs);
        PolicyDocument combinedBindingInputPolicies = WSPUtils.merge(bindingInputPolicyDocs);
        PolicyDocument[] inputPolicies = WSPAUtils.getPolicyDocuments(wctx, (AttributeExtensible)in);
        PolicyDocument combinedInputPolicies = WSPUtils.merge(inputPolicies);
        javax.wsdl.Message msg = in.getMessage();
        PolicyDocument[] messagePolicies = new PolicyDocument[]{};
        if (msg != null) {
            messagePolicies = WSPAUtils.getPolicyDocuments(wctx, (AttributeExtensible)msg);
        }
        PolicyDocument combinedMessagePolicies = WSPUtils.merge(messagePolicies);
        PolicyDocument messageSubjectPolicy = WSPUtils.merge(combinedBindingInputPolicies, WSPUtils.merge(combinedInputPolicies, combinedMessagePolicies));
        return messageSubjectPolicy;
    }

    public static PolicyDocument getOutputMessagePolicy(WSDLContext wctx, BindingOutput bout, Output out) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        PolicyDocument combinedBindingOutputPolicies = null;
        if (bout != null) {
            WSPPolicyReference[] bindingOutputPolicyRefs = WSPAUtils.getPolicyReferences(bout);
            PolicyDocument[] bindingOutputPolicyDocs = WSPUtils.dereference(wctx, bindingOutputPolicyRefs);
            combinedBindingOutputPolicies = WSPUtils.merge(bindingOutputPolicyDocs);
        }
        PolicyDocument combinedOutputPolicies = null;
        PolicyDocument combinedMessagePolicies = null;
        if (out != null) {
            PolicyDocument[] outputPolicyDocs = WSPAUtils.getPolicyDocuments(wctx, (AttributeExtensible)out);
            combinedOutputPolicies = WSPUtils.merge(outputPolicyDocs);
            PolicyDocument[] messagePolicyDocs = WSPAUtils.getPolicyDocuments(wctx, (AttributeExtensible)out.getMessage());
            combinedMessagePolicies = WSPUtils.merge(messagePolicyDocs);
        }
        PolicyDocument messageSubjectPolicy = WSPUtils.merge(combinedBindingOutputPolicies, WSPUtils.merge(combinedOutputPolicies, combinedMessagePolicies));
        return messageSubjectPolicy;
    }

    public static PolicyDocument getFaultMessagePolicy(WSDLContext wctx, BindingFault bfault, Fault fault) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        WSPPolicyReference[] bindingFaultPolicyRefs = WSPAUtils.getPolicyReferences(bfault);
        PolicyDocument[] bindingFaultPolicyDocs = WSPUtils.dereference(wctx, bindingFaultPolicyRefs);
        PolicyDocument combinedBindingFaultPolicies = WSPUtils.merge(bindingFaultPolicyDocs);
        PolicyDocument[] faultPolicyDocs = WSPAUtils.getPolicyDocuments(wctx, (AttributeExtensible)fault);
        PolicyDocument combinedFaultPolicies = WSPUtils.merge(faultPolicyDocs);
        PolicyDocument[] messagePolicyDocs = WSPAUtils.getPolicyDocuments(wctx, (AttributeExtensible)fault.getMessage());
        PolicyDocument combinedMessagePolicies = WSPUtils.merge(messagePolicyDocs);
        PolicyDocument messageSubjectPolicy = WSPUtils.merge(combinedBindingFaultPolicies, WSPUtils.merge(combinedFaultPolicies, combinedMessagePolicies));
        return messageSubjectPolicy;
    }

    public static Operation getMessageOperation(Definition def, Port port, SOAPBody body) {
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        Iterator bodyElements = body.getChildElements();
        while (bodyElements.hasNext()) {
            SOAPBodyElement sOAPBodyElement = (SOAPBodyElement)bodyElements.next();
        }
        return null;
    }

    public static WSPPolicyReference[] getServicePolicyReferences(Definition def, QName service) {
        Service svc = def.getService(service);
        return WSPAUtils.getPolicyReferences(svc);
    }

    public static WSPPolicyReference[] getPolicyReferences(Service svc) {
        return WSPAUtils.getPolicyReferences(svc.getExtensibilityElements());
    }

    public static WSPPolicyReference[] getPolicyReferences(Port port) {
        return WSPAUtils.getPolicyReferences(port.getExtensibilityElements());
    }

    public static WSPPolicyReference[] getPolicyReferences(Binding binding) {
        return WSPAUtils.getPolicyReferences(binding.getExtensibilityElements());
    }

    public static WSPPolicyReference[] getPolicyReferences(BindingInput input) {
        return WSPAUtils.getPolicyReferences(input.getExtensibilityElements());
    }

    public static WSPPolicyReference[] getPolicyReferences(BindingOutput output) {
        return WSPAUtils.getPolicyReferences(output.getExtensibilityElements());
    }

    public static WSPPolicyReference[] getPolicyReferences(BindingFault fault) {
        return WSPAUtils.getPolicyReferences(fault.getExtensibilityElements());
    }

    public static WSPPolicyReference[] getPolicyReferences(BindingOperation bindingOp) {
        return WSPAUtils.getPolicyReferences(bindingOp.getExtensibilityElements());
    }

    private static WSPPolicyReference[] getPolicyReferences(List extElements) {
        ArrayList<WSPPolicyReference> policyRefs = new ArrayList<WSPPolicyReference>();
        for (ExtensibilityElement ext : extElements) {
            if (!ext.getElementType().equals(WSPConstants.QNAME_ELEMENT_WSP_POLICYREFERENCE)) continue;
            policyRefs.add((WSPPolicyReference)ext);
        }
        WSPPolicyReference[] refs = new WSPPolicyReference[policyRefs.size()];
        policyRefs.toArray(refs);
        return refs;
    }

    private static PolicyDocument[] getPolicyDocuments(WSDLContext wctx, AttributeExtensible aext) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        List listOfUrls = WSPAUtils.retrievePolicyUrls(aext);
        return WSPAUtils.getPolicyDocuments(wctx, listOfUrls);
    }

    private static PolicyDocument[] getPolicyDocuments(WSDLContext wctx, List listOfUrls) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        ArrayList<PolicyDocument> policies = new ArrayList<PolicyDocument>();
        if (listOfUrls != null) {
            for (String url : listOfUrls) {
                PolicyDocument policy = WSPUtils.getPolicyDocumentFromURL(wctx, url);
                policies.add(policy);
            }
        }
        PolicyDocument[] result = new PolicyDocument[policies.size()];
        policies.toArray(result);
        return result;
    }

    public static Policy getEffectiveServicePolicy(WSDLContext wctx, Service svc) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        WSPPolicyReference[] svcPolicyRefs = WSPAUtils.getPolicyReferences(svc);
        Policy mergedPolicy = new Policy();
        for (int i = 0; i < svcPolicyRefs.length; ++i) {
            Policy p = svcPolicyRefs[i].getPolicy(wctx);
            if (p == null) continue;
            mergedPolicy = (Policy)mergedPolicy.merge((Assertion)p);
        }
        return mergedPolicy;
    }

    public static Policy getEffectiveEndpointPolicy(WSDLContext wctx, Port port) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        WSPPolicyReference[] portPolicyRefs = WSPAUtils.getPolicyReferences(port);
        Policy mergedPortPolicy = new Policy();
        for (int i = 0; i < portPolicyRefs.length; ++i) {
            Policy p = portPolicyRefs[i].getPolicy(wctx);
            if (p == null) continue;
            mergedPortPolicy = (Policy)mergedPortPolicy.merge((Assertion)p);
        }
        WSPPolicyReference[] bindingPolicyRefs = WSPAUtils.getPolicyReferences(port.getBinding());
        Policy mergedBindingPolicy = new Policy();
        for (int i = 0; i < bindingPolicyRefs.length; ++i) {
            Policy p = bindingPolicyRefs[i].getPolicy(wctx);
            if (p == null) continue;
            mergedBindingPolicy = (Policy)mergedBindingPolicy.merge((Assertion)p);
        }
        PortType portType = port.getBinding().getPortType();
        Policy[] policies = WSPAUtils.deferencePolicyURIs(wctx, (AttributeExtensible)portType, true);
        Policy mergedPortTypePolicy = policies[0];
        return (Policy)mergedPortPolicy.merge((Assertion)mergedBindingPolicy).merge((Assertion)mergedPortTypePolicy);
    }

    public static Policy getEffectiveOperationPolicy(WSDLContext wctx, BindingOperation bindingOp) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        WSPPolicyReference[] bindingOpPolicyRefs = WSPAUtils.getPolicyReferences(bindingOp);
        Policy mergedBindingOpPolicy = new Policy();
        for (int i = 0; i < bindingOpPolicyRefs.length; ++i) {
            Policy p = bindingOpPolicyRefs[i].getPolicy(wctx);
            if (p == null) continue;
            mergedBindingOpPolicy = (Policy)mergedBindingOpPolicy.merge((Assertion)p);
        }
        Operation op = bindingOp.getOperation();
        Policy[] policies = WSPAUtils.deferencePolicyURIs(wctx, (AttributeExtensible)op, true);
        Policy mergedPortTypeOpPolicy = policies[0];
        return (Policy)mergedBindingOpPolicy.merge((Assertion)mergedPortTypeOpPolicy);
    }

    public static Policy getEffectiveInputMessagePolicy(WSDLContext wctx, BindingInput bindingInput, Input input) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        WSPPolicyReference[] bindingInputPolicyRefs = WSPAUtils.getPolicyReferences(bindingInput);
        Policy mergedBindingInputPolicy = new Policy();
        for (int i = 0; i < bindingInputPolicyRefs.length; ++i) {
            Policy p = bindingInputPolicyRefs[i].getPolicy(wctx);
            if (p == null) continue;
            mergedBindingInputPolicy = (Policy)mergedBindingInputPolicy.merge((Assertion)p);
        }
        Policy[] policies = WSPAUtils.deferencePolicyURIs(wctx, (AttributeExtensible)input, true);
        Policy mergedInputPolicy = policies[0];
        javax.wsdl.Message msg = input.getMessage();
        policies = WSPAUtils.deferencePolicyURIs(wctx, (AttributeExtensible)msg, true);
        Policy mergedMessagePolicy = policies[0];
        return (Policy)mergedBindingInputPolicy.merge((Assertion)mergedInputPolicy).merge((Assertion)mergedMessagePolicy);
    }

    public static Policy getEffectiveOutputMessagePolicy(WSDLContext wctx, BindingOutput bindingOutput, Output output) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        WSPPolicyReference[] bindingOutputPolicyRefs = WSPAUtils.getPolicyReferences(bindingOutput);
        Policy mergedBindingOutputPolicy = new Policy();
        for (int i = 0; i < bindingOutputPolicyRefs.length; ++i) {
            Policy p = bindingOutputPolicyRefs[i].getPolicy(wctx);
            if (p == null) continue;
            mergedBindingOutputPolicy = (Policy)mergedBindingOutputPolicy.merge((Assertion)p);
        }
        Policy[] policies = WSPAUtils.deferencePolicyURIs(wctx, (AttributeExtensible)output, true);
        Policy mergedOutputPolicy = policies[0];
        javax.wsdl.Message msg = output.getMessage();
        policies = WSPAUtils.deferencePolicyURIs(wctx, (AttributeExtensible)msg, true);
        Policy mergedMessagePolicy = policies[0];
        return (Policy)mergedBindingOutputPolicy.merge((Assertion)mergedOutputPolicy).merge((Assertion)mergedMessagePolicy);
    }

    public static Policy getEffectiveFaultMessagePolicy(WSDLContext wctx, BindingFault bindingFault, Fault fault) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        WSPPolicyReference[] bindingFaultPolicyRefs = WSPAUtils.getPolicyReferences(bindingFault);
        Policy mergedBindingFaultPolicy = new Policy();
        for (int i = 0; i < bindingFaultPolicyRefs.length; ++i) {
            Policy p = bindingFaultPolicyRefs[i].getPolicy(wctx);
            if (p == null) continue;
            mergedBindingFaultPolicy = (Policy)mergedBindingFaultPolicy.merge((Assertion)p);
        }
        Policy[] policies = WSPAUtils.deferencePolicyURIs(wctx, (AttributeExtensible)fault, true);
        Policy mergedFaultPolicy = policies[0];
        javax.wsdl.Message msg = fault.getMessage();
        policies = WSPAUtils.deferencePolicyURIs(wctx, (AttributeExtensible)msg, true);
        Policy mergedMessagePolicy = policies[0];
        return (Policy)mergedBindingFaultPolicy.merge((Assertion)mergedFaultPolicy).merge((Assertion)mergedMessagePolicy);
    }

    private static Policy[] deferencePolicyURIs(WSDLContext wctx, AttributeExtensible attrs, boolean merge) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        List listOfUrls = WSPAUtils.retrievePolicyUrls(attrs);
        ArrayList<Policy> policies = new ArrayList<Policy>();
        Policy mergedPolicy = new Policy();
        if (listOfUrls != null) {
            for (String urls : listOfUrls) {
                StringTokenizer st = new StringTokenizer(urls);
                while (st.hasMoreTokens()) {
                    Policy policy = WSPUtils.getPolicyFromURL(wctx, st.nextToken());
                    if (policy == null) continue;
                    if (merge) {
                        mergedPolicy = (Policy)mergedPolicy.merge((Assertion)policy);
                        continue;
                    }
                    policies.add(policy);
                }
            }
        }
        Policy[] result = null;
        if (merge) {
            result = new Policy[]{mergedPolicy};
        } else {
            result = new Policy[policies.size()];
            policies.toArray(result);
        }
        return result;
    }

    private static List retrievePolicyUrls(AttributeExtensible attrs) {
        List listOfUrls = null;
        if (attrs != null) {
            listOfUrls = (List)attrs.getExtensionAttribute(WSPConstants.QNAME_ATTRIBUTE_WSP_POLICYURIS);
        }
        return listOfUrls;
    }

    public static SOAPMessage wsdl2soap(String wsdlLocation, String serviceName, String portName, String operationName, Object[] parameters, QName[] headers) throws Exception {
        int pos = -1;
        QName serviceQName = null;
        pos = serviceName.indexOf("}");
        serviceQName = pos != -1 ? new QName(serviceName.substring(1, pos), serviceName.substring(++pos)) : new QName(serviceName);
        org.apache.axis.client.Service service = new org.apache.axis.client.Service(wsdlLocation, serviceQName);
        QName portQName = null;
        pos = portName.indexOf("}");
        portQName = pos != -1 ? new QName(portName.substring(1, pos), portName.substring(++pos)) : new QName(portName);
        Call call = (Call)service.createCall(portQName, operationName);
        call.setTargetEndpointAddress(new URL("http://127.0.0.1:9999"));
        try {
            call.invoke(parameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (headers != null && headers.length > 0) {
            for (int i = 0; i < headers.length; ++i) {
                SOAPFactory soapFactory = SOAPFactory.newInstance();
                SOAPHeader header = call.getMessageContext().getRequestMessage().getSOAPHeader();
                SOAPHeaderElement wsaAction = header.addHeaderElement(soapFactory.createName(headers[i].getLocalPart(), headers[i].getPrefix(), headers[i].getNamespaceURI()));
                wsaAction.addTextNode(headers[i].toString());
                wsaAction.setMustUnderstand(false);
            }
        } else {
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            SOAPHeader header = call.getMessageContext().getRequestMessage().getSOAPHeader();
            if (header != null) {
                SOAPHeaderElement wsaAction = header.addHeaderElement(soapFactory.createName("Action", "wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing"));
                wsaAction.addTextNode(call.getSOAPActionURI());
                wsaAction.setMustUnderstand(false);
                SOAPHeaderElement appHeader = header.addHeaderElement(soapFactory.createName("Id", "app", "http://www.foo.com/application"));
                appHeader.addTextNode("Application Id: " + System.currentTimeMillis());
                appHeader.setMustUnderstand(false);
            }
        }
        return call.getMessageContext().getRequestMessage();
    }

    public static void main(String[] argv) {
        try {
            String wsdlURL = argv[0];
            String service = argv[1];
            String port = argv[2];
            String operation = argv[3];
            int parameterCount = argv.length - 4;
            Object[] parameters = new String[parameterCount];
            int index = 0;
            for (int i = 4; i < argv.length; ++i) {
                parameters[index++] = argv[i];
            }
            QName[] headerQNames = null;
            SOAPMessage msg = WSPAUtils.wsdl2soap(wsdlURL, service, port, operation, parameters, headerQNames);
            System.out.println("SOAP message to be dispatched:\n" + ((Message)msg).getSOAPPartAsString());
            InputStream wsdlIs = new URL(wsdlURL).openStream();
            WSDLHelper wsdlHelper = new WSDLHelper(wsdlIs);
            String sp2005 = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy";
            String sp2002 = "http://schemas.xmlsoap.org/ws/2002/12/secext";
            for (String ns : wsdlHelper.getDefinition().getNamespaces().values()) {
                System.out.println("Namespace " + ns + " in scope...");
                if (ns.equalsIgnoreCase(sp2002)) {
                    System.out.println("Namespace " + sp2002 + " in scope...");
                }
                if (!ns.equalsIgnoreCase(sp2005)) continue;
                System.out.println("Namespace " + sp2005 + " in scope...");
            }
            int pos = -1;
            QName serviceQName = null;
            pos = service.indexOf("}");
            serviceQName = pos != -1 ? new QName(service.substring(1, pos), service.substring(++pos)) : new QName(service);
            String portLN = port;
            pos = port.indexOf("}");
            if (pos != -1) {
                portLN = port.substring(++pos);
            }
            SOAPAddress soapAddress = WSDLUtils.getSOAPAddress(wsdlHelper.getDefinition().getService(serviceQName).getPort(portLN));
            ByteArrayOutputStream wsdlOS = new ByteArrayOutputStream();
            wsdlHelper.writeWSDL(wsdlOS);
            WSDLContext ctx = new WSDLContext(wsdlURL, wsdlHelper.getDefinition(), wsdlOS.toByteArray());
            String endpointURL = soapAddress.getLocationURI();
            String actionURI = null;
            WSDLContext.RequestDispatchContext disp = ctx.getRequestDispatchContext(endpointURL, actionURI, null, msg);
            PolicyDocument endpointPolicy = disp.getEndpointPolicy();
            PolicyDocument messagePolicy = disp.getMessagePolicy();
            PolicyDocument operationPolicy = disp.getOperationPolicy();
            System.out.println("Merged endpoint policy:\n" + endpointPolicy);
            System.out.println("Merged operation policy:\n" + operationPolicy);
            System.out.println("Merged message policy:\n" + messagePolicy);
            PolicyDocument[] subjects = new PolicyDocument[]{endpointPolicy, messagePolicy, operationPolicy};
            PolicyDocument effective = WSPUtils.merge(subjects);
            System.out.println("Merged effective policy:\n" + effective);
            if (effective == null) {
                return;
            }
            try {
                Policy policy = WSPUtils.getPolicy(effective.toString());
                System.out.println("Namespace " + sp2005 + " in scope...");
            }
            catch (SecurityPolicy2002Exception e) {
                System.out.println("Namespace " + sp2002 + " in scope...");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

