/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public class DurableDisconnectEvt
extends LogEvent {
    private long m_disconnectTime = -1L;
    private long m_id;
    private boolean m_inDoubt;

    DurableDisconnectEvt(long id, long disconnectTime, boolean inDoubt) {
        this.m_id = id;
        this.m_disconnectTime = disconnectTime;
        this.m_inDoubt = inDoubt;
    }

    DurableDisconnectEvt() {
    }

    @Override
    public short type() {
        return 61;
    }

    @Override
    public boolean usesClientRegistry() {
        return true;
    }

    @Override
    public long getClientID() {
        return this.m_id;
    }

    @Override
    protected int memSizeBody() {
        return 17;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return 17;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
        StreamUtil.writeLong(this.m_disconnectTime, os);
        StreamUtil.writeBoolean(this.m_inDoubt, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        this.m_disconnectTime = StreamUtil.readLong(in);
        this.m_inDoubt = StreamUtil.readBoolean(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoDurableDisconnect(this.m_id, this.m_disconnectTime, this.m_inDoubt);
    }

    @Override
    public String toString() {
        return super.toString() + "DisconnectConnect cid: " + this.m_id + " Time: " + new Date(this.m_disconnectTime) + " in doubt: " + this.m_inDoubt;
    }
}

