/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.provision.spi.ProvisionControl;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import progress.message.broker.Config;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class ProvisionMonitor
extends DebugObject {
    public static boolean DEBUG = Boolean.getBoolean("SonicProvisionDebug");
    public static final String PROVISION_MONITOR_KEY = "PROVISION_MONITOR";
    public static final int STATE_UNKNOWN = -1;
    public static final int STATE_CHECK_PROVISION_STARTED = 1;
    public static final int STATE_CHECK_PROVISION_STOPED = 2;
    private static volatile boolean s_provisioning = true;
    private volatile boolean m_activated;
    private int m_monitorState;
    private ProvisionCheckThread m_provisionCheckThread;
    private Timer m_timer;
    private volatile String m_provisionSPIClassName;

    public ProvisionMonitor() {
        block5: {
            block4: {
                super(DebugState.GLOBAL_DEBUG_ON ? "SonicProvisionDebug" : null);
                this.m_activated = false;
                this.m_monitorState = -1;
                this.m_provisionCheckThread = null;
                this.m_timer = null;
                this.m_provisionSPIClassName = null;
                if (((DebugObject)this).DEBUG) break block4;
                if (!DEBUG) break block5;
            }
            DEBUG = true;
        }
        if (DEBUG) {
            System.out.println("!!! new ProvisionMonitor");
        }
    }

    public synchronized void activate() {
        this.m_activated = true;
        try {
            this.startProvisionCheck();
        }
        catch (ClassNotFoundException e) {
            BrokerComponent.getComponentContext().logMessage("Activate provision monitor. Provision check is not started because the provision class is not found: " + Config.PROVISION_SPI_CLASSNAME, (Throwable)e, 2);
        }
        catch (InstantiationException e) {
            BrokerComponent.getComponentContext().logMessage("Activate provision monitor. Provision check is not started because fail to instantiate provision object: " + Config.PROVISION_SPI_CLASSNAME, (Throwable)e, 2);
        }
        catch (IllegalAccessException e) {
            BrokerComponent.getComponentContext().logMessage("Activate provision monitor. Provision check is not started because illegal access to the provision class: " + Config.PROVISION_SPI_CLASSNAME, (Throwable)e, 2);
        }
        catch (RuntimeException e) {
            BrokerComponent.getComponentContext().logMessage("Activate provision monitor. Provision check is not started because RuntimeException:", (Throwable)e, 2);
            e.printStackTrace();
        }
    }

    public synchronized void shutdown() {
        this.stopProvisionCheck();
        this.m_activated = false;
    }

    public static boolean isProvisioning() {
        return s_provisioning;
    }

    private void startProvisionCheck() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.m_monitorState == 1) {
            return;
        }
        if (Config.PROVISION_SPI_CLASSNAME == null || Config.PROVISION_SPI_CLASSNAME.trim().length() == 0) {
            return;
        }
        ProvisionControl provisionControlObj = this.loadProvisionControl();
        this.m_timer = new Timer();
        String threadName = "PROVISION_" + this.m_provisionSPIClassName;
        this.m_provisionCheckThread = new ProvisionCheckThread(threadName, provisionControlObj);
        this.m_provisionCheckThread.startProvisionCheckThread();
        this.m_monitorState = 1;
    }

    private ProvisionControl loadProvisionControl() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.m_provisionSPIClassName = Config.PROVISION_SPI_CLASSNAME;
        Class<?> privisionControlClass = classLoader.loadClass(this.m_provisionSPIClassName);
        ProvisionControl provisionControlObj = (ProvisionControl)privisionControlClass.newInstance();
        provisionControlObj.initialize();
        return provisionControlObj;
    }

    private synchronized void stopProvisionCheck() {
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
        if (this.m_provisionCheckThread != null) {
            this.m_provisionCheckThread.shutdownProvisionCheckThread();
            this.m_provisionCheckThread = null;
        }
        this.m_monitorState = 2;
    }

    public synchronized void classNameAttributeCreated() {
        if (!this.m_activated) {
            return;
        }
        if (DEBUG) {
            System.out.println("@@@@ attributeCreated start provision check");
        }
        try {
            this.startProvisionCheck();
        }
        catch (ClassNotFoundException e) {
            BrokerComponent.getComponentContext().logMessage("Create attribute PROVISION_SPI_CLASSNAME. Provision check is not started because the provision class is not found: " + Config.PROVISION_SPI_CLASSNAME, (Throwable)e, 2);
        }
        catch (InstantiationException e) {
            BrokerComponent.getComponentContext().logMessage("Create attribute PROVISION_SPI_CLASSNAME. Provision check is not started because fail to instantiate provision object: " + Config.PROVISION_SPI_CLASSNAME, (Throwable)e, 2);
        }
        catch (IllegalAccessException e) {
            BrokerComponent.getComponentContext().logMessage("Create attribute PROVISION_SPI_CLASSNAME. Provision check is not started because illegal access to the provision class: " + Config.PROVISION_SPI_CLASSNAME, (Throwable)e, 2);
        }
        catch (RuntimeException e) {
            BrokerComponent.getComponentContext().logMessage("Create attribute PROVISION_SPI_CLASSNAME. Provision check is not started because RuntimeException:", (Throwable)e, 2);
            e.printStackTrace();
        }
    }

    public void classNameAttributeDeleted() {
        this.stopProvisionCheck();
    }

    class ProvisionCheckThread
    extends Thread {
        private ProvisionControl l_provisionControlObj;
        private volatile boolean l_shutdown;
        private int l_interval;
        private long l_intervalMillis;
        private TimerTask l_intervalInterruptor;
        private volatile long l_intervalStartTime;

        public ProvisionCheckThread(String threadName, ProvisionControl provisionControlObj) {
            super(threadName);
            this.l_provisionControlObj = null;
            this.l_shutdown = false;
            this.l_interval = -1;
            this.l_intervalInterruptor = null;
            if (DEBUG) {
                System.out.println("!!! new ProvisionCheckThread " + threadName);
            }
            this.l_provisionControlObj = provisionControlObj;
        }

        public void startProvisionCheckThread() {
            this.start();
        }

        private void setupIntervalInterruptor() {
            this.l_interval = Config.PROVISION_SPI_INTERVAL;
            this.l_intervalMillis = this.l_interval * 60 * 1000;
            this.closeIntervalInterruptor();
            this.l_intervalInterruptor = new CheckInterruptor();
            ProvisionMonitor.this.m_timer.scheduleAtFixedRate(this.l_intervalInterruptor, this.l_intervalMillis, this.l_intervalMillis);
            if (DEBUG) {
                System.out.println(this.l_intervalMillis + " -- setup check reminder. ");
            }
        }

        private void closeIntervalInterruptor() {
            if (this.l_intervalInterruptor != null) {
                this.l_intervalInterruptor.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean checkReturned = false;
            boolean interruptorRunning = false;
            while (!this.l_shutdown) {
                try {
                    if (!ProvisionMonitor.this.m_provisionSPIClassName.equals(Config.PROVISION_SPI_CLASSNAME)) {
                        this.closeIntervalInterruptor();
                        interruptorRunning = false;
                        try {
                            this.closeProvisionControlObj();
                            this.l_provisionControlObj = ProvisionMonitor.this.loadProvisionControl();
                        }
                        catch (ClassNotFoundException e) {
                            BrokerComponent.getComponentContext().logMessage("Modified attribute PROVISION_SPI_CLASSNAME. Provision check is not executed because the provision class is not found: " + Config.PROVISION_SPI_CLASSNAME, (Throwable)e, 2);
                        }
                        catch (InstantiationException e) {
                            BrokerComponent.getComponentContext().logMessage("Modified attribute PROVISION_SPI_CLASSNAME. Provision check is not executed because fail to instantiate provision object: " + Config.PROVISION_SPI_CLASSNAME, (Throwable)e, 2);
                        }
                        catch (IllegalAccessException e) {
                            BrokerComponent.getComponentContext().logMessage("Modified attribute PROVISION_SPI_CLASSNAME. Provision check is not executed because illegal access to the provision class: " + Config.PROVISION_SPI_CLASSNAME, (Throwable)e, 2);
                        }
                        catch (RuntimeException e) {
                            BrokerComponent.getComponentContext().logMessage("Modified attribute PROVISION_SPI_CLASSNAME. Provision check is not executed because RuntimeException:", (Throwable)e, 2);
                            e.printStackTrace();
                        }
                    }
                    if (!interruptorRunning || this.l_interval != Config.PROVISION_SPI_INTERVAL) {
                        this.setupIntervalInterruptor();
                        interruptorRunning = true;
                    }
                    checkReturned = false;
                    this.l_intervalStartTime = System.currentTimeMillis();
                    if (this.l_provisionControlObj == null) {
                        BrokerComponent.getComponentContext().logMessage("Provision check is not executed because there is no ProvisionControl implementation.", 2);
                    } else {
                        s_provisioning = this.l_provisionControlObj.checkProvisioning();
                    }
                    long durationOfCheckProvisioning = System.currentTimeMillis() - this.l_intervalStartTime;
                    checkReturned = true;
                    if (this.l_shutdown) continue;
                    if (durationOfCheckProvisioning < this.l_intervalMillis) {
                        Thread.sleep(this.l_intervalMillis - durationOfCheckProvisioning);
                        continue;
                    }
                    if (durationOfCheckProvisioning <= this.l_intervalMillis) continue;
                    this.closeIntervalInterruptor();
                    interruptorRunning = false;
                }
                catch (InterruptedException e) {
                    if (!checkReturned) {
                        BrokerComponent.getComponentContext().logMessage(this.getName() + ": checkProvisioning is interrupted ", (Throwable)e, 3);
                    }
                }
                finally {
                    if (!this.l_shutdown) continue;
                    if (DEBUG) {
                        System.out.println("Stop privision check thread: " + this.getName());
                    }
                    this.closeIntervalInterruptor();
                    interruptorRunning = false;
                    this.closeProvisionControlObj();
                    break;
                }
            }
        }

        private void closeProvisionControlObj() {
            if (this.l_provisionControlObj != null) {
                this.l_provisionControlObj.close();
                this.l_provisionControlObj = null;
            }
        }

        public void shutdownProvisionCheckThread() {
            this.l_shutdown = true;
            this.interrupt();
        }
    }

    class CheckInterruptor
    extends TimerTask {
        CheckInterruptor() {
        }

        @Override
        public void run() {
            long delta;
            if (DEBUG) {
                System.out.println("-- Reminder run at -- " + new Date());
            }
            if ((delta = System.currentTimeMillis() - ProvisionMonitor.this.m_provisionCheckThread.l_intervalStartTime) > 1000L) {
                ProvisionMonitor.this.m_provisionCheckThread.interrupt();
            }
        }
    }
}

