/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.IMetricsData;
import com.sonicsw.mf.common.metrics.impl.MetricIdentity;
import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mf.common.metrics.manager.impl.MetricsManager;
import com.sonicsw.mq.components.BrokerMetricsHelper;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.GetStats;
import progress.message.broker.StatsMetrics;
import progress.message.broker.prAccessor;
import progress.message.broker.stats.ICounterProvider;
import progress.message.broker.stats.IStatsProvider;
import progress.message.broker.stats.LTotStatsObj;
import progress.message.broker.stats.StatsObj;
import progress.message.client.EGeneralException;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugThread;
import progress.message.zclient.Envelope;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

public class StatsManager
extends DebugThread {
    public static long STATS_REFRESH_INTERVAL;
    public static long STATS_COLLECTION_INTERVAL;
    static int MONITOR_VERSION;
    private StatsMetrics metrics;
    private StatsMonitor statsMonitor;
    private int monitorInterval;
    private static final String STATS_TOPIC = "SYS.stats.subscribe";
    private AgentRegistrar reg;
    private static volatile StatsManager statsMgr;
    private boolean debug_stats = false;
    private Vector<IStatsProvider> stats = new Vector();
    private LongHashTable<IStatsProvider> availableMetrics = new LongHashTable();
    private long refreshInterval;
    private long collectionInterval;
    private int numSubintervals;
    private boolean doStatsDisplay = false;
    private long statsDisplayInterval;
    private long lastStatsDisplay;
    private long lastRefresh;
    private int numOutputValues = 0;
    private StatsObj memoryStats;
    private static DateFormat DATE_FORMAT;

    public StatsManager(AgentRegistrar agentreg) {
        super("StatsManager");
        this.reg = agentreg;
        statsMgr = this;
        this.metrics = new StatsMetrics();
        this.debug_stats = (this.debugFlags & 2) > 0;
        int refresh = Config.METRICS_REFRESH_INTERVAL;
        if (refresh < 5) {
            refresh = 5;
        }
        if (refresh > 60) {
            refresh = 60;
        }
        refresh *= 1000;
        this.collectionInterval = Config.METRICS_COLLECTION_INTERVAL;
        if (this.collectionInterval < 5L) {
            this.collectionInterval = 5L;
        }
        if (this.collectionInterval > 20L) {
            this.collectionInterval = 20L;
        }
        this.collectionInterval = this.collectionInterval * 60L * 1000L;
        this.monitorInterval = Config.METRICS_MONITOR_INTERVAL * 1000;
        if (this.debug_stats && Config.DEBUG_METRICS_COLLECTION_INTERVAL_SECS > 0) {
            this.collectionInterval = Config.DEBUG_METRICS_COLLECTION_INTERVAL_SECS;
            this.collectionInterval *= 1000L;
        }
        this.refreshInterval = refresh;
        this.numSubintervals = (int)(this.collectionInterval / this.refreshInterval);
        if (this.numSubintervals < 1) {
            this.numSubintervals = 1;
        }
        STATS_COLLECTION_INTERVAL = this.collectionInterval = this.refreshInterval * (long)this.numSubintervals;
        STATS_REFRESH_INTERVAL = this.refreshInterval;
        if (this.debug_stats && Config.DEBUG_METRICS_DISPLAY_INTERVAL > 0) {
            this.statsDisplayInterval = Config.DEBUG_METRICS_DISPLAY_INTERVAL * 1000;
            this.doStatsDisplay = true;
        }
        if (this.DEBUG) {
            this.debug("Created");
            this.debugStartIntervals();
            this.debug("statsDisplayInterval: " + this.statsDisplayInterval);
            this.debug("monitorInterval: " + this.monitorInterval);
            this.debug("Metrics Monitor Output: " + Config.METRICS_MONITOR_OUTPUT);
        }
        if (StatsMetrics.areStatsEnabled(1)) {
            this.memoryStats = new StatsObj(1, new ICounterProvider(){

                @Override
                public long getCurrentValue() {
                    return StatsManager.this.getMemory();
                }
            });
            this.memoryStats.outputStatistic(257, 2);
            this.registerStat(this.memoryStats);
        }
        this.registerStat(TimeKeeperHolder.TIME_KEEPER);
    }

    public static void registerStatsObj(IStatsProvider obj) {
        statsMgr.registerStat(obj);
    }

    public static void unregisterStatsObj(IStatsProvider obj) {
        statsMgr.unregisterStat(obj);
    }

    public static StatsObj getTimeKeeper() {
        return TimeKeeperHolder.TIME_KEEPER;
    }

    public final synchronized void registerStat(IStatsProvider obj) {
        if (obj == null) {
            throw new EAssertFailure("Attempt to register null IStatsProvider");
        }
        if (this.DEBUG) {
            this.debug("Registering " + obj.toString());
        }
        this.numOutputValues += obj.getNumOutputValues();
        obj.init();
        Enumeration e = obj.getStatisticsIds();
        while (e.hasMoreElements()) {
            int id = (Integer)e.nextElement();
            this.availableMetrics.put(id, obj);
        }
        this.stats.addElement(obj);
    }

    public synchronized void unregisterStat(IStatsProvider obj) {
        this.stats.removeElement(obj);
        Enumeration e = obj.getStatisticsIds();
        while (e.hasMoreElements()) {
            int id = (Integer)e.nextElement();
            this.availableMetrics.remove(id);
        }
    }

    public Message getStats(Message msg) throws IOException {
        if (this.DEBUG) {
            this.debug("GetStats(Message) called " + new Date());
        }
        msg.writeLong(this.lastRefresh);
        int numMetrics = this.numOutputValues;
        msg.writeInt(numMetrics);
        Enumeration<IStatsProvider> entries = this.stats.elements();
        IStatsProvider obj = null;
        while (entries.hasMoreElements()) {
            obj = entries.nextElement();
            if (obj.getNumOutputValues() <= 0) continue;
            obj.write(msg);
        }
        return msg;
    }

    public void getStats(PrintWriter out) throws IOException {
        if (this.DEBUG) {
            this.debug("GetStats(PrintWriter) called " + new Date());
        }
        out.println(this.lastRefresh);
        out.println(this.numOutputValues);
        Enumeration<IStatsProvider> entries = this.stats.elements();
        IStatsProvider obj = null;
        while (entries.hasMoreElements()) {
            obj = entries.nextElement();
            if (obj.getNumOutputValues() <= 0) continue;
            obj.write(out);
        }
    }

    public void getStats(DataOutputStream out) throws IOException {
        if (this.DEBUG) {
            this.debug("GetStats(DataOutputStream) called " + new Date());
        }
        out.writeLong(this.lastRefresh);
        out.writeInt(this.numOutputValues);
        Enumeration<IStatsProvider> entries = this.stats.elements();
        IStatsProvider obj = null;
        while (entries.hasMoreElements()) {
            obj = entries.nextElement();
            if (obj.getNumOutputValues() <= 0) continue;
            obj.write(out);
        }
    }

    public void resetStats() {
        Enumeration<IStatsProvider> entries = this.stats.elements();
        while (entries.hasMoreElements()) {
            IStatsProvider statsObj = entries.nextElement();
            if (this.DEBUG) {
                this.debug(System.currentTimeMillis() + " resetting: " + statsObj);
            }
            statsObj.reset();
        }
    }

    public synchronized long getMetric(int metricId) {
        IStatsProvider statsObj = this.availableMetrics.get(metricId);
        if (statsObj != null) {
            return statsObj.getStatisticValue(metricId);
        }
        return 0L;
    }

    public Enumeration<IStatsProvider> getMetricsIds() {
        return this.availableMetrics.elements();
    }

    private long getMemory() {
        Runtime rt = Runtime.getRuntime();
        long freeMem = rt.freeMemory();
        long totalMem = rt.totalMemory();
        if (this.DEBUG) {
            this.debug("freemem= " + freeMem + "; totalmem= " + totalMem);
        }
        return totalMem - freeMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() throws InterruptedException {
        if (!Broker.exiting) {
            block26: {
                if (this.DEBUG) {
                    this.debug("Starting StatsManager");
                    this.debugStartIntervals();
                    this.debug("monitorInterval: " + this.monitorInterval + " millisecs");
                    this.debug("Metrics Monitor Output: " + Config.METRICS_MONITOR_OUTPUT);
                    this.debug("statsDisplayInterval " + this.statsDisplayInterval);
                }
                if (this.monitorInterval > 0) {
                    if (this.DEBUG) {
                        this.debug("Starting stats monitor");
                    }
                    try {
                        this.statsMonitor = new StatsMonitor();
                        this.statsMonitor.setDaemon(true);
                        this.statsMonitor.start();
                    }
                    catch (EGeneralException e) {
                        if (!this.DEBUG) break block26;
                        this.debug("Failure to start stats monitor - " + e, e);
                    }
                }
            }
            boolean anyOldStats = false;
            for (int i = 0; i < 7; ++i) {
                if (!StatsMetrics.areStatsEnabled(i)) continue;
                anyOldStats = true;
                break;
            }
            if (this.DEBUG) {
                this.debug("No old stats enabled, stop thread");
            }
            if (!anyOldStats) {
                return;
            }
            this.lastRefresh = System.currentTimeMillis();
            long nextRefresh = this.lastRefresh + this.refreshInterval;
            this.lastStatsDisplay = this.lastRefresh;
            try {
                while (!Broker.exiting && !this.isInterrupted()) {
                    IStatsProvider obj;
                    Enumeration<IStatsProvider> entries;
                    long duration;
                    long sleepTime = 0L;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime < nextRefresh) {
                        sleepTime = nextRefresh - currentTime;
                        if (this.DEBUG) {
                            this.debug("Sleeping " + sleepTime);
                        }
                        Thread.sleep(sleepTime);
                        currentTime = nextRefresh;
                    }
                    if (currentTime - nextRefresh > this.collectionInterval) {
                        if (this.DEBUG) {
                            this.debug("Starting over " + new Date());
                        }
                        this.lastRefresh = System.currentTimeMillis();
                        nextRefresh = this.lastRefresh + this.refreshInterval;
                        this.lastStatsDisplay = this.lastRefresh;
                        continue;
                    }
                    while (nextRefresh <= currentTime) {
                        duration = System.currentTimeMillis() - this.lastRefresh;
                        if (this.DEBUG) {
                            this.debug("About to do intervalEnd for duration " + duration);
                        }
                        TimeKeeperHolder.TIME_KEEPER.add(duration);
                        entries = this.stats.elements();
                        while (entries.hasMoreElements()) {
                            obj = entries.nextElement();
                            obj.intervalEnd();
                        }
                        this.lastRefresh = System.currentTimeMillis();
                        nextRefresh += this.refreshInterval;
                    }
                    if (this.statsDisplayInterval <= 0L || currentTime - this.lastStatsDisplay < this.statsDisplayInterval) continue;
                    if (this.doStatsDisplay && this.stats.size() > 1) {
                        this.debug("");
                        duration = TimeKeeperHolder.TIME_KEEPER.getStatistic(1);
                        this.debug("" + new Date() + "   Last Collection Interval: IntervalSecs= " + Math.round((double)duration / 1000.0));
                        entries = this.stats.elements();
                        while (entries.hasMoreElements()) {
                            obj = entries.nextElement();
                            obj.debugWrite(SessionConfig.getLog());
                        }
                    }
                    this.lastStatsDisplay = currentTime;
                }
            }
            catch (InterruptedException ie) {
                if (!Broker.exiting) {
                    throw ie;
                }
            }
            finally {
                if (this.DEBUG) {
                    this.debug("Thread Exiting; Broker.exiting = " + Broker.exiting);
                }
            }
        }
    }

    private void debugStartIntervals() {
        this.debug("RefreshInterval: " + this.refreshInterval);
        this.debug("CollectionInterval: " + this.collectionInterval);
        this.debug("numSubintervals: " + this.numSubintervals);
    }

    Enumeration<IStatsProvider> getStats() {
        return this.stats.elements();
    }

    int getNumOutputValues() {
        return this.numOutputValues;
    }

    static {
        MONITOR_VERSION = 1;
        DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);
        if (DATE_FORMAT instanceof SimpleDateFormat) {
            ((SimpleDateFormat)DATE_FORMAT).applyPattern("yy/MM/dd kk:mm:ss");
        }
    }

    class StatsMonitor
    extends DebugThread {
        Session statsPubSession;
        String statsTopic;
        boolean dedicatedConnection;
        Connection statsConnection;
        PrintWriter statsOutAscii;
        DataOutputStream statsOutBinary;
        long lastMonitorTime;
        private boolean binary;
        MetricsManager m_metricsManager;
        boolean m_writeMetricsHeader;
        boolean m_pubMetricsHeader;
        boolean m_metricsManagerReset;

        StatsMonitor() throws EGeneralException {
            block15: {
                block14: {
                    super("StatsMonitor");
                    this.statsTopic = StatsManager.STATS_TOPIC;
                    this.dedicatedConnection = false;
                    this.binary = true;
                    this.m_writeMetricsHeader = true;
                    this.m_pubMetricsHeader = true;
                    this.m_metricsManagerReset = false;
                    if (this.DEBUG) {
                        this.binary = false;
                    }
                    this.m_metricsManager = (MetricsManager)BrokerMetricsHelper.getMetricsRegistrar();
                    if (Config.METRICS_MONITOR_EVENTS) {
                        if (!Config.METRICS_MONITOR_CONNECTION) {
                            if (this.DEBUG) {
                                this.debug("Using default Admin Session");
                            }
                            this.statsPubSession = StatsManager.this.reg.getAdminSession();
                        } else {
                            if (this.DEBUG) {
                                this.debug("Constructing dedicated connection and session");
                            }
                            this.dedicatedConnection = true;
                            try {
                                this.statsConnection = new Connection("StatsMonitor", null, new MessageHandler(null, true, true));
                                this.statsConnection.connect(StatsManager.this.reg.getAdminConnection());
                                this.statsPubSession = this.statsConnection.getDefaultSession();
                            }
                            catch (Exception e) {
                                if (!this.DEBUG) break block14;
                                this.debug("Failure to construct dedicated connection - " + e, e);
                            }
                        }
                    }
                }
                if (Config.METRICS_MONITOR_OUTPUT != null) {
                    if (this.DEBUG) {
                        this.debug("Creating " + (this.binary ? "binary " : "") + "output file " + Config.METRICS_MONITOR_OUTPUT);
                    }
                    try {
                        FileOutputStream out = new FileOutputStream(new File(Config.METRICS_MONITOR_OUTPUT));
                        if (this.binary) {
                            this.statsOutBinary = new DataOutputStream(out);
                            this.writeHeader();
                            this.statsOutBinary.flush();
                        } else {
                            this.statsOutAscii = new PrintWriter(out);
                            this.writeHeader();
                            this.statsOutAscii.flush();
                        }
                    }
                    catch (Exception e) {
                        if (!this.DEBUG) break block15;
                        this.debug("Failure to create file " + Config.METRICS_MONITOR_OUTPUT + " - " + e, e);
                    }
                }
            }
        }

        @Override
        public void threadMain() {
            if (!Broker.exiting) {
                if (this.DEBUG) {
                    this.debug("Starting with interval = " + StatsManager.this.monitorInterval + " ms Events = " + Config.METRICS_MONITOR_EVENTS + " Output = " + Config.METRICS_MONITOR_OUTPUT + " MetricsManager available = " + (this.m_metricsManager != null));
                }
                if (this.m_metricsManager != null) {
                    IStatisticProvider[] providers = new IStatisticProvider[]{new IStatisticProvider(){

                        public void updateStatistic(ISampledStatistic statistic) {
                        }

                        public void resetStatistic(ISampledStatistic statistic) {
                            if (StatsMonitor.this.DEBUG) {
                                StatsMonitor.this.debug("Metrics Manager Reset called");
                            }
                            StatsMonitor.this.m_metricsManagerReset = true;
                        }
                    }};
                    IStatistic watch = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])providers, (short)0);
                    this.m_metricsManager.registerStatistic(watch);
                }
                this.lastMonitorTime = System.currentTimeMillis();
                while (!Thread.interrupted() && !Broker.exiting) {
                    IMetricsData metricsData;
                    block21: {
                        long now = System.currentTimeMillis();
                        long sleepTime = this.lastMonitorTime + (long)StatsManager.this.monitorInterval - now;
                        if (sleepTime > 0L) {
                            try {
                                Thread.sleep(sleepTime);
                            }
                            catch (InterruptedException ie) {
                                return;
                            }
                        }
                        this.lastMonitorTime = System.currentTimeMillis();
                        metricsData = null;
                        if (this.m_metricsManager != null) {
                            metricsData = this.getMetricsData();
                            if (this.m_metricsManagerReset) {
                                this.m_writeMetricsHeader = true;
                                this.m_pubMetricsHeader = true;
                            }
                        }
                        if (this.statsPubSession != null) {
                            try {
                                if (this.DEBUG) {
                                    this.debug(System.currentTimeMillis() + ": Publishing to " + this.statsTopic);
                                }
                                Message m = new Message(this.statsTopic);
                                m.writeUTF(Config.BROKER_NAME);
                                Message msg = StatsManager.this.getStats(m);
                                Message msg1 = this.writeMetricsData(msg, metricsData);
                                Envelope env = new Envelope(msg1);
                                this.statsPubSession.publishInternal(env, 0, false, true);
                            }
                            catch (Exception e) {
                                if (!this.DEBUG) break block21;
                                this.debug("Failure to publish to " + this.statsTopic + " - " + e, e);
                            }
                        }
                    }
                    if (this.binary) {
                        if (this.statsOutBinary != null) {
                            try {
                                this.debugWritingTo();
                                StatsManager.this.getStats(this.statsOutBinary);
                                this.writeMetricsData(metricsData);
                                this.statsOutBinary.flush();
                            }
                            catch (Exception e) {
                                this.debugWriteFailure(e);
                            }
                        }
                    } else if (this.statsOutAscii != null) {
                        try {
                            this.debugWritingTo();
                            StatsManager.this.getStats(this.statsOutAscii);
                            this.writeMetricsData(metricsData);
                            this.statsOutAscii.flush();
                        }
                        catch (Exception e) {
                            this.debugWriteFailure(e);
                        }
                    }
                    this.m_metricsManagerReset = false;
                }
            }
        }

        private void debugWriteFailure(Exception e) {
            if (this.DEBUG) {
                this.debug("Failure to write to " + Config.METRICS_MONITOR_OUTPUT + " - " + e, e);
            }
        }

        private void debugWritingTo() {
            if (this.DEBUG) {
                this.debug(System.currentTimeMillis() + ": Writing to " + Config.METRICS_MONITOR_OUTPUT);
            }
        }

        private IMetricsData getMetricsData() {
            if (this.m_metricsManager == null) {
                return null;
            }
            IMetricsData metricsData = this.m_metricsManager.getAllMetricsData();
            if (this.DEBUG) {
                long now = System.currentTimeMillis();
                this.debug("[" + DATE_FORMAT.format(new Date(now)) + "] ****** MF Metrics Data ********");
                IMetric[] metrics = metricsData.getMetrics();
                for (int i = 0; i < metrics.length; ++i) {
                    long timestamp = metrics[i].getCurrencyTimestamp();
                    IMetricIdentity id = metrics[i].getMetricIdentity();
                    long hash = ((MetricIdentity)id).getHash();
                    long value = metrics[i].getValue();
                    String time = "[" + DATE_FORMAT.format(new Date(timestamp)) + "]";
                    this.debug(time + " " + id + "(" + hash + ")  = " + value);
                }
            }
            return metricsData;
        }

        void writeMetricsData(IMetricsData data) {
            if (data == null) {
                return;
            }
            IMetric[] metrics = data.getMetrics();
            if (this.m_metricsManagerReset) {
                this.writeString("*RESET");
            }
            if (this.m_writeMetricsHeader) {
                this.writeMetricsHeader(data);
                this.m_writeMetricsHeader = false;
            }
            long timestamp = data.getCurrencyTimestamp();
            this.writeString("*DATA");
            this.writeLong(timestamp);
            this.writeInt(metrics.length);
            for (int i = 0; i < metrics.length; ++i) {
                IMetricIdentity id = metrics[i].getMetricIdentity();
                long hash = ((MetricIdentity)id).getHash();
                long value = metrics[i].getValue();
                this.writeLong(hash);
                this.writeLong(value);
            }
        }

        private Message writeMetricsData(Message msg, IMetricsData data) {
            if (data == null) {
                return msg;
            }
            IMetric[] metrics = data.getMetrics();
            if (this.m_metricsManagerReset) {
                try {
                    msg.writeUTF("*RESET*");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.m_pubMetricsHeader) {
                this.writeMetricsHeader(msg, data);
                this.m_pubMetricsHeader = false;
            }
            try {
                msg.writeUTF("*DATA");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            long timestamp = data.getCurrencyTimestamp();
            msg.writeLong(timestamp);
            msg.writeInt(metrics.length);
            for (int i = 0; i < metrics.length; ++i) {
                IMetricIdentity id = metrics[i].getMetricIdentity();
                long hash = ((MetricIdentity)id).getHash();
                long value = metrics[i].getValue();
                msg.writeLong(hash);
                msg.writeLong(value);
            }
            return msg;
        }

        final void writeHeader() {
            long now = System.currentTimeMillis();
            String banner = "SonicMQ Metrics Monitor Output File - created on " + DATE_FORMAT.format(new Date(now)) + "\nBy broker \"" + Config.BROKER_NAME + "\" " + Config.RELEASE + prAccessor.getString("STR274") + 32 + "\n";
            if (this.m_metricsManager != null) {
                banner = banner + "\n in Management Container\n";
            }
            this.writeString(banner);
            this.writeInt(MONITOR_VERSION);
            this.writeInt(Config.METRICS_REFRESH_INTERVAL);
            this.writeInt(Config.METRICS_COLLECTION_INTERVAL);
            this.writeInt(Config.METRICS_MONITOR_INTERVAL);
            this.writeString(Config.BROKER_NAME);
            this.writeInt(StatsManager.this.numOutputValues);
            HashMap idToKey = new HashMap();
            Enumeration keys = GetStats.metricKeys.keys();
            while (keys.hasMoreElements()) {
                Object k = keys.nextElement();
                idToKey.put(GetStats.metricKeys.get(k), k);
            }
            Enumeration entries = StatsManager.this.stats.elements();
            IStatsProvider obj = null;
            while (entries.hasMoreElements()) {
                obj = (IStatsProvider)entries.nextElement();
                Enumeration ids = obj.getStatisticsIds();
                while (ids.hasMoreElements()) {
                    int id = (Integer)ids.nextElement();
                    String key = (String)idToKey.get(new Integer(id));
                    if (key == null) {
                        key = "";
                    }
                    int type = obj.getStatisticType(id);
                    String caption = (String)GetStats.metricCaptions.get(new Integer(id));
                    this.writeInt(id);
                    this.writeString(StatsMetrics.getFacilityName(obj.getFacilityId()) + ";" + key + ";" + type + ";" + caption);
                }
            }
            this.flush();
        }

        private void writeMetricsHeader(IMetricsData data) {
            if (data == null) {
                return;
            }
            this.writeString("*HEADER");
            this.writeLong(this.m_metricsManager.getCollectionInterval());
            this.writeLong(this.m_metricsManager.getRefreshInterval());
            IMetric[] metrics = data.getMetrics();
            this.writeInt(metrics.length);
            for (int i = 0; i < metrics.length; ++i) {
                IMetricIdentity id = metrics[i].getMetricIdentity();
                String name = id.getName();
                long hash = ((MetricIdentity)id).getHash();
                IMetricInfo info = this.m_metricsManager.getMetricInfo(id);
                if (info == null) continue;
                String desc = info.getDescription();
                boolean isInstance = info.isInstanceMetric();
                boolean isDynamic = info.isDynamic();
                short type = info.getValueType();
                boolean supportsHi = info.supportsHighThresholdAlerts();
                boolean supportsLo = info.supportsLowThresholdAlerts();
                String units = info.getUnits();
                if (this.DEBUG) {
                    this.debug("\nMetric = " + name + "\ntype = " + type + "\nhash = " + hash + "\ndynamic = " + isDynamic + "\ninstance = " + isInstance + "\ndesc = " + desc + "\nAlerts: High = " + supportsHi + " Low = " + supportsLo + " Units = " + units);
                }
                String del = ";";
                this.writeLong(hash);
                this.writeString(name + del + type + del + isInstance + del + isDynamic + del + desc + del + supportsHi + del + supportsLo + del + units);
            }
            this.flush();
        }

        private Message writeMetricsHeader(Message msg, IMetricsData data) {
            if (data == null) {
                return msg;
            }
            try {
                msg.writeUTF("*HEADER");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            msg.writeLong(this.m_metricsManager.getCollectionInterval());
            msg.writeLong(this.m_metricsManager.getRefreshInterval());
            IMetric[] metrics = data.getMetrics();
            msg.writeInt(metrics.length);
            for (int i = 0; i < metrics.length; ++i) {
                IMetricIdentity id = metrics[i].getMetricIdentity();
                String name = id.getName();
                long hash = ((MetricIdentity)id).getHash();
                IMetricInfo info = this.m_metricsManager.getMetricInfo(id);
                if (info == null) continue;
                String desc = info.getDescription();
                boolean isInstance = info.isInstanceMetric();
                boolean isDynamic = info.isDynamic();
                short type = info.getValueType();
                boolean supportsHi = info.supportsHighThresholdAlerts();
                boolean supportsLo = info.supportsLowThresholdAlerts();
                String units = info.getUnits();
                if (this.DEBUG) {
                    this.debug("\nMetric = " + name + "\ntype = " + type + "\nhash = " + hash + "\ndynamic = " + isDynamic + "\ninstance = " + isInstance + "\ndesc = " + desc + "\nAlerts: High = " + supportsHi + " Low = " + supportsLo + " Units = " + units);
                }
                String del = ";";
                msg.writeLong(hash);
                try {
                    msg.writeUTF(name + del + type + del + isInstance + del + isDynamic + del + desc + del + supportsHi + del + supportsLo + del + units);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return msg;
        }

        void writeString(String s) {
            if (this.binary) {
                try {
                    this.statsOutBinary.writeUTF(s);
                }
                catch (IOException iOException) {}
            } else {
                this.statsOutAscii.println(s);
            }
        }

        void writeInt(int n) {
            if (this.binary) {
                try {
                    this.statsOutBinary.writeInt(n);
                }
                catch (IOException iOException) {}
            } else {
                this.statsOutAscii.println(n);
            }
        }

        void writeLong(long n) {
            if (this.binary) {
                try {
                    this.statsOutBinary.writeLong(n);
                }
                catch (IOException iOException) {}
            } else {
                this.statsOutAscii.println(n);
            }
        }

        void flush() {
            if (this.binary) {
                try {
                    this.statsOutBinary.flush();
                }
                catch (IOException iOException) {}
            } else {
                this.statsOutAscii.flush();
            }
        }
    }

    private static class TimeKeeperHolder {
        private static final LTotStatsObj TIME_KEEPER = new LTotStatsObj("TimeKeeper");

        private TimeKeeperHolder() {
        }
    }
}

