/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.durable.DurableInfoDelegator;
import progress.message.broker.durable.IDurableReplyOperation;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class DurableBrowseReplyOp
extends DurableInfoDelegator
implements IDurableReplyOperation {
    private static final byte CURRENT_VERSION = 0;
    private boolean m_containsError = false;
    private int m_errorCode = 0;
    private boolean m_isEnd = false;
    private long m_trkNum = 0L;

    public DurableBrowseReplyOp(long trkNum, String brokerName) {
        this.m_trkNum = trkNum;
        this.setBrokerName(brokerName);
    }

    public DurableBrowseReplyOp(IMgram mg) {
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 9) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        ObjectInput dinput = mg.getPayloadInputStreamHandle();
        try {
            dinput.readByte();
            this.m_containsError = dinput.readBoolean();
            this.m_isEnd = dinput.readBoolean();
            this.unserializeInfo(dinput);
            if (this.m_containsError) {
                this.m_errorCode = dinput.readInt();
            } else if (!this.m_isEnd) {
                this.m_trkNum = dinput.readLong();
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    public void setEnd() {
        this.m_isEnd = true;
    }

    public boolean isEnd() {
        return this.m_isEnd;
    }

    @Override
    public boolean isComplete() {
        return this.m_isEnd;
    }

    public long getTrkNum() {
        return this.m_trkNum;
    }

    @Override
    public int getErrorCode() {
        return this.m_errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.m_errorCode = errorCode;
        this.m_containsError = true;
    }

    public boolean hasError() {
        return this.m_containsError;
    }

    @Override
    public IMgram getMgram() {
        IMgram mg = MgramFactory.getMgramFactory().buildOperationMgram(9);
        ObjectOutput doutput = mg.getPayloadOutputStreamHandle();
        IOperationHandle iopHandle = mg.getOperationHandle();
        try {
            doutput.writeByte(0);
            doutput.writeBoolean(this.m_containsError);
            doutput.writeBoolean(this.m_isEnd);
            this.serializeInfo(doutput);
            if (this.m_containsError) {
                doutput.writeInt(this.m_errorCode);
            } else if (!this.m_isEnd) {
                doutput.writeLong(this.m_trkNum);
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return mg;
    }

    public boolean isReplicateable() {
        return false;
    }
}

