/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.IOException;
import java.io.ObjectInput;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EOldVirtualClockException;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.gs.GSAdminDeleteHandler;
import progress.message.broker.gs.GSIBReconciliationHandler;
import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.GSPingHandler;
import progress.message.broker.gs.GSReconciliationHandler;
import progress.message.broker.gs.GSReconciliationRejectsHandler;
import progress.message.broker.gs.GSRequest;
import progress.message.broker.gs.GSSubscribeEvt;
import progress.message.broker.gs.GSTransport;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.msg.IMgram;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Label;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

public class GSPropagationClient
extends DebugObject
implements IMessageHandler {
    private Connection m_con;
    private Session m_ssn;
    private AgentRegistrar m_reg;
    private GSTransport m_transport;
    private GSManager m_manager;

    public GSPropagationClient(AgentRegistrar reg, GSManager manager, GSTransport transport) {
        super("GSPropagationClient");
        this.m_reg = reg;
        this.m_manager = manager;
        this.m_transport = transport;
    }

    public void start() throws IOException {
        this.subscribeGSPropagationClientSubjects();
    }

    public void setupGSPropagationClientHandlers() throws IOException {
        this.m_con = this.m_reg.getAdminConnection();
        MessageHandler mh = new MessageHandler(this);
        mh.setName("GSA request handler");
        mh.bind("$ISYS.GSA.globalSubscribe");
        mh.bind("$ISYS.GSA.globalUnsubscribe");
        mh.bind("$ISYS.GSA.globalRequestFailure", (IMessageHandler)new GSRequestFailureHandler());
        mh.bind("$ISYS.GSA.globalPingSubscriptions", (IMessageHandler)new GSPingHandler(this.m_reg, this.m_manager, this.m_transport));
        mh.bind("$ISYS.GSA.globalAdminDelete", (IMessageHandler)new GSAdminDeleteHandler(this.m_reg, this.m_manager, this.m_transport));
        GSReconciliationHandler recH = new GSReconciliationHandler(this.m_reg, this.m_manager, this.m_transport);
        mh.bind("$ISYS.GSA.globalReconcile", (IMessageHandler)recH);
        mh.bind("$ISYS.GSA.globalAdminReconcile", (IMessageHandler)recH);
        mh.bind("$ISYS.GSA.globalReconcileRejects", (IMessageHandler)new GSReconciliationRejectsHandler(this.m_reg, this.m_manager, this.m_transport));
        mh.setGuaranteed(true);
        this.m_con.addMessageHandler(mh);
        mh = new MessageHandler(new GSIBReconciliationHandler(this.m_reg, this.m_manager, this.m_transport));
        mh.setName("GSA IBReconcile handler");
        mh.bind("$ISYS.GSA.globalIBReconcile");
        mh.setGuaranteed(false);
        this.m_con.addMessageHandler(mh);
    }

    public void subscribeGSPropagationClientSubjects() throws IOException {
        this.m_con = this.m_reg.getAdminConnection();
        this.m_ssn = this.m_reg.getAdminSession();
        Label reliablelab = new Label();
        reliablelab.setGuaranteed(true);
        Label unreliablelab = new Label();
        unreliablelab.setGuaranteed(false);
        this.m_ssn.submitSubscription("$ISYS.GSA.globalSubscribe", reliablelab);
        this.m_ssn.submitSubscription("$ISYS.GSA.globalUnsubscribe", unreliablelab);
        this.m_ssn.submitSubscription("$ISYS.GSA.globalRequestFailure", reliablelab);
        this.m_ssn.submitSubscription("$ISYS.GSA.globalPingSubscriptions", unreliablelab);
        this.m_ssn.submitSubscription("$ISYS.GSA.globalReconcile", unreliablelab);
        this.m_ssn.submitSubscription("$ISYS.GSA.globalAdminReconcile", unreliablelab);
        this.m_ssn.submitSubscription("$ISYS.GSA.globalReconcileRejects", unreliablelab);
        this.m_ssn.submitSubscription("$ISYS.GSA.globalIBReconcile", unreliablelab);
        this.m_ssn.submitSubscription("$ISYS.GSA.globalAdminDelete", unreliablelab);
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        if (!BrokerStateManager.getBrokerStateManager().isActive()) {
            return;
        }
        GSRequest req = null;
        try {
            IMgram mgram = env.getMgram();
            ObjectInput in = mgram.getPayloadInputStreamHandle();
            req = GSRequest.deserialize(in);
            boolean isSelectorAtBroker = true;
            if (this.getDebug()) {
                this.debug(req.toString());
            }
            long clientID = this.m_reg.getRouterManager().getRemoteBrokerGSClientID(req.getHomeNodeName(), req.getHomeBrokerName());
            if (req.getOpCode() == 2) {
                try {
                    this.m_reg.unsubscribe(new UnsubscribeEvt(env, clientID, new Subject(req.getTopic()), req.getVirtualClock()));
                }
                catch (EClientNotRegistered ecnr) {
                    if (this.getDebug()) {
                        this.debug(req.opStr() + " - client not registered");
                    }
                }
            } else if (req.getOpCode() == 1) {
                this.m_reg.getGSManager().createRemoteBrokerCC(req.getHomeNodeName(), req.getHomeBrokerName());
                GSSubscribeEvt evt = new GSSubscribeEvt(env, clientID, new Subject(req.getTopic()), this.m_reg.getGSManager().getLabel(), req.getSelectors(), isSelectorAtBroker, req.getVirtualClock());
                String receivingBrokerName = req.getReceivingBrokerName();
                if (receivingBrokerName == null || receivingBrokerName.equals("") || receivingBrokerName.equals(Config.BROKER_NAME)) {
                    evt.setSuppressNotification(false);
                } else {
                    evt.setSuppressNotification(true);
                }
                this.m_reg.subscribeAndWaitForFlush(evt, true, true, null);
            }
            if (this.getDebug()) {
                this.debug(req.opStr() + " successful!");
            }
        }
        catch (EOldVirtualClockException eovc) {
            if (this.getDebug()) {
                if (req != null) {
                    this.debug(req.opStr() + " rejected stale vc:" + eovc);
                } else {
                    this.debug("req is null. rejected stale vc:" + eovc);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Exception e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
    }

    class GSRequestFailureHandler
    implements IMessageHandler {
        GSRequestFailureHandler() {
        }

        @Override
        public void handleMessage(Session s, Envelope env) {
            if (!BrokerStateManager.getBrokerStateManager().isActive()) {
                return;
            }
            int eventType = -1;
            GSVirtualClock virtualClock = null;
            int failureCode = -1;
            if (!BrokerStateManager.getBrokerStateManager().isActive()) {
                return;
            }
            try {
                IMgram mgram = env.getMgram();
                ObjectInput in = mgram.getPayloadInputStreamHandle();
                in.readByte();
                eventType = in.readInt();
                String remoteNode = in.readUTF();
                String homeBroker = in.readUTF();
                String reportingBroker = in.readUTF();
                String topic = in.readUTF();
                try {
                    virtualClock = GSVirtualClock.unserialize(in);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                failureCode = in.readInt();
                if (GSPropagationClient.this.getDebug()) {
                    GSPropagationClient.this.debug("Received request failure for: eventType " + eventType + ", remoteNode " + remoteNode + ", homeBroker " + homeBroker + ", topic " + topic + ", failureCode " + failureCode + ", vc " + (virtualClock != null ? virtualClock.toString() : "NO_VC"));
                }
                if (!homeBroker.equals(Config.BROKER_NAME)) {
                    if (GSPropagationClient.this.getDebug()) {
                        GSPropagationClient.this.debug("Ignored request failure for broker " + homeBroker);
                    }
                    return;
                }
                GSPropagationClient.this.m_manager.onRequestFailure(eventType, remoteNode, topic, virtualClock, failureCode, reportingBroker);
            }
            catch (Exception e) {
                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            }
        }
    }
}

