/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbq.pse;

import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.Placement;
import com.odi.util.DuplicateKeyException;
import com.odi.util.IndexIterator;
import com.odi.util.OSTreeSet;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import progress.message.broker.MgramSerializer;
import progress.message.db.EDatabaseException;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.db.pse.util.OpContext;
import progress.message.dbq.IPtpDBQ;
import progress.message.dbq.pse.DBQPSEBase;
import progress.message.dbsc.data.IDbData;
import progress.message.dbsc.data.IDbDataEnum;
import progress.message.dbsc.data.IDbQMsgData;
import progress.message.dbsc.data.IDbQueueData;
import progress.message.dbsc.data.impl.DbQMsgData;
import progress.message.dbsc.data.impl.DbQueueDataPSE;
import progress.message.dbsc.pse.pc.ptp.PSEQCounters;
import progress.message.dbsc.pse.pc.ptp.PSEQMessage;
import progress.message.dbsc.pse.pc.ptp.PSEQueue;
import progress.message.msg.IMgram;
import progress.message.util.LongHashTable;
import progress.message.util.server.ByteBufferInputStream;
import progress.message.util.server.ByteBufferOutputStream;
import progress.message.zclient.EMgramFormatError;

public class PtpDBQImplPSE
extends DBQPSEBase
implements IPtpDBQ {
    public static final int DELETE_BATCH_SIZE = 10000000;
    private PSEBrokerDb m_pseDb = null;
    private static final String ERROR_MESSAGE = "Error in PtpDBQImplPSE";

    public PtpDBQImplPSE(PSEBrokerDb db) {
        super("PtpDBQImplPSE ");
        this.m_pseDb = db;
    }

    @Override
    public void init() throws EDatabaseException {
        if (this.m_dbCtx == null) {
            this.m_dbCtx = this.m_pseDb.getCtx(4);
        }
        this.m_opCtxUpdate = new OpContext(2, this.m_dbCtx);
        this.m_opCtxRead = new OpContext(1, 2, this.m_dbCtx);
        this.m_opCtxDirtyRead = new OpContext(1, 1, this.m_dbCtx);
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSEQCounters rootQCounters = this.getRootQCounters();
            if (rootQCounters == null) {
                rootQCounters = new PSEQCounters();
                this.m_dbCtx.getDatabase().setRoot(this.m_pseDb.rootName("QCounters"), (Object)rootQCounters);
                this.commit();
            }
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
    }

    private OSTreeSet getQueuesRoot() {
        return (OSTreeSet)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("Queues"));
    }

    private OSTreeSet getQMessagesRoot() {
        return (OSTreeSet)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("QMessages"));
    }

    private PSEQCounters getRootQCounters() {
        return (PSEQCounters)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("QCounters"));
    }

    private PSEQueue getQueue(String qname) {
        return (PSEQueue)this.getQueuesRoot().getFromPrimaryIndex((Object)qname);
    }

    private PSEQMessage getQMessage(long msg_id) {
        Long key = new Long(msg_id);
        return (PSEQMessage)this.getQMessagesRoot().getFromPrimaryIndex((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyQMessage(PSEQMessage msg) {
        PSEQMessage pSEQMessage = msg;
        synchronized (pSEQMessage) {
            ObjectStore.destroy((Object)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMgram extractQMgram(PSEQMessage msg) {
        IMgram mgram = null;
        String qname = null;
        boolean DEBUG1 = this.isDebugLevel1();
        PSEQMessage pSEQMessage = msg;
        synchronized (pSEQMessage) {
            block9: {
                if (ObjectStore.isDestroyed((Object)msg)) {
                    return null;
                }
                qname = msg.getQueue().getQueueName();
                byte[] buf = msg.getMessageBody();
                ByteBufferInputStream bis = new ByteBufferInputStream(buf);
                try {
                    mgram = MgramSerializer.getMgramSerializer().unserialize(bis);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (DEBUG1) {
                        this.debug(ERROR_MESSAGE, e);
                    }
                }
                catch (EMgramFormatError ex) {
                    ex.printStackTrace();
                    if (!DEBUG1) break block9;
                    this.debug(ERROR_MESSAGE, ex);
                }
            }
        }
        if (mgram != null) {
            mgram.getBrokerHandle().setLocalQueueName(qname);
            mgram.getBrokerHandle().setFromDB(true);
        }
        return mgram;
    }

    @Override
    public boolean saveQMsg(String qname, IMgram message) throws EDatabaseException, IOException {
        boolean DEBUG = this.getDebug();
        boolean DEBUG1 = this.isDebugLevel1();
        long msg_id = message.getGuarenteedTrackingNum();
        String debugInfo = PtpDBQImplPSE.findDebugInfoQname(DEBUG, DEBUG1, msg_id, qname);
        if (DEBUG) {
            this.debug("entering saveQMsg: " + debugInfo);
        }
        long msg_exp = 0L;
        if (message.isTTE()) {
            msg_exp = message.getTTE();
        }
        int msgSize = message.serializedLength();
        ByteBufferOutputStream t = null;
        try {
            t = new ByteBufferOutputStream(msgSize);
            MgramSerializer.getMgramSerializer().serialize(t, message, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        if (DEBUG1 && msgSize < t.size()) {
            this.debug("saveQMsg: " + debugInfo + ", message.serializedLength() = " + msgSize + ", written to Db = " + t.size() + ", enqueuedSize = " + message.getEnqueuedSize());
        }
        boolean saved = false;
        this.checkUpdateLock();
        try {
            boolean addedToQMessages;
            boolean addedToQueue;
            PSEQMessage msg;
            block11: {
                PSEQueue q = this.getQueue(qname);
                if (q == null) {
                    q = new PSEQueue(qname, this.m_dbCtx.getDatabase());
                    this.getQueuesRoot().add((Object)q);
                }
                msg = new PSEQMessage(msg_id, msg_exp, message.getEnqueuedSize(), message.getPriority(), message.isJMSPersistent() && !message.isNonPersistentReplicated(), message.isSuccessor(), q, t.getBuffer());
                addedToQueue = false;
                addedToQMessages = false;
                try {
                    addedToQueue = q.addMessage(msg);
                    addedToQMessages = this.getQMessagesRoot().add((Object)msg);
                }
                catch (DuplicateKeyException dke) {
                    if (!DEBUG1) break block11;
                    this.debug("saveQMsg: Ignoring unique constraint error: " + debugInfo, dke);
                }
            }
            if (addedToQueue || addedToQMessages) {
                ObjectStore.migrate((Object)msg, (Placement)this.m_dbCtx.getDatabase(), (boolean)false);
                ObjectStore.evict((Object)msg, (int)3);
            }
            saved = true;
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMgram getQMgram(String qname, long msg_id) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        boolean DEBUG1 = this.isDebugLevel1();
        String debugInfo = PtpDBQImplPSE.retrieveDebugInfoQname(DEBUG, DEBUG1, msg_id, qname);
        IMgram mgram = this.debugEnteringGetQMgramAndAcquireLock(DEBUG, debugInfo);
        try {
            PSEQueue q = this.getQueue(qname);
            if (q == null) {
                if (DEBUG1) {
                    this.debug("getQMgram: queue not found: " + debugInfo);
                }
                IMgram iMgram = null;
                return iMgram;
            }
            PSEQMessage msg = q.getMessage(msg_id);
            if (msg == null) {
                if (DEBUG1) {
                    this.debug("getQMgram: msg not found in queue: " + debugInfo);
                }
                IMgram iMgram = null;
                return iMgram;
            }
            mgram = this.extractQMgram(msg);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxDirtyRead);
        }
        return mgram;
    }

    @Override
    public IMgram getQMgramTx(String qname, long msg_id) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        boolean DEBUG1 = this.isDebugLevel1();
        String debugInfo = PtpDBQImplPSE.retrieveDebugInfoQname(DEBUG, DEBUG1, msg_id, qname);
        if (DEBUG) {
            this.debug("entering getQMgramTx: " + debugInfo);
        }
        IMgram mgram = null;
        this.checkUpdateLock();
        try {
            PSEQueue q = this.getQueue(qname);
            if (q == null) {
                if (DEBUG1) {
                    this.debug("getQMgramTx: queue not found: " + debugInfo);
                }
                return null;
            }
            PSEQMessage msg = q.getMessage(msg_id);
            if (msg == null) {
                if (DEBUG1) {
                    this.debug("getQMgramTx: msg not found in queue: " + debugInfo);
                }
                return null;
            }
            mgram = this.extractQMgram(msg);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        return mgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMgram getQMgram(long msg_id) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        boolean DEBUG1 = this.isDebugLevel1();
        String debugInfo = null;
        if (DEBUG || DEBUG1) {
            debugInfo = "msg_id = " + msg_id;
        }
        IMgram mgram = this.debugEnteringGetQMgramAndAcquireLock(DEBUG, debugInfo);
        try {
            PSEQMessage msg = this.getQMessage(msg_id);
            if (msg == null) {
                if (DEBUG1) {
                    this.debug("getQMgram: msg not found: " + debugInfo);
                }
                IMgram iMgram = null;
                return iMgram;
            }
            mgram = this.extractQMgram(msg);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxDirtyRead);
        }
        return mgram;
    }

    private IMgram debugEnteringGetQMgramAndAcquireLock(boolean DEBUG, String debugInfo) throws EDatabaseException {
        if (DEBUG) {
            this.debug("entering getQMgram: " + debugInfo);
        }
        IMgram mgram = null;
        this.acquireLock(this.m_opCtxDirtyRead);
        return mgram;
    }

    @Override
    public void deleteQMsg(String qname, long msg_id) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        boolean DEBUG1 = this.isDebugLevel1();
        String debugInfo = PtpDBQImplPSE.retrieveDebugInfoQname(DEBUG, DEBUG1, msg_id, qname);
        this.debugEnteringDeleteQMsgAndCheckLock(DEBUG, debugInfo);
        try {
            PSEQueue q = this.getQueue(qname);
            if (q == null) {
                if (DEBUG1) {
                    this.debug("deleteQMsg: queue not found: " + debugInfo);
                }
                return;
            }
            PSEQMessage msg = q.getMessage(msg_id);
            if (msg == null) {
                if (DEBUG1) {
                    this.debug("deleteQMsg: msg not found in queue: " + debugInfo);
                }
                return;
            }
            this.getQMessagesRoot().remove((Object)msg);
            q.removeMessage(msg);
            this.destroyQMessage(msg);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
    }

    private static String retrieveDebugInfoQname(boolean DEBUG, boolean DEBUG1, long msg_id, String qname) {
        String debugInfo = PtpDBQImplPSE.findDebugInfoQname(DEBUG, DEBUG1, msg_id, qname);
        return debugInfo;
    }

    private static String findDebugInfoQname(boolean DEBUG, boolean DEBUG1, long msg_id, String qname) {
        String debugInfo = null;
        if (DEBUG || DEBUG1) {
            debugInfo = "qname = " + qname + ", msg_id = " + msg_id;
        }
        return debugInfo;
    }

    @Override
    public void deleteQMsg(long msg_id) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        boolean DEBUG1 = this.isDebugLevel1();
        String debugInfo = null;
        if (DEBUG || DEBUG1) {
            debugInfo = "msg_id = " + msg_id;
        }
        this.debugEnteringDeleteQMsgAndCheckLock(DEBUG, debugInfo);
        try {
            PSEQMessage msg = this.getQMessage(msg_id);
            if (msg == null) {
                if (DEBUG1) {
                    this.debug("deleteQMsg: msg not found: " + debugInfo);
                }
                return;
            }
            this.getQMessagesRoot().remove((Object)msg);
            msg.getQueue().removeMessage(msg);
            this.destroyQMessage(msg);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
    }

    private void debugEnteringDeleteQMsgAndCheckLock(boolean DEBUG, String debugInfo) {
        if (DEBUG) {
            this.debug("entering deleteQMsg: " + debugInfo);
        }
        this.checkUpdateLock();
    }

    @Override
    public void deleteQMsgs(String qname) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        boolean DEBUG1 = this.isDebugLevel1();
        String debugInfo = null;
        if (DEBUG || DEBUG1) {
            debugInfo = "qname = " + qname;
        }
        if (DEBUG) {
            this.debug("entering deleteQMsgs: " + debugInfo);
        }
        this.checkUpdateLock();
        try {
            PSEQueue q = this.getQueue(qname);
            if (q == null) {
                if (DEBUG1) {
                    this.debug("deleteQMsgs: queue not found: " + debugInfo);
                }
                return;
            }
            Iterator it = q.getMessageIterator();
            while (it.hasNext()) {
                PSEQMessage msg = (PSEQMessage)it.next();
                it.remove();
                this.getQMessagesRoot().remove((Object)msg);
                this.destroyQMessage(msg);
            }
            this.getQueuesRoot().remove((Object)q);
            ObjectStore.destroy((Object)q);
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteNonpersistentQMsgs() throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("entering deleteNonPersistentQMsgs");
        }
        int msg_count = 0;
        this.acquireLock(this.m_opCtxUpdate);
        try {
            int batch_size = 0;
            Iterator it = this.getQMessagesRoot().iterator();
            while (it.hasNext()) {
                PSEQMessage msg = (PSEQMessage)it.next();
                if (msg.getPersistent()) continue;
                ++msg_count;
                it.remove();
                msg.getQueue().removeMessage(msg);
                this.destroyQMessage(msg);
                if ((batch_size += msg.getMsgSize()) < 10000000) continue;
                this.commit();
                batch_size = 0;
            }
            this.commit();
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (this.isDebugLevel1()) {
            this.debug("returning from deleteNonpersistentQMsgs: msg_count = " + msg_count);
        }
        return msg_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongHashTable getMessageIDsInQueue(String qname) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        boolean DEBUG1 = this.isDebugLevel1();
        String debugInfo = null;
        if (DEBUG || DEBUG1) {
            debugInfo = "qname = " + qname;
        }
        if (DEBUG) {
            this.debug("entering getMessageIDsInQueue: " + debugInfo);
        }
        LongHashTable<Long> ids = new LongHashTable<Long>();
        this.acquireLock(this.m_opCtxRead);
        try {
            PSEQueue q = this.getQueue(qname);
            if (q == null) {
                if (DEBUG1) {
                    this.debug("getMessageIDsInQueue: queue not found: " + debugInfo);
                }
                LongHashTable<Long> longHashTable = ids;
                return longHashTable;
            }
            Iterator it = q.getMessageIterator();
            while (it.hasNext()) {
                PSEQMessage msg = (PSEQMessage)it.next();
                Long id = new Long(msg.getMessageId());
                ids.put(id, id);
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap getAllQMessageIds() throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("entering getAllQMessageIds");
        }
        TreeMap<Long, Long> ids = new TreeMap<Long, Long>();
        this.acquireLock(this.m_opCtxRead);
        try {
            IndexIterator it = this.getQMessagesRoot().primaryIndexIterator();
            while (it.hasNext()) {
                it.advance();
                Long id = (Long)it.currentKey();
                ids.put(id, id);
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return ids;
    }

    @Override
    public Long getMaxAddedMessageId() throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("entering getMaxMessageId");
        }
        Long max = null;
        this.acquireLock(this.m_opCtxRead);
        try {
            max = new Long(this.getRootQCounters().getMessageId());
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        if (this.isDebugLevel1()) {
            this.debug("returning from getMaxMessageId: max = " + max);
        }
        return max;
    }

    @Override
    public Long[] getMaxMinMessageIds() throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("entering getMaxMinMessageIds");
        }
        Long[] result = new Long[2];
        this.checkUpdateLock();
        try {
            result[0] = (Long)this.getQMessagesRoot().getMaxPrimaryKey();
            result[1] = (Long)this.getQMessagesRoot().getMinPrimaryKey();
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        if (this.isDebugLevel1()) {
            this.debug("returning from getMaxMinMessageIds: max = " + result[0] + ", min = " + result[1]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCounters(long messageId) throws EDatabaseException {
        this.debugUpdateCounters(messageId);
        this.acquireLock(this.m_opCtxUpdate);
        try {
            this.getRootQCounters().setMessageId(messageId);
            this.commit();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
    }

    @Override
    public void updateCountersTx(long messageId) throws EDatabaseException {
        this.debugUpdateCounters(messageId);
        this.checkUpdateLock();
        try {
            this.getRootQCounters().setMessageId(messageId);
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
    }

    private void debugUpdateCounters(long messageId) {
        if (this.getDebug()) {
            this.debug("updateCounters starting; messageId = " + messageId);
        }
    }

    @Override
    public TreeMap getMessageIdsTx(long from, long to, int count) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("entering getMessageIdsTx: from = " + from + ", to = " + to + ", count = " + count);
        }
        this.checkUpdateLock();
        return this.getMessageIdsInternal(from, to, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap getMessageIds(long from, long to, int count) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("entering getMessageIds: from = " + from + ", to = " + to + ", count = " + count);
        }
        this.acquireLock(this.m_opCtxRead);
        try {
            TreeMap treeMap = this.getMessageIdsInternal(from, to, count);
            return treeMap;
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
    }

    private TreeMap getMessageIdsInternal(long from, long to, int count) throws EDatabaseException {
        TreeMap<Long, Long> ids = new TreeMap<Long, Long>();
        try {
            IndexIterator it = this.getQMessagesRoot().primaryIndexIterator((Object)new Long(from));
            for (int idCount = 0; it.hasNext() && idCount < count; ++idCount) {
                it.advance();
                Long id = (Long)it.currentKey();
                if (id <= to) {
                    ids.put(id, id);
                    continue;
                }
                break;
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        return ids;
    }

    @Override
    public int deleteQMsgs(long from, long to) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("entering deleteQMsgs: from = " + from + ", to = " + to);
        }
        int msg_count = 0;
        this.checkUpdateLock();
        try {
            PSEQMessage msg;
            long id;
            IndexIterator it = this.getQMessagesRoot().primaryIndexIterator((Object)new Long(from));
            while (it.hasNext() && (id = (msg = (PSEQMessage)it.next()).getMessageId()) <= to) {
                it.remove();
                msg.getQueue().removeMessage(msg);
                this.destroyQMessage(msg);
                ++msg_count;
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        if (DEBUG) {
            this.debug("returning from deleteQMsgs: msg_count = " + msg_count);
        }
        return msg_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDbQMsgData getQueueMsgData(long id) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("entering getQMsgData: id= " + id);
        }
        DbQMsgData qmsgData = null;
        this.acquireLock(this.m_opCtxRead);
        try {
            PSEQMessage msg = this.getQMessage(id);
            if (msg == null) {
                if (this.isDebugLevel1()) {
                    this.debug("deleteQMsg: msg not found: " + id);
                }
                DbQMsgData dbQMsgData = qmsgData;
                return dbQMsgData;
            }
            qmsgData = new DbQMsgData(id, msg.getMsgSize(), msg.getExpiration(), msg.getPriority(), msg.getPersistent(), msg.getRedelivery(), msg.getQueue().getQueueName());
        }
        catch (ObjectStoreException ose) {
            this.m_dbCtx.handlePSEException(ose);
        }
        finally {
            this.releaseLock(this.m_opCtxRead);
        }
        return qmsgData;
    }

    @Override
    public IDbDataEnum getQueuesDbDataEnum() throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("entering getQueuesDbDataEnum");
        }
        return new QueuesDbDataEnum();
    }

    @Override
    public IDbDataEnum getQMsgsDbDataEnum(IDbQueueData queueData) throws EDatabaseException {
        if (this.getDebug()) {
            this.debug("entering getQMsgsDbDataEnum");
        }
        return new QMsgsDbDataEnum(queueData);
    }

    class QMsgsDbDataEnum
    implements IDbDataEnum {
        private Iterator m_QMsgIterator = null;

        public QMsgsDbDataEnum(IDbQueueData queueData) throws EDatabaseException {
            PtpDBQImplPSE.this.acquireLock(PtpDBQImplPSE.this.m_opCtxRead);
            try {
                PSEQueue q = PtpDBQImplPSE.this.getQueue(queueData.getQueueName());
                if (q != null) {
                    this.m_QMsgIterator = q.getMessageIterator();
                } else {
                    this.close();
                }
            }
            catch (ObjectStoreException ose) {
                this.close();
                PtpDBQImplPSE.this.m_dbCtx.handlePSEException(ose);
            }
        }

        @Override
        public boolean hasMoreElements() throws EDatabaseException {
            if (this.m_QMsgIterator == null) {
                return false;
            }
            try {
                if (this.m_QMsgIterator.hasNext()) {
                    return true;
                }
            }
            catch (ObjectStoreException ose) {
                this.close();
                PtpDBQImplPSE.this.m_dbCtx.handlePSEException(ose);
            }
            this.close();
            return false;
        }

        @Override
        public IDbData nextElement() throws EDatabaseException {
            DbQMsgData msgData = null;
            try {
                PSEQMessage msg = (PSEQMessage)this.m_QMsgIterator.next();
                msgData = new DbQMsgData(msg);
            }
            catch (ObjectStoreException ose) {
                this.close();
                PtpDBQImplPSE.this.m_dbCtx.handlePSEException(ose);
            }
            return msgData;
        }

        @Override
        public final void close() {
            this.m_QMsgIterator = null;
            PtpDBQImplPSE.this.releaseLock(PtpDBQImplPSE.this.m_opCtxRead);
        }
    }

    class QueuesDbDataEnum
    implements IDbDataEnum {
        private Iterator m_QueueIterator = null;

        public QueuesDbDataEnum() throws EDatabaseException {
            PtpDBQImplPSE.this.acquireLock(PtpDBQImplPSE.this.m_opCtxRead);
            try {
                this.m_QueueIterator = PtpDBQImplPSE.this.getQueuesRoot().iterator();
            }
            catch (ObjectStoreException ose) {
                PtpDBQImplPSE.this.m_dbCtx.handlePSEException(ose);
            }
            finally {
                PtpDBQImplPSE.this.releaseLock(PtpDBQImplPSE.this.m_opCtxRead);
            }
        }

        @Override
        public boolean hasMoreElements() throws EDatabaseException {
            if (this.m_QueueIterator == null) {
                return false;
            }
            boolean hasMore = false;
            PtpDBQImplPSE.this.acquireLock(PtpDBQImplPSE.this.m_opCtxRead);
            try {
                hasMore = this.m_QueueIterator.hasNext();
            }
            catch (ObjectStoreException ose) {
                PtpDBQImplPSE.this.m_dbCtx.handlePSEException(ose);
            }
            finally {
                PtpDBQImplPSE.this.releaseLock(PtpDBQImplPSE.this.m_opCtxRead);
            }
            return hasMore;
        }

        @Override
        public IDbData nextElement() throws EDatabaseException {
            DbQueueDataPSE queueData = null;
            PtpDBQImplPSE.this.acquireLock(PtpDBQImplPSE.this.m_opCtxRead);
            try {
                PSEQueue nextQueue = (PSEQueue)this.m_QueueIterator.next();
                queueData = new DbQueueDataPSE(nextQueue.getQueueName());
            }
            catch (ObjectStoreException ose) {
                PtpDBQImplPSE.this.m_dbCtx.handlePSEException(ose);
            }
            finally {
                PtpDBQImplPSE.this.releaseLock(PtpDBQImplPSE.this.m_opCtxRead);
            }
            return queueData;
        }

        @Override
        public void close() {
            this.m_QueueIterator = null;
        }
    }
}

