/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.util.LinkedList;
import progress.message.broker.Broker;
import progress.message.ft.DynamicSyncManager;
import progress.message.ft.TransactionSyncOp;
import progress.message.zclient.DebugThread;

public class TransactionDynSyncer
extends DebugThread {
    private DynamicSyncManager m_dsm;
    private int m_role = -1;
    private LinkedList m_todoList = null;

    public TransactionDynSyncer(DynamicSyncManager dsm, int role) {
        super("TransactionDynSyncer");
        this.m_dsm = dsm;
        this.m_role = role;
        if (this.m_role == 2) {
            this.m_todoList = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkItem(TransactionSyncOp txnSyncOp) {
        LinkedList linkedList = this.m_todoList;
        synchronized (linkedList) {
            this.m_todoList.add(txnSyncOp);
            this.m_todoList.notifyAll();
        }
    }

    @Override
    public void threadMain() {
        try {
            if (this.DEBUG) {
                this.debug("running... m_role: " + this.m_role);
            }
            if (this.m_role == 1) {
                if (this.DEBUG) {
                    this.debug("get and send file based transaction information to be replicated on the standby");
                }
                this.doActiveSync();
            } else if (this.m_role == 2) {
                if (this.DEBUG) {
                    this.debug("receive and process file based txn info replicated from active");
                }
                this.doStandbySync();
            }
            if (this.DEBUG) {
                this.debug("exiting...");
            }
            this.m_dsm.setStatus(128);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.DEBUG) {
                this.debug("Thread Exiting; Broker.exiting= " + Broker.exiting);
            }
        }
    }

    private void doActiveSync() throws InterruptedException {
        this.m_dsm.replicateFileBasedTxns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStandbySync() throws InterruptedException {
        while (!this.isShuttingDown()) {
            TransactionSyncOp txnSyncOp = null;
            LinkedList linkedList = this.m_todoList;
            synchronized (linkedList) {
                while (this.m_todoList.isEmpty()) {
                    this.m_todoList.wait();
                }
                txnSyncOp = (TransactionSyncOp)this.m_todoList.removeFirst();
            }
            if (txnSyncOp.isTxnSyncComplete()) {
                if (!this.DEBUG) break;
                this.debug("No more work to do.  Received txn dyn sync complete");
                break;
            }
            txnSyncOp.execute();
            if (!this.CALLBACK) continue;
            this.callback("Processed a txnsyncop", 0, null);
        }
    }
}

