/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import com.sonicsw.mq.common.runtime.IGlobalQueueRouteData;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpRemoteBroker;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.INeighbor;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.MgramURLHelper;
import progress.message.broker.RoutingConfiguration;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.gr.RemoteBroker;
import progress.message.gr.RemoteBrokerHelper;
import progress.message.gr.RouteInfo;
import progress.message.gr.RouteNodeHolder;
import progress.message.gr.RouteRequest;
import progress.message.gr.RouteSaver;
import progress.message.gr.RouteTable;
import progress.message.gr.RouterManager;
import progress.message.interbroker.Interbroker;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.QueueUtil;
import progress.message.zclient.DebugObject;

public class RouteForwarder
extends DebugObject {
    private RouterManager m_rm;
    private RouteTable m_rt;
    private RouteSaver m_rs;
    private RemoteBrokerHelper m_rbHelper = null;
    private Hashtable m_nodeTable;
    private Vector m_advertiseList;
    private String m_localNodeName;
    private int[] m_wildcardDest;
    public static final String WILDCARD_GLOBAL = "*";
    private final boolean DEBUG1 = (this.debugFlags & 0x40) > 0;

    public RouteForwarder(RouterManager rm) {
        super(DebugState.GLOBAL_DEBUG_ON ? "RouteForwarder" : null);
        this.m_rm = rm;
        this.m_localNodeName = Config.ROUTING_NODE_NAME;
        this.m_nodeTable = new Hashtable();
        this.m_rt = new RouteTable(this.m_nodeTable);
        this.m_advertiseList = new Vector();
        this.m_rs = new RouteSaver(AgentRegistrar.getAgentRegistrar());
        this.m_rs.start();
        this.m_wildcardDest = QueueUtil.queueNameToMatchVector(WILDCARD_GLOBAL);
    }

    void setRemoteBrokerHelper(RemoteBrokerHelper rbHelper) {
        this.m_rbHelper = rbHelper;
    }

    public void loadSavedRouteTableFromDatastore() {
        Vector routes = this.m_rs.getRoutes();
        if (routes == null) {
            return;
        }
        for (int i = 0; i < routes.size(); ++i) {
            RouteInfo ri = (RouteInfo)routes.elementAt(i);
            RoutingConnectionInfo rci = ri.getConnectionInfo();
            RouteForwarder.configAdvertisedCheckingNull(rci);
            this.m_rt.setRoute(ri, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNeighborRoutes() {
        RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
        RouteNodeHolder rnh = null;
        String trackingNodeName = null;
        RouteTable routeTable = this.m_rt;
        synchronized (routeTable) {
            Enumeration routes = this.m_rt.getAll();
            while (routes.hasMoreElements()) {
                RoutingConnectionInfo rci;
                RouteInfo ri = (RouteInfo)routes.nextElement();
                trackingNodeName = ri.getSendingBrokerName();
                if (ri.getNodeName().equals(this.m_localNodeName) || trackingNodeName == null || !trackingNodeName.startsWith(this.m_localNodeName) || !ri.getGlobalName().equals(WILDCARD_GLOBAL)) continue;
                String neighborName = trackingNodeName.substring(this.m_localNodeName.length());
                String outboundBrokerName = null;
                if (Config.ENABLE_INTERBROKER && (rci = rc.getRoutingConnection(ri.getNodeName())) != null) {
                    outboundBrokerName = rci.getOutboundBrokerName();
                }
                if (outboundBrokerName != null && outboundBrokerName.length() != 0 && !outboundBrokerName.equals(neighborName) || (rnh = this.lookUpNeighbor(trackingNodeName)) == null) continue;
                ri.setRemoteNode(rnh);
            }
        }
    }

    public void onMgram(IRemoteBroker rb, IMgram mg) {
        RouteRequest rr = new RouteRequest();
        rr.fromIMgramPayload(mg.getRawBody(), (short)-1);
        switch (rr.getRequestType()) {
            case 1: {
                this.handleAdvertise(rb, rr);
                break;
            }
            case 3: {
                this.handleRemove(rb, rr);
                break;
            }
            case 2: {
                this.handleUpdate(rb, rr);
                break;
            }
            case 4: 
            case 5: {
                AgentRegistrar.getAgentRegistrar().getClusteredQueueManager().onMgram(rb, mg);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAdvertise(IRemoteBroker rb, RouteRequest rr) {
        Vector advertiseList;
        boolean sameNode = false;
        boolean sendOk = false;
        String trackingNodeName = rb.getNodeName();
        if (trackingNodeName.equals(this.m_localNodeName)) {
            sameNode = true;
            trackingNodeName = trackingNodeName.concat(rb.getBrokerName());
        }
        if (this.DEBUG1 && rb != null) {
            this.debug("handleAdvertise: from RemoteBroker " + rb.getNodeName() + "::" + rb.getBrokerName() + ", advertised route count = " + rr.getInfoCount());
        }
        RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
        RoutingConnectionInfo rci = null;
        RouteNodeHolder oldNode = new RouteNodeHolder("", null);
        for (int i = rr.getInfoCount() - 1; i >= 0; --i) {
            int res;
            RouteInfo ri = rr.getInfo(i);
            ri.setHops(ri.getHops() + 1);
            ri.setSendingBrokerName(trackingNodeName);
            oldNode.setRemoteBroker(null);
            rci = ri.getConnectionInfo();
            RouteForwarder.configAdvertisedCheckingNull(rci);
            boolean setNodeInfo = true;
            RouteTable routeTable = this.m_rt;
            synchronized (routeTable) {
                RouteNodeHolder rnh = (RouteNodeHolder)this.m_nodeTable.get(trackingNodeName);
                if (rnh == null || rnh.getRemoteBroker() != rb) {
                    if (this.DEBUG1) {
                        this.debug("handleAdvertise: from RemoteBroker " + rb.getNodeName() + "::" + rb.getBrokerName() + "RNH is stale for ri: " + ri + ", RNH: " + rnh);
                    }
                    return;
                }
                res = this.m_rt.setRoute(ri, oldNode);
                if (!ri.getNodeName().equals(this.m_localNodeName) && (rci = rc.getRoutingConnection(ri.getNodeName())) != null) {
                    String outboundBrokerName = rci.getOutboundBrokerName();
                    if (Config.ENABLE_INTERBROKER && outboundBrokerName != null && outboundBrokerName.length() > 0) {
                        if (sameNode) {
                            if (!outboundBrokerName.equals(rb.getBrokerName())) {
                                setNodeInfo = false;
                            }
                        } else if (!outboundBrokerName.equals(Config.BROKER_NAME)) {
                            setNodeInfo = false;
                        }
                    }
                }
                if (setNodeInfo) {
                    ri.setRemoteNode(rnh);
                }
            }
            if (res == RouteTable.REMOVE || res == RouteTable.REPLACE) {
                if (!ri.getNodeName().equals(this.m_localNodeName)) {
                    this.m_rs.deleteRouteNode(ri);
                } else {
                    this.m_rs.deleteRouteBroker(ri);
                }
            }
            if (res == 0 || res == RouteTable.REPLACE) {
                if (this.DEBUG && setNodeInfo) {
                    this.debug("handleAdvertise: set remote node " + trackingNodeName + " for " + ri);
                }
                this.m_rs.save(ri);
                if (setNodeInfo && ri.getGlobalName().equals(WILDCARD_GLOBAL)) {
                    AgentRegistrar.getAgentRegistrar().getGSManager().notifyRemoteNodeWayOutUpdate(ri.getNodeName());
                }
                if (oldNode.getRemoteBroker() != null) {
                    AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper().notifyNodeUpdate(ri.getNodeName(), oldNode.getRemoteBroker().getNodeName());
                }
            } else {
                rr.removeInfo(i);
                continue;
            }
            if (!sameNode || ri.getNodeName().equals(this.m_localNodeName)) continue;
            rr.removeInfo(i);
        }
        if (rr.getRequestDate().getTime() == 0L) {
            rr.setRequestDate(new Date(1L));
            this.deleteUnreconciledRoutes(trackingNodeName);
        }
        if ((advertiseList = this.m_advertiseList).isEmpty()) {
            return;
        }
        if (rr.getInfoCount() == 0) {
            return;
        }
        for (int j = 0; j < advertiseList.size(); ++j) {
            IRemoteBroker rba = (IRemoteBroker)advertiseList.elementAt(j);
            sendOk = false;
            if (sameNode && !rba.getNodeName().equals(this.m_localNodeName)) {
                sendOk = true;
            }
            if (!sameNode && rba.getNodeName().equals(this.m_localNodeName)) {
                sendOk = true;
            }
            RouteForwarder.sendWhenCheckPassed(rb, rba, rr, sendOk);
        }
    }

    private static void configAdvertisedCheckingNull(RoutingConnectionInfo rci) {
        if (rci != null) {
            rci.setAdvertised(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUnreconciledRoutes(String trackingNodeName) {
        LinkedList<RouteInfo> removed = new LinkedList<RouteInfo>();
        RouteTable routeTable = this.m_rt;
        synchronized (routeTable) {
            Enumeration enu = this.m_rt.getAll();
            int deletedRouteCount = 0;
            while (enu.hasMoreElements()) {
                int res;
                RouteInfo ri = (RouteInfo)enu.nextElement();
                if (!ri.getSendingBrokerName().equals(trackingNodeName) || !ri.isReconcilePending()) continue;
                if (this.DEBUG) {
                    this.debug("requestUpdate: deleting unreconciled route " + ++deletedRouteCount + ", global name = " + ri.getGlobalName() + ", sent by " + ri.getSendingBrokerName());
                }
                if ((res = this.m_rt.removeRoute(ri, false)) != RouteTable.REMOVE) continue;
                removed.add(ri);
            }
        }
        for (RouteInfo ri : removed) {
            this.deleteRouteNodesAndBrokers(ri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdate(IRemoteBroker rb, RouteRequest rrParam) {
        IClientContext cc;
        RouteInfo ri;
        RouteRequest rr = rrParam;
        if (this.checkDebugFlags(64) && rb != null) {
            this.debug("handleUpdate: Remote Broker is " + rb.getNodeName() + "::" + rb.getBrokerName() + " Count: " + rr.getInfoCount());
        }
        String trackingNodeName = rb.getNodeName();
        boolean sameNode = false;
        if (trackingNodeName.equals(this.m_localNodeName)) {
            sameNode = true;
            trackingNodeName = trackingNodeName.concat(rb.getBrokerName());
        }
        IMgram updateRequest = null;
        RouteTable routeTable = this.m_rt;
        synchronized (routeTable) {
            RouteNodeHolder rnh = (RouteNodeHolder)this.m_nodeTable.get(trackingNodeName);
            if (rnh == null) {
                return;
            }
            if (!rnh.getInitalized()) {
                rnh.setInitialized(true);
                updateRequest = this.requestUpdate(rnh);
            }
        }
        RouteForwarder.sendOutUpdateRequest(rb, updateRequest);
        boolean advertise = false;
        if (this.m_advertiseList.contains(rb)) {
            advertise = true;
        }
        Date cutoff = rr.getRequestDate();
        rr = new RouteRequest(1);
        rr.setRequestDate(cutoff);
        if (advertise) {
            RouteTable routeTable2 = this.m_rt;
            synchronized (routeTable2) {
                Enumeration enu = this.m_rt.getAll();
                while (enu.hasMoreElements()) {
                    ri = (RouteInfo)enu.nextElement();
                    if (!cutoff.before(ri.getTimestamp())) continue;
                    boolean sendOk = false;
                    if (sameNode) {
                        if (!ri.getNodeName().equals(Config.ROUTING_NODE_NAME) && !ri.getSendingBrokerName().startsWith(Config.ROUTING_NODE_NAME)) {
                            if (this.DEBUG) {
                                this.debug("handleUpdate: cluster advertise of remote global to " + rb.getBrokerName() + " for " + ri);
                            }
                            sendOk = true;
                        }
                    } else if (ri.getNodeName().equals(this.m_localNodeName)) {
                        if (this.DEBUG) {
                            this.debug("handleUpdate: remote advertise to " + rb.getNodeName() + "::" + rb.getBrokerName() + " for " + ri);
                        }
                        sendOk = true;
                    }
                    if (!sendOk) continue;
                    RouteInfo riNew = (RouteInfo)ri.clone();
                    riNew.setHops(riNew.getHops() + 1);
                    rr.addInfo(ri);
                }
            }
            this.advertiseGlobals(rr, rb);
        }
        if (!sameNode && (cc = ((RemoteBroker)rb).getCC()) != null && cc.getClientSessionVer() >= 25) {
            RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
            RoutingConnectionInfo rci = rc.getRoutingConnection(this.m_localNodeName);
            ri = new RouteInfo();
            ri.setNodeName(this.m_localNodeName);
            ri.setGlobalName(WILDCARD_GLOBAL);
            ri.setBrokerName(Config.BROKER_NAME);
            ri.setConnectionInfo(rci);
            rr.addInfo(ri);
        }
        if (rr.getInfoCount() > 0 && rb.isConnected()) {
            rb.sendThrough(rr.getIMgram((short)-1));
        }
    }

    public void handleRemove(IRemoteBroker rb, RouteRequest rr) {
        if (this.checkDebugFlags(64) && rb != null) {
            this.debug("handleRemove: Remote Broker is " + rb.getNodeName() + "::" + rb.getBrokerName() + " Count: " + rr.getInfoCount());
        }
        boolean sameNode = false;
        boolean sendOk = false;
        if (rb.getNodeName().equals(this.m_localNodeName)) {
            sameNode = true;
        }
        for (int i = rr.getInfoCount() - 1; i >= 0; --i) {
            RouteInfo ri = rr.getInfo(i);
            int res = this.m_rt.removeRoute(ri, false);
            if (res == RouteTable.REMOVE) {
                this.deleteRouteNodesAndBrokers(ri);
            }
            if (!sameNode || ri.getNodeName().equals(this.m_localNodeName)) continue;
            rr.removeInfo(i);
        }
        Vector advertiseList = this.m_advertiseList;
        if (advertiseList.isEmpty()) {
            return;
        }
        if (rr.getInfoCount() == 0) {
            return;
        }
        for (int j = 0; j < advertiseList.size(); ++j) {
            IRemoteBroker rba = (IRemoteBroker)advertiseList.elementAt(j);
            sendOk = false;
            if (sameNode && !rba.getNodeName().equals(this.m_localNodeName)) {
                sendOk = true;
            }
            if (!sameNode && rba.getNodeName().equals(this.m_localNodeName)) {
                sendOk = true;
            }
            RouteForwarder.sendWhenCheckPassed(rb, rba, rr, sendOk);
        }
    }

    private static void sendWhenCheckPassed(IRemoteBroker rb, IRemoteBroker rba, RouteRequest rr, boolean sendOk) {
        if (sendOk && rba != rb && rba.isConnected()) {
            rba.sendThrough(rr.getIMgram((short)-1));
        }
    }

    private void deleteRouteNodesAndBrokers(RouteInfo ri) {
        if (!ri.getNodeName().equals(this.m_localNodeName)) {
            this.m_rs.deleteRouteNode(ri);
        } else {
            this.m_rs.deleteRouteBroker(ri);
        }
    }

    private RouteNodeHolder lookUpNeighbor(String trackingNodeName) {
        if (Config.ENABLE_INTERBROKER) {
            IRemoteBroker rb = null;
            INeighbor[] narray = Interbroker.getInterbroker().getAllNeighbors();
            for (int i = 0; i < narray.length; ++i) {
                rb = (IRemoteBroker)((Object)narray[i]);
                String otherTrackingNodeName = this.m_localNodeName.concat(rb.getBrokerName());
                if (this.DEBUG) {
                    this.debug("lookUpNeighbor: checking Neighbor " + rb.getBrokerName() + " comparing lookup key " + otherTrackingNodeName + " to requested key " + trackingNodeName);
                }
                if (!otherTrackingNodeName.equals(trackingNodeName)) continue;
                RouteNodeHolder rnh = new RouteNodeHolder(trackingNodeName, rb);
                this.m_nodeTable.put(trackingNodeName, rnh);
                return rnh;
            }
            if (this.DEBUG) {
                this.debug("lookUpNeighbor: Unable to locate Neighbor broker to perform message routing to match requested: " + trackingNodeName);
            }
            return null;
        }
        if (this.DEBUG) {
            this.debug("lookUpNeighbor: Unable to locate Neigbor broker to perform message routing.  This broker is not a cluster member.");
        }
        return null;
    }

    private boolean isRemoteBrokerStale(IRemoteBroker previousRemoteBroker, String outboundBrokerName, boolean outboundIsLocal) {
        if (outboundIsLocal) {
            if (previousRemoteBroker.getNodeName().equals(this.m_localNodeName)) {
                if (this.DEBUG) {
                    this.debug("getRemoteBroker: ignored previous neighbor IRemoteBroker because outbound broker has changed");
                }
                return true;
            }
        } else if (!previousRemoteBroker.getNodeName().equals(this.m_localNodeName) || !previousRemoteBroker.getBrokerName().equals(outboundBrokerName)) {
            if (this.DEBUG) {
                this.debug("getRemoteBroker: ignored previous IRemoteBroker because outbound broker has changed");
            }
            return true;
        }
        return false;
    }

    public IRemoteBroker getRemoteBroker(String nodeName, int[] destination, boolean newconnect) {
        return this.getRemoteBroker(nodeName, destination, null, null, newconnect);
    }

    public IRemoteBroker getRemoteBroker(String nodeName, int[] destination, IMgram message, boolean newconnect) {
        String httpGroupID = null;
        String httpDestURL = null;
        if (message != null) {
            Hashtable properties = message.getSidebandData().getProperties();
            try {
                httpDestURL = MgramURLHelper.getEffectiveURLDestination(message);
                httpGroupID = (String)properties.get("X-HTTP-GroupID");
            }
            catch (ClassCastException ex) {
                httpDestURL = null;
            }
        }
        return this.getRemoteBroker(nodeName, destination, httpGroupID, httpDestURL, newconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteBroker getRemoteBroker(String nodeName, int[] destination, String httpGroupID, String httpDestURL, boolean newconnect) {
        IRemoteBroker rb;
        RoutingConnectionInfo rci;
        boolean sameNode = false;
        String hashName = null;
        RouteInfo ri = null;
        String outboundBrokerName = null;
        boolean outboundIsLocal = false;
        String pendingQueueName = null;
        RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
        String trackingNodeName = nodeName;
        if (!nodeName.equals(this.m_localNodeName)) {
            rci = rc.getRoutingConnection(nodeName);
            if (rci != null && rci.getRouteType() != RoutingConnectionInfo.ROUTE_TYPE_SONIC) {
                pendingQueueName = HttpRemoteBroker.getHTTPDirectPendingQueueName(nodeName, httpGroupID, httpDestURL, rci.groupMessagesByUrl());
            }
            if (Config.ENABLE_INTERBROKER) {
                if (rci != null && (outboundBrokerName = rci.getOutboundBrokerName()) != null) {
                    if (outboundBrokerName.length() == 0) {
                        outboundBrokerName = null;
                    } else {
                        outboundIsLocal = outboundBrokerName.equals(Config.BROKER_NAME);
                    }
                }
                if (this.DEBUG) {
                    this.debug("getRemoteBroker: outbound broker is: " + outboundBrokerName);
                }
            }
        } else {
            sameNode = true;
        }
        RouteTable routeTable = this.m_rt;
        synchronized (routeTable) {
            RoutingConnectionInfo ri_rci;
            if (destination != null) {
                hashName = RouteForwarder.createHashKeyFromNodeAndDestination(destination, nodeName);
                ri = this.m_rt.getRoute(hashName);
            }
            if (ri == null) {
                hashName = new String(nodeName);
                for (int i = 0; i < this.m_wildcardDest.length; ++i) {
                    hashName = hashName.concat(Integer.toHexString(this.m_wildcardDest[i]));
                }
                if (this.DEBUG) {
                    this.debug("getRemoteBroker: looking for a wildcard entry for node " + nodeName);
                }
                ri = this.m_rt.getRoute(hashName);
                if (this.DEBUG) {
                    this.debug("getRemoteBroker: RouteInfo object for wildcard entry = " + ri);
                }
            }
            if (this.DEBUG) {
                this.debug("getRemoteBroker: nodeName = " + nodeName);
                this.debug("getRemoteBroker: destination = " + destination);
                this.debug("getRemoteBroker: newconnect flag = " + newconnect);
                this.debug("getRemoteBroker: hashName = " + hashName);
                this.debug("getRemoteBroker: RouteInfo object for hashed name = " + ri);
            }
            RouteNodeHolder rnh = null;
            if (sameNode) {
                if (ri == null) {
                    if (this.DEBUG) {
                        this.debug("getRemoteBroker; [node= " + nodeName + " hashname= " + hashName + "] returning null - 1 " + Thread.currentThread().getName());
                    }
                    return null;
                }
                trackingNodeName = nodeName.concat(ri.getBrokerName());
            } else if (pendingQueueName != null) {
                trackingNodeName = pendingQueueName;
            }
            if (!newconnect) {
                IRemoteBroker previousRemoteBroker = null;
                if (ri != null && (rnh = ri.getRemoteNode()) != null) {
                    if (this.DEBUG) {
                        this.debug("getRemoteBroker: RouteNodeHolder object for: " + rnh.getRemoteBroker());
                    }
                    previousRemoteBroker = rnh.getRemoteBroker();
                }
                if (previousRemoteBroker != null && outboundBrokerName != null && this.isRemoteBrokerStale(previousRemoteBroker, outboundBrokerName, outboundIsLocal)) {
                    previousRemoteBroker = null;
                }
                if (previousRemoteBroker == null && (rnh = (RouteNodeHolder)this.m_nodeTable.get(trackingNodeName)) != null) {
                    previousRemoteBroker = rnh.getRemoteBroker();
                }
                if (previousRemoteBroker != null && outboundBrokerName != null && this.isRemoteBrokerStale(previousRemoteBroker, outboundBrokerName, outboundIsLocal)) {
                    if (this.DEBUG1) {
                        this.debug("getRemoteBroker: previousRemoteBroker " + previousRemoteBroker + " is stale, cannot use it");
                    }
                    previousRemoteBroker = null;
                }
                if (previousRemoteBroker == null && sameNode) {
                    rnh = this.lookUpNeighbor(trackingNodeName);
                }
                if (rnh != null) {
                    if (ri != null) {
                        ri.setRemoteNode(rnh);
                    }
                    previousRemoteBroker = rnh.getRemoteBroker();
                    if (this.DEBUG) {
                        this.debug("getRemoteBroker: [node= " + nodeName + " hashname= " + hashName + "] returning previousRemoteBroker " + previousRemoteBroker + " " + Thread.currentThread().getName());
                    }
                    return previousRemoteBroker;
                }
                previousRemoteBroker = null;
                if (sameNode) {
                    if (this.DEBUG) {
                        this.debug("getRemoteBroker; [node= " + nodeName + " hashname= " + hashName + "] returning null - 2 " + Thread.currentThread().getName());
                    }
                    return null;
                }
            } else if (sameNode) {
                if (this.DEBUG1) {
                    this.debug("getRemoteBroker; [node= " + nodeName + " hashname= " + hashName + "] returning null - 3 " + Thread.currentThread().getName());
                }
                return null;
            }
            if (this.DEBUG) {
                this.debug("getRemoteBroker: [node= " + nodeName + " hashname= " + hashName + "] Either a new connection was requested, or we couldn't find a  previously used IRemoteBroker  outboundBrokerName = " + outboundBrokerName + " outboundIsLocal = " + outboundIsLocal);
            }
            if (outboundBrokerName != null && !outboundIsLocal) {
                IRemoteBroker outboundBroker = null;
                String outboundTrackingNodeName = this.m_localNodeName.concat(outboundBrokerName);
                rnh = (RouteNodeHolder)this.m_nodeTable.get(outboundTrackingNodeName);
                if (rnh != null) {
                    outboundBroker = rnh.getRemoteBroker();
                } else {
                    rnh = this.lookUpNeighbor(outboundTrackingNodeName);
                    if (rnh == null) {
                        BrokerComponent.getComponentContext().logMessage("Unable to locate routing broker for routing to node " + nodeName + " for local node " + this.m_localNodeName + ", the expected routing broker was " + outboundBrokerName + "(thread = " + Thread.currentThread().getName() + ")", 2);
                        outboundBroker = null;
                    } else {
                        outboundBroker = rnh.getRemoteBroker();
                    }
                }
                if (this.DEBUG) {
                    this.debug("getRemoteBroker: [node= " + nodeName + " hashname= " + hashName + "] returning outbound broker: " + outboundBroker + " " + Thread.currentThread().getName());
                }
                return outboundBroker;
            }
            rci = rc.getRoutingConnection(nodeName);
            boolean isStatic = false;
            if (rci != null && rci.isStaticRouting()) {
                isStatic = true;
            }
            if (ri != null && !isStatic && (ri_rci = ri.getConnectionInfo()) != null) {
                this.overrideAdvertisedConnectionInfo(ri_rci, rci);
                rci = ri_rci;
            }
            if (rci == null) {
                if (this.DEBUG) {
                    this.debug("getRemoteBroker; [node= " + nodeName + " hashname= " + hashName + "] returning null - 4 " + Thread.currentThread().getName());
                }
                return null;
            }
            rb = this.m_rm.createRemoteBroker(rci, trackingNodeName);
            rnh = (RouteNodeHolder)this.m_nodeTable.get(trackingNodeName);
            if (rnh == null) {
                if (rb != null && rb.isHttp()) {
                    this.cleanUpUnusedHttpRBs();
                    this.m_rbHelper.addHttpRemoteBroker((HttpRemoteBroker)rb);
                }
                rnh = new RouteNodeHolder(trackingNodeName, rb);
                if (this.DEBUG1) {
                    this.debug("getRemoteBroker: Adding new rnh to node table: " + rnh);
                }
                this.m_nodeTable.put(trackingNodeName, rnh);
            } else {
                IRemoteBroker oldRB = rnh.getRemoteBroker();
                if (oldRB != null && oldRB.isHttp()) {
                    this.m_rbHelper.removeHttpRemoteBroker((HttpRemoteBroker)oldRB);
                }
                rnh.setRemoteBroker(rb);
                if (rb != null && rb.isHttp()) {
                    this.m_rbHelper.addHttpRemoteBroker((HttpRemoteBroker)rb);
                }
                if (this.DEBUG1) {
                    this.debug("getRemoteBroker: replaced remote broker: " + rnh);
                }
            }
        }
        if (this.DEBUG) {
            this.debug("getRemoteBroker: [node= " + nodeName + " hashname= " + hashName + "] returning new remote broker: " + rb + " " + Thread.currentThread().getName());
        }
        return rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpUnusedHttpRBs() {
        RouteNodeHolder nodeHolder = null;
        IRemoteBroker irb = null;
        HttpRemoteBroker hrb = null;
        RouteTable routeTable = this.m_rt;
        synchronized (routeTable) {
            Iterator it = this.m_nodeTable.values().iterator();
            while (it.hasNext()) {
                nodeHolder = (RouteNodeHolder)it.next();
                irb = nodeHolder.getRemoteBroker();
                if (irb == null || !irb.isHttp() || !(hrb = (HttpRemoteBroker)irb).isOkToRemove()) continue;
                nodeHolder.setRemoteBroker(null);
                it.remove();
                this.m_rbHelper.removeHttpRemoteBroker(hrb);
            }
        }
    }

    void overrideAdvertisedConnectionInfo(RoutingConnectionInfo advertisedRCI, RoutingConnectionInfo localRCI) {
        if (localRCI != null) {
            advertisedRCI.setTimeout(localRCI.getTimeout());
            advertisedRCI.setForwardRoutings(localRCI.isForwardRoutings());
            advertisedRCI.setUserName(localRCI.getUserName());
            advertisedRCI.setPassword(localRCI.getPasswordBytes());
        } else {
            advertisedRCI.setTimeout(Config.CONNECT_IDLE_TIMEOUT);
            advertisedRCI.setForwardRoutings(false);
            advertisedRCI.setUserName("AUTHENTICATED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewConnection(IRemoteBroker rb, boolean inbound) {
        String routeNodeName;
        String trackingNodeName;
        boolean sameNode = false;
        if (this.checkDebugFlags(64) && rb != null) {
            this.debug("onNewConnection: Remote Broker is " + rb.getNodeName() + "::" + rb.getBrokerName());
        }
        if ((trackingNodeName = (routeNodeName = rb.getNodeName())).equals(this.m_localNodeName)) {
            trackingNodeName = trackingNodeName.concat(rb.getBrokerName());
        }
        RouteNodeHolder rnh = null;
        IMgram updateRequest = null;
        IRemoteBroker oldrb = null;
        RouteTable routeTable = this.m_rt;
        synchronized (routeTable) {
            rnh = (RouteNodeHolder)this.m_nodeTable.get(trackingNodeName);
            if (rnh == null) {
                rnh = new RouteNodeHolder(trackingNodeName, rb);
                if (this.DEBUG1) {
                    this.debug("onNewConnection: adding to node table: " + rnh);
                }
                this.m_nodeTable.put(trackingNodeName, rnh);
            } else if (rnh.getRemoteBroker() != null && rnh.getRemoteBroker() != rb && rnh.getRemoteBroker().isConnected()) {
                if (trackingNodeName.equals(routeNodeName)) {
                    oldrb = rnh.getRemoteBroker();
                }
                if (this.DEBUG1) {
                    this.debug("onNewConnection: inbound= " + inbound + " ***** replacing connected rb in rnh; currentRNH: " + rnh + " NEW RemoteBroker= " + rb + " oldCCid==newCCid? " + (rnh.getRemoteBroker().getClientID() == rb.getClientID()));
                }
                rnh.setFailed(false);
                rnh.setRemoteBroker(rb);
            } else {
                rnh.setFailed(false);
                rnh.setRemoteBroker(rb);
            }
            if (!inbound) {
                rnh.setInitialized(false);
            } else {
                rnh.setInitialized(true);
                updateRequest = this.requestUpdate(rnh);
            }
        }
        boolean advertise = false;
        if (this.m_localNodeName.equals(routeNodeName)) {
            sameNode = true;
            advertise = true;
        } else {
            RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
            RoutingConnectionInfo rci = rc.getRoutingConnection(routeNodeName);
            if (rci != null && rci.isForwardRoutings()) {
                advertise = true;
            }
        }
        boolean needsRemoval = false;
        boolean updated = false;
        Vector vector = this.m_advertiseList;
        synchronized (vector) {
            IRemoteBroker trb;
            for (int i = this.m_advertiseList.size() - 1; i >= 0; --i) {
                trb = (IRemoteBroker)this.m_advertiseList.elementAt(i);
                if (!trb.getNodeName().equals(rb.getNodeName()) || !trb.getBrokerName().equals(rb.getBrokerName())) continue;
                if (advertise) {
                    updated = true;
                    this.m_advertiseList.setElementAt(rb, i);
                    continue;
                }
                needsRemoval = true;
            }
            if (needsRemoval) {
                Vector<IRemoteBroker> newList = new Vector<IRemoteBroker>(this.m_advertiseList.size());
                for (int i = this.m_advertiseList.size() - 1; i >= 0; --i) {
                    trb = (IRemoteBroker)this.m_advertiseList.elementAt(i);
                    if (trb.getNodeName().equals(rb.getNodeName()) && trb.getBrokerName().equals(rb.getBrokerName())) continue;
                    newList.addElement(trb);
                }
                this.m_advertiseList.clear();
                this.m_advertiseList.addAll(newList);
            } else if (advertise && !updated) {
                this.m_advertiseList.addElement(rb);
            }
        }
        if (!sameNode) {
            AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper().notifyNodeUpdate(rb.getNodeName(), rb.getNodeName());
        }
        RouteForwarder.sendOutUpdateRequest(rb, updateRequest);
        if (oldrb != null) {
            this.m_rm.prepareForIdleTimeout(oldrb);
        }
    }

    private static void sendOutUpdateRequest(IRemoteBroker rb, IMgram updateRequest) {
        if (updateRequest != null && rb.isConnected()) {
            rb.sendThrough(updateRequest);
        }
    }

    public void onNewGlobal(String globalName) {
        Vector advertiseList;
        if (this.checkDebugFlags(64)) {
            this.debug("onNewGlobal: global name is " + globalName);
        }
        if ((advertiseList = this.m_advertiseList).isEmpty()) {
            return;
        }
        RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
        RoutingConnectionInfo rci = rc.getRoutingConnection(this.m_localNodeName);
        RouteRequest rr = new RouteRequest(1);
        this.createRouteInfo(globalName, rci, rr);
        for (int j = 0; j < advertiseList.size(); ++j) {
            IRemoteBroker rba = (IRemoteBroker)advertiseList.elementAt(j);
            if (!rba.isConnected()) continue;
            rba.sendThrough(rr.getIMgram((short)-1));
        }
    }

    public void onRemoveGlobal(String nodeName, String globalName) {
        this.onRemoveGlobal(nodeName, globalName, false);
    }

    public void onRemoveGlobal(String nodeName, String globalName, boolean isDestination) {
        Vector advertiseList;
        if (this.checkDebugFlags(64)) {
            this.debug("onRemoveGlobal: node name is " + nodeName + ", global name is " + globalName + ", isDestination is " + isDestination);
        }
        RouteInfo ri = new RouteInfo();
        ri.setGlobalName(globalName);
        ri.setNodeName(nodeName);
        ri.setBrokerName(Config.BROKER_NAME);
        int res = this.m_rt.removeRoute(ri, isDestination);
        if (res == RouteTable.REMOVE) {
            if (!nodeName.equals(this.m_localNodeName) || isDestination) {
                this.m_rs.deleteRouteNode(ri);
            } else {
                this.m_rs.deleteRouteBroker(ri);
            }
        }
        if ((advertiseList = this.m_advertiseList).isEmpty()) {
            return;
        }
        RouteRequest rr = new RouteRequest(3);
        rr.addInfo(ri);
        if (isDestination && ri.getNodeName().equals(this.m_localNodeName)) {
            return;
        }
        for (int j = 0; j < advertiseList.size(); ++j) {
            IRemoteBroker rba = (IRemoteBroker)advertiseList.elementAt(j);
            if (isDestination) {
                if (!rba.getNodeName().equals(this.m_localNodeName) || !rba.isConnected()) continue;
                rba.sendThrough(rr.getIMgram((short)-1));
                continue;
            }
            if (!rba.isConnected()) continue;
            rba.sendThrough(rr.getIMgram((short)-1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRoutePathFailure(String nodeName, String brokerName) {
        RouteInfo ri = null;
        RouteNodeHolder rnh = null;
        String trackingNodeName = null;
        trackingNodeName = nodeName;
        if (trackingNodeName.equals(this.m_localNodeName)) {
            trackingNodeName = trackingNodeName.concat(brokerName);
        }
        RouteTable routeTable = this.m_rt;
        synchronized (routeTable) {
            rnh = (RouteNodeHolder)this.m_nodeTable.get(trackingNodeName);
            if (rnh == null) {
                return;
            }
            rnh.setFailed(true);
            if (this.checkDebugFlags(64)) {
                this.debug("onRoutePathFailure: marked " + rnh.getTrackingNodeName() + " as failed");
            }
            Enumeration routes = this.m_rt.getAll();
            while (routes.hasMoreElements()) {
                for (RouteInfo riNext = ri = (RouteInfo)routes.nextElement(); riNext != null; riNext = riNext.getNext()) {
                    if (riNext.getRemoteNode() != rnh || riNext.getNodeName().equals(this.m_localNodeName) && riNext.getBrokerName().equals(brokerName)) continue;
                    riNext.setRemoteNode(null);
                    if (!this.DEBUG1) continue;
                    this.debug("onRoutePathFailure: Decoupled global (" + riNext.getGlobalName() + ", " + riNext.getNodeName() + ", " + riNext.getBrokerName() + ") from " + rnh.getTrackingNodeName());
                }
            }
        }
    }

    public void advertiseGlobals(RouteRequest rr, IRemoteBroker rb) {
        RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
        RoutingConnectionInfo rci = rc.getRoutingConnection(this.m_localNodeName);
        AgentQueueProcessor aqp = AgentRegistrar.getAgentRegistrar().getQueueProc();
        Enumeration enu = aqp.getGlobalQueues();
        while (enu.hasMoreElements()) {
            IAgentQueue iaq = (IAgentQueue)enu.nextElement();
            String globalName = iaq.getQueueName();
            this.createRouteInfo(globalName, rci, rr);
        }
    }

    private void createRouteInfo(String globalName, RoutingConnectionInfo rci, RouteRequest rr) {
        RouteInfo ri = new RouteInfo();
        ri.setGlobalName(globalName);
        ri.setNodeName(this.m_localNodeName);
        ri.setBrokerName(Config.BROKER_NAME);
        ri.setConnectionInfo(rci);
        rr.addInfo(ri);
    }

    public IMgram requestUpdate(RouteNodeHolder rnh) {
        String routeNodeName;
        String trackingNodeName;
        IRemoteBroker rb = rnh.getRemoteBroker();
        if (this.checkDebugFlags(64) && rb != null) {
            this.debug("requestUpdate: Remote Broker is " + rb.getNodeName() + "::" + rb.getBrokerName());
        }
        if ((trackingNodeName = (routeNodeName = rb.getNodeName())).equals(this.m_localNodeName)) {
            trackingNodeName = trackingNodeName.concat(rb.getBrokerName());
        }
        Enumeration enu = this.m_rt.getAll();
        RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
        RoutingConnectionInfo rci = null;
        int updatedRouteCount = 0;
        while (enu.hasMoreElements()) {
            RouteInfo ri = (RouteInfo)enu.nextElement();
            if (!ri.getSendingBrokerName().equals(trackingNodeName)) continue;
            if (this.m_localNodeName.equals(rb.getNodeName()) && ri.getGlobalName().equals(WILDCARD_GLOBAL)) {
                if (ri.getRemoteNode() != null) continue;
                String outboundBrokerName = null;
                if (Config.ENABLE_INTERBROKER && (rci = rc.getRoutingConnection(ri.getNodeName())) != null) {
                    outboundBrokerName = rci.getOutboundBrokerName();
                }
                if (outboundBrokerName != null && outboundBrokerName.length() != 0 && !outboundBrokerName.equals(rb.getBrokerName())) continue;
                ri.setRemoteNode(rnh);
                if (!this.DEBUG1) continue;
                this.debug("requestUpdate set RNH for ri: " + ri);
                continue;
            }
            if (this.DEBUG) {
                this.debug("requestUpdate: marked route " + ++updatedRouteCount + " for reconcile, global name = " + ri.getGlobalName() + ", sent by " + ri.getSendingBrokerName());
            }
            ri.setReconcilePending();
        }
        RouteRequest rr = new RouteRequest(2);
        rr.setRequestDate(new Date(0L));
        return rr.getIMgram((short)-1);
    }

    public RouteSaver getRouteSaver() {
        return this.m_rs;
    }

    public boolean lookupGlobalDestination(String nodeName, int[] destination) {
        RouteInfo ri;
        boolean exists = false;
        String hashName = null;
        if (destination != null && (ri = this.m_rt.getRoute(hashName = RouteForwarder.createHashKeyFromNodeAndDestination(destination, nodeName))) != null) {
            exists = true;
        }
        return exists;
    }

    private static String createHashKeyFromNodeAndDestination(int[] destination, String nodeName) {
        String hashName = new String(nodeName);
        for (int i = 0; i < destination.length; ++i) {
            hashName = hashName.concat(Integer.toHexString(destination[i]));
        }
        return hashName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRouteInfoList() {
        if (this.DEBUG) {
            this.debug("getRouteInfoList:");
        }
        Vector<RouteInfo> routes = new Vector<RouteInfo>();
        RouteTable routeTable = this.m_rt;
        synchronized (routeTable) {
            Enumeration enu = this.m_rt.getAll();
            while (enu.hasMoreElements()) {
                RouteInfo ri = (RouteInfo)enu.nextElement();
                if (ri.getGlobalName().equals(WILDCARD_GLOBAL)) continue;
                if (this.DEBUG) {
                    this.debug("getRouteInfoList: adding " + ri.getGlobalName());
                }
                routes.addElement(ri);
            }
        }
        return routes;
    }

    public void stopRouteSaver() {
        if (this.m_rs != null) {
            this.m_rs.shutdown();
        }
    }

    public ArrayList getGlobalQueueRoutes(String prefix) {
        ArrayList<IGlobalQueueRouteData> routes = new ArrayList<IGlobalQueueRouteData>();
        boolean useFilter = prefix != null && prefix.length() > 0;
        Enumeration enu = this.getRouteInfoList().elements();
        while (enu.hasMoreElements()) {
            RouteInfo info = (RouteInfo)enu.nextElement();
            String node = info.getNodeName();
            if (useFilter && !node.startsWith(prefix)) continue;
            IGlobalQueueRouteData advertisement = RuntimeDataFactory.createGlobalQueueRouteData(node, info.getGlobalName());
            routes.add(advertisement);
        }
        return routes;
    }

    public void deleteGlobalQueueRoutes(ArrayList globalQueueRoutes) {
        for (IGlobalQueueRouteData route : globalQueueRoutes) {
            this.onRemoveGlobal(route.getRoutingNode(), route.getGlobalQueueName(), true);
        }
    }

    public void clearGlobalQueueRoutes(String prefix) {
        ArrayList routes = this.getGlobalQueueRoutes(prefix);
        this.deleteGlobalQueueRoutes(routes);
    }
}

