/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg;

import java.io.IOException;
import java.io.InputStream;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMsgTooBigException;
import progress.message.zclient.SessionConfig;

public final class StreamUtilCounter {
    private int m_count = 0;
    private boolean m_applySizeLimit = false;

    public StreamUtilCounter(boolean applySizeLimit) {
        this.m_applySizeLimit = applySizeLimit;
    }

    public short readShort(InputStream is) throws IOException {
        this.incrementCounter(2);
        return StreamUtil.readShort(is);
    }

    public long readLong(InputStream is) throws IOException {
        this.incrementCounter(8);
        return StreamUtil.readLong(is);
    }

    public long read6ByteLong(InputStream is) throws IOException {
        this.incrementCounter(6);
        return StreamUtil.read6ByteLong(is);
    }

    public int readInt(InputStream is) throws IOException {
        this.incrementCounter(4);
        return StreamUtil.readInt(is);
    }

    public byte[] readUTFString(InputStream is) throws IOException {
        byte[] returnVal = StreamUtil.readUTFString(is);
        this.incrementCounter(returnVal.length);
        return returnVal;
    }

    public void readBytes(InputStream is, byte[] target, int offset, int length) throws IOException {
        this.incrementCounter(length);
        StreamUtil.readBytes(is, target, offset, length);
    }

    public byte readByte(InputStream is) throws IOException {
        this.incrementCounter(1);
        return StreamUtil.readByte(is);
    }

    public void resetCounter() {
        this.m_count = 0;
    }

    public int getCounter() {
        return this.m_count;
    }

    public void skip(InputStream is, int len) throws IOException {
        this.incrementCounter(len);
        StreamUtil.skip(is, len);
    }

    public final void incrementCounter(int value) throws IOException {
        this.m_count += value;
        if (this.m_applySizeLimit && SessionConfig.MAX_MSG_SIZE > 0 && this.m_count > SessionConfig.MAX_MSG_SIZE) {
            throw new EMsgTooBigException(this.m_count, SessionConfig.MAX_MSG_SIZE);
        }
    }

    public final void checkMessageLength(int msgLength) throws IOException {
        int size;
        if (this.m_applySizeLimit && SessionConfig.MAX_MSG_SIZE > 0 && (size = this.m_count + msgLength) > SessionConfig.MAX_MSG_SIZE) {
            throw new EMsgTooBigException(size, SessionConfig.MAX_MSG_SIZE);
        }
    }
}

