/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.security.Principal;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.util.DebugState;
import progress.message.zclient.Group;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressPrincipal;
import progress.message.zclient.prAccessor;

public final class ProgressGroup
extends ProgressPrincipal
implements Group {
    private final String m_name;
    private final Hashtable m_membersUsers;

    public ProgressGroup(String group_name) {
        this(group_name, new Hashtable());
    }

    public ProgressGroup(String group_name, Hashtable membersUsers) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ProgressGroup" : null);
        if (this.DEBUG) {
            this.debug("in ctor");
        }
        this.m_name = group_name;
        this.m_membersUsers = membersUsers == null ? new Hashtable() : membersUsers;
        if (this.DEBUG) {
            this.debug("leaving ctor");
        }
    }

    @Override
    public boolean addMember(Principal user) {
        if (this.DEBUG) {
            this.debug("in addMember");
        }
        if (user == null) {
            return false;
        }
        String principalName = user.getName();
        if (user instanceof ProgressPasswordUser) {
            Object obj = this.m_membersUsers.get(principalName);
            if (obj == null) {
                this.m_membersUsers.put(principalName, user);
                ((ProgressPasswordUser)user).setlogOperation((short)2);
                if (this.DEBUG) {
                    this.debug("Added user " + principalName + " to group " + this.m_name + ". About to return");
                }
                return true;
            }
            if (this.DEBUG) {
                this.debug("User already in group.  About to return");
            }
            return false;
        }
        String mf85 = prAccessor.getString("STR185");
        return this.logData(principalName, mf85, user);
    }

    @Override
    public boolean removeMember(Principal user) {
        if (this.DEBUG) {
            this.debug("in removeMember");
        }
        if (user == null) {
            return false;
        }
        String principalName = user.getName();
        if (user instanceof ProgressPasswordUser) {
            Object obj = this.m_membersUsers.get(principalName);
            if (obj == null) {
                return this.debugNotFoundInTheGroup(principalName, user);
            }
            Object status = this.m_membersUsers.remove(principalName);
            if (status != null) {
                ((ProgressPasswordUser)user).setlogOperation((short)3);
                if (this.DEBUG) {
                    this.debug("Removed user " + principalName + " from group " + this.m_name + ". About to return");
                }
                return true;
            }
            return this.debugNotFoundInTheGroup(principalName, user);
        }
        String mf128 = prAccessor.getString("STR186");
        return this.logData(principalName, mf128, user);
    }

    private boolean logData(String principalName, String mf128, Principal user) {
        Object[] ob128 = new Object[]{principalName};
        System.out.println(MessageFormat.format(mf128, ob128));
        return false;
    }

    private boolean debugNotFoundInTheGroup(String principalName, Principal user) {
        if (this.DEBUG) {
            this.debug("User " + principalName + " not found in group " + this.m_name + ". About to return");
        }
        return false;
    }

    @Override
    public boolean isMember(Principal member) {
        boolean retVal = false;
        if (this.DEBUG) {
            this.debug("entering isMember.");
        }
        if (member == null) {
            return retVal;
        }
        String principalName = member.getName();
        if (member instanceof ProgressPasswordUser) {
            Object obj = this.m_membersUsers.get(principalName);
            if (obj != null) {
                return true;
            }
            return retVal;
        }
        String mf155 = prAccessor.getString("STR187");
        Object[] ob155 = new Object[]{principalName};
        System.out.println(MessageFormat.format(mf155, ob155));
        return retVal;
    }

    @Override
    public Enumeration members() {
        if (this.DEBUG) {
            this.debug("entering members()");
        }
        return this.m_membersUsers.elements();
    }

    @Override
    public String getName() {
        if (this.DEBUG) {
            this.debug("entering getName()");
        }
        return this.m_name;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ProgressGroup && ((ProgressGroup)obj).m_name.equals(this.m_name);
    }

    @Override
    public int hashCode() {
        return this.m_name.hashCode();
    }
}

