/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mq.common.runtime.ISubscriberData;
import com.sonicsw.mq.common.runtime.JMSObjectFactory;
import com.sonicsw.mq.common.runtime.impl.Destination;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;

public class SubscriberData
implements ISubscriberData,
Serializable {
    static final long serialVersionUID = -212987638287163571L;
    private static final short CURRENT_VERSION = 1;
    private transient short m_version = 1;
    private String m_clientID;
    private String m_subscriptionName;
    private long m_messageCount;
    private long m_messageSize;
    private boolean m_isDurable;
    private boolean m_isConnectionConsumer;
    private transient Destination m_destination;
    private Long m_connectionMemberRef = null;

    public SubscriberData() {
    }

    public SubscriberData(String clientID, String subscriptionName, byte[] subject, boolean isDurable, boolean isConnectionConsumer, long messageCount, long messageSize, long connectionMemberRef) {
        this.m_clientID = clientID;
        this.m_subscriptionName = subscriptionName;
        this.m_destination = new Destination(null, subject);
        this.m_messageCount = messageCount;
        this.m_messageSize = messageSize;
        this.m_isDurable = isDurable;
        this.m_isConnectionConsumer = isConnectionConsumer;
        this.m_connectionMemberRef = new Long(connectionMemberRef);
    }

    @Override
    public String getClientID() {
        return this.m_clientID;
    }

    @Override
    public String getSubscriptionName() {
        return this.m_subscriptionName;
    }

    @Override
    public long getMessageCount() {
        return this.m_messageCount;
    }

    @Override
    public long getMessageSize() {
        return this.m_messageSize;
    }

    @Override
    public boolean isConnectionConsumer() {
        return this.m_isConnectionConsumer;
    }

    @Override
    public boolean isDurable() {
        return this.m_isDurable;
    }

    @Override
    public String getTopicName() {
        progress.message.jimpl.Destination dest = (progress.message.jimpl.Destination)JMSObjectFactory.createJMSDestination(this.m_destination);
        if (dest == null) {
            return null;
        }
        return dest.getFullName();
    }

    public Destination getDestination() {
        return this.m_destination;
    }

    @Override
    public Long getConnectionMemberRef() {
        return this.m_connectionMemberRef;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(this.m_version);
        stream.writeUTF(this.m_clientID);
        stream.writeUTF(this.m_subscriptionName);
        stream.writeObject(this.m_destination);
        stream.writeBoolean(this.m_isDurable);
        stream.writeBoolean(this.m_isConnectionConsumer);
        stream.writeLong(this.m_messageCount);
        stream.writeLong(this.m_messageSize);
        stream.writeObject(this.m_connectionMemberRef);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        block2: {
            this.m_version = stream.readShort();
            this.m_clientID = stream.readUTF();
            this.m_subscriptionName = stream.readUTF();
            this.m_destination = (Destination)stream.readObject();
            this.m_isDurable = stream.readBoolean();
            this.m_isConnectionConsumer = stream.readBoolean();
            this.m_messageCount = stream.readLong();
            this.m_messageSize = stream.readLong();
            try {
                this.m_connectionMemberRef = (Long)stream.readObject();
            }
            catch (OptionalDataException e) {
                if (e.eof) break block2;
                throw e;
            }
        }
    }
}

