/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mq.components.ACLPermissionChangeHandler;
import com.sonicsw.mq.components.AddNewAcceptorDirectProtocolHandler;
import com.sonicsw.mq.components.AddNewAcceptorDirectURLHandler;
import com.sonicsw.mq.components.AddNewCRLCachePolicyChangeHandler;
import com.sonicsw.mq.components.AddNewGSRuleChangeHandler;
import com.sonicsw.mq.components.AddNewQueueChangeHandler;
import com.sonicsw.mq.components.AddNewReplicationChannelChangeHandler;
import com.sonicsw.mq.components.AddNewRouteChangeHandler;
import com.sonicsw.mq.components.AttributeChangeHandlerFactory;
import com.sonicsw.mq.components.AttributesHolder;
import com.sonicsw.mq.components.AuthSPIAttributeSettingsChangeHandler;
import com.sonicsw.mq.components.AuthSPIDefinationChangeHandler;
import com.sonicsw.mq.components.BrokerAcceptorChangeDelegator;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerCredentialsChangeHandler;
import com.sonicsw.mq.components.BrokerKeyStoreChangeHandler;
import com.sonicsw.mq.components.BrokerNotificationConfigChangeHandler;
import com.sonicsw.mq.components.BrokerTrustStoreChangeHandler;
import com.sonicsw.mq.components.CRLCachePolicyChangeHandler;
import com.sonicsw.mq.components.CertificateStoreChangeHandler;
import com.sonicsw.mq.components.ClusterChangeHandler;
import com.sonicsw.mq.components.ClusterPeerUpdateChangeHandler;
import com.sonicsw.mq.components.ConnectionTuningConfigChangeHandler;
import com.sonicsw.mq.components.DirectProtocolConfigChangeHandler;
import com.sonicsw.mq.components.DirectURLConfigChangeHandler;
import com.sonicsw.mq.components.DirectURLWSConfigChangeHandler;
import com.sonicsw.mq.components.ExternalDomainAuthSPINameChangeHandler;
import com.sonicsw.mq.components.ExternalDomainGroupMapChangeHandler;
import com.sonicsw.mq.components.LGConfigChangeHandler;
import com.sonicsw.mq.components.ProductInfoChangeHandler;
import com.sonicsw.mq.components.PubSubConfigChangeHandler;
import com.sonicsw.mq.components.QoPTypeChangeHandler;
import com.sonicsw.mq.components.QueueConfigChangeHandler;
import com.sonicsw.mq.components.RemoveACLChangeHandler;
import com.sonicsw.mq.components.RemoveGSRuleChangeHandler;
import com.sonicsw.mq.components.RemoveGroupChangeHandler;
import com.sonicsw.mq.components.RemoveQoPChangeHandler;
import com.sonicsw.mq.components.RemoveUserChangeHandler;
import com.sonicsw.mq.components.ReplicationChannelChangeHandler;
import com.sonicsw.mq.components.RouteConfigChangeHandler;
import com.sonicsw.mq.components.RoutingParametersChangeHandler;
import com.sonicsw.mq.components.SecurityParametersChangeHandler;
import com.sonicsw.mq.components.UpdateGSRuleChangeHandler;
import com.sonicsw.mq.components.UserPasswordChangeHandler;
import com.sonicsw.security.cert.BrokerCertificateStore;
import com.sonicsw.security.cert.BrokerKeyStore;
import com.sonicsw.security.cert.BrokerTrustStore;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundEntry;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.ft.ReplicationChannel;
import progress.message.net.ssl.CRLCachePolicy;
import progress.message.zclient.ProgressPasswordUser;

public class ConfigurationChangeBindHelper {
    private static volatile IComponentContext s_componentContext = null;
    private static volatile AttributesHolder s_attributesHolder = null;
    private static volatile AttributeChangeHandlerFactory s_handlerFactory;
    private static volatile Hashtable<String, IAttributeSet> s_boundIndividualClusterPeerChangeAset;
    private static volatile Hashtable<String, BrokerAcceptorChangeDelegator> s_boundBrokerAcceptorChangeDelegator;
    private static final Object DOUBLE_CHECK_LOCK_OBJ;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationChangeBindHelper(AttributeChangeHandlerFactory handlerFactory, AttributesHolder attributesHolder, IComponentContext componentContext) {
        Object object;
        if (s_handlerFactory == null) {
            object = DOUBLE_CHECK_LOCK_OBJ;
            synchronized (object) {
                if (s_handlerFactory == null) {
                    s_handlerFactory = handlerFactory;
                }
            }
        }
        if (s_attributesHolder == null) {
            object = DOUBLE_CHECK_LOCK_OBJ;
            synchronized (object) {
                if (s_attributesHolder == null) {
                    s_attributesHolder = attributesHolder;
                }
            }
        }
        if (s_componentContext == null) {
            object = DOUBLE_CHECK_LOCK_OBJ;
            synchronized (object) {
                if (s_componentContext == null) {
                    s_componentContext = componentContext;
                }
            }
        }
        if (s_boundIndividualClusterPeerChangeAset == null) {
            object = DOUBLE_CHECK_LOCK_OBJ;
            synchronized (object) {
                if (s_boundIndividualClusterPeerChangeAset == null) {
                    s_boundIndividualClusterPeerChangeAset = new Hashtable();
                }
            }
        }
        if (s_boundBrokerAcceptorChangeDelegator == null) {
            object = DOUBLE_CHECK_LOCK_OBJ;
            synchronized (object) {
                if (s_boundBrokerAcceptorChangeDelegator == null) {
                    s_boundBrokerAcceptorChangeDelegator = new Hashtable();
                }
            }
        }
    }

    void bindChangeHandlers() {
        this.bindQueueChangeHandlers();
    }

    void bindQueueChangeHandlers() {
        Enumeration qnamesEnum;
        IAttributeSet unclusteredTopLevelQueueAS;
        IAttributeSet clusteredTopLevelQueueAS = s_attributesHolder.getClusteredTopLevelQueueAttributeSet();
        if (clusteredTopLevelQueueAS != null) {
            AddNewQueueChangeHandler newQueueHandler = s_handlerFactory.createAddNewQueueChangeHandler(s_attributesHolder, this);
            clusteredTopLevelQueueAS.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)newQueueHandler);
        }
        if ((unclusteredTopLevelQueueAS = s_attributesHolder.getUnclusteredTopLevelQueueAttributeSet()) != null) {
            AddNewQueueChangeHandler newQueueHandler = s_handlerFactory.createAddNewQueueChangeHandler(s_attributesHolder, this);
            unclusteredTopLevelQueueAS.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)newQueueHandler);
        }
        if ((qnamesEnum = s_attributesHolder.getQueueNames()) != null) {
            String qname = null;
            IAttributeSet qas = null;
            while (qnamesEnum.hasMoreElements()) {
                qname = (String)qnamesEnum.nextElement();
                qas = s_attributesHolder.getQueueAttributeSet(qname);
                this.bindQueueChangeHandler(qname, qas);
            }
        }
    }

    public void bindQueueChangeHandler(String queueName, IAttributeSet qas) {
        QueueConfigChangeHandler handler = s_handlerFactory.createQueueConfigChangeHandler(queueName, s_attributesHolder);
        qas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    public void bindClusterChangeHandler(IAttributeSet cas) {
        if (cas == null) {
            return;
        }
        ClusterChangeHandler handler = s_handlerFactory.createClusterChangeHandler();
        cas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindRemoveUserChangeHandler(String username, IAttributeSet uas) {
        if (username == null || uas == null) {
            return;
        }
        RemoveUserChangeHandler handler = s_handlerFactory.createRemoveUserChangeHandler(username);
        uas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindUserPasswordChangeHandler(ProgressPasswordUser user, IAttributeSet uas) {
        if (user == null || uas == null) {
            return;
        }
        UserPasswordChangeHandler handler = s_handlerFactory.createUserPasswordChangeHandler(user, s_attributesHolder);
        uas.registerAttributeChangeHandler((Object)s_componentContext, "PASSWORD", (IAttributeChangeHandler)handler);
    }

    void bindAddNewRouteChangeHandler(IAttributeSet ias, boolean securityEnabled) {
        AddNewRouteChangeHandler handler = s_handlerFactory.createAddNewRouteChangeHandler(this, securityEnabled);
        ias.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindAddNewAcceptorDirectURLHandler(IAttributeSet ias, String name, String type, HTTPAcceptor httpAcceptor) {
        AddNewAcceptorDirectURLHandler handler = s_handlerFactory.createAddNewAcceptorDirectURLHandler(this, name, type, httpAcceptor);
        ias.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindDirectURLConfigChangeHandler(IAttributeSet as, HTTPDirectInboundEntry entry, String name, HTTPAcceptor httpAcceptor) {
        DirectURLConfigChangeHandler handler = s_handlerFactory.createDirectURLConfigChangeHandler(entry, name, httpAcceptor);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindDirectURLWSConfigChangeHandler(IAttributeSet as, HTTPDirectInboundEntry entry, String name, HTTPAcceptor httpAcceptor) {
        DirectURLWSConfigChangeHandler handler = s_handlerFactory.createDirectURLWSConfigChangeHandler(entry, name, httpAcceptor);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindDirectProtocolConfigChangeHandler(IAttributeSet as, String name, HTTPAcceptor httpAcceptor) {
        DirectProtocolConfigChangeHandler handler = s_handlerFactory.createDirectProtocolConfigChangeHandler(name, httpAcceptor);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindAddNewAcceptorDirectProtocolHandler(IAttributeSet ias, HTTPAcceptor httpAcceptor) {
        Iterator iterator = ias.getAttributes().keySet().iterator();
        String attributeName = null;
        Hashtable<String, String> names = new Hashtable<String, String>();
        Reference ref = null;
        while (iterator.hasNext()) {
            attributeName = (String)iterator.next();
            ref = (Reference)ias.getAttributes().get(attributeName);
            String hdceCID = ref.getElementName();
            IElement hdce = s_componentContext.getConfiguration(hdceCID, true);
            IAttributeSet das = hdce.getAttributes();
            String handlerName = (String)das.getAttribute("DIRECT_NAME");
            names.put(attributeName, handlerName);
        }
        AddNewAcceptorDirectProtocolHandler handler = s_handlerFactory.createAddNewAcceptorDirectProtocolHandler(this, httpAcceptor, names);
        ias.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindAddNewReplicationChannelChangeHandler(IAttributeSet ias) {
        AddNewReplicationChannelChangeHandler handler = s_handlerFactory.createAddNewReplicationChannelChangeHandler(this);
        ias.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindAddNewCRLCachePolicyChangeHandler(IAttributeSet ias) {
        AddNewCRLCachePolicyChangeHandler handler = s_handlerFactory.createAddNewCRLCachePolicyChangeHandler(this);
        ias.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindRemoveGroupChangeHandler(String groupname, IAttributeSet gas) {
        if (groupname == null || gas == null) {
            return;
        }
        RemoveGroupChangeHandler handler = s_handlerFactory.createRemoveGroupChangeHandler(groupname);
        gas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindACLChangeHandlers(String principalName, String principalType, String resourceName, String aclType, IAttributeSet aas) {
        if (principalName == null || principalType == null || resourceName == null || aclType == null) {
            return;
        }
        this.bindRemoveACLChangeHandler(principalName, principalType, resourceName, aclType, aas);
        this.bindACLPermissionChangeHandler(principalName, principalType, resourceName, aclType, aas);
    }

    void bindRemoveACLChangeHandler(String principalName, String principalType, String resourceName, String aclType, IAttributeSet aas) {
        RemoveACLChangeHandler handler = s_handlerFactory.createRemoveACLChangeHandler(principalName, principalType, resourceName, aclType);
        aas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindACLPermissionChangeHandler(String principalName, String principalType, String resourceName, String aclType, IAttributeSet aas) {
        ACLPermissionChangeHandler handler = s_handlerFactory.createACLPermissionChangeHandler(principalName, principalType, resourceName, aclType);
        aas.registerAttributeChangeHandler((Object)s_componentContext, "PERMISSION", (IAttributeChangeHandler)handler);
    }

    void bindRemoveQoPChangeHandler(String subjectName, IAttributeSet qopas) {
        RemoveQoPChangeHandler handler = s_handlerFactory.createRemoveQoPChangeHandler(subjectName);
        qopas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindQoPTypeChangeHandler(String subjectName, IAttributeSet qopas) {
        if (subjectName == null || qopas == null) {
            return;
        }
        QoPTypeChangeHandler handler = s_handlerFactory.createQoPTypeChangeHandler(subjectName);
        qopas.registerAttributeChangeHandler((Object)s_componentContext, "QOP", (IAttributeChangeHandler)handler);
    }

    void bindRouteConfigChangeHandler(RoutingConnectionInfo rci, IAttributeSet ras) {
        RouteConfigChangeHandler handler = s_handlerFactory.createRouteConfigChangeHandler(rci, s_attributesHolder);
        ras.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    public void bindReplicationChannelChangeHandler(ReplicationChannel rch, IAttributeSet rchas) {
        ReplicationChannelChangeHandler handler = s_handlerFactory.createReplicationChannelChangeHandler(rch);
        rchas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    public void bindCRLCachePolicyChangeHandler(CRLCachePolicy policy, IAttributeSet cpas) {
        CRLCachePolicyChangeHandler handler = s_handlerFactory.createCRLCachePolicyChangeHandler(policy);
        cpas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindClusterPeerUpdateChangeHandler(String clusterName, IAttributeSet cpas, HashMap brokerNameMap) {
        ClusterPeerUpdateChangeHandler handler = s_handlerFactory.createClusterPeerUpdateChangeHandler(this, clusterName, brokerNameMap);
        cpas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindAddNewGSRuleChangeHandler(IAttributeSet gsas) {
        if (gsas == null) {
            return;
        }
        AddNewGSRuleChangeHandler handler = s_handlerFactory.createAddNewGSRuleChangeHandler(this);
        gsas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindRemoveGSRuleChangeHandler(String topicName, IAttributeSet gsas) {
        if (topicName == null || gsas == null) {
            return;
        }
        RemoveGSRuleChangeHandler handler = s_handlerFactory.createRemoveGSRuleChangeHandler(topicName);
        gsas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindUpdateGSRuleChangeHandler(String topicName, Vector toNodes, IAttributeSet gsas) {
        if (topicName == null || gsas == null) {
            return;
        }
        UpdateGSRuleChangeHandler handler = s_handlerFactory.createUpdateGSRuleChangeHandler(topicName, toNodes);
        gsas.registerAttributeChangeHandler((Object)s_componentContext, "NODES", (IAttributeChangeHandler)handler);
    }

    void unbindNonLocalBrokerAcceptorChangeDelegators() {
        Enumeration entries = ((Hashtable)s_boundBrokerAcceptorChangeDelegator.clone()).keys();
        while (entries.hasMoreElements()) {
            String bname = (String)entries.nextElement();
            if (bname.equals(BrokerComponent.getBrokerComponent().getBrokerName())) continue;
            this.unbindBrokerAcceptorChangeDelegator(bname);
        }
    }

    void unbindBrokerAcceptorChangeDelegator(String bname) {
        IAttributeSet aset = s_boundIndividualClusterPeerChangeAset.get(bname);
        BrokerAcceptorChangeDelegator handler = s_boundBrokerAcceptorChangeDelegator.get(bname);
        if (handler != null) {
            handler.prepareToUnbind();
            s_boundBrokerAcceptorChangeDelegator.remove(bname);
        }
        if (aset != null) {
            aset.unregisterAttributeChangeHandler((Object)s_componentContext);
            s_boundIndividualClusterPeerChangeAset.remove(bname);
        }
    }

    void bindBrokerAcceptorChangeDelegator(String bname, IElement primarybce) {
        if (primarybce == null) {
            return;
        }
        BrokerAcceptorChangeDelegator handler = s_boundBrokerAcceptorChangeDelegator.get(bname);
        if (handler != null) {
            return;
        }
        IAttributeSet primarybuas = primarybce.getAttributes();
        IAttributeSet primarycers = (IAttributeSet)primarybuas.getAttribute("CONFIG_ELEMENT_REFERENCES");
        handler = s_handlerFactory.createBrokerAcceptorChangeDelegator(s_componentContext, primarybce, bname);
        primarycers.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
        s_boundIndividualClusterPeerChangeAset.put(bname, primarycers);
        s_boundBrokerAcceptorChangeDelegator.put(bname, handler);
    }

    void bindConnectionTuningConfigChangeHandler(IAttributeSet ctpas) {
        if (ctpas == null) {
            return;
        }
        ConnectionTuningConfigChangeHandler handler = s_handlerFactory.createConnectionTuningConfigChangeHandler();
        ctpas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindPubSubConfigChangeHandler(IAttributeSet psas) {
        if (psas == null) {
            return;
        }
        PubSubConfigChangeHandler handler = s_handlerFactory.createPubSubConfigChangeHandler();
        psas.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindProductInfoChangeHandler(IAttributeSet pias, Properties props) {
        if (pias == null) {
            return;
        }
        ProductInfoChangeHandler piHandler = new ProductInfoChangeHandler(props);
        pias.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)piHandler);
    }

    final void bindAuthSPIAttributeSettingsChangeHandler(IAttributeSet as) {
        if (as == null) {
            return;
        }
        AuthSPIAttributeSettingsChangeHandler handler = s_handlerFactory.createAuthSPIAttributeSettingsChangeHandler(as);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    final void bindAuthSPIDefinationChangeHandler(IAttributeSet as) {
        if (as == null) {
            return;
        }
        AuthSPIDefinationChangeHandler handler = s_handlerFactory.createAuthSPIDefinationChangeHandler(as);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    final void bindExternalDomainGroupMapChangeHandler(IAttributeSet as) {
        if (as == null) {
            return;
        }
        ExternalDomainGroupMapChangeHandler handler = s_handlerFactory.createExternalDomainGroupMapChangeHandler(as);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    final void bindExternalDomainAuthSPINameChangeHandler(IAttributeSet as) {
        if (as == null) {
            return;
        }
        ExternalDomainAuthSPINameChangeHandler handler = s_handlerFactory.createExternalDomainAuthSPINameChangeHandler(as);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    final void bindSecurityParametersChangeHandler(IAttributeSet as) {
        if (as == null) {
            return;
        }
        SecurityParametersChangeHandler handler = s_handlerFactory.createACLCheckAtRestoreChangeHandler();
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    final void bindCertStoreChangeHandler(IAttributeSet as, BrokerCertificateStore store) {
        if (as == null) {
            return;
        }
        CertificateStoreChangeHandler handler = s_handlerFactory.createCertificateStoreChangeHandler(s_componentContext, store);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    final void bindBrokerKeyStoreChangeHandler(IAttributeSet as, BrokerKeyStore store) {
        if (as == null) {
            return;
        }
        BrokerKeyStoreChangeHandler handler = s_handlerFactory.createBrokerKeyStoreChangeHandler(s_componentContext, store);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    final void bindBrokerTrustStoreChangeHandler(IAttributeSet as, BrokerTrustStore store) {
        if (as == null) {
            return;
        }
        BrokerTrustStoreChangeHandler handler = s_handlerFactory.createBrokerTrustStoreChangeHandler(s_componentContext, store);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    final void bindBrokerCredentialsChangeHandler(IAttributeSet as, BrokerKeyStore store) {
        if (as == null) {
            return;
        }
        BrokerCredentialsChangeHandler handler = s_handlerFactory.createBrokerCredentialsChangeHandler(store);
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    final void bindLGConfigChangeHandler(IAttributeSet as) {
        if (as == null) {
            return;
        }
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)LGConfigChangeHandler.getInstance());
    }

    void bindRoutingParametersChangeHandler(IAttributeSet as) {
        if (as == null) {
            return;
        }
        RoutingParametersChangeHandler handler = s_handlerFactory.createRoutingParametersChangeHandler();
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    void bindBrokerNotificationConfigChangeHandler(IAttributeSet as) {
        if (as == null) {
            return;
        }
        BrokerNotificationConfigChangeHandler handler = s_handlerFactory.createBrokerNotificationConfigChangeHandler();
        as.registerAttributeChangeHandler((Object)s_componentContext, (IAttributeChangeHandler)handler);
    }

    static {
        DOUBLE_CHECK_LOCK_OBJ = new Object();
    }
}

