/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.dstriggers;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.ITriggerDSContext;
import com.sonicsw.mf.common.config.IValidationDSContext;
import com.sonicsw.mf.common.config.IValidationElementChange;
import com.sonicsw.mf.common.config.IValidator;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.BooleanExpression;
import com.sonicsw.mf.common.config.query.ContainsExpression;
import com.sonicsw.mf.common.config.query.EqualExpression;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromDirectory;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.StartsWithExpression;
import com.sonicsw.mf.common.config.query.Where;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.url.BrokerURL;
import com.sonicsw.mf.common.url.SonicRNURL;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DynamicHostTrigger
implements IValidator {
    private boolean m_debug = Boolean.parseBoolean(System.getProperty("DEBUG_SONICRNHANDLER", "false"));
    private static final String CONNECTION_FACTORY = "ConnectionFactory";
    private static final String MQ_ROUTE_SONIC = "MQ_ROUTE_SONIC";
    private static final String URLS_ATTRIBUTE = "URLS";
    private static final String SONICRN_URL_ATTRIBUTE = "SONICRN_URL";
    private static final String RESOLVED_URL_ATTRIBUTE = "resolvedUrl";
    private Map<String, List<String>> m_nodeNameToSonicRNUsageMap = new HashMap<String, List<String>>();
    private static final String[] TYPES_VALIDATED = new String[]{"MQ_RUNTIME_LOCATION", "ReferenceObject", "connection", "MQ_BROKER", "MQ_ACCEPTORS", "MQ_BACKUPBROKER", "MQ_CLUSTER", "MQ_ACCEPTOR_TCPS", "MQ_ACCEPTOR_TUNNELING", "MQ_ACCEPTOR_MQTT", "MQ_REPLICATION_CONNECTIONS", "MQ_ROUTE_SONIC"};

    public DynamicHostTrigger(ITriggerDSContext dsContext) throws DirectoryServiceException {
        this.addConnectionFactoriesToNodeNameMap(dsContext, "/_MFContext");
        this.addXQConnectionsToNodeNameMap(dsContext);
        this.addDynamicRoutingToNodeNameMap(dsContext);
    }

    public String[] getElementTypesValidated() {
        return TYPES_VALIDATED;
    }

    public String getReleaseVersion() {
        return "*";
    }

    public void validate(IValidationDSContext dsContext, IValidationElementChange[] changes) throws Exception {
    }

    public void onCreate(ITriggerDSContext dsContext, IDirElement[] newElements) throws DirectoryServiceException {
        this.debug("DynamicHostTrigger.onCreate length of additions == " + newElements.length);
        for (IDirElement newElement : newElements) {
            IElementIdentity identity = newElement.getIdentity();
            String type = identity.getType();
            if (type.equals("MQ_RUNTIME_LOCATION")) {
                this.onBrokerLocationCreate(dsContext, newElement);
                continue;
            }
            if (type.equals("ReferenceObject")) {
                if (!this.isConnectionFactoryElement(newElement)) continue;
                this.onConnectionFactoryCreate(dsContext, newElement);
                continue;
            }
            if ("connection".equals(type)) {
                if (!this.isXQJMSConnectionElement(newElement)) continue;
                this.onXQJMSConnectionCreate(dsContext, newElement);
                continue;
            }
            if ("MQ_BROKER".equals(type)) {
                this.onBrokerCreate(dsContext, newElement, true);
                continue;
            }
            if ("MQ_BACKUPBROKER".equals(type)) {
                this.onBrokerCreate(dsContext, newElement, false);
                continue;
            }
            if (!type.equals(MQ_ROUTE_SONIC)) continue;
            this.onDynamicRoutingCreate(dsContext, newElement);
        }
    }

    public void onUpdate(ITriggerDSContext dsContext, IDirElement[] originalElements, IDeltaElement[] updatedElements) throws DirectoryServiceException {
        this.debug("DynamicHostTrigger.onUpdate length of changes == " + originalElements.length);
        for (int i = 0; i < originalElements.length; ++i) {
            IDirElement originalElement = originalElements[i];
            IDeltaElement updatedElement = updatedElements[i];
            IElementIdentity identity = updatedElement.getIdentity();
            String type = identity.getType();
            if (type.equals("MQ_RUNTIME_LOCATION")) {
                this.onBrokerLocationUpdate(dsContext, originalElement, updatedElement);
                continue;
            }
            if (type.equals("ReferenceObject")) {
                if (!this.isConnectionFactoryElement(originalElements[i])) continue;
                this.onConnectionFactoryUpdate(dsContext, originalElement);
                continue;
            }
            if ("connection".equals(type)) {
                if (!this.isXQJMSConnectionElement(originalElement)) continue;
                this.onXQJMSConnectionUpdate(dsContext, originalElement);
                continue;
            }
            if ("MQ_BROKER".equals(type)) {
                this.onBrokerUpdate(dsContext, originalElement, updatedElement);
                continue;
            }
            if ("MQ_CLUSTER".equals(type)) {
                this.onClusterUpdate(dsContext, originalElement, updatedElement);
                continue;
            }
            if ("MQ_ACCEPTORS".equals(type)) {
                this.onAcceptorsUpdate(dsContext, originalElement, updatedElement);
                continue;
            }
            if ("MQ_ACCEPTOR_TCPS".equals(type) || "MQ_ACCEPTOR_TUNNELING".equals(type) || "MQ_ACCEPTOR_MQTT".equals(type)) {
                this.onAcceptorUpdate(dsContext, originalElement, updatedElement);
                continue;
            }
            if ("MQ_REPLICATION_CONNECTIONS".equals(type)) {
                this.onReplicationConnectionsUpdate(dsContext, originalElement, updatedElement);
                continue;
            }
            if (!type.equals(MQ_ROUTE_SONIC)) continue;
            this.onDynamicRoutingUpdate(dsContext, originalElement, updatedElement);
        }
    }

    public void onDelete(ITriggerDSContext dsContext, IDirElement[] deletedElements) throws DirectoryServiceException {
        this.debug("DynamicHostTrigger.onDelete length of additions == " + deletedElements.length);
        for (IDirElement deletedElement : deletedElements) {
            IElementIdentity identity = deletedElement.getIdentity();
            String type = identity.getType();
            if (type.equals("MQ_RUNTIME_LOCATION")) {
                this.onBrokerLocationDelete(dsContext, deletedElement);
                continue;
            }
            if (type.equals("ReferenceObject")) {
                if (!this.isConnectionFactoryElement(deletedElement)) continue;
                this.onConnectionFactoryDelete(dsContext, deletedElement);
                continue;
            }
            if ("connection".equals(type)) {
                if (!this.isXQJMSConnectionElement(deletedElement)) continue;
                this.onXQJMSConnectionDelete(dsContext, deletedElement);
                continue;
            }
            if ("MQ_BROKER".equals(type)) {
                this.onBrokerDelete(dsContext, deletedElement, true);
                continue;
            }
            if ("MQ_BACKUPBROKER".equals(type)) {
                this.onBrokerDelete(dsContext, deletedElement, false);
                continue;
            }
            if ("MQ_CLUSTER".equals(type)) {
                this.onClusterDelete(dsContext, deletedElement);
                continue;
            }
            if (!type.equals(MQ_ROUTE_SONIC)) continue;
            this.onDynamicRoutingDelete(dsContext, deletedElement);
        }
    }

    private void addConnectionFactoriesToNodeNameMap(ITriggerDSContext dsContext, String directoryName) throws DirectoryServiceException {
        IDirElement[] factories;
        IDirIdentity[] directories;
        for (IDirIdentity directory : directories = dsContext.listDirectories(directoryName)) {
            this.addConnectionFactoriesToNodeNameMap(dsContext, directory.getName());
        }
        FromDirectory elementType = new FromDirectory(directoryName);
        ContainsExpression classIsFactoryClass = new ContainsExpression(new AttributeName("classname"), CONNECTION_FACTORY);
        Where factoryClass = new Where(new BooleanExpression[]{classIsFactoryClass});
        Query factoriesQuery = new Query();
        factoriesQuery.setFrom((From)elementType);
        factoriesQuery.setWhere(factoryClass);
        for (IDirElement factory : factories = dsContext.getElements(factoriesQuery, true)) {
            IAttributeList addrList = (IAttributeList)factory.getAttributes().getAttribute("RefAdresses");
            ArrayList items = addrList.getItems();
            String url = null;
            for (IAttributeSet item : items) {
                Object value = null;
                value = item.getAttribute("brokerList");
                if (value == null) continue;
                url = (String)value;
                break;
            }
            this.addSonicRNUsageToNodeNameMap(factory, url);
        }
    }

    private void addXQConnectionsToNodeNameMap(ITriggerDSContext dsContext) throws DirectoryServiceException {
        Query xqConnectionsQuery = new Query();
        xqConnectionsQuery.setFrom((From)new FromDirectory("/xqConnections"));
        ContainsExpression typeRefExpression = new ContainsExpression(new AttributeName("type_ref"), "JMSType");
        Where typeRefWhere = new Where(new BooleanExpression[]{typeRefExpression});
        xqConnectionsQuery.setWhere(typeRefWhere);
        IDirElement[] xqJMSConnectionElements = null;
        try {
            xqJMSConnectionElements = dsContext.getElements(xqConnectionsQuery, false);
        }
        catch (DirectoryDoesNotExistException e) {
            return;
        }
        for (IDirElement xqJMSConnectionElement : xqJMSConnectionElements) {
            IAttributeSet xqJMSConnectionAttributes = xqJMSConnectionElement.getAttributes();
            IAttributeSet xqJMSConnectionParameters = (IAttributeSet)xqJMSConnectionElement.getAttributes().getAttribute("params");
            if (xqJMSConnectionParameters == null) continue;
            IAttributeSet urlAttrs = (IAttributeSet)xqJMSConnectionParameters.getAttribute("url");
            String url = (String)urlAttrs.getAttribute("value");
            this.addSonicRNUsageToNodeNameMap(xqJMSConnectionElement, url);
        }
    }

    private void addDynamicRoutingToNodeNameMap(ITriggerDSContext dsContext) throws DirectoryServiceException {
        IDirElement[] dynamicRoutings;
        for (IDirElement dynamicRouting : dynamicRoutings = this.getSonicRNDynamicRoutings(dsContext, false)) {
            String sonicrnUrl = (String)dynamicRouting.getAttributes().getAttribute(SONICRN_URL_ATTRIBUTE);
            this.debug("DynamicHostTrigger.addDynamicRoutingToNodeNameMap dynamicRouting sonicrnUrl - " + dynamicRouting.getIdentity().getName() + " " + sonicrnUrl);
            this.addSonicRNUsageToNodeNameMap(dynamicRouting, sonicrnUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSonicRNUsageToNodeNameMap(IDirElement sonicRNUsage, String sonicRNURLParam) {
        String sonicRNURL = sonicRNURLParam;
        this.debug("DynamicHostTrigger.addSonicRNUsageToNodeNameMap sonicRNURL sonicRNUsage - " + sonicRNURL + " " + sonicRNUsage);
        if (!SonicRNURL.isValid((String)sonicRNURL, (boolean)false)) {
            this.debug("DynamicHostTrigger.addSonicRNUsageToNodeNameMap - Invalid sonicrn url - sonicRNURL:" + sonicRNURL);
            return;
        }
        sonicRNURL = sonicRNURL.trim();
        String nodeName = new SonicRNURL(sonicRNURL).getNodename();
        Map<String, List<String>> map = this.m_nodeNameToSonicRNUsageMap;
        synchronized (map) {
            List<String> sonicRNUsages = this.m_nodeNameToSonicRNUsageMap.get(nodeName);
            if (sonicRNUsages == null) {
                sonicRNUsages = new ArrayList<String>();
                this.m_nodeNameToSonicRNUsageMap.put(nodeName, sonicRNUsages);
            }
            sonicRNUsages.add(sonicRNUsage.getIdentity().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSonicRNUsageFromNodeNameMap(IDirElement sonicRNUsage, String sonicRNURLParam) {
        String sonicRNURL = sonicRNURLParam;
        this.debug("DynamicHostTrigger.removeSonicRNUsageFromNodeNameMap sonicRNURL sonicRNUsage - " + sonicRNURL + " " + sonicRNUsage);
        if (!SonicRNURL.isValid((String)sonicRNURL, (boolean)false)) {
            this.debug("DynamicHostTrigger.removeSonicRNUsageFromNodeNameMap - Invalid sonicrn url - sonicRNURL:" + sonicRNURL);
            return;
        }
        sonicRNURL = sonicRNURL.trim();
        String nodeName = new SonicRNURL(sonicRNURL).getNodename();
        Map<String, List<String>> map = this.m_nodeNameToSonicRNUsageMap;
        synchronized (map) {
            List<String> sonicRNUsages = this.m_nodeNameToSonicRNUsageMap.get(nodeName);
            if (sonicRNUsages == null) {
                return;
            }
            sonicRNUsages.remove(sonicRNUsage.getIdentity().getName());
            if (sonicRNUsages.isEmpty()) {
                this.m_nodeNameToSonicRNUsageMap.remove(nodeName);
            }
        }
    }

    private void onBrokerCreate(ITriggerDSContext dsContext, IDirElement brokerElementParam, boolean isPrimary) throws DirectoryServiceException {
        IDirElement brokerElement = brokerElementParam;
        if (!isPrimary) {
            IAttributeSet referenceAttributes = (IAttributeSet)brokerElement.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference primaryBrokerRef = (Reference)referenceAttributes.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            if (primaryBrokerRef.getElementName().startsWith("/NO_STORAGE:")) {
                return;
            }
            brokerElement = dsContext.getElement(primaryBrokerRef.getElementName());
        }
        String nodeName = this.getBrokerNodeName(dsContext, brokerElement);
        this.updateResolvedURLs(dsContext, nodeName);
    }

    private void onBrokerUpdate(ITriggerDSContext dsContext, IDirElement originalBrokerElement, IDeltaElement updatedBrokerElement) throws DirectoryServiceException {
        IAttributeSet originalBrokerAttributes = originalBrokerElement.getAttributes();
        String originalBrokerName = (String)originalBrokerAttributes.getAttribute("BROKER_NAME");
        String originalNodeName = this.getBrokerNodeName(dsContext, originalBrokerElement);
        this.debug("DynamicHostTrigger.onBrokerUpdate - originalBrokerElement originalNodeName : " + originalBrokerElement + " " + originalNodeName);
        IDirElement storedBrokerElement = dsContext.getElement(updatedBrokerElement.getIdentity().getName());
        IAttributeSet storedBrokerAttributes = storedBrokerElement.getAttributes();
        String storedBrokerName = (String)storedBrokerAttributes.getAttribute("BROKER_NAME");
        String storedNodeName = this.getBrokerNodeName(dsContext, storedBrokerElement);
        this.debug("DynamicHostTrigger.onBrokerUpdate - updatedBrokerElement storedNodeName : " + updatedBrokerElement + " " + storedNodeName);
        if (!(originalNodeName == null || storedBrokerName.equals(originalBrokerName) && storedNodeName.equals(originalNodeName))) {
            String brokerLocationElementName = "/_MQRuntime/location/" + originalNodeName + '/' + originalBrokerName;
            this.deleteBrokerLocationElement(dsContext, brokerLocationElementName + "/primary");
            this.deleteBrokerLocationElement(dsContext, brokerLocationElementName + "/backup");
        }
        if (originalNodeName == null || !storedNodeName.equals(originalNodeName)) {
            if (originalNodeName != null) {
                this.updateResolvedURLs(dsContext, originalNodeName);
            }
            this.updateResolvedURLs(dsContext, storedNodeName);
        }
        Boolean originalDyn = (Boolean)originalBrokerAttributes.getAttribute("USE_DYNAMIC_HOST_BINDING");
        Boolean newDyn = (Boolean)storedBrokerAttributes.getAttribute("USE_DYNAMIC_HOST_BINDING");
        IAttributeSet refs = (IAttributeSet)storedBrokerAttributes.getAttribute("CONFIG_ELEMENT_REFERENCES");
        IDirElement replicationsElement = null;
        if (refs != null) {
            replicationsElement = DynamicHostTrigger.retrieveReplicationsElement(dsContext, refs, replicationsElement);
        }
        if ((originalDyn == null || !originalDyn.booleanValue()) && newDyn != null && newDyn.booleanValue() && replicationsElement != null) {
            IDirElement primaryLocation = this.getLocationElement(dsContext, storedBrokerElement, false);
            IDirElement backupLocation = this.getLocationElement(dsContext, storedBrokerElement, true);
            try {
                if (primaryLocation != null || backupLocation != null) {
                    this.updatePrimaryAndBackupAddresses(dsContext, replicationsElement, primaryLocation, backupLocation, true);
                }
            }
            catch (Exception e) {
                DirectoryServiceException dirE = new DirectoryServiceException("DynamicHostrigger.onBrokerUpdate unable to update replication connections of " + storedBrokerElement.getIdentity().getName());
                dirE.initCause((Throwable)e);
                throw dirE;
            }
        }
    }

    private void onConnectionFactoryDelete(ITriggerDSContext dsContext, IDirElement factoryElement) throws DirectoryServiceException {
        String brokerList = this.getConnectionFactoryBrokerList(factoryElement);
        if (brokerList == null) {
            return;
        }
        this.removeSonicRNUsageFromNodeNameMap(factoryElement, brokerList);
    }

    private void onXQJMSConnectionDelete(ITriggerDSContext dsContext, IDirElement xqJMSConnectionElement) throws DirectoryServiceException {
        String url = this.getXQJMSConnectionURL(xqJMSConnectionElement);
        if (url == null) {
            return;
        }
        this.removeSonicRNUsageFromNodeNameMap(xqJMSConnectionElement, url);
    }

    private void onBrokerDelete(ITriggerDSContext dsContext, IDirElement brokerElement, boolean isPrimary) throws DirectoryServiceException {
        this.debug("DynamicHostTrigger.onBrokerDelete for broker " + brokerElement.getIdentity().getName() + " and primary flag == " + isPrimary);
        IDirElement primaryBrokerElement = null;
        if (!isPrimary) {
            IAttributeSet referenceAttributes = (IAttributeSet)brokerElement.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference primaryBrokerRef = (Reference)referenceAttributes.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            primaryBrokerElement = dsContext.getElement(primaryBrokerRef.getElementName());
        } else {
            primaryBrokerElement = brokerElement;
        }
        String nodeName = null;
        if (primaryBrokerElement != null) {
            nodeName = this.getBrokerNodeName(dsContext, primaryBrokerElement);
        }
        String brokerName = (String)brokerElement.getAttributes().getAttribute("BROKER_NAME");
        if (nodeName != null) {
            String brokerLocationElementName = "/_MQRuntime/location/" + nodeName + '/' + brokerName + '/' + (isPrimary ? "primary" : "backup");
            this.debug("DynamicHostTrigger.onBrokerDelete deleting location element " + brokerLocationElementName);
            this.deleteBrokerLocationElement(dsContext, brokerLocationElementName);
            if (isPrimary) {
                String backupLocationElementName = "/_MQRuntime/location/" + nodeName + '/' + brokerName + "/backup";
                this.debug("DynamicHostTrigger.onBrokerDelete deleting location element " + backupLocationElementName);
                this.deleteBrokerLocationElement(dsContext, backupLocationElementName);
            }
            this.updateResolvedURLs(dsContext, nodeName);
        } else {
            this.debug("DynamicHostTrigger.onBrokerDelete for broker " + brokerElement.getIdentity().getName() + " nodename was not found, so not action was taken");
        }
    }

    private void onClusterUpdate(ITriggerDSContext dsContext, IDirElement originalClusterElement, IDeltaElement updatedClusterElement) throws DirectoryServiceException {
        boolean nodeNameModified = false;
        boolean useDynamicHostBindingModified = false;
        IAttributeSet originalClusterAttributes = originalClusterElement.getAttributes();
        IDeltaAttributeSet updatedClusterAttributes = (IDeltaAttributeSet)updatedClusterElement.getDeltaAttributes();
        String originalNodeName = (String)originalClusterAttributes.getAttribute("ROUTING_NODE_NAME");
        String newNodeName = null;
        try {
            newNodeName = (String)updatedClusterAttributes.getNewValue("ROUTING_NODE_NAME");
            nodeNameModified = true;
        }
        catch (NotModifiedAttException notModifiedAttException) {
            // empty catch block
        }
        this.debug("DynamicHostTrigger.onClusterUpdate - originalClusterElement originalNodeName : " + originalClusterElement + " " + originalNodeName);
        this.debug("DynamicHostTrigger.onClusterUpdate - updatedClusterElement newNodeName : " + updatedClusterElement + " " + newNodeName);
        if (nodeNameModified) {
            IDirElement clusterElement = dsContext.getElement(originalClusterElement.getIdentity().getName());
            this.cleanupClusteredBrokerLocationElements(dsContext, clusterElement, originalNodeName);
            this.updateResolvedURLs(dsContext, originalNodeName);
            this.updateResolvedURLs(dsContext, newNodeName);
        }
        Boolean originalDyn = (Boolean)originalClusterAttributes.getAttribute("USE_DYNAMIC_HOST_BINDING");
        Boolean newDyn = null;
        try {
            newDyn = (Boolean)updatedClusterAttributes.getNewValue("USE_DYNAMIC_HOST_BINDING");
            useDynamicHostBindingModified = true;
        }
        catch (NotModifiedAttException notModifiedAttException) {
            // empty catch block
        }
        if (useDynamicHostBindingModified && (originalDyn == null || !originalDyn.booleanValue()) && newDyn != null && newDyn.booleanValue()) {
            try {
                this.resolveClusteredBrokerAcceptorsAndReplicationConnections(dsContext, newNodeName == null ? originalNodeName : newNodeName, originalClusterElement.getIdentity().getName());
            }
            catch (Exception e) {
                DirectoryServiceException dirE = new DirectoryServiceException("DynamicHostTrigger.onClusterUpdate unable to update cluster member acceptors");
                dirE.initCause((Throwable)e);
                throw dirE;
            }
        }
    }

    private void onClusterDelete(ITriggerDSContext dsContext, IDirElement clusterElement) throws DirectoryServiceException {
        String nodeName = (String)clusterElement.getAttributes().getAttribute("ROUTING_NODE_NAME");
        this.debug("DynamicHostTrigger.onClusterDelete - clusterElement nodeName : " + clusterElement + " " + nodeName);
        this.cleanupClusteredBrokerLocationElements(dsContext, clusterElement, nodeName);
        this.updateResolvedURLs(dsContext, nodeName);
    }

    private void onAcceptorsUpdate(ITriggerDSContext dsContext, IDirElement originalAcceptorsElement, IDeltaElement updatedAcceptorsElement) throws DirectoryServiceException {
        IDirElement locationElement;
        String[] updatedAcceptorAttributeNames;
        this.debug("DynamicHostTrigger.onAcceptorsUpdate");
        boolean newAcceptors = false;
        IDeltaAttributeSet updatedAcceptorsAttributes = (IDeltaAttributeSet)updatedAcceptorsElement.getDeltaAttributes();
        boolean hasRelevantUpdates = false;
        for (String updatedAcceptorAttributeName : updatedAcceptorAttributeNames = updatedAcceptorsAttributes.getModifiedAttributesNames()) {
            if (!"ACCEPTORS".equals(updatedAcceptorAttributeName)) continue;
            hasRelevantUpdates = true;
            newAcceptors = true;
            break;
        }
        if (!hasRelevantUpdates) {
            String[] deletedAcceptorAttributeNames = updatedAcceptorsAttributes.getDeletedAttributesNames();
            hasRelevantUpdates = this.checkIsAcceptors(deletedAcceptorAttributeNames, hasRelevantUpdates);
        }
        if (!hasRelevantUpdates) {
            String[] newAcceptorAttributeNames = updatedAcceptorsAttributes.getNewAttributesNames();
            hasRelevantUpdates = this.checkIsAcceptors(newAcceptorAttributeNames, hasRelevantUpdates);
        }
        if (!hasRelevantUpdates) {
            return;
        }
        IDirElement brokerElement = this.getBrokerElementFromAcceptorsElement(dsContext, originalAcceptorsElement.getIdentity().getName());
        if (brokerElement == null) {
            return;
        }
        String nodeName = this.getBrokerNodeName(dsContext, brokerElement);
        this.debug("DynamicHostTrigger.onAcceptorsUpdate - brokerElement nodeName : " + brokerElement + " " + nodeName);
        if (newAcceptors && this.getUseDynamicHostBinding(dsContext, brokerElement) && (locationElement = this.getLocationElement(dsContext, brokerElement, brokerElement.getIdentity().getName().startsWith("/mq/backupbrokers"))) != null) {
            this.debug("DynamicHostTrigger.onAcceptorsUpdate updating regular acceptors for " + brokerElement.getIdentity().getName());
            this.updateBrokerRegularAcceptors(dsContext, brokerElement, locationElement);
        }
        this.updateResolvedURLs(dsContext, nodeName);
    }

    private boolean checkIsAcceptors(String[] attributeNames, boolean hasRelevantUpdatesParam) {
        boolean hasRelevantUpdates = hasRelevantUpdatesParam;
        for (String newAcceptorAttributeName : attributeNames) {
            if (!"ACCEPTORS".equals(newAcceptorAttributeName)) continue;
            hasRelevantUpdates = true;
            break;
        }
        return hasRelevantUpdates;
    }

    private void onAcceptorUpdate(ITriggerDSContext dsContext, IDirElement originalAcceptorElement, IDeltaElement updatedAcceptorElement) throws DirectoryServiceException {
        String[] updatedAcceptorAttributeNames;
        this.debug("DynamicHostTrigger.onAcceptorUpdate ");
        IDeltaAttributeSet updatedAcceptorAttributes = (IDeltaAttributeSet)updatedAcceptorElement.getDeltaAttributes();
        boolean hasRelevantUpdates = false;
        for (String updatedAcceptorAttributeName : updatedAcceptorAttributeNames = updatedAcceptorAttributes.getModifiedAttributesNames()) {
            if (!"ACCEPTOR_URL".equals(updatedAcceptorAttributeName) && !"ACCEPTOR_EXTERNAL_URL".equals(updatedAcceptorAttributeName) && !"ACCEPTOR_NAME".equals(updatedAcceptorAttributeName)) continue;
            hasRelevantUpdates = true;
            break;
        }
        if (!hasRelevantUpdates) {
            String[] deletedAcceptorAttributeNames = updatedAcceptorAttributes.getDeletedAttributesNames();
            hasRelevantUpdates = this.checkIsAcceptorOrExternalAcceptorUrl(deletedAcceptorAttributeNames, hasRelevantUpdates);
        }
        if (!hasRelevantUpdates) {
            String[] newAcceptorAttributeNames = updatedAcceptorAttributes.getNewAttributesNames();
            hasRelevantUpdates = this.checkIsAcceptorOrExternalAcceptorUrl(newAcceptorAttributeNames, hasRelevantUpdates);
        }
        if (!hasRelevantUpdates) {
            return;
        }
        IDirElement brokerElement = this.getBrokerElementFromAcceptorElement(dsContext, originalAcceptorElement.getIdentity().getName());
        if (brokerElement == null) {
            return;
        }
        String nodeName = this.getBrokerNodeName(dsContext, brokerElement);
        this.debug("DynamicHostTrigger.onAcceptorUpdate - brokerElement nodeName : " + brokerElement + " " + nodeName);
        this.debug("DynamicHostTrigger.onAcceptorUpdate updating resolved URLs");
        this.updateResolvedURLs(dsContext, nodeName);
    }

    private boolean checkIsAcceptorOrExternalAcceptorUrl(String[] attributeNames, boolean hasRelevantUpdatesParam) {
        boolean hasRelevantUpdates = hasRelevantUpdatesParam;
        for (String newAcceptorAttributeName : attributeNames) {
            if (!"ACCEPTOR_URL".equals(newAcceptorAttributeName) && !"ACCEPTOR_EXTERNAL_URL".equals(newAcceptorAttributeName)) continue;
            hasRelevantUpdates = true;
            break;
        }
        return hasRelevantUpdates;
    }

    private IDirElement getBrokerElementFromAcceptorElement(ITriggerDSContext dsContext, String acceptorElementName) throws DirectoryServiceException {
        IElementIdentity[] acceptorsElementIdentities;
        IDirElement parentAcceptorsElement = null;
        for (IElementIdentity acceptorsElementIdentity : acceptorsElementIdentities = dsContext.listElements("/mq/acceptors")) {
            IDirElement acceptorsElement = dsContext.getElement(acceptorsElementIdentity.getName());
            if (acceptorsElement == null) continue;
            IAttributeSet acceptorsAttributeSet = (IAttributeSet)acceptorsElement.getAttributes().getAttribute("ACCEPTORS");
            for (Object acceptorReference : acceptorsAttributeSet.getAttributes().values()) {
                if (!((Reference)acceptorReference).getElementName().equals(acceptorElementName)) continue;
                parentAcceptorsElement = acceptorsElement;
                break;
            }
            if (parentAcceptorsElement != null) break;
        }
        if (parentAcceptorsElement == null) {
            return null;
        }
        return this.getBrokerElementFromAcceptorsElement(dsContext, parentAcceptorsElement.getIdentity().getName());
    }

    private IDirElement getBrokerElementFromAcceptorsElement(ITriggerDSContext dsContext, String acceptorsElementName) throws DirectoryServiceException {
        IDirElement brokerElement = this.getBrokerElementFromAcceptorsElement(dsContext, acceptorsElementName, "/mq/brokers");
        if (brokerElement == null) {
            brokerElement = this.getBrokerElementFromAcceptorsElement(dsContext, acceptorsElementName, "/mq/backupbrokers");
        }
        if (brokerElement == null) {
            return null;
        }
        return brokerElement;
    }

    private IDirElement getBrokerElementFromAcceptorsElement(ITriggerDSContext dsContext, String acceptorsElementName, String fromDirectory) throws DirectoryServiceException {
        Query brokersQuery = new Query();
        brokersQuery.setFrom((From)new FromDirectory(fromDirectory));
        EqualExpression acceptorsRefExpression = new EqualExpression(new AttributeName("CONFIG_ELEMENT_REFERENCES").setNextComponent("ACCEPTOR_CONFIG_ELEMENT_REF"), new Reference(acceptorsElementName));
        Where acceptorsRefWhere = new Where(new BooleanExpression[]{acceptorsRefExpression});
        brokersQuery.setWhere(acceptorsRefWhere);
        IDirElement[] brokerElements = dsContext.getElements(brokersQuery, true);
        if (brokerElements.length == 0) {
            return null;
        }
        return brokerElements[0];
    }

    private void cleanupClusteredBrokerLocationElements(ITriggerDSContext dsContext, IDirElement clusterElement, String nodeName) throws DirectoryServiceException {
        ArrayList<String> brokersWithSameNodeName = new ArrayList<String>();
        IAttributeSet clusterMembersAttributes = (IAttributeSet)clusterElement.getAttributes().getAttribute("CLUSTER_MEMBERS");
        for (Object clusterMember : clusterMembersAttributes.getAttributes().values()) {
            IAttributeSet brokerAttributes;
            IAttributeSet brokerRoutingParameters;
            String brokerNodeName;
            Reference clusterMemberReference = (Reference)clusterMember;
            IDirElement brokerElement = dsContext.getElement(clusterMemberReference.getElementName());
            if (brokerElement == null || !(brokerNodeName = (String)(brokerRoutingParameters = (IAttributeSet)(brokerAttributes = brokerElement.getAttributes()).getAttribute("BROKER_ROUTING_PARAMETERS")).getAttribute("ROUTING_NODE_NAME")).equals(nodeName)) continue;
            brokersWithSameNodeName.add((String)brokerAttributes.getAttribute("BROKER_NAME"));
        }
        String brokerLocationRootDirectory = "/_MQRuntime/location/" + nodeName;
        try {
            IDirIdentity[] brokerLocationDirectories;
            for (IDirIdentity brokerLocationDirectory : brokerLocationDirectories = dsContext.listDirectories(brokerLocationRootDirectory)) {
                String[] brokerLocationDirectoryNameComponents = brokerLocationDirectory.getNameComponents();
                if (brokersWithSameNodeName.contains(brokerLocationDirectoryNameComponents[brokerLocationDirectoryNameComponents.length - 1])) continue;
                this.deleteBrokerLocationElement(dsContext, brokerLocationDirectory.getName() + '/' + "primary");
                this.deleteBrokerLocationElement(dsContext, brokerLocationDirectory.getName() + '/' + "backup");
            }
        }
        catch (DirectoryDoesNotExistException directoryDoesNotExistException) {
            // empty catch block
        }
    }

    private String getBrokerNodeName(ITriggerDSContext dsContext, IDirElement brokerElementParam) throws DirectoryServiceException {
        Reference clusterReference;
        IAttributeSet referenceAttributes;
        IDirElement brokerElement = brokerElementParam;
        if ("MQ_BACKUPBROKER".equals(brokerElement.getIdentity().getType())) {
            referenceAttributes = (IAttributeSet)brokerElement.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference primaryBrokerRef = (Reference)referenceAttributes.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            brokerElement = dsContext.getElement(primaryBrokerRef.getElementName());
        }
        if ((clusterReference = (Reference)(referenceAttributes = (IAttributeSet)brokerElement.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES")).getAttribute("CLUSTER_CONFIG_ELEMENT_REF")) == null) {
            IAttributeSet routingAttributes = (IAttributeSet)brokerElement.getAttributes().getAttribute("BROKER_ROUTING_PARAMETERS");
            return (String)routingAttributes.getAttribute("ROUTING_NODE_NAME");
        }
        String clusterElementName = clusterReference.getElementName();
        if (clusterElementName.startsWith("/NO_STORAGE:")) {
            return null;
        }
        IDirElement clusterElement = dsContext.getElement(clusterElementName);
        if (clusterElement == null) {
            return null;
        }
        return (String)clusterElement.getAttributes().getAttribute("ROUTING_NODE_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void debug(String message) {
        if (this.m_debug) {
            System.out.print("[");
            SimpleDateFormat simpleDateFormat = SonicRNURL.SIMPLE_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                System.out.print(SonicRNURL.SIMPLE_DATE_FORMAT.format(new Date(System.currentTimeMillis())));
            }
            System.out.print(" ");
            System.out.println(" " + message);
        }
    }

    private void onBrokerLocationCreate(ITriggerDSContext dsContext, IDirElement newElement) throws DirectoryServiceException {
        IDirElement brokerElement;
        String brokerId = (String)newElement.getAttributes().getAttribute("BROKER_CONFIG_ELEMENT_REF");
        String nodeName = this.getNodeNameFromBrokerLocation(newElement.getIdentity().getName());
        this.debug("DynamicHostTrigger.handleBrokerLocationCreate brokerId, nodeName: " + brokerId + " " + nodeName);
        IDirElement primaryBrokerElement = brokerElement = dsContext.getElement(brokerId);
        String brokerType = brokerElement.getIdentity().getType();
        String hostAttribute = "PRIMARY_ADDR";
        if ("MQ_BACKUPBROKER".equals(brokerType)) {
            IAttributeSet referenceAttributes = (IAttributeSet)brokerElement.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference primaryBrokerRef = (Reference)referenceAttributes.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            primaryBrokerElement = dsContext.getElement(primaryBrokerRef.getElementName());
            hostAttribute = "BACKUP_ADDR";
        }
        this.updateBrokerResolvedUrls(primaryBrokerElement, hostAttribute, dsContext, brokerElement, newElement, nodeName);
    }

    private void onBrokerLocationUpdate(ITriggerDSContext dsContext, IDirElement originalBrokerLocationElement, IDeltaElement updatedBrokerLocationElement) throws DirectoryServiceException {
        IDirElement brokerElement;
        IDirElement newLocationElement = dsContext.getElement(originalBrokerLocationElement.getIdentity().getName());
        String brokerId = (String)originalBrokerLocationElement.getAttributes().getAttribute("BROKER_CONFIG_ELEMENT_REF");
        String nodeName = this.getNodeNameFromBrokerLocation(updatedBrokerLocationElement.getIdentity().getName());
        this.debug("DynamicHostTrigger.handleBrokerLocationUpdate brokerId, nodeName: " + brokerId + " " + nodeName);
        IDirElement primaryBrokerElement = brokerElement = dsContext.getElement(brokerId);
        String brokerType = brokerElement.getIdentity().getType();
        String hostAttribute = "PRIMARY_ADDR";
        if ("MQ_BACKUPBROKER".equals(brokerType)) {
            IAttributeSet referenceAttributes = (IAttributeSet)brokerElement.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference primaryBrokerRef = (Reference)referenceAttributes.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            primaryBrokerElement = dsContext.getElement(primaryBrokerRef.getElementName());
            hostAttribute = "BACKUP_ADDR";
        }
        if (newLocationElement != null) {
            this.updateBrokerResolvedUrls(primaryBrokerElement, hostAttribute, dsContext, brokerElement, newLocationElement, nodeName);
        }
    }

    private void updateBrokerResolvedUrls(IDirElement primaryBrokerElement, String hostAttribute, ITriggerDSContext dsContext, IDirElement brokerElement, IDirElement newElement, String nodeName) throws DirectoryServiceException {
        boolean useDynamicHostBinding;
        if (primaryBrokerElement != null && (useDynamicHostBinding = this.getUseDynamicHostBinding(dsContext, primaryBrokerElement))) {
            this.updateBrokerRegularAcceptors(dsContext, brokerElement, newElement);
            this.updateBrokerReplicationAcceptors(dsContext, primaryBrokerElement, newElement, hostAttribute);
        }
        this.updateResolvedURLs(dsContext, nodeName);
    }

    private void onBrokerLocationDelete(ITriggerDSContext dsContext, IDirElement deletedElement) throws DirectoryServiceException {
        boolean useDynamicHostBinding;
        IDirElement brokerElement;
        String brokerId = (String)deletedElement.getAttributes().getAttribute("BROKER_CONFIG_ELEMENT_REF");
        String nodeName = this.getNodeNameFromBrokerLocation(deletedElement.getIdentity().getName());
        this.debug("DynamicHostTrigger.handleBrokerLocationDelete brokerId, nodeName: " + brokerId + " " + nodeName);
        IDirElement primaryBrokerElement = brokerElement = dsContext.getElement(brokerId);
        String brokerType = brokerElement.getIdentity().getType();
        String hostAttribute = "PRIMARY_ADDR";
        if ("MQ_BACKUPBROKER".equals(brokerType)) {
            IAttributeSet referenceAttributes = (IAttributeSet)brokerElement.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference primaryBrokerRef = (Reference)referenceAttributes.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            primaryBrokerElement = dsContext.getElement(primaryBrokerRef.getElementName());
            hostAttribute = "BACKUP_ADDR";
        }
        if (primaryBrokerElement != null && (useDynamicHostBinding = this.getUseDynamicHostBinding(dsContext, primaryBrokerElement))) {
            this.updateBrokerRegularAcceptors(dsContext, brokerElement, null);
            this.updateBrokerReplicationAcceptors(dsContext, primaryBrokerElement, null, hostAttribute);
        }
    }

    private void updateBrokerRegularAcceptors(ITriggerDSContext dsContext, IDirElement brokerElement, IDirElement locationElement) throws DirectoryServiceException {
        IDirElement[] regularAcceptors;
        String newHostname = "";
        String newExternalHostname = "";
        if (locationElement != null) {
            newExternalHostname = this.getExternalLocationHostname(locationElement);
            newHostname = this.getLocationHostname(locationElement, false);
        }
        this.debug("DynamicHostTrigger.updateBrokerRegularAcceptors brokerId == " + brokerElement.getIdentity().getName() + " newHostname " + newHostname + " newExternalHostname " + newExternalHostname);
        for (IDirElement regularAcceptor : regularAcceptors = this.getRegularAcceptors(dsContext, brokerElement)) {
            try {
                String externalUrl;
                String url = (String)regularAcceptor.getAttributes().getAttribute("ACCEPTOR_URL");
                boolean updateAcceptor = false;
                if (url != null) {
                    BrokerURL brokerURL = new BrokerURL(url, true);
                    String brokerHost = brokerURL.getBrokerHostName();
                    this.debug("DynamicHostTrigger.updateBrokerRegularAcceptors original acceptor hostname " + brokerHost);
                    boolean bl = updateAcceptor = brokerHost == null || brokerHost.length() == 0 || "localhost".equals(brokerHost);
                    if (!updateAcceptor) {
                        if (newHostname.equalsIgnoreCase(brokerHost)) continue;
                        updateAcceptor = this.checkIsUpdateAcceptor(newHostname, brokerHost, updateAcceptor);
                    }
                    if (updateAcceptor = this.checkIsBrokerHost(updateAcceptor, brokerHost, newHostname)) {
                        this.debug("DynamicHostTrigger.updateBrokerAcceptors changing hostname of acceptor " + regularAcceptor.getIdentity().getName() + " of broker " + brokerElement.getIdentity().getName() + " from " + brokerHost + " to " + newHostname);
                        brokerURL = new BrokerURL(brokerURL.getBrokerProtocol() + "://" + newHostname + ":" + brokerURL.getBrokerPort());
                        regularAcceptor.getAttributes().setStringAttribute("ACCEPTOR_URL", brokerURL.getBrokerURL());
                    } else {
                        this.debug("DynamicHostTrigger.updateBrokerAcceptors will not update acceptor " + regularAcceptor.getIdentity().getName() + " of broker " + brokerElement.getIdentity().getName());
                    }
                }
                if ((externalUrl = (String)regularAcceptor.getAttributes().getAttribute("ACCEPTOR_EXTERNAL_URL")) == null && newExternalHostname != null && newExternalHostname.length() > 0) {
                    externalUrl = url;
                }
                boolean updateExternalAcceptor = false;
                if (externalUrl != null) {
                    BrokerURL brokerExternalURL = new BrokerURL(externalUrl, true);
                    String brokerExternalHost = brokerExternalURL.getBrokerHostName();
                    this.debug("DynamicHostTrigger.updateBrokerRegularAcceptors original acceptor external hostname " + brokerExternalHost);
                    boolean bl = updateExternalAcceptor = brokerExternalHost == null || brokerExternalHost.length() == 0 || "localhost".equals(brokerExternalHost);
                    if (!updateExternalAcceptor) {
                        if (newExternalHostname.equalsIgnoreCase(brokerExternalHost)) continue;
                        updateExternalAcceptor = this.checkIsUpdateAcceptor(newExternalHostname, brokerExternalHost, updateExternalAcceptor);
                    }
                    if (updateExternalAcceptor = this.checkIsBrokerHost(updateExternalAcceptor, brokerExternalHost, newExternalHostname)) {
                        this.debug("DynamicHostTrigger.updateBrokerAcceptors changing external hostname of acceptor " + regularAcceptor.getIdentity().getName() + " of broker " + brokerElement.getIdentity().getName() + " from " + brokerExternalHost + " to " + newExternalHostname);
                        brokerExternalURL = new BrokerURL(brokerExternalURL.getBrokerProtocol() + "://" + newExternalHostname + ":" + brokerExternalURL.getBrokerPort());
                        regularAcceptor.getAttributes().setStringAttribute("ACCEPTOR_EXTERNAL_URL", brokerExternalURL.getBrokerURL());
                    } else {
                        this.debug("DynamicHostTrigger.updateBrokerAcceptors will not update external acceptor " + regularAcceptor.getIdentity().getName() + " of broker " + brokerElement.getIdentity().getName());
                    }
                }
                if (!updateAcceptor && !updateExternalAcceptor) continue;
                dsContext.setElement((IDeltaElement)regularAcceptor.doneUpdate());
            }
            catch (Exception e) {
                DirectoryServiceException dirE = new DirectoryServiceException("Unable to modify acceptor urls in broker " + brokerElement.getIdentity().getName());
                dirE.initCause((Throwable)e);
                throw dirE;
            }
        }
    }

    private void updateBrokerReplicationAcceptors(ITriggerDSContext dsContext, IDirElement brokerElement, IDirElement locationElement, String hostAttribute) throws DirectoryServiceException {
        String newHostname = this.getLocationHostname(locationElement, true);
        this.debug("DynamicHostTrigger.updateBrokerReplicationAcceptors brokerId == " + brokerElement.getIdentity().getName() + " newHostname " + newHostname);
        IDirElement replicationAcceptorsElement = this.getReplicationAcceptors(dsContext, brokerElement);
        if (replicationAcceptorsElement == null) {
            this.debug("DynamicHostTrigger.updateBrokerReplicationAcceptors brokerId == " + brokerElement.getIdentity().getName() + " found no replication connections element");
            return;
        }
        IAttributeSet replicationAcceptors = (IAttributeSet)replicationAcceptorsElement.getAttributes().getAttribute("REPLICATION_CONNECTIONS");
        boolean modified = false;
        try {
            Iterator iterator = replicationAcceptors.getAttributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry replicationAcceptor;
                Map.Entry entry = replicationAcceptor = iterator.next();
                String key = (String)entry.getKey();
                IAttributeSet replicationAcceptorProperties = (IAttributeSet)entry.getValue();
                if (!this.updateReplicationConnection(replicationAcceptorProperties, hostAttribute, newHostname)) continue;
                modified = true;
            }
            if (modified) {
                dsContext.setElement((IDeltaElement)replicationAcceptorsElement.doneUpdate());
            }
        }
        catch (Exception e) {
            throw this.handleException(brokerElement, e);
        }
    }

    private boolean updateReplicationConnection(IAttributeSet replicationConnection, String hostAttribute, String newHostname) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
        boolean updateAcceptor;
        boolean modified = false;
        String hostname = (String)replicationConnection.getAttribute(hostAttribute);
        boolean bl = updateAcceptor = hostname == null || "localhost".equals(hostname);
        if (!updateAcceptor) {
            if (newHostname.equalsIgnoreCase(hostname)) {
                return false;
            }
            updateAcceptor = this.checkIsUpdateAcceptor(newHostname, hostname, updateAcceptor);
        }
        if (updateAcceptor = this.checkIsBrokerHost(updateAcceptor, hostname, newHostname)) {
            this.debug("DynamicHostTrigger.updateReplicationConnection updating attribute " + hostAttribute + " to " + newHostname);
            replicationConnection.setStringAttribute(hostAttribute, newHostname);
            modified = true;
        } else {
            this.debug("DynamicHostTrigger.updateReplicationConnection did not update attribute " + hostAttribute + " to " + newHostname);
        }
        return modified;
    }

    private boolean checkIsUpdateAcceptor(String newHostname, String hostname, boolean updateAcceptorParam) {
        boolean updateAcceptor = updateAcceptorParam;
        if (newHostname.length() == 0 && hostname.length() > 0) {
            updateAcceptor = true;
        }
        return updateAcceptor;
    }

    private boolean checkIsBrokerHost(boolean updateAcceptorParam, String brokerHost, String newHostname) {
        boolean updateAcceptor = updateAcceptorParam;
        if (!updateAcceptor) {
            updateAcceptor = !brokerHost.equals(newHostname);
        }
        return updateAcceptor;
    }

    private IDirElement[] getRegularAcceptors(ITriggerDSContext dsContext, IDirElement broker) throws DirectoryServiceException {
        IDirElement acceptors;
        ArrayList<IDirElement> acceptorList = new ArrayList<IDirElement>();
        Reference acceptorsRef = (Reference)((IAttributeSet)broker.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES")).getAttribute("ACCEPTOR_CONFIG_ELEMENT_REF");
        if (acceptorsRef != null && (acceptors = dsContext.getElement(acceptorsRef.getElementName())) != null) {
            for (Reference acceptorRef : ((IAttributeSet)acceptors.getAttributes().getAttribute("ACCEPTORS")).getAttributes().values()) {
                IDirElement acceptor = dsContext.getElement(acceptorRef.getElementName());
                if (acceptor == null) continue;
                acceptorList.add(acceptor);
            }
        }
        acceptors = new IDirElement[acceptorList.size()];
        acceptorList.toArray((T[])acceptors);
        this.debug("DynamicHostTrigger.getRegularAcceptors found " + ((IDirElement)acceptors).length + " regular acceptors for broker " + broker.getIdentity().getName());
        return acceptors;
    }

    private IDirElement getReplicationAcceptors(ITriggerDSContext dsContext, IDirElement broker) throws DirectoryServiceException {
        Reference acceptorsRef = (Reference)((IAttributeSet)broker.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES")).getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF");
        if (acceptorsRef != null && !acceptorsRef.getElementName().startsWith("/NO_STORAGE:")) {
            return dsContext.getElement(acceptorsRef.getElementName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateResolvedURLs(ITriggerDSContext dsContext, String nodeName) throws DirectoryServiceException {
        List usages = null;
        Map<String, List<String>> map = this.m_nodeNameToSonicRNUsageMap;
        synchronized (map) {
            usages = this.m_nodeNameToSonicRNUsageMap.get(nodeName);
            if (usages == null) {
                return;
            }
            usages = (List)((ArrayList)usages).clone();
        }
        for (String usage : usages) {
            IDirElement usageElement = dsContext.getElement(usage);
            if (usage.startsWith("/_MFContext")) {
                this.updateConnectionFactoryResolvedURLs(dsContext, usageElement);
                continue;
            }
            if (usage.startsWith("/xqConnections")) {
                this.updateXQJMSConnectionResolvedURLs(dsContext, usageElement);
                continue;
            }
            if (!MQ_ROUTE_SONIC.equals(usageElement.getIdentity().getType())) continue;
            String sonicrnUrl = (String)usageElement.getAttributes().getAttribute(SONICRN_URL_ATTRIBUTE);
            this.updateDynamicRoutingResolvedURLs(dsContext, usageElement, sonicrnUrl);
        }
    }

    private void updateConnectionFactoryResolvedURLs(ITriggerDSContext dsContext, IDirElement factoryElement) throws DirectoryServiceException {
        try {
            IAttributeList addrList = (IAttributeList)factoryElement.getAttributes().getAttribute("RefAdresses");
            ArrayList items = addrList.getItems();
            String url = null;
            IAttributeSet resolvedSet = null;
            for (IAttributeSet item : items) {
                Object value = null;
                value = item.getAttribute("brokerList");
                if (value != null) {
                    url = (String)value;
                    continue;
                }
                value = item.getAttribute("RESOLVED_BROKER_LIST");
                if (value == null) continue;
                resolvedSet = item;
            }
            if (!SonicRNURL.isValid(url, (boolean)false)) {
                this.debug("DynamicHostTrigger.updateConnectionFactoryResolvedURLs - Invalid sonicrn url - url:" + url);
                return;
            }
            if (url == null) {
                throw new NullPointerException("String url is null at " + this.getClass().getName() + ".updateConnectionFactoryResolvedURLs(ITriggerDSContext dsContext, IDirElement factoryElement)");
            }
            url = url.trim();
            String resolvedURL = (String)new URL(url).getContent();
            if (resolvedSet == null) {
                resolvedSet = addrList.addNewAttributeSetItem();
            } else if (resolvedSet.getAttribute("RESOLVED_BROKER_LIST").equals(resolvedURL)) {
                return;
            }
            resolvedSet.setStringAttribute("RESOLVED_BROKER_LIST", resolvedURL);
            dsContext.setElement((IDeltaElement)factoryElement.doneUpdate(), false);
        }
        catch (Exception e) {
            String connectionFactoryPath = factoryElement.getIdentity().getName();
            connectionFactoryPath = connectionFactoryPath.substring("/_MFContext".length());
            DirectoryServiceException dirE = new DirectoryServiceException("Unable to update the resolved urls for JMS connection factory " + connectionFactoryPath);
            dirE.initCause((Throwable)e);
            throw dirE;
        }
    }

    private boolean isConnectionFactoryElement(IDirElement element) {
        IAttributeSet attributes = element.getAttributes();
        String classname = (String)attributes.getAttribute("classname");
        if (!classname.startsWith("progress.message.jclient.")) {
            return false;
        }
        return classname.endsWith(CONNECTION_FACTORY);
    }

    private boolean isXQJMSConnectionElement(IDirElement element) {
        IAttributeSet attributes = element.getAttributes();
        String typeRef = (String)attributes.getAttribute("type_ref");
        return "JMSType".equals(typeRef);
    }

    private void onConnectionFactoryCreate(ITriggerDSContext dsContext, IDirElement factoryElement) {
        String brokerList = null;
        try {
            IDirElement storedFactoryElement = dsContext.getElement(factoryElement.getIdentity().getName());
            brokerList = this.getConnectionFactoryBrokerList(storedFactoryElement);
            this.setConnectionFactoryResolvedBrokerList(dsContext, storedFactoryElement, null, brokerList);
        }
        catch (Exception e) {
            dsContext.logMessage("Failed to update resolved URL \"" + brokerList + "\", trace follows...", (Throwable)e, 2);
            return;
        }
    }

    private void onConnectionFactoryUpdate(ITriggerDSContext dsContext, IDirElement originalFactoryElement) {
        String storedBrokerList = null;
        try {
            IDirElement storedUpdatedFactoryElement = dsContext.getElement(originalFactoryElement.getIdentity().getName());
            String originalBrokerList = this.getConnectionFactoryBrokerList(originalFactoryElement);
            storedBrokerList = this.getConnectionFactoryBrokerList(storedUpdatedFactoryElement);
            this.debug("DynamicHostTrigger.onConnectionFactoryUpdate originalBrokerList storedBrokerList - " + originalBrokerList + " " + storedBrokerList);
            if (storedBrokerList == null && originalBrokerList == null) {
                return;
            }
            if (storedBrokerList != null && storedBrokerList.equals(originalBrokerList)) {
                String originalResolvedBrokerList = this.getConnectionFactoryResolvedBrokerList(originalFactoryElement);
                String storedResolvedBrokerList = this.getConnectionFactoryResolvedBrokerList(storedUpdatedFactoryElement);
                this.debug("DynamicHostTrigger.onConnectionFactoryUpdate originalResolvedBrokerList storedResolvedBrokerList - " + originalResolvedBrokerList + " " + storedResolvedBrokerList);
                if (storedResolvedBrokerList != null && storedResolvedBrokerList.equals(originalResolvedBrokerList)) {
                    return;
                }
            }
            this.setConnectionFactoryResolvedBrokerList(dsContext, storedUpdatedFactoryElement, originalBrokerList, storedBrokerList);
        }
        catch (Exception e) {
            dsContext.logMessage("Failed to update resolved URL \"" + storedBrokerList + "\", trace follows...", (Throwable)e, 2);
            return;
        }
    }

    private void setConnectionFactoryResolvedBrokerList(ITriggerDSContext dsContext, IDirElement factoryElement, String originalBrokerList, String storedBrokerListParam) throws Exception {
        String storedBrokerList = storedBrokerListParam;
        boolean isSonicRNURL = SonicRNURL.isValid((String)(storedBrokerList = this.trimData(storedBrokerList)), (boolean)false);
        String resolvedBrokerList = isSonicRNURL ? (String)new URL(storedBrokerList).getContent() : storedBrokerList;
        IAttributeSet factoryAttributes = factoryElement.getAttributes();
        IAttributeList refsAttributeList = (IAttributeList)factoryAttributes.getAttribute("RefAdresses");
        IAttributeSet resolvedBrokerListAttributes = DynamicHostTrigger.checkResolvedBrokerList(refsAttributeList);
        if (resolvedBrokerListAttributes == null) {
            resolvedBrokerListAttributes = refsAttributeList.addNewAttributeSetItem();
        }
        resolvedBrokerListAttributes.setStringAttribute("RESOLVED_BROKER_LIST", resolvedBrokerList);
        this.updateSonicRNUsage(dsContext, factoryElement, isSonicRNURL, storedBrokerList, originalBrokerList);
    }

    private String getConnectionFactoryBrokerList(IDirElement factoryElement) {
        IAttributeSet factoryAttributes = factoryElement.getAttributes();
        IAttributeList refsAttributeList = (IAttributeList)factoryAttributes.getAttribute("RefAdresses");
        for (Object item : refsAttributeList.getItems()) {
            IAttributeSet itemAttributes = (IAttributeSet)item;
            if (itemAttributes.getAttribute("brokerList") == null) continue;
            return (String)itemAttributes.getAttribute("brokerList");
        }
        return null;
    }

    private void onXQJMSConnectionCreate(ITriggerDSContext dsContext, IDirElement xqJMSConnectionElement) {
        String url = null;
        try {
            IDirElement storedXQJMSConnectionElement = dsContext.getElement(xqJMSConnectionElement.getIdentity().getName());
            url = this.getXQJMSConnectionURL(storedXQJMSConnectionElement);
            if (url == null) {
                return;
            }
            this.setXQJMSConnectionResolvedURL(dsContext, storedXQJMSConnectionElement, null, url);
        }
        catch (Exception e) {
            dsContext.logMessage("Failed to update resolved URL \"" + url + "\", trace follows...", (Throwable)e, 2);
            return;
        }
    }

    private void onXQJMSConnectionUpdate(ITriggerDSContext dsContext, IDirElement originalXQJMSConnectionElement) {
        String storedURL = null;
        try {
            IDirElement storedUpdatedXQJMSConnectionElement = dsContext.getElement(originalXQJMSConnectionElement.getIdentity().getName());
            String originalURL = this.getXQJMSConnectionURL(originalXQJMSConnectionElement);
            storedURL = this.getXQJMSConnectionURL(storedUpdatedXQJMSConnectionElement);
            this.debug("DynamicHostTrigger.onXQJMSConnectionUpdate originalURL storedURL - " + originalURL + " " + storedURL);
            if (storedURL == null && originalURL == null) {
                return;
            }
            if (storedURL != null && storedURL.equals(originalURL)) {
                String originalResolvedURL = this.getXQJMSConnectionResolvedURL(originalXQJMSConnectionElement);
                String storedResolvedURL = this.getXQJMSConnectionResolvedURL(storedUpdatedXQJMSConnectionElement);
                this.debug("DynamicHostTrigger.onXQJMSConnectionUpdate originalResolvedURL storedResolvedURL - " + originalResolvedURL + " " + storedResolvedURL);
                if (storedResolvedURL != null && storedResolvedURL.equals(originalResolvedURL)) {
                    return;
                }
            }
            this.setXQJMSConnectionResolvedURL(dsContext, storedUpdatedXQJMSConnectionElement, originalURL, storedURL);
        }
        catch (Exception e) {
            dsContext.logMessage("Failed to update resolved URL \"" + storedURL + "\", trace follows...", (Throwable)e, 2);
            return;
        }
    }

    private void setXQJMSConnectionResolvedURL(ITriggerDSContext dsContext, IDirElement xqJMSConnectionElement, String originalURL, String storedURLParam) throws Exception {
        String storedURL = storedURLParam;
        this.debug("DynamicHostTrigger.setXQJMSConnectionResolvedURL originalURL storedURL - " + originalURL + " " + storedURL);
        storedURL = this.trimData(storedURL);
        boolean isSonicRNURL = SonicRNURL.isValid((String)storedURL, (boolean)false);
        String resolvedURL = isSonicRNURL ? (String)new URL(storedURL).getContent() : (storedURL == null ? "" : storedURL);
        IAttributeSet xqJMSConnectionAttributes = (IAttributeSet)xqJMSConnectionElement.getAttributes().getAttribute("params");
        if (xqJMSConnectionAttributes == null) {
            return;
        }
        IAttributeSet resolvedUrlAttrs = (IAttributeSet)xqJMSConnectionAttributes.getAttribute(RESOLVED_URL_ATTRIBUTE);
        if (resolvedUrlAttrs == null) {
            resolvedUrlAttrs = this.createIAttributeSet(xqJMSConnectionAttributes);
        }
        resolvedUrlAttrs.setStringAttribute("value", resolvedURL);
        this.updateSonicRNUsage(dsContext, xqJMSConnectionElement, isSonicRNURL, storedURL, originalURL);
    }

    private String trimData(String dataParam) {
        String data = dataParam;
        if (data != null) {
            data = data.trim();
        }
        return data;
    }

    private void updateSonicRNUsage(ITriggerDSContext dsContext, IDirElement xqJMSConnectionElement, boolean isSonicRNURL, String storedURL, String originalURL) throws DirectoryServiceException, ReadOnlyException {
        dsContext.setElement((IDeltaElement)xqJMSConnectionElement.doneUpdate(), false);
        if (isSonicRNURL) {
            this.addSonicRNUsageToNodeNameMap(xqJMSConnectionElement, storedURL);
        }
        this.removeSonicRNUsageFromNodeNameMap(xqJMSConnectionElement, originalURL);
    }

    private String getXQJMSConnectionURL(IDirElement xqJMSConnectionElement) {
        IAttributeSet xqJMSConnectionAttributes = (IAttributeSet)xqJMSConnectionElement.getAttributes().getAttribute("params");
        if (xqJMSConnectionAttributes == null) {
            return null;
        }
        IAttributeSet urlAttrs = (IAttributeSet)xqJMSConnectionAttributes.getAttribute("url");
        return this.retrieveAttribute(urlAttrs);
    }

    private String getXQJMSConnectionResolvedURL(IDirElement xqJMSConnectionElement) {
        IAttributeSet xqJMSConnectionAttributes = (IAttributeSet)xqJMSConnectionElement.getAttributes().getAttribute("params");
        IAttributeSet urlAttrs = (IAttributeSet)xqJMSConnectionAttributes.getAttribute(RESOLVED_URL_ATTRIBUTE);
        return this.retrieveAttribute(urlAttrs);
    }

    private String retrieveAttribute(IAttributeSet urlAttrs) {
        if (urlAttrs == null) {
            return null;
        }
        return (String)urlAttrs.getAttribute("value");
    }

    private String getConnectionFactoryResolvedBrokerList(IDirElement connectionFactoryElement) throws ReadOnlyException {
        IAttributeList refsAttributeList = (IAttributeList)connectionFactoryElement.getAttributes().getAttribute("RefAdresses");
        IAttributeSet resolvedBrokerListAttributes = DynamicHostTrigger.checkResolvedBrokerList(refsAttributeList);
        if (resolvedBrokerListAttributes == null) {
            return null;
        }
        return (String)resolvedBrokerListAttributes.getAttribute("RESOLVED_BROKER_LIST");
    }

    private static IAttributeSet checkResolvedBrokerList(IAttributeList refsAttributeList) {
        ArrayList items = refsAttributeList.getItems();
        IAttributeSet resolvedBrokerListAttributes = null;
        for (Object item : items) {
            IAttributeSet itemAttributes = (IAttributeSet)item;
            if (itemAttributes.getAttribute("RESOLVED_BROKER_LIST") == null) continue;
            resolvedBrokerListAttributes = itemAttributes;
            break;
        }
        return resolvedBrokerListAttributes;
    }

    private void updateXQJMSConnectionResolvedURLs(ITriggerDSContext dsContext, IDirElement xqJMSConnectionElement) throws DirectoryServiceException {
        try {
            IAttributeSet xqJMSConnectionParameters = (IAttributeSet)xqJMSConnectionElement.getAttributes().getAttribute("params");
            if (xqJMSConnectionParameters == null) {
                return;
            }
            IAttributeSet urlAttrs = (IAttributeSet)xqJMSConnectionParameters.getAttribute("url");
            String url = (String)urlAttrs.getAttribute("value");
            if (!SonicRNURL.isValid((String)url, (boolean)false)) {
                this.debug("DynamicHostTrigger.updateXQJMSConnectionResolvedURLs - Invalid sonicrn url - url:" + url);
                return;
            }
            url = url.trim();
            String resolvedURL = (String)new URL(url).getContent();
            IAttributeSet resolvedUrlAttrs = (IAttributeSet)xqJMSConnectionParameters.getAttribute(RESOLVED_URL_ATTRIBUTE);
            if (resolvedUrlAttrs == null) {
                resolvedUrlAttrs = this.createIAttributeSet(xqJMSConnectionParameters);
            } else {
                String currentResolvedUrl = (String)resolvedUrlAttrs.getAttribute("value");
                if (resolvedURL.equals(currentResolvedUrl)) {
                    return;
                }
            }
            resolvedUrlAttrs.setStringAttribute("value", resolvedURL);
            dsContext.setElement((IDeltaElement)xqJMSConnectionElement.doneUpdate(), false);
        }
        catch (Exception e) {
            DirectoryServiceException dirE = new DirectoryServiceException("Unable to update the resolved urls for ESB JMS connection  " + xqJMSConnectionElement.getIdentity().getName());
            dirE.initCause((Throwable)e);
            throw dirE;
        }
    }

    private IAttributeSet createIAttributeSet(IAttributeSet xqJMSConnectionParameters) throws ConfigException {
        IAttributeSet resolvedUrlAttrs = xqJMSConnectionParameters.createAttributeSet(RESOLVED_URL_ATTRIBUTE);
        resolvedUrlAttrs.setStringAttribute("name", RESOLVED_URL_ATTRIBUTE);
        resolvedUrlAttrs.setStringAttribute("type", "stringParam");
        return resolvedUrlAttrs;
    }

    private void deleteBrokerLocationElement(ITriggerDSContext dsContext, String brokerLocationElementName) throws DirectoryServiceException {
        try {
            dsContext.deleteElement(brokerLocationElementName);
        }
        catch (DirectoryDoesNotExistException directoryDoesNotExistException) {
            // empty catch block
        }
        String parentDirectory = brokerLocationElementName.substring(0, brokerLocationElementName.lastIndexOf(47));
        try {
            if (dsContext.listElements(parentDirectory).length == 0) {
                dsContext.deleteDirectory(parentDirectory);
            }
        }
        catch (DirectoryDoesNotExistException directoryDoesNotExistException) {
            // empty catch block
        }
        String parentsParentDirectory = parentDirectory.substring(0, parentDirectory.lastIndexOf(47));
        try {
            if (dsContext.listDirectories(parentsParentDirectory).length == 0) {
                dsContext.deleteDirectory(parentsParentDirectory);
            }
        }
        catch (DirectoryDoesNotExistException directoryDoesNotExistException) {
            // empty catch block
        }
    }

    public String getNodeNameFromBrokerLocation(String id) {
        String idAfterDirectory = id.substring("/_MQRuntime/location/".length());
        String nodename = idAfterDirectory.substring(0, idAfterDirectory.indexOf(47));
        return nodename;
    }

    private void onReplicationConnectionsUpdate(ITriggerDSContext dsContext, IDirElement originalConnectionsElement, IDeltaElement updatedConnectionsElement) throws DirectoryServiceException {
        boolean needUpdate = false;
        IDirElement broker = this.getBrokerElementFromReplicationConnectionsElement(dsContext, updatedConnectionsElement.getIdentity().getName());
        this.debug("DynamicHostTrigger.onReplicationConnectionsUpdate " + broker.getIdentity().getName());
        boolean useDynamicHostBinding = this.getUseDynamicHostBinding(dsContext, broker);
        if (!useDynamicHostBinding) {
            return;
        }
        IDirElement primaryLocationElement = this.getLocationElement(dsContext, broker, false);
        IDirElement backupLocationElement = this.getLocationElement(dsContext, broker, true);
        if (backupLocationElement == null && primaryLocationElement == null) {
            return;
        }
        Object dAttrs = updatedConnectionsElement.getDeltaAttributes();
        if (dAttrs instanceof IAttributeSet) {
            needUpdate = true;
        } else {
            IDeltaAttributeSet changed = (IDeltaAttributeSet)dAttrs;
            if (changed.getModifiedAttributesNames().length > 0 || changed.getNewAttributesNames().length > 0) {
                needUpdate = true;
            }
        }
        if (needUpdate) {
            this.debug("DynamicHostTrigger.onReplicationConnectionsUpdate replication connections change needs hostname check for primary and backup");
            IDirElement replicationsElement = dsContext.getElement(updatedConnectionsElement.getIdentity().getName());
            try {
                this.updatePrimaryAndBackupAddresses(dsContext, replicationsElement, primaryLocationElement, backupLocationElement, false);
            }
            catch (Exception e) {
                throw this.handleException(broker, e);
            }
        } else {
            this.debug("DynamicHostTrigger.onReplicationConnectionsUpdate did not need to update the replications connections");
        }
    }

    private DirectoryServiceException handleException(IDirElement broker, Exception e) {
        DirectoryServiceException dirE = new DirectoryServiceException("Unable to modify replication connection for broker " + broker.getIdentity().getName());
        dirE.initCause((Throwable)e);
        return dirE;
    }

    private IDirElement getBrokerElementFromReplicationConnectionsElement(ITriggerDSContext dsContext, String connectionsElementName) throws DirectoryServiceException {
        this.debug("DynamicHostTrigger.getBrokerElementFromReplicationConnectionsElement getting broker for replication connections elements " + connectionsElementName);
        Query brokersQuery = new Query();
        brokersQuery.setFrom((From)new FromDirectory("/mq/brokers"));
        EqualExpression connectionsRefExpression = new EqualExpression(new AttributeName("CONFIG_ELEMENT_REFERENCES").setNextComponent("REPLICATION_CONNECTIONS_ELEMENT_REF"), new Reference(connectionsElementName));
        Where connectionsRefWhere = new Where(new BooleanExpression[]{connectionsRefExpression});
        brokersQuery.setWhere(connectionsRefWhere);
        IDirElement[] brokerElements = dsContext.getElements(brokersQuery, true);
        if (brokerElements.length == 0) {
            this.debug("DynamicHostTrigger.getBrokerElementFromReplicationConnectionsElement found no broker for replication connections element " + connectionsElementName);
            return null;
        }
        this.debug("DynamicHostTrigger.getBrokerElementFromReplicationConnectionsElement found broker " + brokerElements[0].getIdentity().getName() + " for replication connections element " + connectionsElementName);
        return brokerElements[0];
    }

    private IDirElement getLocationElement(ITriggerDSContext dsContext, IDirElement broker, boolean backup) throws DirectoryServiceException {
        this.debug("DynamicHostTrigger.getLocationElement called for broker " + broker.getAttributes().getAttribute("BROKER_NAME") + (backup ? " backup" : " primary"));
        String nodeName = this.getBrokerNodeName(dsContext, broker);
        if (nodeName != null) {
            String locationElId = "/_MQRuntime/location/" + nodeName + "/" + broker.getAttributes().getAttribute("BROKER_NAME") + "/" + (backup ? "backup" : "primary");
            IDirElement location = null;
            try {
                location = dsContext.getElement(locationElId);
            }
            catch (DirectoryServiceException directoryServiceException) {
                // empty catch block
            }
            if (location != null) {
                this.debug("DynamicHostTrigger.getLocationElement found location element " + location.getIdentity().getName() + " for broker " + broker.getAttributes().getAttribute("BROKER_NAME") + (backup ? " backup" : " primary"));
                return location;
            }
        }
        this.debug("DynamicHostTrigger.getLocationElement found no location element for broker " + broker.getAttributes().getAttribute("BROKER_NAME") + (backup ? " backup" : " primary"));
        return null;
    }

    private boolean getUseDynamicHostBinding(ITriggerDSContext dsContext, IDirElement brokerOrBackupBroker) throws DirectoryServiceException {
        this.debug("DynamicHostTrigger.getUseDynamicHostBinding finding setting for broker " + brokerOrBackupBroker.getIdentity().getName());
        Boolean dynamic = null;
        IDirElement primaryBroker = null;
        String type = brokerOrBackupBroker.getIdentity().getType();
        if ("MQ_BROKER".equals(type)) {
            primaryBroker = brokerOrBackupBroker;
        } else {
            IAttributeSet refs = (IAttributeSet)brokerOrBackupBroker.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference primaryRef = null;
            if (refs != null) {
                primaryRef = (Reference)refs.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            }
            primaryBroker = DynamicHostTrigger.retrieveElement(primaryRef, primaryBroker, dsContext);
        }
        if (primaryBroker != null) {
            this.debug("DynamicHostTrigger.getUseDynamicHostBinding found primary broker " + primaryBroker.getIdentity().getName());
            IAttributeSet brokerRefs = (IAttributeSet)primaryBroker.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference clusterRef = (Reference)brokerRefs.getAttribute("CLUSTER_CONFIG_ELEMENT_REF");
            if (clusterRef != null) {
                if (!clusterRef.getElementName().startsWith("/NO_STORAGE:")) {
                    this.debug("DynamicHostTrigger.getUseDynamicHostBinding found cluster for broker " + clusterRef.getElementName());
                    IDirElement cluster = dsContext.getElement(clusterRef.getElementName());
                    dynamic = (Boolean)cluster.getAttributes().getAttribute("USE_DYNAMIC_HOST_BINDING");
                }
            } else {
                dynamic = (Boolean)primaryBroker.getAttributes().getAttribute("USE_DYNAMIC_HOST_BINDING");
            }
        } else {
            this.debug("DynamicHostTrigger.getUseDynamicHostBinding did not find primary broker to look for flag");
        }
        if (dynamic == null || !dynamic.booleanValue()) {
            this.debug("DynamicHostTrigger.getUseDynamicHostBinding returning false");
            return false;
        }
        this.debug("DynamicHostTrigger.getUseDynamicHostBinding returning true");
        return true;
    }

    private void updatePrimaryAndBackupAddresses(ITriggerDSContext dsContext, IDirElement replicationsElement, IDirElement primaryLocationElement, IDirElement backupLocationElement, boolean fireTriggers) throws Exception {
        this.debug("DynamicHostTrigger.updatePrimaryAndBackupAddresses replication connections change needs hostname check for primary and backup");
        String primaryHostname = null;
        if (primaryLocationElement != null) {
            primaryHostname = this.getLocationHostname(primaryLocationElement, true);
        }
        String backupHostname = null;
        if (backupLocationElement != null) {
            backupHostname = this.getLocationHostname(backupLocationElement, true);
        }
        IAttributeSet replicationAcceptors = (IAttributeSet)replicationsElement.getAttributes().getAttribute("REPLICATION_CONNECTIONS");
        boolean modified = false;
        Iterator iterator = replicationAcceptors.getAttributes().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry replicationAcceptor;
            Map.Entry entry = replicationAcceptor = iterator.next();
            String key = (String)entry.getKey();
            IAttributeSet replicationAcceptorProperties = (IAttributeSet)entry.getValue();
            if (primaryHostname != null && primaryHostname.length() > 0 && this.updateReplicationConnection(replicationAcceptorProperties, "PRIMARY_ADDR", primaryHostname)) {
                modified = true;
            }
            if (backupHostname == null || backupHostname.length() <= 0 || !this.updateReplicationConnection(replicationAcceptorProperties, "BACKUP_ADDR", backupHostname)) continue;
            modified = true;
        }
        if (modified) {
            this.debug("DynamicHostTrigger.updatePrimaryAndBackupAddresses made hostname modifications to replication connections");
            dsContext.setElement((IDeltaElement)replicationsElement.doneUpdate(), fireTriggers);
        } else {
            this.debug("DynamicHostTrigger.updatePrimaryAndBackupAddresses made no hostname modifications to replication connections");
        }
    }

    private void resolveClusteredBrokerAcceptorsAndReplicationConnections(ITriggerDSContext dsContext, String nodename, String clusterId) throws Exception {
        String nodeDirectory = "/_MQRuntime/location/" + nodename;
        IDirIdentity[] brokerLocationDirectories = null;
        try {
            brokerLocationDirectories = dsContext.listDirectories(nodeDirectory);
        }
        catch (DirectoryDoesNotExistException dirDoesNotExist) {
            return;
        }
        for (IDirIdentity brokerLocationDirectory : brokerLocationDirectories) {
            IAttributeSet refs;
            Reference clusterRef;
            IDirElement primaryLocation = dsContext.getElement(brokerLocationDirectory.getName() + "/" + "primary");
            IDirElement backupLocation = dsContext.getElement(brokerLocationDirectory.getName() + "/" + "backup");
            String primaryBrokerId = (String)primaryLocation.getAttributes().getAttribute("BROKER_CONFIG_ELEMENT_REF");
            IDirElement primaryBroker = dsContext.getElement(primaryBrokerId);
            if (primaryBroker != null && (clusterRef = (Reference)(refs = (IAttributeSet)primaryBroker.getAttributes().getAttribute("CONFIG_ELEMENT_REFERENCES")).getAttribute("CLUSTER_CONFIG_ELEMENT_REF")) != null && clusterRef.getElementName().equals(clusterId)) {
                this.updateBrokerRegularAcceptors(dsContext, primaryBroker, primaryLocation);
                IDirElement replicationsElement = null;
                replicationsElement = DynamicHostTrigger.retrieveReplicationsElement(dsContext, refs, replicationsElement);
                if (replicationsElement != null) {
                    this.updatePrimaryAndBackupAddresses(dsContext, replicationsElement, primaryLocation, backupLocation, true);
                }
            }
            IDirElement backupBroker = null;
            if (backupLocation != null) {
                backupBroker = dsContext.getElement((String)backupLocation.getAttributes().getAttribute("BROKER_CONFIG_ELEMENT_REF"));
            }
            if (backupBroker == null) continue;
            this.updateBrokerRegularAcceptors(dsContext, backupBroker, backupLocation);
        }
    }

    private static IDirElement retrieveReplicationsElement(ITriggerDSContext dsContext, IAttributeSet refs, IDirElement replicationsElementParam) throws DirectoryServiceException {
        IDirElement replicationsElement = replicationsElementParam;
        Reference replicationReference = (Reference)refs.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF");
        replicationsElement = DynamicHostTrigger.retrieveElement(replicationReference, replicationsElement, dsContext);
        return replicationsElement;
    }

    private static IDirElement retrieveElement(Reference replicationReference, IDirElement replicationsElementParam, ITriggerDSContext dsContext) throws DirectoryServiceException {
        IDirElement replicationsElement = replicationsElementParam;
        if (replicationReference != null && !replicationReference.getElementName().startsWith("/NO_STORAGE:")) {
            replicationsElement = dsContext.getElement(replicationReference.getElementName());
        }
        return replicationsElement;
    }

    private String getLocationHostname(IDirElement location, boolean useExternal) {
        String externalHost = this.getExternalLocationHostname(location);
        if (useExternal && externalHost != null && externalHost.length() > 0) {
            return externalHost;
        }
        return (String)location.getAttributes().getAttribute("PRIVATE_HOSTNAME");
    }

    private String getExternalLocationHostname(IDirElement location) {
        String publicHost = (String)location.getAttributes().getAttribute("PUBLIC_HOSTNAME");
        if (publicHost != null && publicHost.length() > 0) {
            return publicHost;
        }
        return "";
    }

    private void onDynamicRoutingCreate(ITriggerDSContext dsContext, IDirElement dynamicRouting) throws DirectoryServiceException {
        this.debug("DynamicHostTrigger.onDynamicRoutingCreate - dynamicRouting:" + dynamicRouting.getIdentity().getName());
        String sonicrnUrl = (String)dynamicRouting.getAttributes().getAttribute(SONICRN_URL_ATTRIBUTE);
        if (!SonicRNURL.isValid((String)sonicrnUrl, (boolean)false)) {
            this.debug("DynamicHostTrigger.onDynamicRoutingCreate - Invalid sonicrn url - sonicrnUrl:" + sonicrnUrl);
            return;
        }
        this.updateDynamicResolvedUrlAddSonicRNUsage(sonicrnUrl, dsContext, dynamicRouting);
    }

    private void onDynamicRoutingUpdate(ITriggerDSContext dsContext, IDirElement originalDynamicRouting, IDeltaElement updatedDynamicRouting) throws DirectoryServiceException {
        this.debug("DynamicHostTrigger.onDynamicRoutingUpdate - originalDynamicRouting:" + originalDynamicRouting.getIdentity().getName() + " updatedDynamicRouting:" + updatedDynamicRouting.getIdentity().getName());
        IDeltaAttributeSet updatedAttributes = (IDeltaAttributeSet)updatedDynamicRouting.getDeltaAttributes();
        String[] attrNames = updatedAttributes.getNewAttributesNames();
        try {
            for (String attrName : attrNames) {
                if (!SONICRN_URL_ATTRIBUTE.equals(attrName)) continue;
                String updatedSonicrnUrl = (String)updatedAttributes.getNewValue(SONICRN_URL_ATTRIBUTE);
                this.debug("DynamicHostTrigger.onDynamicRoutingUpdate - SONICRN_URL added - " + updatedSonicrnUrl);
                if (!SonicRNURL.isValid((String)updatedSonicrnUrl, (boolean)false)) {
                    this.debug("DynamicHostTrigger.onDynamicRoutingUpdate - Invalid sonicrn url - updatedSonicrnUrl:" + updatedSonicrnUrl);
                    return;
                }
                this.updateDynamicResolvedUrlAddSonicRNUsage(updatedSonicrnUrl, dsContext, originalDynamicRouting);
                return;
            }
            for (String attrName : attrNames = updatedAttributes.getModifiedAttributesNames()) {
                if (!SONICRN_URL_ATTRIBUTE.equals(attrName)) continue;
                String originalSonicrnUrl = (String)originalDynamicRouting.getAttributes().getAttribute(SONICRN_URL_ATTRIBUTE);
                String updatedSonicrnUrl = (String)updatedAttributes.getNewValue(SONICRN_URL_ATTRIBUTE);
                this.debug("DynamicHostTrigger.onDynamicRoutingUpdate - SONICRN_URL updated - originalSonicrnUrl updatedSonicrnUrl - " + originalSonicrnUrl + " " + updatedSonicrnUrl);
                if (updatedSonicrnUrl != null) {
                    updatedSonicrnUrl = updatedSonicrnUrl.trim();
                }
                if (updatedSonicrnUrl != null && !updatedSonicrnUrl.equals(originalSonicrnUrl)) {
                    this.updateDynamicRoutingResolvedURLs(dsContext, originalDynamicRouting, updatedSonicrnUrl);
                    String originalNodeName = "";
                    if (SonicRNURL.isValid((String)originalSonicrnUrl, (boolean)false)) {
                        originalNodeName = new SonicRNURL(originalSonicrnUrl).getNodename();
                    }
                    String updatedNodeName = "";
                    if (SonicRNURL.isValid((String)updatedSonicrnUrl, (boolean)false)) {
                        updatedNodeName = new SonicRNURL(updatedSonicrnUrl).getNodename();
                    }
                    if (!updatedNodeName.equals(originalNodeName)) {
                        this.removeSonicRNUsageFromNodeNameMap(originalDynamicRouting, originalSonicrnUrl);
                        this.addSonicRNUsageToNodeNameMap(originalDynamicRouting, updatedSonicrnUrl);
                    }
                } else if (updatedSonicrnUrl == null || updatedSonicrnUrl.isEmpty()) {
                    this.removeSonicRNUsageFromNodeNameMap(originalDynamicRouting, originalSonicrnUrl);
                }
                return;
            }
            for (String attrName : attrNames = updatedAttributes.getDeletedAttributesNames()) {
                if (!SONICRN_URL_ATTRIBUTE.equals(attrName)) continue;
                String originalSonicrnUrl = (String)originalDynamicRouting.getAttributes().getAttribute(SONICRN_URL_ATTRIBUTE);
                this.debug("DynamicHostTrigger.onDynamicRoutingUpdate - SONICRN_URL removed (or set to null) - originalSonicrnUrl - " + originalSonicrnUrl);
                this.removeSonicRNUsageFromNodeNameMap(originalDynamicRouting, originalSonicrnUrl);
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException("DynamicHostrigger.onDynamicRoutingUpdate - Error on handling of dynamic routing update:" + originalDynamicRouting.getIdentity().getName(), (Throwable)e);
        }
    }

    private void updateDynamicResolvedUrlAddSonicRNUsage(String updatedSonicrnUrlParam, ITriggerDSContext dsContext, IDirElement originalDynamicRouting) throws DirectoryServiceException {
        String updatedSonicrnUrl = updatedSonicrnUrlParam;
        updatedSonicrnUrl = updatedSonicrnUrl.trim();
        this.updateDynamicRoutingResolvedURLs(dsContext, originalDynamicRouting, updatedSonicrnUrl);
        this.addSonicRNUsageToNodeNameMap(originalDynamicRouting, updatedSonicrnUrl);
    }

    private void onDynamicRoutingDelete(ITriggerDSContext dsContext, IDirElement dynamicRouting) throws DirectoryServiceException {
        this.debug("DynamicHostTrigger.onDynamicRoutingDelete - dynamicRouting:" + dynamicRouting.getIdentity().getName());
        String sonicrnUrl = (String)dynamicRouting.getAttributes().getAttribute(SONICRN_URL_ATTRIBUTE);
        this.removeSonicRNUsageFromNodeNameMap(dynamicRouting, sonicrnUrl);
    }

    private void updateDynamicRoutingResolvedURLs(ITriggerDSContext dsContext, IDirElement dynamicRouting, String sonicrnUrlParam) throws DirectoryServiceException {
        String sonicrnUrl = sonicrnUrlParam;
        this.debug("DynamicHostTrigger.updateDynamicRoutingResolvedURLs - dynamicRouting: " + dynamicRouting.getIdentity().getName() + " SONICRN_URL:" + sonicrnUrl);
        if (!SonicRNURL.isValid((String)sonicrnUrl, (boolean)false)) {
            this.debug("DynamicHostTrigger.updateDynamicRoutingResolvedURLs - Invalid sonicrn url - sonicrnUrl:" + sonicrnUrl);
            return;
        }
        sonicrnUrl = sonicrnUrl.trim();
        try {
            String resolvedUrls = (String)new URL(sonicrnUrl).getContent();
            this.debug("DynamicHostTrigger.updateDynamicRoutingResolvedURLs - resolvedUrls: " + resolvedUrls);
            IDirElement routingDefinition = dsContext.getElement(dynamicRouting.getIdentity().getName());
            routingDefinition.getAttributes().setStringAttribute(URLS_ATTRIBUTE, resolvedUrls);
            dsContext.setElement((IDeltaElement)routingDefinition.doneUpdate(), false);
            this.debug("DynamicHostTrigger.updateDynamicRoutingResolvedURLs - dynamicRouting: " + dynamicRouting.getIdentity().getName() + " URLS:" + resolvedUrls);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("DynamicHostTrigger.updateDynamicRoutingResolvedURLs - Unable to set resolved urls for dynamicRouting - sonicrnUrl: " + dynamicRouting + " - " + sonicrnUrl, (Throwable)e);
        }
    }

    private IDirElement[] getSonicRNDynamicRoutings(ITriggerDSContext dsContext, boolean forUpdate) throws DirectoryServiceException {
        ArrayList<IDirElement> dynamicRouting = new ArrayList<IDirElement>();
        Query query = new Query();
        query.setFrom((From)new FromDirectory("/mq/routes"));
        StartsWithExpression expression = new StartsWithExpression(new AttributeName(SONICRN_URL_ATTRIBUTE), "sonicrn:///");
        Where where = new Where(new BooleanExpression[]{expression});
        query.setWhere(where);
        this.debug("DynamicHostTrigger.getSonicRNDynamicRoutings - query:" + query);
        IDirElement[] routingDefinitions = dsContext.getElements(query, forUpdate);
        if (routingDefinitions != null && routingDefinitions.length > 0) {
            for (IDirElement routingDefinition : routingDefinitions) {
                if (!MQ_ROUTE_SONIC.equals(routingDefinition.getIdentity().getType())) continue;
                dynamicRouting.add(routingDefinition);
            }
        }
        this.debug("DynamicHostTrigger.getSonicRNDynamicRoutings - queryResult:" + dynamicRouting);
        return dynamicRouting.toArray(new IDirElement[0]);
    }
}

