/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.common;

import com.sonicsw.mq.common.runtime.IReliableSequenceData;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.TimedUrlConnection;
import com.sonicsw.net.http.ws.WSHttpInRequest;
import com.sonicsw.net.http.ws.WSHttpProtocolHandler;
import com.sonicsw.ws.rm.common.CreateOperationContext;
import com.sonicsw.ws.rm.common.RMClusteringHelper;
import com.sonicsw.ws.rm.common.RMEvent;
import com.sonicsw.ws.rm.common.RMSequence;
import com.sonicsw.ws.rm.common.RMSequenceSupport;
import com.sonicsw.ws.rm.common.ReliableMessageWrapper;
import com.sonicsw.ws.rm.common.SequenceCapsule;
import com.sonicsw.ws.rm.common.SequenceMonitorThread;
import com.sonicsw.ws.rm.common.SequencedDataContext;
import com.sonicsw.ws.rm.policy.RMPolicy;
import com.sonicsw.ws.rm.protocol.AcksTo;
import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.Identifier;
import com.sonicsw.ws.rm.protocol.SequenceAcknowledgement;
import com.sonicsw.ws.rm.protocol.SequenceFault;
import com.sonicsw.ws.rm.protocol.prAccessor;
import com.sonicsw.ws.rm.receiver.fsm.EstablishedReceiveState;
import com.sonicsw.ws.rm.receiver.fsm.RMReceiveSequence;
import com.sonicsw.ws.rm.sender.fsm.EstablishedSendState;
import com.sonicsw.ws.rm.sender.fsm.RMSendSequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.SortedMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.types.URI;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.LogEvent;
import progress.message.broker.LogManager;
import progress.message.broker.RMInboundEndEvt;
import progress.message.broker.RMInboundEvt;
import progress.message.broker.RMOutboundEndEvt;
import progress.message.broker.RMOutboundEvt;
import progress.message.broker.SyncRMInboundEvt;
import progress.message.broker.SyncRMOutboundEvt;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.Message;

public class RMManager
extends DebugObject {
    public static final short VERSION = 0;
    ArrayList m_rmSequences = null;
    private Hashtable m_createOperations = new Hashtable();
    private Hashtable m_pendingSequencedData = new Hashtable();
    private Hashtable m_rmIdToSendSequences = new Hashtable();
    private Hashtable m_rmIdToReceiveSequences = new Hashtable();
    private Hashtable m_createSequenceMidToReceiveSequences = new Hashtable();
    ArrayList m_dispatchThreads = null;
    int m_rmIndex = 0;
    SequenceMonitorThread m_monitor = null;
    private int m_dispatchThreadId;
    private int m_configMaxPoolSize = Config.WS_RM_SEQUENCE_CONTROL_THREADS;
    private int m_currentPoolSize;
    private RMClusteringHelper m_clusteringHelper;
    public static long BROKER_ID = AddrUtil.stringToClientId(Config.BROKER_NAME, "Broker");

    public RMManager() {
        super("RMManager");
        this.m_rmSequences = new ArrayList(10);
        if (Config.ENABLE_INTERBROKER) {
            this.m_clusteringHelper = new RMClusteringHelper(this);
        }
    }

    public static RMManager getRMManager() {
        return AgentRegistrar.getAgentRegistrar().getReliableSequenceMgr();
    }

    public static String getBrokerIDAsString() {
        return Long.toString(BROKER_ID);
    }

    public void start() {
        this.m_configMaxPoolSize = Config.WS_RM_SEQUENCE_CONTROL_THREADS;
        this.m_dispatchThreads = new ArrayList(this.m_configMaxPoolSize);
        for (int ii = 0; ii < this.m_configMaxPoolSize; ++ii) {
            this.createNewDispatchThread();
        }
        this.m_monitor = new SequenceMonitorThread();
        this.m_monitor.start();
        if (this.m_clusteringHelper != null) {
            try {
                this.m_clusteringHelper.subscribePropagationSubjects();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void reset() {
        this.m_createOperations = new Hashtable();
        this.m_pendingSequencedData = new Hashtable();
        this.m_rmIdToSendSequences = new Hashtable();
        this.m_rmIdToReceiveSequences = new Hashtable();
        this.m_createSequenceMidToReceiveSequences = new Hashtable();
    }

    public void setupAdminHandlers() throws IOException {
        if (this.m_clusteringHelper != null) {
            this.m_clusteringHelper.setupPropagationHandlers();
        }
    }

    public void stopThreads() {
        for (RMDispatchThread dispatchThread : this.m_dispatchThreads) {
            if (dispatchThread == null || !dispatchThread.isAlive()) continue;
            dispatchThread.shutdown();
        }
        this.m_monitor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigMaxPoolSize(int newSize) {
        ArrayList arrayList = this.m_rmSequences;
        synchronized (arrayList) {
            if (this.m_configMaxPoolSize == newSize) {
                return;
            }
            if (this.m_configMaxPoolSize < newSize) {
                for (int ii = 0; ii < newSize - this.m_configMaxPoolSize; ++ii) {
                    this.createNewDispatchThread();
                }
            } else {
                this.m_rmSequences.notifyAll();
            }
            this.m_configMaxPoolSize = newSize;
        }
    }

    public void clearPendingSequencedData(String seqId) {
        Hashtable ht = (Hashtable)this.m_pendingSequencedData.remove(seqId);
        if (ht != null) {
            Hashtable<String, String> errorInfo = new Hashtable<String, String>();
            int dmqReason = 10;
            String msg = prAccessor.getString("REASON_TERMINATED");
            errorInfo.put("JMS_SonicMQ_undeliveredExplanationText", msg);
            Enumeration en = ht.elements();
            while (en.hasMoreElements()) {
                MessageContext mc;
                SequencedDataContext sdc = (SequencedDataContext)en.nextElement();
                if (sdc.isResend() || (mc = sdc.getContext()) == null) continue;
                IMgram m = (IMgram)mc.getProperty("progress.message.msg.IMgram");
                if (m == null) {
                    m = (IMgram)mc.getProperty("COM_SONIC_RESPONSEMGRAM");
                }
                if (m == null) continue;
                try {
                    AgentRegistrar.getAgentRegistrar().getQueueProc().processUndelivered(m, dmqReason, true, errorInfo);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingSequencedData(SequenceCapsule cap) {
        Hashtable hashtable = this.m_pendingSequencedData;
        synchronized (hashtable) {
            Hashtable ht = (Hashtable)this.m_pendingSequencedData.get(cap.getId());
            if (ht == null) {
                return;
            }
            ht.remove(cap.getNr());
            if (ht.isEmpty()) {
                this.m_pendingSequencedData.remove(cap.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequencedDataContext getPendingSequencedData(SequenceCapsule cap) {
        Hashtable hashtable = this.m_pendingSequencedData;
        synchronized (hashtable) {
            Hashtable ht = (Hashtable)this.m_pendingSequencedData.get(cap.getId());
            if (ht == null) {
                return null;
            }
            return (SequencedDataContext)ht.get(cap.getNr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequencedDataContext getAndClearPendingSequencedData(SequenceCapsule cap) {
        Hashtable hashtable = this.m_pendingSequencedData;
        synchronized (hashtable) {
            SequencedDataContext result = null;
            Hashtable ht = (Hashtable)this.m_pendingSequencedData.get(cap.getId());
            if (ht == null) {
                return result;
            }
            result = (SequencedDataContext)ht.get(cap.getNr());
            if (result != null) {
                ht.remove(cap.getNr());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingSequencedData(SequencedDataContext ctx) {
        Hashtable hashtable = this.m_pendingSequencedData;
        synchronized (hashtable) {
            SequenceCapsule cap = ctx.getCapsule();
            Hashtable<Long, SequencedDataContext> ht = (Hashtable<Long, SequencedDataContext>)this.m_pendingSequencedData.get(cap.getId());
            if (ht == null) {
                ht = new Hashtable<Long, SequencedDataContext>();
            }
            ht.put(cap.getNr(), ctx);
            this.m_pendingSequencedData.put(cap.getId(), ht);
        }
    }

    public void removeCreateOperationContext(String seq) {
        this.m_createOperations.remove(seq);
    }

    public CreateOperationContext getCreateOperationContext(String seq) {
        return (CreateOperationContext)this.m_createOperations.get(seq);
    }

    public void addCreateOperationContext(CreateOperationContext cap) {
        this.m_createOperations.put(cap.m_msgId, cap);
    }

    public RMReceiveSequence getRMReceiveSequenceSupport(String seq) {
        if (seq == null) {
            return null;
        }
        return (RMReceiveSequence)this.m_rmIdToReceiveSequences.get(seq);
    }

    public RMSendSequence getRMSendSequenceSupport(String seq) {
        if (seq == null) {
            return null;
        }
        return (RMSendSequence)this.m_rmIdToSendSequences.get(seq);
    }

    public RMReceiveSequence getRMReceiveSequenceSupportByRequestMid(EndpointReference replyTo, MessageID mid) {
        return (RMReceiveSequence)this.m_createSequenceMidToReceiveSequences.get(this.stringifyRequestMid(replyTo, mid));
    }

    private String stringifyRequestMid(EndpointReference replyTo, MessageID mid) {
        return replyTo.getAddress().toString() + ":" + mid.toString();
    }

    public void addRMSequenceSupport(RMSequenceSupport seq) {
        this.addRMSequenceSupport(seq, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRMSequenceSupport(RMSequenceSupport seq, boolean log, boolean requestDispatch) {
        ArrayList arrayList = this.m_rmSequences;
        synchronized (arrayList) {
            RMReceiveSequence rrs = null;
            RMSendSequence rss = null;
            if (seq.isOutbound()) {
                rss = (RMSendSequence)seq;
                this.m_rmIdToSendSequences.put(seq.getSequenceState().getSequenceIdentifier().getIdentifier(), seq);
            } else {
                rrs = (RMReceiveSequence)seq;
                this.m_rmIdToReceiveSequences.put(rrs.getSequenceState().getSequenceIdentifier().getIdentifier(), rrs);
                if (rrs.getRequestMessageID() != null) {
                    String key = this.stringifyRequestMid(rrs.getRequestReplyTo(), rrs.getRequestMessageID());
                    this.m_createSequenceMidToReceiveSequences.put(key, seq);
                }
            }
            if (log) {
                try {
                    if (rrs != null) {
                        this.logBegin(rrs);
                    } else if (rss != null) {
                        this.logBegin(rss);
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            this.m_rmSequences.add(seq);
            if (requestDispatch) {
                this.requestDispatch();
            }
        }
    }

    public void removeRMSequenceSupport(RMSequenceSupport seq) {
        this.removeRMSequenceSupport(seq, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRMSequenceSupport(RMSequenceSupport seq, boolean log) {
        RMReceiveSequence rrs = null;
        RMSendSequence rss = null;
        if (seq == null) {
            return;
        }
        ArrayList arrayList = this.m_rmSequences;
        synchronized (arrayList) {
            if (seq.isOutbound()) {
                rss = (RMSendSequence)seq;
                String id = seq.getSequenceState().getSequenceIdentifier().getIdentifier();
                this.clearPendingSequencedData(id);
                this.m_rmIdToSendSequences.remove(id);
            } else {
                this.m_rmIdToReceiveSequences.remove(seq.getSequenceState().getSequenceIdentifier().getIdentifier());
                rrs = (RMReceiveSequence)seq;
                if (rrs.getRequestMessageID() != null) {
                    String key = this.stringifyRequestMid(rrs.getRequestReplyTo(), rrs.getRequestMessageID());
                    this.m_createSequenceMidToReceiveSequences.remove(key);
                }
            }
            if (log) {
                if (rrs != null) {
                    this.logEnd(rrs);
                } else if (rss != null) {
                    this.logEnd(rss);
                }
            }
            this.m_rmSequences.remove(seq);
        }
    }

    public void cancelReliableSequence(String id) {
        this.cancelReliableSendSequence(id);
        this.cancelReliableReceiveSequence(id);
    }

    public void cancelReliableSendSequence(String id) {
        RMSendSequence sseq = (RMSendSequence)this.m_rmIdToSendSequences.get(id);
        this.terminateAndRemoveRMSequenceSupport(sseq, id);
    }

    public void cancelReliableReceiveSequence(String id) {
        RMReceiveSequence rseq = (RMReceiveSequence)this.m_rmIdToReceiveSequences.get(id);
        this.terminateAndRemoveRMSequenceSupport(rseq, id);
    }

    private void terminateAndRemoveRMSequenceSupport(RMSequenceSupport rseq, String id) {
        if (rseq != null) {
            rseq.markForTermination(null);
            rseq.faultSequence(SequenceFault.makeSequenceTerminatedFault(rseq.getConstants(), id));
            this.removeRMSequenceSupport(rseq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getReliableReceiveSequences() {
        ArrayList<IReliableSequenceData> al = new ArrayList<IReliableSequenceData>();
        Hashtable hashtable = this.m_rmIdToReceiveSequences;
        synchronized (hashtable) {
            Enumeration entries = this.m_rmIdToReceiveSequences.elements();
            while (entries.hasMoreElements()) {
                RMReceiveSequence rrs = (RMReceiveSequence)entries.nextElement();
                IReliableSequenceData rsd = RuntimeDataFactory.createReliableSequenceData(rrs.getId(), rrs.getSequenceState().getPendingReorderCount());
                al.add(rsd);
            }
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getReliableSendSequences() {
        ArrayList<IReliableSequenceData> al = new ArrayList<IReliableSequenceData>();
        Hashtable hashtable = this.m_rmIdToSendSequences;
        synchronized (hashtable) {
            Enumeration entries = this.m_rmIdToSendSequences.elements();
            while (entries.hasMoreElements()) {
                RMSendSequence rss = (RMSendSequence)entries.nextElement();
                long unacks = 0L;
                SortedMap sm = rss.getSequenceState().getMessageList();
                Collection se = sm.values();
                SortedMap sortedMap = sm;
                synchronized (sortedMap) {
                    for (ReliableMessageWrapper rmc : se) {
                        if (rmc.getAcknowledged()) continue;
                        ++unacks;
                    }
                }
                IReliableSequenceData rsd = RuntimeDataFactory.createReliableSequenceData(rss.getId(), unacks);
                al.add(rsd);
            }
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RMSequenceSupport selectSequenceForDispatch(RMDispatchThread dispatchThread) throws InterruptedException {
        RMSequenceSupport result = null;
        ArrayList arrayList = this.m_rmSequences;
        synchronized (arrayList) {
            Thread.currentThread();
            while (!Thread.interrupted() && !dispatchThread.isShuttingDown() && this.m_currentPoolSize <= this.m_configMaxPoolSize) {
                int limit = this.m_rmSequences.size();
                result = null;
                for (int count = 0; count < limit; ++count) {
                    if (this.m_rmIndex >= limit) {
                        this.m_rmIndex = 0;
                    }
                    if (!(result = (RMSequenceSupport)this.m_rmSequences.get(this.m_rmIndex++)).isDispatching() && !result.isQuiet()) break;
                    result = null;
                }
                if (result != null) {
                    result.setDispatchThread(dispatchThread);
                    break;
                }
                if (this.DEBUG) {
                    this.debug("Waiting for work ..");
                }
                this.m_rmSequences.wait();
            }
            if (dispatchThread.isShuttingDown() || this.m_currentPoolSize > this.m_configMaxPoolSize) {
                return null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDispatch() {
        ArrayList arrayList = this.m_rmSequences;
        synchronized (arrayList) {
            this.m_rmSequences.notifyAll();
        }
    }

    private void createNewDispatchThread() {
        RMDispatchThread newThread = new RMDispatchThread(++this.m_dispatchThreadId);
        ++this.m_currentPoolSize;
        this.m_dispatchThreads.add(newThread);
        newThread.start();
    }

    public void redoSync(SyncRMOutboundEvt roe) {
        this.redoBegin(roe);
    }

    public void redoSync(SyncRMInboundEvt rie) {
        RMReceiveSequence ss = this.getRMReceiveSequenceSupport(rie.getSequenceIdentifier());
        if (ss == null) {
            this.redoBegin(rie);
            ss = this.getRMReceiveSequenceSupport(rie.getSequenceIdentifier());
            for (Long L : rie.getMessageList()) {
                long l = L;
                if (l > ss.getSequenceState().getMaxReceivedMessageNumber()) {
                    ss.getSequenceState().setMaxReceivedMessageNumber(l);
                }
                ss.getSequenceState().getMessageList().put(L, "COMMITED");
            }
            ss.getSequenceState().setDesignatedLastMessageNumber(rie.getDesignatedLastMessageNumber());
        }
    }

    public void redoEnd(RMOutboundEndEvt roe) {
        RMSendSequence ss = this.getRMSendSequenceSupport(roe.getSequenceIdentifier());
        this.removeRMSequenceSupportCheckingNull(ss);
    }

    public void redoEnd(RMInboundEndEvt rie) {
        RMReceiveSequence ss = this.getRMReceiveSequenceSupport(rie.getSequenceIdentifier());
        this.removeRMSequenceSupportCheckingNull(ss);
    }

    private void removeRMSequenceSupportCheckingNull(RMSequenceSupport ss) {
        if (ss != null) {
            this.removeRMSequenceSupport(ss, false);
        }
    }

    public void redoBegin(RMOutboundEvt roe) {
        RMSendSequence support = new RMSendSequence();
        RMSequence se = new RMSequence();
        Constants RMConstants = Constants.FEB2005_CONSTANTS;
        if (roe.getRMConstantsURI() != null && roe.getRMConstantsURI().equalsIgnoreCase(Constants.MAR2004_CONSTANTS.getNSURI())) {
            RMConstants = Constants.MAR2004_CONSTANTS;
        }
        SOAP11Constants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
        if (roe.getSoapConstantsURI() != null && roe.getSoapConstantsURI().equalsIgnoreCase(SOAPConstants.SOAP12_CONSTANTS.getEnvelopeURI())) {
            soapConstants = SOAPConstants.SOAP12_CONSTANTS;
        }
        Identifier ide = new Identifier(RMConstants);
        ide.setIdentifier(roe.getSequenceIdentifier());
        se.setSequenceIdentifier(ide);
        se.setEndpointReference(roe.getEndpointReference());
        se.setInternalFaultDestination(roe.getInternalFaultDestination());
        se.setRMConstants(RMConstants);
        RMPolicy p = roe.getPolicy();
        se.setPolicy(p);
        se.setExpires(roe.getExpires());
        support.changeState(new EstablishedSendState());
        support.setSOAPConstants((SOAPConstants)soapConstants);
        support.setWSANS(roe.getWSANS());
        support.setSequenceState(se);
        support.setConstants(RMConstants);
        support.setLocallyHomed(true);
        this.addRMSequenceSupport(support, false, false);
    }

    public void redoBegin(RMInboundEvt rie) {
        ArrayList ml;
        RMReceiveSequence support = new RMReceiveSequence();
        RMSequence se = new RMSequence();
        Constants RMConstants = Constants.FEB2005_CONSTANTS;
        if (rie.getRMConstantsURI() != null && rie.getRMConstantsURI().equalsIgnoreCase(Constants.MAR2004_CONSTANTS.getNSURI())) {
            RMConstants = Constants.MAR2004_CONSTANTS;
        }
        SOAP11Constants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
        if (rie.getSoapConstantsURI() != null && rie.getSoapConstantsURI().equalsIgnoreCase(SOAPConstants.SOAP12_CONSTANTS.getEnvelopeURI())) {
            soapConstants = SOAPConstants.SOAP12_CONSTANTS;
        }
        Identifier ide = new Identifier(RMConstants);
        ide.setIdentifier(rie.getSequenceIdentifier());
        se.setSequenceIdentifier(ide);
        se.setReturnSequenceIdentifier(rie.getReturnSequenceIdentifier());
        RMPolicy p = rie.getPolicy();
        se.setPolicy(p);
        se.setRMConstants(RMConstants);
        se.setEndpointReference(rie.getEndpointReference());
        se.setExpires(rie.getExpires());
        EndpointReference a2epr = rie.getAcksTo();
        if (a2epr != null) {
            AcksTo a2 = new AcksTo(RMConstants);
            a2.setAddress(a2epr);
            se.setAcksTo(a2);
        }
        if ((ml = rie.getMessageList()) != null) {
            for (Long L : ml) {
                long l = L;
                boolean last = l == rie.getDesignatedLastMessageNumber();
                se.insertReceivedMessage(l, last);
                se.commitReceivedMessage(l, last);
            }
        }
        support.changeState(new EstablishedReceiveState());
        support.setSequenceState(se);
        support.setConstants(RMConstants);
        support.setSOAPConstants((SOAPConstants)soapConstants);
        support.setWSANS(rie.getWSANS());
        se.getReorderBuffer().setConditionListener(support);
        try {
            if (rie.getRequestMid() != null) {
                support.setRequestMessageID(new MessageID(new URI(rie.getRequestMid())));
            }
            if (rie.getRequestReplyTo() != null) {
                support.setRequestReplyTo(new EndpointReference((EndpointReferenceType)rie.getRequestReplyTo()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addRMSequenceSupport(support, false, false);
    }

    protected void logBegin(RMReceiveSequence support) throws InterruptedException {
        LogManager logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        RMInboundEvt rie = new RMInboundEvt(support);
        logMgr.addEvent(rie, true);
        logMgr.waitForFlush(rie);
    }

    protected void logEnd(RMReceiveSequence support) {
        LogManager logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        RMInboundEndEvt rie = new RMInboundEndEvt(support);
        logMgr.addEvent(rie, true);
    }

    protected void logBegin(RMSendSequence support) throws InterruptedException {
        LogManager logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        RMOutboundEvt roe = new RMOutboundEvt(support);
        logMgr.addEvent(roe, true);
        logMgr.waitForFlush(roe);
    }

    protected void logEnd(RMSendSequence support) {
        LogManager logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        RMOutboundEndEvt roe = new RMOutboundEndEvt(support);
        logMgr.addEvent(roe, true);
    }

    public void onRecoveredMsg(IMgram m) {
        if (m == null) {
            return;
        }
        try {
            ISidebandData sideband = null;
            sideband = m.getSidebandDataReadOnly();
            if (sideband == null) {
                return;
            }
            String gid = (String)sideband.getProperty("JMSXGroupID");
            Integer gnr = (Integer)sideband.getProperty("JMSXGroupSeq");
            Boolean last = (Boolean)sideband.getProperty("JMS_SonicMQ_lastMessageInGroup");
            if (gid == null || gnr == null) {
                return;
            }
            if (last == null) {
                last = Boolean.FALSE;
            }
            SequenceCapsule capsule = new SequenceCapsule(gid, new Long(gnr.longValue()), last);
            RMReceiveSequence rss = this.getRMReceiveSequenceSupport(gid);
            if (rss != null) {
                rss.getSequenceState().commitReceivedMessage(capsule);
            }
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage("Failure in RMManager:" + ex, (Throwable)ex, BrokerComponent.getLevelWarning().intValue());
        }
    }

    public void onRecoveredGuarMsg(IMgram m) {
        this.onRecoveredMsg(m);
    }

    public void onRecoveredGuarQMsg(IMgram m) {
        this.onRecoveredMsg(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSyncRecords() {
        LogManager logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        ArrayList arrayList = this.m_rmSequences;
        synchronized (arrayList) {
            for (RMSequenceSupport rss : this.m_rmSequences) {
                LogEvent synce;
                if (!rss.isOutbound()) {
                    synce = new SyncRMInboundEvt((RMReceiveSequence)rss);
                    logMgr.addEvent(synce, false);
                    continue;
                }
                if (!rss.isLocallyHomed()) continue;
                synce = new SyncRMOutboundEvt((RMSendSequence)rss);
                logMgr.addEvent(synce, false);
            }
        }
    }

    public void onAckReceived(SequenceAcknowledgement sa) {
        if (this.m_clusteringHelper == null) {
            return;
        }
        Message m = new Message();
        try {
            m.writeShort(0);
            m.writeUTF(Config.BROKER_NAME);
            m.writeUTF(sa.getIdentifier().getIdentifier());
            SOAPEnvelope envelopToSend = new SOAPEnvelope((SOAPConstants)SOAPConstants.SOAP12_CONSTANTS);
            sa.toSOAPEnvelope(envelopToSend);
            org.apache.axis.Message axisMsg = new org.apache.axis.Message((Object)envelopToSend);
            RMClusteringHelper.soapToSonicMessage(axisMsg, m);
            this.m_clusteringHelper.broadcast(1, m);
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage("Failure in RMManager:" + ex, (Throwable)ex, BrokerComponent.getLevelWarning().intValue());
        }
    }

    public boolean onMsgReceived(String nodeSuffix, String seqId, org.apache.axis.Message request) {
        if (this.m_clusteringHelper == null) {
            return false;
        }
        long brokerId = 0L;
        try {
            brokerId = Long.parseLong(nodeSuffix);
            if (!this.m_clusteringHelper.isNeighbor(brokerId)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        try {
            MessageContext mc = request.getMessageContext();
            WSHttpInRequest ireq = (WSHttpInRequest)mc.getProperty("com.sonicsw.net.http.HttpInRequest");
            HttpClientContext hctx = (HttpClientContext)mc.getProperty("com.sonicsw.net.http.HttpClientContext");
            Message m = new Message();
            String s = null;
            RMManager.startWriting(m, seqId);
            HttpServletRequest hr = ireq.getRequest();
            m.writeUTF(hr.getRequestURL().toString());
            m.writeUTF(hr.getRequestURI());
            m.writeInt(hr.getContentLength());
            s = hr.getCharacterEncoding();
            m.writeUTF(s != null ? s : "");
            s = hr.getContentType();
            m.writeUTF(s != null ? s : "");
            s = hr.getMethod();
            m.writeUTF(s != null ? s : "");
            s = hr.getHeader("SOAPAction");
            m.writeUTF(s != null ? s : "");
            WSHttpProtocolHandler.writePropertySetToStream(WSHttpProtocolHandler.getJMSPropertySetFromHTTPFields(hr), m);
            hctx.getCSC().writeToStream(m, (short)-1);
            RMClusteringHelper.soapToSonicMessage(request, m);
            this.m_clusteringHelper.forward(brokerId, m);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public void onSequenceTermination(String seqId) {
        if (this.m_clusteringHelper == null) {
            return;
        }
        Message m = new Message();
        try {
            RMManager.startWriting(m, seqId);
            this.m_clusteringHelper.broadcast(2, m);
        }
        catch (IOException ex) {
            BrokerComponent.getComponentContext().logMessage("Failure in RMManager:" + ex, (Throwable)ex, BrokerComponent.getLevelWarning().intValue());
        }
    }

    public void onSequenceFault(String seqId, org.apache.axis.Message flt) {
        if (this.m_clusteringHelper == null) {
            return;
        }
        Message m = new Message();
        try {
            RMManager.startWriting(m, seqId);
            RMClusteringHelper.soapToSonicMessage(flt, m);
            this.m_clusteringHelper.broadcast(3, m);
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage("Failure in RMManager:" + ex, (Throwable)ex, BrokerComponent.getLevelWarning().intValue());
        }
    }

    public void onSequenceFault(String seqId) {
        if (this.m_clusteringHelper == null) {
            return;
        }
        Message m = new Message();
        try {
            RMManager.startWriting(m, seqId);
            this.m_clusteringHelper.broadcast(3, m);
        }
        catch (IOException ex) {
            BrokerComponent.getComponentContext().logMessage("Failure in RMManager:" + ex, (Throwable)ex, BrokerComponent.getLevelWarning().intValue());
        }
    }

    private static void startWriting(Message m, String seqId) throws IOException {
        m.writeShort(0);
        m.writeUTF(Config.BROKER_NAME);
        m.writeUTF(seqId);
    }

    class RMDispatchThread
    extends DebugThread
    implements TimedUrlConnection.ITimedUrlConnectionUserHandle {
        private int m_threadId;
        private RMSequenceSupport m_rmSequence;
        private TimedUrlConnection.ResponseInfoThread m_responseThread;

        @Override
        public TimedUrlConnection.ResponseInfoThread getResponseThread() {
            return this.m_responseThread;
        }

        @Override
        public void setResponseThread(TimedUrlConnection.ResponseInfoThread responseThread) {
            this.m_responseThread = responseThread;
        }

        @Override
        public int getThreadId() {
            return this.m_threadId;
        }

        public RMDispatchThread(int threadId) {
            super("RMDispatchThread " + threadId);
            this.m_rmSequence = null;
            this.m_responseThread = null;
            this.m_threadId = threadId;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            if (this.DEBUG) {
                this.debug("Starting");
            }
            try {
                while (!Thread.currentThread().isInterrupted() && !this.isShuttingDown()) {
                    ArrayList arrayList = RMManager.this.m_rmSequences;
                    synchronized (arrayList) {
                        RMDispatchThread rMDispatchThread = this;
                        synchronized (rMDispatchThread) {
                            if (this.m_rmSequence != null) {
                                this.m_rmSequence.setDispatchThread(null);
                                this.m_rmSequence = null;
                            }
                        }
                        RMSequenceSupport newSequence = RMManager.this.selectSequenceForDispatch(this);
                        if (newSequence == null) {
                            if (this.DEBUG) {
                                this.debug("Exiting - too many dispatch threads");
                            }
                            break;
                        }
                        rMDispatchThread = this;
                        synchronized (rMDispatchThread) {
                            this.m_rmSequence = newSequence;
                        }
                    }
                    this.dispatch(1);
                }
            }
            catch (InterruptedException ie) {
                if (this.DEBUG) {
                    this.debug("Returning after interrupt");
                }
                return;
            }
            finally {
                ArrayList arrayList = RMManager.this.m_rmSequences;
                synchronized (arrayList) {
                    --RMManager.this.m_currentPoolSize;
                }
                if (this.m_responseThread != null) {
                    this.m_responseThread.cancel();
                }
            }
        }

        private void dispatch(int numMessages) throws InterruptedException {
            RMEvent evt = null;
            int ii = 0;
            while ((evt = this.m_rmSequence.dequeueAndNotify()) != null) {
                evt.execute();
                ++ii;
            }
        }
    }
}

