/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.action.Encryption;
import com.sonicsw.ws.security.policy.Assertion;
import com.sonicsw.ws.security.policy.MessageParts;
import com.sonicsw.ws.security.policy.SSPConstants;
import com.sonicsw.ws.security.policy.SecurityTokenAssertion;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.ws.security.policy.XDSIGConstants;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wsp.WSPUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.xmlsoap.schemas.ws.x2002.x12.secext.AlgorithmType;
import org.xmlsoap.schemas.ws.x2002.x12.secext.Confidentiality;
import org.xmlsoap.schemas.ws.x2002.x12.secext.KeyInfoType;
import org.xmlsoap.schemas.ws.x2002.x12.secext.SecurityTokenType;
import org.xmlsoap.schemas.ws.x2002.x12.secext.XPathSoap;

public class ConfidentialityAssertion
extends Assertion {
    private Encryption m_encryption = new Encryption();

    @Override
    public final int getType() {
        return CONFIDENTIALITY_ASSERTION;
    }

    @Override
    public Object getAction() {
        return this.m_encryption;
    }

    public String getX509TokenRefURI() {
        return this.m_encryption.getX509TokenRefURI();
    }

    public void setX509TokenRefURI(String X509TokenRefURI) {
        this.m_encryption.setX509TokenRefURI(X509TokenRefURI);
    }

    public String getX509TokenRefIssuer() {
        return this.m_encryption.getX509TokenRefIssuer();
    }

    public void setX509TokenRefIssuer(String X509TokenRefIssuer) {
        this.m_encryption.setX509TokenRefIssuer(X509TokenRefIssuer);
    }

    public String getX509TokenRefSerialNumber() {
        return this.m_encryption.getX509TokenRefSerialNumber();
    }

    public void setX509TokenRefSerialNumber(String X509TokenRefSerialNumber) {
        this.m_encryption.setX509TokenRefSerialNumber(X509TokenRefSerialNumber);
    }

    public String getSubjectKeyIdentifier() {
        return this.m_encryption.getSubjectKeyIdentifier();
    }

    public void setSubjectKeyIdentifier(String ski) {
        this.m_encryption.setSubjectKeyIdentifier(ski);
    }

    public QName getX509TokenRef() {
        return this.m_encryption.getX509TokenRef();
    }

    public void setX509TokenRef(QName X509TokenRef) {
        this.m_encryption.setX509TokenRef(X509TokenRef);
    }

    public String getEncryptionAlgorithm() {
        return this.m_encryption.getEncryptionAlgorithm();
    }

    public final void setEncryptionAlgorithm(String alg) {
        this.m_encryption.setEncryptionAlgorithm(alg);
    }

    public String getAlgEncryption() {
        return this.m_encryption.getAlgEncryption();
    }

    public void setAlgEncryption(String algEncryption) {
        this.m_encryption.setAlgEncryption(algEncryption);
    }

    public List getKeyList() {
        return this.m_encryption.getKeyList();
    }

    public void setKeyList(List keyList) {
        this.m_encryption.setKeyList(keyList);
    }

    public String getPassword() {
        return this.m_encryption.getPassword();
    }

    public final void setPassword(String password) {
        this.m_encryption.setPassword(password);
    }

    public ConfidentialityAssertion() {
    }

    public ConfidentialityAssertion(String soapEnvNSUri, Confidentiality confidentialityBean) throws PolicyException {
        this.initConfidentialityAssertion(soapEnvNSUri, confidentialityBean);
    }

    private void initConfidentialityAssertion(String soapEnvNSUri, Confidentiality confidentialityBean) throws PolicyException {
        int i;
        XmlObject[] algorithmBeans = confidentialityBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_ALGORITHM));
        for (int i2 = 0; i2 < algorithmBeans.length; ++i2) {
            AlgorithmType algorithm = (AlgorithmType)algorithmBeans[i2];
            QName type = algorithm.getType();
            String algURI = algorithm.getURI();
            if (!type.equals(WSSPConstants.QN_ALGTYPE_ENCRYPTION)) continue;
            this.setEncryptionAlgorithm(algURI);
            DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_ALGTYPE_ENCRYPTION, Alg: " + algURI);
        }
        XmlObject[] keys = confidentialityBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_KEY_INFO));
        KeyInfoType keyInfoBean = (KeyInfoType)keys[0];
        if (keyInfoBean != null) {
            XmlObject[] tokens = keyInfoBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_SECURITY_TOKEN));
            ArrayList<SecurityTokenAssertion> keyList = new ArrayList<SecurityTokenAssertion>(3);
            for (i = 0; i < tokens.length; ++i) {
                XmlObject[] SKIBeans;
                SecurityTokenType tokenBean = (SecurityTokenType)tokens[i];
                SecurityTokenAssertion sta = new SecurityTokenAssertion((XmlObject)tokenBean);
                keyList.add(sta);
                if (sta.getTokenType().equals(WSSPConstants.QN_TOKENTYPE_USERNAME)) {
                    XmlObject[] passwordBeans = tokenBean.selectPath(WSPUtils.childElementXPath(SSPConstants.QN_PASSWORD));
                    if (passwordBeans == null || passwordBeans.length <= 0) continue;
                    XmlObject passwordBean = passwordBeans[0];
                    this.setPassword(ConfidentialityAssertion.getTextContent(passwordBean));
                    DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_TOKENTYPE_USERNAME, password: " + this.getPassword());
                    continue;
                }
                if (!sta.getTokenType().equals(WSSPConstants.QN_TOKENTYPE_X509V3)) continue;
                XmlObject[] issuerSerialBeans = tokenBean.selectPath(WSPUtils.childElementXPath(XDSIGConstants.QN_X509_ISSUER_SERIAL));
                if (issuerSerialBeans != null && issuerSerialBeans.length > 0) {
                    XmlObject[] serialNumberBeans;
                    XmlObject issuerSerialBean = issuerSerialBeans[0];
                    XmlObject[] issuerNameBeans = issuerSerialBean.selectPath(WSPUtils.childElementXPath(XDSIGConstants.QN_X509_ISSUER_NAME));
                    if (issuerNameBeans != null && issuerNameBeans.length > 0) {
                        this.setX509TokenRefIssuer(ConfidentialityAssertion.getTextContent(issuerNameBeans[0]));
                        DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_TOKENTYPE_X509V3, X509TokenRefIssuer: " + this.getX509TokenRefIssuer());
                    }
                    if ((serialNumberBeans = issuerSerialBean.selectPath(WSPUtils.childElementXPath(XDSIGConstants.QN_X509_SERIAL_NUMBER))) != null && serialNumberBeans.length > 0) {
                        this.setX509TokenRefSerialNumber(ConfidentialityAssertion.getTextContent(serialNumberBeans[0]));
                        DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_TOKENTYPE_X509V3, X509TokenRefSerialNumber: " + this.getX509TokenRefSerialNumber());
                    }
                }
                this.setX509TokenRef(sta.getX509TokenRef());
                if (this.getX509TokenRef() == null || !this.getX509TokenRef().equals(SSPConstants.QN_TOKEN_REF_MODEL_KEYIDENTIFIER) || (SKIBeans = tokenBean.selectPath(WSPUtils.childElementXPath(SSPConstants.QN_KEYIDENTIFIER))) == null || SKIBeans.length <= 0) continue;
                XmlObject SKIBean = SKIBeans[0];
                this.setSubjectKeyIdentifier(ConfidentialityAssertion.getTextContent(SKIBean));
            }
            this.setKeyList(keyList);
        }
        DebugObjects.getPolicyDebug().debug("type: WSSPConstants.QN_MESSAGE_PARTS");
        XmlObject[] messagePartsBeans = confidentialityBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_MESSAGE_PARTS));
        ArrayList<MessageParts> partList = new ArrayList<MessageParts>(3);
        for (i = 0; i < messagePartsBeans.length; ++i) {
            XPathSoap messagePartsBean = (XPathSoap)messagePartsBeans[i];
            String dialect = messagePartsBean.getDialect();
            List signer = messagePartsBean.getSigner();
            Map namespaceMap = ConfidentialityAssertion.getInScopeNamespaces((XmlObject)messagePartsBean);
            String expression = ConfidentialityAssertion.getTextContent((XmlObject)messagePartsBean);
            MessageParts part = new MessageParts(dialect, namespaceMap, expression, signer, soapEnvNSUri);
            DebugObjects.getPolicyDebug().debug("part #" + (i + 1) + ": " + (part == null ? "null" : part.toString()));
            partList.add(part);
        }
        this.m_encryption.addParts(partList);
    }

    private static Map getInScopeNamespaces(XmlObject xobj) {
        XmlCursor c = xobj.newCursor();
        TreeMap m = new TreeMap();
        c.getAllNamespaces(m);
        c.dispose();
        return m;
    }

    private static String getTextContent(XmlObject xobj) {
        XmlCursor c = xobj.newCursor();
        c.toFirstChild();
        return c.getTextValue();
    }

    public String toString() {
        String NEWLINE = "\n";
        StringBuffer buf = new StringBuffer();
        buf.append("-----------------------------------------------------------\n");
        buf.append("Assertion: Confidentiality").append("\n");
        buf.append("/Confidentiality/Algorithm/@Encryption : ").append(this.getEncryptionAlgorithm()).append("\n");
        buf.append("/Confidentiality/ds:X509IssuerSerial/ds:X509IssuerName : ").append(this.getX509TokenRefIssuer()).append("\n");
        buf.append("/Confidentiality/ds:X509IssuerSerial/ds:X509SerialNumber : ").append(this.getX509TokenRefSerialNumber()).append("\n");
        buf.append("Supported Keys: ").append("\n");
        for (SecurityTokenAssertion sta : this.getKeyList()) {
            buf.append(sta.toString());
        }
        buf.append("Message Parts").append("\n");
        buf.append(this.m_encryption.getPartsAsString());
        buf.append("-----------------------------------------------------------\n");
        buf.append("\n");
        return buf.toString();
    }
}

