/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.model.RequiredElements;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class RequiredElementsProcessor {
    private boolean initializedRequiredElements = false;

    private void initializeRequiredElements(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.xPath.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
    }

    public Object doRequiredElements(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                PrimitiveAssertion pa;
                String text;
                if (!this.initializedRequiredElements) {
                    try {
                        this.initializeRequiredElements(spt);
                        RequiredElements elements = (RequiredElements)spc.readCurrentPolicyEngineData();
                        PolicyEngineData parent = spc.readPreviousPolicyEngineData();
                        this.initializedRequiredElements = true;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        return new Boolean(false);
                    }
                }
                if ((text = (pa = spc.getAssertion()).getStrValue()) != null) {
                    text = text.trim();
                    DebugObjects.getPolicyDebug().debug("Value: '" + text.toString() + "'");
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doXPath(SecurityProcessorContext spc) {
        DebugObjects.getPolicyDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        if (spc.getAction() == 1) {
            ((RequiredElements)spc.readCurrentPolicyEngineData()).addXPathExpression(spc.getAssertion().getStrValue());
        }
        return new Boolean(true);
    }
}

