/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.HttpProxyConfig;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.ProvisionMonitor;
import progress.message.broker.interceptor.InterceptorManager;
import progress.message.broker.prAccessor;
import progress.message.net.ssl.ProgressSslSocketFactory;
import progress.message.resources.prMessageFormat;
import progress.message.util.CompressionFactory;
import progress.message.util.DebugState;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.SubjectUtil;

public final class Config {
    static volatile Properties m_properties;
    public static short MAJOR_VERSION;
    public static byte MINOR_VERSION;
    public static final int BUILD_NUMBER = 120;
    public static int SERIAL_NUMBER;
    public static String PRODUCT_NAME;
    public static int PRODUCT_NUMBER;
    public static final String RELEASE;
    public static final String RELEASE_BANNER;
    public static final String COPYRIGHT1;
    public static final String COPYRIGHT2;
    public static final String APP_NAME;
    public static final String UNKNOWN_BROKER_RELEASE = "Release Pre-8.0";
    public static boolean CONFIGURED;
    public static boolean ENABLE_SECURITY;
    public static final String DEFAULT_INI_FILE = "broker.ini";
    public static String INI_FILE;
    public static final String DB_INI_FILE = "db.ini";
    public static volatile String FILE_SEPARATOR;
    public static String CONFIG_CLASS;
    public static boolean ENABLE_INTERBROKER;
    public static boolean ENABLE_ROUTING;
    public static boolean ENABLE_HTTP_DIRECT;
    public static boolean EVALUATION_MODE;
    public static String MAX_CONNECTIONS_PER_USER;
    public static String MAX_CONNECTIONS_PER_USER_WARN_INTERVAL;
    public static boolean ENABLE_REVERSE_DNS_LOOKUP;
    public static long BACKLOGGED_SESSION_SKIP_WARN_INTERVAL;
    public static int BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT;
    public static boolean USE_DYNAMIC_HOST_BINDING;
    public static final String RootSubject = "$SonicMQ-Root-Subject";
    public static int DEFAULT_BROKER_SUBJECT_CACHE;
    public static int MAX_BROKER_SUBJECT_CACHE;
    public static boolean ENABLE_QOPSECURITY;
    public static boolean ENABLE_ACCESS_MEDIATION;
    public static boolean SET_JMSXUSERID;
    public static boolean ENABLE_ACL_CHECK_AT_RESTORE;
    public static String REALM;
    public static boolean PRELOAD_SECURITY_POLICIES;
    public static short DEFAULT_QOP;
    public static boolean USE_DEFAULT_QOP;
    public static boolean DEBUG;
    public static boolean FT_START_ACTIVE;
    public static final int FT_PRIMARY = 0;
    public static final int FT_BACKUP = 1;
    public static int FT_PREFERRED_ACTIVE;
    public static String DUAL_ACTIVE_RESOLUTION;
    public static String DUAL_ACTIVE_RESOLUTION_METRICS_PARAM;
    public static String FT_FAILURE_DETECT_CALLBACK;
    public static boolean FT_REPLICATE_PERSISTENT;
    public static long FT_FAILURE_DETECT_TIMEOUT;
    public static long FT_RETRY_INTERVAL;
    public static long FT_CONNECT_TIMEOUT;
    public static long FT_PING_INTERVAL;
    public static int FT_PING_TIMEOUT;
    public static int FT_PING_TIMEOUT_MIN;
    public static String FT_START_ACTIVE_PROPERTY;
    public static String FT_BIND_HOST_ONLY_PROPERTY;
    public static final int REPLICATION_CHUNK_SIZE_DEFAULT = 102400;
    public static int REPLICATION_CHUNK_SIZE;
    public static boolean REPLICATED;
    public static boolean PRIMARY;
    public static boolean FT_REPLICATE_NON_PERSISTENT;
    public static int PORT;
    public static final int AVG_NO_CLIENTS = 203;
    public static final int AVG_NO_SUBJECTS = 812;
    public static String MCAST_LISTENER;
    public static int BROKER_CONNECT_TIMEOUT;
    public static int BROKER_PING_INTERVAL;
    public static int BROKER_PING_TIMEOUT;
    public static int BROKER_PING_TIMEOUT_MIN;
    public static int CONNECT_PING_TIMEOUT;
    public static int REMOTE_BROKER_CONNECT_TIMEOUT;
    public static int REMOTE_BROKER_MONITOR_TIMEOUT;
    public static int REMOTE_BROKER_MONITOR_INTERVAL;
    public static int CLUSTERED_Q_PREFETCH_COUNT;
    public static int CLUSTERED_Q_PREFETCH_THRESHOLD;
    public static int CLUSTERED_Q_AGGRESSIVE_PREFETCH_THRESHOLD;
    public static final MgramQueueConfig.Metadata RESTART_THRESHOLD_METADATA;
    public static final MgramQueueConfig OUTPUT_QUEUE;
    public static final MgramQueueConfig GUAR_QUEUE;
    public static final MgramQueueConfig WAIT_QUEUE;
    public static int TARGET_MESSAGE_SIZE;
    public static int PS_DB_QUEUE_SIZE;
    public static int REDELIVERY_BATCH_SIZE;
    public static int LOG_QUEUE_SIZE;
    public static int LOG_QUEUE_COUNT;
    public static int LOG_FLUSH_PRIORITY_BOOST;
    public static boolean PRESERVE_NON_DURABLE_WHEN_STOPPED;
    public static final boolean FLOW_TO_DISK_DEFAULT = false;
    public static boolean FLOW_TO_DISK;
    public static final boolean FLOW_TO_DISK_NOTIFY_DEFAULT = true;
    public static boolean FLOW_TO_DISK_NOTIFY;
    public static final boolean FLOW_TO_DISK_DISCARDABLE_DEFAULT = false;
    public static boolean FLOW_TO_DISK_DISCARDABLE;
    public static boolean CHECK_DB_SIZE_ON_PUBLISH;
    public static boolean PTP_GUAR_MSG_BUFFER_LIMIT_CHECK;
    public static int MAX_TOPIC_DB_SIZE;
    public static int TOPIC_DB_SIZE_RESTART_THRESHOLD;
    public static int MAX_FTD_MEMORY_SIZE;
    public static int ACKNOWLEDGE_MONITOR_INTERVAL;
    public static int PENDING_RETRIEVE_THRESHOLD;
    public static int PENDING_SAVE_THRESHOLD;
    public static int PENDING_MAX_QUEUE_SIZE;
    public static int DISCONNECTED_PENDING_RETRIEVE_THRESHOLD;
    public static int DISCONNECTED_PENDING_SAVE_THRESHOLD;
    public static int DISCONNECTED_PENDING_MAX_QUEUE_SIZE;
    public static int FLOW_CONTROLLED_PENDING_RETRIEVE_THRESHOLD;
    public static int FLOW_CONTROLLED_PENDING_SAVE_THRESHOLD;
    public static int FLOW_CONTROLLED_PENDING_MAX_QUEUE_SIZE;
    public static int MAX_ADMINISTRATIVELY_CREATED_QUEUE_SIZE;
    public static int MAX_TEMPORARY_QUEUE_SIZE;
    public static int FLOW_CONTROL_DEFAULT_NOTIFY_SIZE;
    public static int FLOW_CONTROL_NOTIFY_SIZE;
    public static int DFLT_MAX_QMSG_SAVER_ASYNC_CACHE_SIZE;
    public static int MAX_QMSG_SAVER_ASYNC_CACHE_SIZE;
    public static int PTP_DB_QUEUE_SIZE;
    public static int PTP_DB_DELETEOP_SIZE;
    public static int PTP_DB_ASYNC_RETRIEVEOP_SIZE;
    public static boolean PTP_ENABLE_SYNCSIZE_MONITOR;
    public static boolean PTP_REDELIVERED_ON_BROKER_RESTART;
    public static int DELAYED_DELIVERY_INTERVAL;
    public static int DURABLE_SUBSCRIBER_EXPIRATION_POLL_INTERVAL;
    public static int EXP_MSG_CLEAN_POLL_INTERVAL;
    public static int SLOW_SUBSCRIBER_MONITOR_POLL_INTERVAL;
    public static long SLOW_SUBSCRIBER_NOTIFY_THRESHOLD;
    public static final byte AGENT_VER = 32;
    public static final String PKG = "progress.message.broker.";
    public static final String RNI_DLL_FILE = "ohmsbroker";
    public static final String JNI_DLL_FILE = "ohbroker";
    public static final String NETWARE_NLM_FILE = "broker";
    public static final String BROKER_APPID = "Broker";
    public static final int BROKER_APPID_SCODE;
    public static volatile String BROKER_UID;
    public static volatile String BROKER_PWD;
    public static final String BROKER_CONFIG_APPID = "Broker config";
    public static final int BROKER_CONFIG_APPID_SCODE;
    public static String ERROR_MSG_FILES_DIR;
    public static String DEFAULT_LANGUAGE;
    public static String DEFAULT_ERROR_PREFIX;
    public static String DEFAULT_ERROR_CAUSE;
    public static String DEFAULT_ERROR_ACTION;
    public static String DEFAULT_ERROR_TEXT;
    public static String BROKER_LOG;
    public static String LICENSE_KEY;
    public static int DAYS_TILL_WARNING;
    public static volatile String CONTROL_NUMBER;
    public static String PROVISION_SPI_CLASSNAME_DEFAULT;
    public static volatile String PROVISION_SPI_CLASSNAME;
    public static int PROVISION_SPI_INTERVAL_DEFAULT;
    public static int PROVISION_SPI_INTERVAL;
    public static String BROKER_NAME;
    public static final String DATABASE_STORE_TYPE_EMBEDDED;
    public static String DATABASE_STORE_TYPE;
    public static String MQSTORE_DB_CONNECT;
    public static boolean DB_FORCE_SYNC;
    public static int DB_MSG_CLEAN_THRESHOLD;
    public static int EXP_MSG_CLEAN_THRESHOLD;
    public static int DB_COMMIT_BATCH_SIZE;
    public static int DB_CLEANUP_BATCH_SIZE;
    public static boolean THROTTLE_PUBS_DURING_RESTORE;
    public static int RESTORE_MSGS_FC_COUNT;
    public static int RESTORE_MSGS_COUNT;
    public static int QUEUE_DELIVERY_THREADS;
    public static float QUEUE_STOP_FACTOR;
    public static float QUEUE_RESUME_FACTOR;
    public static float DMQ_NOTIFY_FACTOR;
    public static boolean ENABLE_DYNAMIC_QUEUE_CLEANUP;
    public static long QUEUE_CLEANUP_INTERVAL;
    public static byte BROKER_MAX_DELIVERY_COUNT;
    public static final String BROKER_MAX_DELIVERY_COUNT_PROPERTY = "SonicMQ.BROKER_MAX_DELIVERY_COUNT";
    public static boolean ENABLE_WSRM_FLOW_CONTROL_NOTIFICATION;
    public static boolean ENABLE_LOAD_BALANCING;
    public static int LOAD_BALANCING_WEIGHT;
    public static volatile String ROUTING_NODE_NAME;
    public static String DEFAULT_ROUTING_URL;
    public static int CONNECT_RETRY_COUNT;
    public static long CONNECT_RETRY_INTERVAL;
    public static long CONNECT_ATTEMPT_INTERVAL;
    public static boolean ENABLE_GLOBAL_SUBCRIPTIONS_FORWARDING;
    public static long GLOBAL_SUBSCRIPTION_EXPIRATION;
    public static int ROUTING_THREADS;
    public static int HTTP_DIRECT_OUTBOUND_DISPATCH_THREADS;
    public static int HTTP_DIRECT_OUTBOUND_RESERVED_FOR_GROUPED_REQUESTS_THREADS;
    public static String[] ROUTING_EXT_FACTORIES;
    public static String[] ROUTING_EXT_PROPFILES;
    public static String[] CLIENT_CONTEXT_FACTORY;
    public static int CONNECT_IDLE_TIMEOUT;
    public static int RECOVERY_RECONNECT_TIMEOUT;
    public static long CLIENT_RECONNECT_TIMEOUT;
    public static long ACKEXCHANGE_TIMEOUT;
    public static long INDOUBT_TIMEOUT;
    public static long INDOUBT_RECONNECT_INTERVAL;
    public static long ROUTING_TIMEOUT;
    public static boolean DISABLE_ACKEXCHANGE;
    public static boolean DISABLE_QR_RECOVERY;
    public static boolean DISABLE_INDOUBT_RECONNECT;
    public static int CLUSTER_RECONNECT_INTERVAL;
    public static int CLUSTER_CONNECT_TIMEOUT;
    public static int CLUSTER_PING_INTERVAL;
    public static int CLUSTER_BROKER_PING_INTERVAL;
    public static int CLUSTER_PING_TIMEOUT;
    public static int CLUSTER_PING_TIMEOUT_MIN;
    public static boolean DISABLE_DYNAMIC_GROUP_SUBSCRIPTION_DISTRIBUTION;
    public static int GROUP_SUBSCRIPTIONS_MAINTENANCE_INTERVAL;
    public static int GROUP_SUBSCRIPTIONS_CIRCULATION_INTERVAL;
    public static int GROUP_SUBSCRIPTIONS_RECEIVER_IDLE_TIMEOUT;
    public static int GROUP_SUBSCRIPTIONS_CIRCULATION_TIME_LIMIT;
    public static int BROKER_FC_MONITOR_INTERVAL;
    public static int CLIENT_DEFAULT_FC_MONITOR_INTERVAL;
    public static int CLIENT_DEFAULT_FC_MONITOR_INTERVAL_MIN;
    public static final byte GENERAL_SECURITY = 1;
    public static final byte QOP_SECURITY = 2;
    public static final short TXN_SUCCESS = 0;
    public static final short TXN_PARAM_ERR = 1;
    public static final short TXN_NOT_FOUND = 2;
    public static final short TXN_SEQ_ERR = 3;
    public static final short TXN_ABORT = 4;
    public static final short TXN_REQDATA_ERR = 5;
    public static final short TXN_ACC_VIOL = 6;
    public static final short TXN_INDEX_ALREADY_EXISTS = 7;
    public static final short TXN_DATABASE_EXCEPTION = 8;
    public static final short TXN_INVALID_DATA = 9;
    public static final short TXN_INDICES_NOT_SUPPORTED = 10;
    public static final short TXN_XA_DUPLICATE_XID = 11;
    public static final short TXN_XA_NO_XID = 12;
    public static volatile String LOG_PATH;
    public static String SECURITY_PATH;
    public static volatile String LOG_FILE_1;
    public static volatile String LOG_FILE_2;
    public static volatile String TXN_FILE_FULLPATH_PREFIX;
    public static final String TXN_FILENAME_PREFIX = "Txn";
    public static volatile String TXN_FILE_PATH;
    public static int LOG_BLOCK_SIZE;
    public static int LOG_BUFFERED_BLOCKS;
    public static boolean LOG_FORCE_SYNC;
    public static String LOG_OPEN_MODE;
    public static int LOG_FLUSH_DELAY;
    public static boolean LOG_NATIVE_FILE;
    public static long MAX_LOG_FILE_SIZE;
    public static float LOG_NOTIFY_FACTOR;
    public static int TXN_BUFFER_SIZE;
    public static int TXN_SECONDARY_THREADS;
    public static int TXN_PRIMARY_THREADS;
    public static int TXN_FLUSH_THREADS;
    public static boolean TXN_PARALLEL_PUBLISH;
    public static int TXN_IDLE_TIMEOUT;
    public static final int ERROR_EXIT_CODE = 1;
    public static int SERVICE_START_LOCAL_NUM;
    public static String[] SERVICE_START_LOCALS;
    public static String[] SERVICE_CONFIG_PATH;
    public static boolean ENABLE_HTTP;
    public static int HTTP_PORT;
    public static int HTTP_CONNECTION_TIMEOUT;
    public static volatile String DEBUG_NAME;
    public static volatile String DEBUG_CALLBACK;
    public static final int METRICS_REFRESH_INTERVAL_DEFAULT = 20;
    public static final int METRICS_REFRESH_INTERVAL_MIN = 5;
    public static final int METRICS_REFRESH_INTERVAL_MAX = 60;
    public static int METRICS_REFRESH_INTERVAL;
    public static final int METRICS_COLLECTION_INTERVAL_DEFAULT = 10;
    public static final int METRICS_COLLECTION_INTERVAL_MIN = 5;
    public static final int METRICS_COLLECTION_INTERVAL_MAX = 20;
    public static int METRICS_COLLECTION_INTERVAL;
    public static int METRICS_MONITOR_INTERVAL;
    public static boolean METRICS_MONITOR_CONNECTION;
    public static final String METRICS_MONITOR_APPID = "StatsMonitor";
    public static final int METRICS_MONITOR_APPID_SCODE;
    public static boolean METRICS_MONITOR_EVENTS;
    public static volatile String METRICS_MONITOR_OUTPUT;
    public static final String STATS_PREFIX = "$SYS.stats";
    public static final String METRICS_ENABLE_DEFAULT = "NONE";
    public static volatile String METRICS_ENABLE;
    public static int DEBUG_METRICS_DISPLAY_INTERVAL;
    public static int DEBUG_METRICS_COLLECTION_INTERVAL_SECS;
    public static boolean ENABLE_PUBLISH_TIMES;
    public static String DEFAULT_SOCKET_TYPE;
    public static String ALT_SOCKET_TYPE;
    public static int ALT_SOCKET_PORT;
    public static String SSL_PROVIDER_CLASS;
    public static String SSL_CERTIFICATE_CHAIN;
    public static String SSL_CERTIFICATE_CHAIN_FORM;
    public static String SSL_PRIVATE_KEY;
    public static String SSL_PRIVATE_KEY_PASSWORD;
    public static String SSL_CIPHER_SUITES;
    public static String SSL_CA_CERTIFICATES_DIR;
    public static String SSL_TLS_PREFERRED_PROTOCOLS;
    public static String SSL_CLIENT_AUTHENTICATION;
    public static String SSL_DEBUG;
    public static boolean SSL_DO_CRL_CHECKING;
    public static boolean SSL_ENABLE_TLSV1_ONLY;
    public static boolean SSL_ENABLE_SSLV3_ONLY;
    public static volatile String TUNNELING_PROXY_URL;
    public static volatile String PROXY_HOST;
    public static volatile String PROXY_PORT;
    public static volatile String PROXY_PROTOCOL;
    public static volatile String PROXY_USER_NAME;
    public static volatile String PROXY_PASSWORD;
    public static volatile String WS_SECURITY_UT_USER;
    public static volatile String WS_SECURITY_UT_PASSWORD;
    public static boolean WS_SECURITY_DSIG_PREFIXLIST_REQUIRED;
    public static int WS_RM_SEQUENCE_CONTROL_THREADS;
    public static volatile String HTTP_DEBUG;
    public static boolean HTTP_DEBUG_DEFAULT;
    static volatile String HTTP_MIN_THREADS;
    static volatile String HTTP_MAX_THREADS;
    static volatile String HTTP_THREAD_IDLE_TIMEOUT;
    public static final long HTTP_THREAD_IDLE_TIMEOUT_DEFAULT = 60000L;
    public static volatile String HTTP_CONNECTION_CLEANUP_INTERVAL;
    static volatile String HTTP_CLIENT_IDLE_TIMEOUT;
    static volatile String HTTP_CLIENT_READ_TIMEOUT;
    static volatile String HTTP_BROKER_READ_TIMEOUT;
    public static volatile String DOMAIN_SUFFIX_SEARCH_ORDER;
    public static int SOCKET_QUEUE_LENGTH;
    public static boolean DS_DEBUG;
    public static int NUM_ACCEPTORS;
    public static String[] IP_OR_HOSTS;
    public static String[] ACCEPTOR_PORTS;
    public static String[] ACCEPTOR_PROTOCOLS;
    public static String[] ACCEPTOR_NAMES;
    public static String[][] ACCEPTOR_HTTP_X_PROTOCOLS;
    public static String[][] ACCEPTOR_HTTP_X_FACTORIES;
    public static String[][] ACCEPTOR_HTTP_X_PROPFILES;
    public static int INTERBROKER_ACCEPTOR;
    static final int MFR_SERVER_TIMEOUT_SEC = 30;
    static final String MFR_SERVER_ID;
    public static volatile int MAX_CONNECTIONS;
    public static int MAX_SESSIONS_PER_CONNECTION;
    public static int MAX_TEMPORARY_QUEUES_PER_SESSION;
    static final long MAX_CONNECTION_ID = Integer.MAX_VALUE;
    static int CONNECTION_ID_BLOCK_SIZE;
    static int PAYLOAD_CHUNK_SIZE;
    static boolean ASYNCHRONOUS_REPLICATION;
    static boolean DEBUG_FT_CONNECTIONS;
    public static final String DEAD_MESSAGE_QUEUE = "SonicMQ.deadMessage";
    public static final String SYS_EVENT_PREFIX = "$SYS.broker.";
    public static final String UNDELIVERED_MESSAGE_EVENT_SUFFIX = "undelivered";
    public static final String QUEUE_STATUS_EVENT_SUFFIX = "dmqstatus";
    public static final String LOG_STATUS_EVENT_SUFFIX = "logstatus";
    public static final String PUB_PAUSE_EVENT_SUFFIX = "pubpause";
    public static final String PUB_RESUME_EVENT_SUFFIX = "pubresume";
    public static final String SEND_PAUSE_EVENT_SUFFIX = "sendpause";
    public static final String SEND_RESUME_EVENT_SUFFIX = "sendresume";
    public static final String PRESERVE_UNDELIVERED = "JMS_SonicMQ_preserveUndelivered";
    public static final String DESTINATION_UNDELIVERED = "JMS_SonicMQ_destinationUndelivered";
    public static final String NOTIFY_UNDELIVERED = "JMS_SonicMQ_notifyUndelivered";
    static final String UNDELIVERED_REASON_CODE = "JMS_SonicMQ_undeliveredReasonCode";
    static final String UNDELIVERED_TIME_STAMP = "JMS_SonicMQ_undeliveredTimestamp";
    public static final String DELIVERY_TIME_PROPERTY = "JMSDeliveryTime";
    public static final String ULTIMATE_DELIVERY_ADDRESS = "JMS_SonicMQ_ultimateDeliveryAddress";
    public static final String ULTIMATE_DELIVERY_SUBSCRIBERS = "JMS_SonicMQ_ultimateDeliverySubscribers";
    public static final String ULTIMATE_DELIVERY_ROUTING_NODE = "JMS_SonicMQ_ultimateDeliveryRoutingNode";
    static final String UNDELIVERED_BROKER_NAME = "JMS_SonicMQ_undeliveredBrokerName";
    static final String UNDELIVERED_NODE_NAME = "JMS_SonicMQ_undeliveredNodeName";
    static final String UNDELIVERED_REASON_REASON_ADDED_TO_DMQ = "JMS_SonicMQ_undeliveredReasonAddedToDMQ";
    public static final String UNDELIVERED_EXPLANATION_TEXT = "JMS_SonicMQ_undeliveredExplanationText";
    public static final int FLOW_TO_DISK_USE_BROKER_SETTING = 0;
    public static final int FLOW_TO_DISK_ON = 1;
    public static final int FLOW_TO_DISK_OFF = 2;
    public static final String ROUTING_QUEUE = "SonicMQ.routingQueue";
    public static final String DELAYED_DELIVERY_QUEUE = "SonicMQ.delayedDeliveryQueue";
    public static boolean XONCE_RECOVERY;
    public static boolean TCP_NODELAY;
    public static boolean DISABLE_NIO;
    public static long BROKER_SEND_DELAY;
    private static boolean standAlone;
    static int REMOTE_RESTORE_THREAD_CAP;
    public static int MAX_SEND_IO_BUFFER_SIZE;
    public static int MIN_SEND_IO_BUFFER_SIZE;
    public static int INITIAL_SEND_IO_BUFFER_SIZE;
    public static int SOCKET_MIN_SEND_BUFFER_SIZE;
    public static int SOCKET_MAX_SEND_BUFFER_SIZE;
    public static int SOCKET_INITIAL_SEND_BUFFER_SIZE;
    public static int MAX_RCV_IO_BUFFER_SIZE;
    public static int MIN_RCV_IO_BUFFER_SIZE;
    public static int INITIAL_RCV_IO_BUFFER_SIZE;
    public static int SOCKET_MIN_RCV_BUFFER_SIZE;
    public static int SOCKET_MAX_RCV_BUFFER_SIZE;
    public static int SOCKET_INITIAL_RCV_BUFFER_SIZE;
    public static final int UNKNOWN = 0;
    public static final int SEVERE = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int CONFIG = 4;
    public static final int FINE = 5;
    public static final int FINER = 6;
    public static final int FINEST = 7;
    public static final int TRACE = 7;
    private static volatile String JSSE_KEYSTORE_KEY_ALIAS;
    private static volatile String JSSE_KEYSTORE_KEY_PASSWORD;
    private static volatile String JSSE_KEYSTORE_LOCATION;
    private static volatile String JSSE_KEYSTORE_PASSWORD;
    private static volatile String JSSE_KEYSTORE_TYPE;
    private static volatile String JSSE_TRUSTSTORE_LOCATION;
    private static volatile String JSSE_TRUSTSTORE_PASSWORD;
    private static volatile String JSSE_TRUSTSTORE_TYPE;
    private static volatile String JSSE_TRUSTMANAGER;
    private static volatile String JSSE_KEYMANAGER;
    public static boolean ENABLE_CHECKSUM;
    public static boolean ENABLE_COMPRESSION;
    public static String COMPRESSION_FACTORY;
    public static boolean LG_ENABLE;
    public static String LG_SERVER_INTERCEPTOR_CLASS;
    public static long SHARED_SUBS_RECOVERY_TIMEOUT_DEFAULT;
    public static long SHARED_SUBS_RECOVERY_TIMEOUT;
    public static int MAX_MESSAGE_GROUPS;
    public static long MQTT_DELIVERY_TIMEOUT;
    public static final int ADMIN_PREFIX_UID_LEVEL = 2;
    public static final int ADMIN_PREFIX_APPID_LEVEL = 3;
    public static final String NO_SECURITY_MSG;
    public static final String NO_INTERBROKER_MSG;

    public static void logMessage(String message, int severity) {
        BrokerComponent.getBrokerComponent();
        BrokerComponent.getComponentContext().logMessage(message, severity);
    }

    public static void logMessage(String message, Throwable exception, int severity) {
        BrokerComponent.getBrokerComponent();
        BrokerComponent.getComponentContext().logMessage(message, exception, severity);
    }

    public static void logMessage(Throwable exception, int severity) {
        BrokerComponent.getBrokerComponent();
        BrokerComponent.getComponentContext().logMessage(exception, severity);
    }

    public static boolean loadConfig(Properties props, boolean uselessFlag) {
        if (Config.getProperties() != null) {
            return true;
        }
        SessionConfig.IN_BROKER = true;
        SessionConfig.sessionLoadConfig();
        FILE_SEPARATOR = System.getProperties().getProperty("file.separator");
        boolean success = false;
        try {
            int maxTempQueue;
            int maxSession;
            Config.setProperties(props);
            boolean failure = false;
            SessionConfig.setMaxMsgSize(Config.getIntProperty("MAX_MSG_SIZE", SessionConfig.MAX_MSG_SIZE_BROKER_DEFAULT));
            HTTP_DEBUG = Config.getProperty("HTTP_DEBUG", String.valueOf(HTTP_DEBUG_DEFAULT), props);
            CONTROL_NUMBER = Config.getProperty("CONTROL_NUMBER", CONTROL_NUMBER);
            EVALUATION_MODE = Config.getBooleanProperty("EVALUATION_MODE", EVALUATION_MODE);
            PROVISION_SPI_CLASSNAME = Config.getProperty("PROVISION_SPI_CLASSNAME", PROVISION_SPI_CLASSNAME_DEFAULT);
            if (PROVISION_SPI_CLASSNAME != null) {
                PROVISION_SPI_CLASSNAME = PROVISION_SPI_CLASSNAME.trim();
            }
            PROVISION_SPI_INTERVAL = Config.getIntProperty("PROVISION_SPI_INTERVAL", PROVISION_SPI_INTERVAL_DEFAULT);
            if (ProvisionMonitor.DEBUG) {
                System.out.println("#### PROVISION_SPI_CLASSNAME = " + PROVISION_SPI_CLASSNAME + "; PROVISION_SPI_INTERVAL = " + PROVISION_SPI_INTERVAL);
            }
            BROKER_UID = BROKER_NAME = Config.getProperty("BROKER_NAME", BROKER_NAME);
            BROKER_PWD = Config.getProperty("BROKER_PASSWORD", BROKER_PWD);
            USE_DYNAMIC_HOST_BINDING = Config.getBooleanProperty("USE_DYNAMIC_HOST_BINDING", false);
            if (!(ENABLE_SECURITY = Config.getBooleanProperty("ENABLE_SECURITY", ENABLE_SECURITY))) {
                ENABLE_QOPSECURITY = false;
                ENABLE_ACCESS_MEDIATION = false;
                SET_JMSXUSERID = false;
            } else {
                ENABLE_QOPSECURITY = Config.getBooleanProperty("ENABLE_QOP_SECURITY", ENABLE_QOPSECURITY);
                ENABLE_ACCESS_MEDIATION = true;
                SET_JMSXUSERID = Config.getBooleanProperty("SET_JMSXUSERID", SET_JMSXUSERID);
            }
            String defaultQop = Config.getProperty("DEFAULT_QOP", METRICS_ENABLE_DEFAULT);
            if (defaultQop.equals(METRICS_ENABLE_DEFAULT)) {
                DEFAULT_QOP = 0;
            } else if (defaultQop.equals("INTEGRITY")) {
                DEFAULT_QOP = 1;
            } else if (defaultQop.equals("PRIVACY")) {
                DEFAULT_QOP = (short)2;
            } else {
                Config.logMessage(prAccessor.getString("STR075"), 2);
                DEFAULT_QOP = 0;
            }
            ENABLE_ACL_CHECK_AT_RESTORE = Config.getBooleanProperty("ENABLE_ACL_CHECK_AT_RESTORE", false);
            BrokerLicenseMgr lm = (BrokerLicenseMgr)((Object)props.get("LICENSE_MANAGER"));
            ENABLE_ROUTING = lm != null && lm.isRoutingAllowed();
            ENABLE_HTTP_DIRECT = lm != null && lm.isHTTPDirectAllowed();
            PRODUCT_NAME = lm != null ? lm.getProductName() : PRODUCT_NAME;
            FT_START_ACTIVE = Config.getBooleanProperty("START_ACTIVE", FT_START_ACTIVE);
            if (FT_START_ACTIVE) {
                Config.logMessage(prAccessor.getString("START_ACTIVE"), 2);
            }
            try {
                String value = System.getProperty(FT_START_ACTIVE_PROPERTY);
                boolean propvalue = Boolean.valueOf(value);
                if (value != null && propvalue != FT_START_ACTIVE) {
                    String warning = prAccessor.getString("START_ACTIVE_SYSPROP");
                    Object[] v = new Object[]{value};
                    warning = prMessageFormat.format(warning, v);
                    Config.logMessage(warning, 2);
                    FT_START_ACTIVE = propvalue;
                }
            }
            catch (SecurityException value) {
                // empty catch block
            }
            DUAL_ACTIVE_RESOLUTION = Config.getProperty("DUAL_ACTIVE_RESOLUTION");
            DUAL_ACTIVE_RESOLUTION_METRICS_PARAM = Config.getProperty("DUAL_ACTIVE_RESOLUTION_METRICS", "broker.messages.Delivered,broker.messages.Received");
            FT_FAILURE_DETECT_CALLBACK = Config.getProperty("FAILURE_DETECT_CALLBACK");
            FT_REPLICATE_PERSISTENT = Config.getBooleanProperty("REPLICATE_PERSISTENT", false);
            FT_FAILURE_DETECT_TIMEOUT = 1000L * Config.getLongProperty("FAILURE_DETECT_TIMEOUT", 0L);
            FT_CONNECT_TIMEOUT = 1000 * Config.getIntProperty("CONNECT_TIMEOUT", 30);
            FT_PING_INTERVAL = 1000L * Config.getLongProperty("PING_INTERVAL", 30L);
            FT_PING_TIMEOUT = 1000 * Config.getIntProperty("PING_TIMEOUT", 60);
            if (FT_PING_TIMEOUT > 0 && FT_PING_INTERVAL > (long)((FT_PING_TIMEOUT = Math.max(FT_PING_TIMEOUT, FT_PING_TIMEOUT_MIN)) >> 1)) {
                FT_PING_INTERVAL = FT_PING_TIMEOUT >> 1;
            }
            FT_RETRY_INTERVAL = 1000L * Config.getLongProperty("RETRY_INTERVAL", 180L);
            REPLICATION_CHUNK_SIZE = Config.getIntProperty("REPLICATION_CHUNK_SIZE", 102400);
            String preferredActive = Config.getProperty("PREFERRED_ACTIVE", "Primary");
            FT_PREFERRED_ACTIVE = preferredActive.equalsIgnoreCase("Backup") ? 1 : 0;
            FT_REPLICATE_NON_PERSISTENT = Config.getBooleanProperty("FT_REPLICATE_NON_PERSISTENT", FT_REPLICATE_NON_PERSISTENT);
            DATABASE_STORE_TYPE = Config.getProperty("DATABASE_STORE_TYPE", "Embedded");
            MQSTORE_DB_CONNECT = Config.getProperty("MQSTORE_DB_CONNECT", MQSTORE_DB_CONNECT);
            DB_MSG_CLEAN_THRESHOLD = Config.getIntProperty("DB_MSG_CLEAN_THRESHOLD", DB_MSG_CLEAN_THRESHOLD);
            EXP_MSG_CLEAN_THRESHOLD = Config.getIntProperty("EXP_MSG_CLEAN_THRESHOLD", EXP_MSG_CLEAN_THRESHOLD);
            DB_COMMIT_BATCH_SIZE = Config.getIntProperty("DB_COMMIT_BATCH_SIZE", DB_COMMIT_BATCH_SIZE);
            DB_CLEANUP_BATCH_SIZE = Config.getIntProperty("DB_CLEANUP_BATCH_SIZE", DB_CLEANUP_BATCH_SIZE);
            DB_FORCE_SYNC = Config.getBooleanProperty("DB_FORCE_SYNC", DB_FORCE_SYNC);
            LOG_PATH = Config.getProperty("RECOVERY_LOG_PATH", "./log") + FILE_SEPARATOR;
            MAX_LOG_FILE_SIZE = Config.getLongProperty("RECOVERY_LOG_MAX_FILE_SIZE", 1000000L);
            LOG_BLOCK_SIZE = Config.getIntProperty("RECOVERY_LOG_BLOCK_SIZE", 8192);
            LOG_BUFFERED_BLOCKS = Config.getIntProperty("RECOVERY_LOG_BUFFERED_BLOCKS", LOG_BUFFERED_BLOCKS);
            LOG_OPEN_MODE = Config.getProperty("RECOVERY_LOG_OPEN_MODE", LOG_OPEN_MODE);
            LOG_FORCE_SYNC = Config.getBooleanProperty("RECOVERY_LOG_FORCE_SYNC", LOG_FORCE_SYNC);
            LOG_FLUSH_DELAY = Config.getIntProperty("RECOVERY_LOG_FLUSH_DELAY", LOG_FLUSH_DELAY);
            LOG_QUEUE_SIZE = Config.getIntProperty("RECOVERY_LOG_QUEUE_SIZE", LOG_QUEUE_SIZE);
            LOG_FLUSH_PRIORITY_BOOST = Config.getIntProperty("RECOVERY_LOG_FLUSH_PRIORITY_BOOST", LOG_FLUSH_PRIORITY_BOOST);
            LOG_NOTIFY_FACTOR = Config.getFloatProperty("RECOVERY_LOG_NOTIFY_FACTOR", 0.5f);
            ENABLE_WSRM_FLOW_CONTROL_NOTIFICATION = Config.getBooleanProperty("ENABLE_WSRM_FLOW_CONTROL_NOTIFICATIONS", ENABLE_WSRM_FLOW_CONTROL_NOTIFICATION);
            BACKLOGGED_SESSION_SKIP_WARN_INTERVAL = Config.getLongProperty("BACKLOGGED_SESSION_SKIP_WARN_INTERVAL", -1L);
            BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT = Config.getIntProperty("BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT", -1);
            SOCKET_QUEUE_LENGTH = Config.getIntProperty("SOCKET_QUEUE_LENGTH", 50);
            OUTPUT_QUEUE.loadConfig();
            GUAR_QUEUE.loadConfig();
            WAIT_QUEUE.loadConfig();
            ACKNOWLEDGE_MONITOR_INTERVAL = Config.getIntProperty("ACKNOWLEDGE_MONITOR_INTERVAL", ACKNOWLEDGE_MONITOR_INTERVAL);
            PTP_GUAR_MSG_BUFFER_LIMIT_CHECK = Config.getBooleanProperty("PTP_GUAR_MSG_BUFFER_LIMIT_CHECK", false);
            MAX_SEND_IO_BUFFER_SIZE = Config.getIntProperty("AGENT_SENDER_OUTPUT_BUFFER_SIZE", MAX_SEND_IO_BUFFER_SIZE);
            MIN_SEND_IO_BUFFER_SIZE = Config.getIntProperty("AGENT_SENDER_MIN_OUTPUT_BUFFER_SIZE", MIN_SEND_IO_BUFFER_SIZE);
            INITIAL_SEND_IO_BUFFER_SIZE = Config.getIntProperty("AGENT_SENDER_INITIAL_OUTPUT_BUFFER_SIZE", INITIAL_SEND_IO_BUFFER_SIZE);
            MAX_RCV_IO_BUFFER_SIZE = Config.getIntProperty("AGENT_LISTENER_INPUT_BUFFER_SIZE", MAX_RCV_IO_BUFFER_SIZE);
            MIN_RCV_IO_BUFFER_SIZE = Config.getIntProperty("AGENT_LISTENER_MIN_INPUT_BUFFER_SIZE", MIN_RCV_IO_BUFFER_SIZE);
            INITIAL_RCV_IO_BUFFER_SIZE = Config.getIntProperty("AGENT_LISTENER_INITIAL_INPUT_BUFFER_SIZE", INITIAL_RCV_IO_BUFFER_SIZE);
            SOCKET_MAX_SEND_BUFFER_SIZE = Config.getIntProperty("TCP_SEND_BUFFER_SIZE", SOCKET_MAX_SEND_BUFFER_SIZE);
            SOCKET_MIN_SEND_BUFFER_SIZE = Config.getIntProperty("TCP_MIN_SEND_BUFFER_SIZE", SOCKET_MIN_SEND_BUFFER_SIZE);
            SOCKET_INITIAL_SEND_BUFFER_SIZE = Config.getIntProperty("TCP_INITIAL_SEND_BUFFER_SIZE", SOCKET_INITIAL_SEND_BUFFER_SIZE);
            SOCKET_MAX_RCV_BUFFER_SIZE = Config.getIntProperty("TCP_RECEIVE_BUFFER_SIZE", SOCKET_MAX_RCV_BUFFER_SIZE);
            SOCKET_MIN_RCV_BUFFER_SIZE = Config.getIntProperty("TCP_MIN_RCV_BUFFER_SIZE", SOCKET_MIN_RCV_BUFFER_SIZE);
            SOCKET_INITIAL_RCV_BUFFER_SIZE = Config.getIntProperty("TCP_INITIAL_RCV_BUFFER_SIZE", SOCKET_INITIAL_RCV_BUFFER_SIZE);
            PS_DB_QUEUE_SIZE = Config.getIntProperty("PS_DB_QUEUE_SIZE", PS_DB_QUEUE_SIZE);
            DURABLE_SUBSCRIBER_EXPIRATION_POLL_INTERVAL = Config.getIntProperty("DURABLE_SUBSCRIBER_EXPIRATION_POLL_INTERVAL", DURABLE_SUBSCRIBER_EXPIRATION_POLL_INTERVAL);
            PRESERVE_NON_DURABLE_WHEN_STOPPED = Config.getBooleanProperty("PRESERVE_NON_DURABLE_WHEN_STOPPED", false);
            REDELIVERY_BATCH_SIZE = Config.getIntProperty("REDELIVERY_BATCH_SIZE", REDELIVERY_BATCH_SIZE);
            THROTTLE_PUBS_DURING_RESTORE = Config.getBooleanProperty("THROTTLE_PUBS_DURING_RESTORE", THROTTLE_PUBS_DURING_RESTORE);
            RESTORE_MSGS_COUNT = Config.getIntProperty("RESTORE_MSGS_COUNT", RESTORE_MSGS_COUNT);
            RESTORE_MSGS_FC_COUNT = Config.getIntProperty("RESTORE_MSGS_FC_COUNT", RESTORE_MSGS_FC_COUNT);
            FLOW_TO_DISK = Config.getBooleanProperty("FLOW_TO_DISK", false);
            FLOW_TO_DISK_NOTIFY = Config.getBooleanProperty("FLOW_TO_DISK_NOTIFY", true);
            FLOW_TO_DISK_DISCARDABLE = Config.getBooleanProperty("FLOW_TO_DISK_DISCARDABLE", false);
            CHECK_DB_SIZE_ON_PUBLISH = Config.getBooleanProperty("CHECK_DB_SIZE_ON_PUBLISH", CHECK_DB_SIZE_ON_PUBLISH);
            EXP_MSG_CLEAN_POLL_INTERVAL = Config.getIntProperty("EXP_MSG_CLEAN_POLL_INTERVAL", EXP_MSG_CLEAN_POLL_INTERVAL);
            SLOW_SUBSCRIBER_MONITOR_POLL_INTERVAL = Config.getIntProperty("SLOW_SUBSCRIBER_MONITOR_POLL_INTERVAL", SLOW_SUBSCRIBER_MONITOR_POLL_INTERVAL);
            SLOW_SUBSCRIBER_NOTIFY_THRESHOLD = Config.getLongProperty("SLOW_SUBSCRIBER_NOTIFY_THRESHOLD", SLOW_SUBSCRIBER_NOTIFY_THRESHOLD);
            if (CHECK_DB_SIZE_ON_PUBLISH) {
                Config.logMessage("CHECK_DB_SIZE_ON_PUBLISH is set to true", 3);
            }
            SHARED_SUBS_RECOVERY_TIMEOUT = Config.getLongProperty("SHARED_SUBS_RECOVERY_TIMEOUT", SHARED_SUBS_RECOVERY_TIMEOUT_DEFAULT);
            MAX_TOPIC_DB_SIZE = Config.getIntProperty("MAX_TOPIC_DB_SIZE", MAX_TOPIC_DB_SIZE);
            TOPIC_DB_SIZE_RESTART_THRESHOLD = Config.getIntProperty("TOPIC_DB_SIZE_RESTART_THRESHOLD", TOPIC_DB_SIZE_RESTART_THRESHOLD);
            MAX_FTD_MEMORY_SIZE = Config.getIntProperty("MAX_FTD_MEMORY_SIZE", MAX_FTD_MEMORY_SIZE);
            PTP_DB_QUEUE_SIZE = Config.getIntProperty("PTP_DB_QUEUE_SIZE", PTP_DB_QUEUE_SIZE);
            PTP_DB_DELETEOP_SIZE = Config.getIntProperty("PTP_DB_DELETEOP_SIZE", PTP_DB_DELETEOP_SIZE);
            PTP_DB_ASYNC_RETRIEVEOP_SIZE = Config.getIntProperty("PTP_DB_ASYNC_RETRIEVEOP_SIZE", PTP_DB_ASYNC_RETRIEVEOP_SIZE);
            PTP_ENABLE_SYNCSIZE_MONITOR = Config.getBooleanProperty("PTP_DB_ENABLE_SYNCSIZE_MONITOR", false);
            PTP_REDELIVERED_ON_BROKER_RESTART = Config.getBooleanProperty("PTP_REDELIVERED_ON_BROKER_RESTART", false);
            ENABLE_DYNAMIC_QUEUE_CLEANUP = Config.getBooleanProperty("ENABLE_QUEUE_CLEANUP", true);
            QUEUE_CLEANUP_INTERVAL = Config.getLongProperty("QUEUE_CLEANUP_INTERVAL", 600L);
            QUEUE_DELIVERY_THREADS = Config.getIntProperty("QUEUE_DELIVERY_THREADS", 10);
            MAX_ADMINISTRATIVELY_CREATED_QUEUE_SIZE = Config.getIntProperty("MAX_ADMINISTRATIVELY_CREATED_QUEUE_SIZE", MAX_ADMINISTRATIVELY_CREATED_QUEUE_SIZE);
            MAX_TEMPORARY_QUEUE_SIZE = Config.getIntProperty("MAX_TEMPORARY_QUEUE_SIZE", MAX_TEMPORARY_QUEUE_SIZE);
            MAX_QMSG_SAVER_ASYNC_CACHE_SIZE = Config.getIntProperty("MAX_QMSG_SAVER_ASYNC_CACHE_SIZE", DFLT_MAX_QMSG_SAVER_ASYNC_CACHE_SIZE);
            DISCONNECTED_PENDING_SAVE_THRESHOLD = Config.getIntProperty("DISCONNECTED_PENDING_SAVE_THRESHOLD", DISCONNECTED_PENDING_SAVE_THRESHOLD);
            DISCONNECTED_PENDING_MAX_QUEUE_SIZE = Config.getIntProperty("DISCONNECTED_PENDING_MAX_QUEUE_SIZE", DISCONNECTED_PENDING_MAX_QUEUE_SIZE);
            FLOW_CONTROLLED_PENDING_SAVE_THRESHOLD = Config.getIntProperty("FLOW_CONTROLLED_PENDING_SAVE_THRESHOLD", FLOW_CONTROLLED_PENDING_SAVE_THRESHOLD);
            FLOW_CONTROLLED_PENDING_MAX_QUEUE_SIZE = Config.getIntProperty("FLOW_CONTROLLED_PENDING_MAX_QUEUE_SIZE", FLOW_CONTROLLED_PENDING_MAX_QUEUE_SIZE);
            DELAYED_DELIVERY_INTERVAL = Config.getIntProperty("DELAYED_DELIVERY_INTERVAL", DELAYED_DELIVERY_INTERVAL);
            int maxDeliveryCount = Integer.getInteger(BROKER_MAX_DELIVERY_COUNT_PROPERTY, BROKER_MAX_DELIVERY_COUNT);
            if (maxDeliveryCount <= 0) {
                maxDeliveryCount = Config.getIntProperty("BROKER_MAX_DELIVERY_COUNT", 0);
            }
            maxDeliveryCount = maxDeliveryCount < 0 ? 0 : maxDeliveryCount;
            maxDeliveryCount = maxDeliveryCount > 127 ? 127 : maxDeliveryCount;
            BROKER_MAX_DELIVERY_COUNT = (byte)maxDeliveryCount;
            DMQ_NOTIFY_FACTOR = Config.getFloatProperty("DMQ_NOTIFY_FACTOR", 0.85f);
            FLOW_CONTROL_NOTIFY_SIZE = Config.getIntProperty("FLOW_CONTROL_NOTIFY_SIZE", FLOW_CONTROL_NOTIFY_SIZE);
            TXN_BUFFER_SIZE = Config.getIntProperty("TXN_BUFFER_SIZE", TXN_BUFFER_SIZE);
            TXN_PRIMARY_THREADS = Config.getIntProperty("TXN_PRIMARY_THREADS", 10);
            TXN_SECONDARY_THREADS = Config.getIntProperty("TXN_SECONDARY_THREADS", 1);
            TXN_FLUSH_THREADS = Config.getIntProperty("TXN_FLUSH_THREADS", 1);
            TXN_PARALLEL_PUBLISH = Config.getBooleanProperty("TXN_PARALLEL_PUBLISH", true);
            TXN_IDLE_TIMEOUT = Config.getIntProperty("TXN_IDLE_TIMEOUT", 0);
            if (TXN_IDLE_TIMEOUT < 0) {
                TXN_IDLE_TIMEOUT = 0;
            }
            if ((TUNNELING_PROXY_URL = Config.getProperty("TUNNELING_PROXY_URL")) != null) {
                HttpProxyConfig pConfig = new HttpProxyConfig(TUNNELING_PROXY_URL, null, null);
                PROXY_HOST = pConfig.getHost();
                PROXY_PORT = Integer.toString(pConfig.getPort());
                PROXY_PROTOCOL = pConfig.getProtocol();
            }
            PROXY_USER_NAME = Config.getProperty("PROXY_USER_NAME");
            PROXY_PASSWORD = Config.getProperty("PROXY_PASSWORD");
            WS_SECURITY_UT_USER = Config.getProperty("USERNAMETOKEN_USERNAME");
            WS_SECURITY_UT_PASSWORD = Config.getProperty("USERNAMETOKEN_PASSWORD");
            WS_SECURITY_DSIG_PREFIXLIST_REQUIRED = Config.getBooleanProperty("WS_SIGNATURE_PREFIXLIST_REQUIRED", WS_SECURITY_DSIG_PREFIXLIST_REQUIRED);
            WS_RM_SEQUENCE_CONTROL_THREADS = Config.getIntProperty("SEQUENCE_CONTROL_THREADS", WS_RM_SEQUENCE_CONTROL_THREADS);
            DOMAIN_SUFFIX_SEARCH_ORDER = Config.getProperty("DOMAIN_SUFFIX_SEARCH_ORDER");
            if (DOMAIN_SUFFIX_SEARCH_ORDER != null && DOMAIN_SUFFIX_SEARCH_ORDER.equals("")) {
                DOMAIN_SUFFIX_SEARCH_ORDER = null;
            }
            TCP_NODELAY = Config.getBooleanProperty("TCP_NODELAY", true);
            DISABLE_NIO = Config.getBooleanProperty("DISABLE_NIO", true);
            ENABLE_CHECKSUM = Config.getBooleanProperty("ENABLE_CHECKSUM", false);
            BROKER_SEND_DELAY = Config.getLongProperty("BROKER_SEND_DELAY", BROKER_SEND_DELAY);
            int maxconn = Config.getIntProperty("MAX_CONNECTIONS", -100);
            if (maxconn >= 0) {
                MAX_CONNECTIONS = maxconn;
            }
            if ((maxSession = Config.getIntProperty("MAX_SESSIONS_PER_CONNECTION", -100)) >= 0) {
                MAX_SESSIONS_PER_CONNECTION = maxSession;
            }
            if ((maxTempQueue = Config.getIntProperty("MAX_TEMPORARY_QUEUES_PER_SESSION", -100)) >= 0) {
                MAX_TEMPORARY_QUEUES_PER_SESSION = maxTempQueue;
            }
            CONNECTION_ID_BLOCK_SIZE = Config.getIntProperty("CONNECTION_ID_BLOCK_SIZE", CONNECTION_ID_BLOCK_SIZE);
            BROKER_CONNECT_TIMEOUT = Config.getIntProperty("BROKER_CONNECT_TIMEOUT", BROKER_CONNECT_TIMEOUT);
            BROKER_PING_TIMEOUT = 1000 * Config.getIntProperty("BROKER_PING_TIMEOUT", BROKER_PING_TIMEOUT / 1000);
            BROKER_PING_INTERVAL = Config.getIntProperty("BROKER_PING_INTERVAL", BROKER_PING_INTERVAL);
            if (BROKER_PING_TIMEOUT > 0) {
                BROKER_PING_TIMEOUT = Math.max(BROKER_PING_TIMEOUT, BROKER_PING_TIMEOUT_MIN);
                BROKER_PING_INTERVAL = Config.updatePingInterval(BROKER_PING_INTERVAL, BROKER_PING_TIMEOUT);
            }
            CONNECT_PING_TIMEOUT = Config.getIntProperty("CONNECT_PING_TIMEOUT", CONNECT_PING_TIMEOUT);
            if ((CLIENT_DEFAULT_FC_MONITOR_INTERVAL = Config.getIntProperty("CLIENT_DEFAULT_FC_MONITOR_INTERVAL", CLIENT_DEFAULT_FC_MONITOR_INTERVAL)) != 0) {
                CLIENT_DEFAULT_FC_MONITOR_INTERVAL = Math.max(CLIENT_DEFAULT_FC_MONITOR_INTERVAL, CLIENT_DEFAULT_FC_MONITOR_INTERVAL_MIN);
            }
            ROUTING_NODE_NAME = Config.getProperty("ROUTING_NODE_NAME", "");
            ROUTING_THREADS = Config.getIntProperty("ROUTING_THREADS", 10);
            HTTP_DIRECT_OUTBOUND_DISPATCH_THREADS = Config.getIntProperty("HTTP_DIRECT_OUTBOUND_DISPATCH_THREADS", 10);
            HTTP_DIRECT_OUTBOUND_RESERVED_FOR_GROUPED_REQUESTS_THREADS = Config.getIntProperty("HTTP_DIRECT_OUTBOUND_RESERVED_FOR_GROUPED_REQUESTS_THREADS", 0);
            CONNECT_RETRY_COUNT = Config.getIntProperty("CONNECT_RETRY_COUNT", 1);
            CONNECT_RETRY_INTERVAL = Config.getLongProperty("CONNECT_RETRY_INTERVAL", 30L);
            CONNECT_ATTEMPT_INTERVAL = Config.getLongProperty("CONNECT_ATTEMPT_INTERVAL", 30L);
            CONNECT_IDLE_TIMEOUT = Config.getIntProperty("CONNECT_IDLE_TIMEOUT", 300);
            RECOVERY_RECONNECT_TIMEOUT = Config.getIntProperty("RECOVERY_RECONNECT_TIMEOUT", 60);
            CLIENT_RECONNECT_TIMEOUT = Config.getLongProperty("CLIENT_RECONNECT_TIMEOUT", 600L);
            INDOUBT_TIMEOUT = Config.getLongProperty("INDOUBT_TIMEOUT", 36000L);
            INDOUBT_TIMEOUT *= 1000L;
            INDOUBT_RECONNECT_INTERVAL = Config.getLongProperty("INDOUBT_RECONNECT_INTERVAL", 300L);
            INDOUBT_RECONNECT_INTERVAL *= 1000L;
            ROUTING_TIMEOUT = Config.getLongProperty("ROUTING_TIMEOUT", 7200L);
            ACKEXCHANGE_TIMEOUT = Config.getLongProperty("ACKEXCHANGE_TIMEOUT", 120L);
            ACKEXCHANGE_TIMEOUT *= 1000L;
            DISABLE_ACKEXCHANGE = Config.getBooleanProperty("DISABLE_ACKEXCHANGE", false);
            DISABLE_QR_RECOVERY = Config.getBooleanProperty("DISABLE_QR_RECOVERY", false);
            if (DISABLE_QR_RECOVERY) {
                DISABLE_ACKEXCHANGE = true;
            }
            DISABLE_INDOUBT_RECONNECT = Config.getBooleanProperty("DISABLE_INDOUBT_RECONNECT", false);
            CLUSTER_RECONNECT_INTERVAL = Config.getIntProperty("CLUSTER_RECONNECT_INTERVAL", 10);
            CLUSTER_CONNECT_TIMEOUT = 1000 * Config.getIntProperty("CLUSTER_BROKER_CONNECT_TIMEOUT", 30);
            CLUSTER_PING_INTERVAL = 1000 * Config.getIntProperty("CLUSTER_BROKER_PING_INTERVAL", 30);
            CLUSTER_BROKER_PING_INTERVAL = Config.getIntProperty("CLUSTER_BROKER_PING_INTERVAL", 30);
            CLUSTER_PING_TIMEOUT = 1000 * Config.getIntProperty("CLUSTER_BROKER_PING_TIMEOUT", 60);
            if (CLUSTER_PING_TIMEOUT > 0) {
                CLUSTER_PING_TIMEOUT = Math.max(CLUSTER_PING_TIMEOUT, CLUSTER_PING_TIMEOUT_MIN);
                CLUSTER_PING_INTERVAL = Config.updatePingInterval(CLUSTER_PING_INTERVAL, CLUSTER_PING_TIMEOUT);
            }
            DISABLE_DYNAMIC_GROUP_SUBSCRIPTION_DISTRIBUTION = Config.getBooleanProperty("DISABLE_DYNAMIC_GROUP_SUBSCRIPTION_DISTRIBUTION", false);
            GROUP_SUBSCRIPTIONS_MAINTENANCE_INTERVAL = Config.getIntProperty("GROUP_SUBSCRIPTIONS_MAINTENANCE_INTERVAL", 60);
            GROUP_SUBSCRIPTIONS_CIRCULATION_INTERVAL = Config.getIntProperty("GROUP_SUBSCRIPTIONS_CIRCULATION_INTERVAL", GROUP_SUBSCRIPTIONS_MAINTENANCE_INTERVAL * 2);
            GROUP_SUBSCRIPTIONS_RECEIVER_IDLE_TIMEOUT = GROUP_SUBSCRIPTIONS_CIRCULATION_INTERVAL * 2;
            GROUP_SUBSCRIPTIONS_CIRCULATION_TIME_LIMIT = Math.min(GROUP_SUBSCRIPTIONS_MAINTENANCE_INTERVAL, 30);
            BROKER_FC_MONITOR_INTERVAL = Config.getIntProperty("FC_MONITOR_INTERVAL", 15);
            ENABLE_GLOBAL_SUBCRIPTIONS_FORWARDING = Config.getBooleanProperty("ENABLE_GLOBAL_SUBCRIPTIONS_FORWARDING", false);
            GLOBAL_SUBSCRIPTION_EXPIRATION = Config.getLongProperty("GLOBAL_SUBSCRIPTION_EXPIRATION", 0L);
            REMOTE_BROKER_CONNECT_TIMEOUT = Config.getIntProperty("REMOTE_BROKER_CONNECT_TIMEOUT", REMOTE_BROKER_CONNECT_TIMEOUT);
            REMOTE_BROKER_MONITOR_TIMEOUT = Config.getIntProperty("REMOTE_BROKER_MONITOR_TIMEOUT", REMOTE_BROKER_MONITOR_TIMEOUT);
            REMOTE_BROKER_MONITOR_INTERVAL = Config.getIntProperty("REMOTE_BROKER_MONITOR_INTERVAL", REMOTE_BROKER_MONITOR_INTERVAL);
            ASYNCHRONOUS_REPLICATION = Config.getBooleanProperty("ASYNCHRONOUS_REPLICATION", ASYNCHRONOUS_REPLICATION);
            Object primary = Config.getProperties().get("PRIMARY_CONFIG_ELEMENT_REF");
            Object backup = Config.getProperties().get("BACKUP_CONFIG_ELEMENT_REF");
            boolean bl = REPLICATED = primary != null || backup != null;
            if (REPLICATED && !lm.isFaultToleranceAllowed()) {
                REPLICATED = false;
                String warning = MessageFormat.format(prAccessor.getString("REPLICATION_NOT_SUPPORTED"), lm.getProductName());
                Config.logMessage(warning, 2);
            }
            if (REPLICATED) {
                XONCE_RECOVERY = true;
                PRIMARY = backup != null;
            } else {
                XONCE_RECOVERY = Config.getBooleanProperty("XONCE_RECOVERY", XONCE_RECOVERY);
            }
            ENABLE_INTERBROKER = Config.getBooleanProperty("ENABLE_INTERBROKER", false);
            ENABLE_LOAD_BALANCING = Config.getBooleanProperty("ENABLE_LOAD_BALANCING", ENABLE_INTERBROKER);
            LOAD_BALANCING_WEIGHT = Config.getIntProperty("LOAD_BALANCING_WEIGHT", 1);
            if (LOAD_BALANCING_WEIGHT < 1) {
                LOAD_BALANCING_WEIGHT = 0;
            }
            HTTP_MIN_THREADS = Config.getProperty("HTTP_MIN_THREADS", HTTP_MIN_THREADS);
            HTTP_MAX_THREADS = Config.getProperty("HTTP_MAX_THREADS", HTTP_MAX_THREADS);
            HTTP_THREAD_IDLE_TIMEOUT = Config.getProperty("HTTP_THREAD_IDLE_TIMEOUT", HTTP_THREAD_IDLE_TIMEOUT);
            HTTP_CLIENT_IDLE_TIMEOUT = Config.getProperty("HTTP_CLIENT_IDLE_TIMEOUT", HTTP_CLIENT_IDLE_TIMEOUT);
            HTTP_CLIENT_READ_TIMEOUT = Config.getProperty("HTTP_CLIENT_READ_TIMEOUT", HTTP_CLIENT_READ_TIMEOUT);
            HTTP_BROKER_READ_TIMEOUT = Config.getProperty("HTTP_BROKER_READ_TIMEOUT", HTTP_BROKER_READ_TIMEOUT);
            HTTP_CONNECTION_CLEANUP_INTERVAL = Long.toString(Config.getLongProperty("HTTP_CONNECTION_CLEANUP_INTERVAL", 60000L));
            ProgressSslSocketFactory.SSL_PROVIDER_CLASS = SSL_PROVIDER_CLASS = Config.getProperty("SSL_PROVIDER_CLASS");
            SSL_DEBUG = Config.getProperty("SSL_DEBUG", "false");
            ProgressSslSocketFactory.DEBUG = SSL_DEBUG.trim().equalsIgnoreCase("true");
            SSL_CERTIFICATE_CHAIN = Config.getProperty("SSL_CERTIFICATE_CHAIN");
            SSL_CERTIFICATE_CHAIN_FORM = Config.getProperty("SSL_CERTIFICATE_CHAIN_FORM");
            SSL_PRIVATE_KEY = Config.getProperty("SSL_PRIVATE_KEY");
            SSL_PRIVATE_KEY_PASSWORD = Config.getProperty("SSL_PRIVATE_KEY_PASSWORD");
            SSL_CA_CERTIFICATES_DIR = Config.getProperty("SSL_CA_CERTIFICATES_DIR");
            SSL_CIPHER_SUITES = Config.getProperty("SSL_CIPHER_SUITES");
            SSL_TLS_PREFERRED_PROTOCOLS = Config.getProperty("SSL_TLS_PREFERRED_PROTOCOLS");
            JSSE_KEYSTORE_KEY_ALIAS = Config.getProperty("JSSE_KEYSTORE_ALIAS");
            JSSE_KEYSTORE_KEY_PASSWORD = Config.getProperty("JSSE_KEYSTORE_KEY_PASSWORD");
            JSSE_KEYSTORE_LOCATION = Config.getProperty("JSSE_KEYSTORE_LOCATION");
            JSSE_KEYSTORE_PASSWORD = Config.getProperty("JSSE_KEYSTORE_PASSWORD");
            JSSE_KEYSTORE_TYPE = Config.getProperty("JSSE_KEYSTORE_TYPE");
            JSSE_TRUSTSTORE_LOCATION = Config.getProperty("JSSE_TRUSTSTORE_LOCATION");
            JSSE_TRUSTSTORE_PASSWORD = Config.getProperty("JSSE_TRUSTSTORE_PASSWORD");
            JSSE_TRUSTSTORE_TYPE = Config.getProperty("JSSE_TRUSTSTORE_TYPE");
            JSSE_TRUSTMANAGER = Config.getProperty("JSSE_TRUSTMANAGER");
            JSSE_KEYMANAGER = Config.getProperty("JSSE_KEYMANAGER");
            SSL_ENABLE_TLSV1_ONLY = Config.getBooleanProperty("ENABLE_TLSV1_ONLY", SSL_ENABLE_TLSV1_ONLY);
            SSL_ENABLE_SSLV3_ONLY = Config.getBooleanProperty("ENABLE_SSLV3_ONLY", SSL_ENABLE_SSLV3_ONLY);
            SSL_DO_CRL_CHECKING = Config.getBooleanProperty("DO_CRL_CHECKING", SSL_DO_CRL_CHECKING);
            METRICS_ENABLE = Config.getProperty("METRICS_ENABLE", METRICS_ENABLE_DEFAULT);
            METRICS_REFRESH_INTERVAL = Config.getIntProperty("METRICS_REFRESH_INTERVAL", 20);
            METRICS_COLLECTION_INTERVAL = Config.getIntProperty("METRICS_COLLECTION_INTERVAL", 10);
            METRICS_MONITOR_INTERVAL = Config.getIntProperty("METRICS_MONITOR_INTERVAL", METRICS_MONITOR_INTERVAL);
            METRICS_MONITOR_CONNECTION = Config.getBooleanProperty("METRICS_MONITOR_CONNECTION", METRICS_MONITOR_CONNECTION);
            METRICS_MONITOR_EVENTS = Config.getBooleanProperty("METRICS_MONITOR_EVENTS", METRICS_MONITOR_EVENTS);
            METRICS_MONITOR_OUTPUT = Config.getProperty("METRICS_MONITOR_OUTPUT", METRICS_MONITOR_OUTPUT);
            DEBUG_METRICS_DISPLAY_INTERVAL = Config.getIntProperty("DEBUG_METRICS_DISPLAY_INTERVAL", 0);
            DEBUG_METRICS_COLLECTION_INTERVAL_SECS = Config.getIntProperty("DEBUG_METRICS_COLLECTION_INTERVAL_SECS", 0);
            REMOTE_RESTORE_THREAD_CAP = Config.getIntProperty("REMOTE_RESTORE_THREAD_CAP", REMOTE_RESTORE_THREAD_CAP);
            CLUSTERED_Q_PREFETCH_COUNT = Config.getIntProperty("CLUSTERED_Q_PREFETCH_COUNT", CLUSTERED_Q_PREFETCH_COUNT);
            CLUSTERED_Q_PREFETCH_THRESHOLD = Config.getIntProperty("CLUSTERED_Q_PREFETCH_THRESHOLD", CLUSTERED_Q_PREFETCH_THRESHOLD);
            CLUSTERED_Q_AGGRESSIVE_PREFETCH_THRESHOLD = Config.getIntProperty("CLUSTERED_Q_AGGRESSIVE_PREFETCH_THRESHOLD", CLUSTERED_Q_AGGRESSIVE_PREFETCH_THRESHOLD);
            MAX_CONNECTIONS_PER_USER = Config.getProperty("MAX_CONNECTIONS_PER_USER");
            MAX_CONNECTIONS_PER_USER_WARN_INTERVAL = Config.getProperty("MAX_CONNECTIONS_PER_USER_WARN_INTERVAL");
            ENABLE_REVERSE_DNS_LOOKUP = Config.getBooleanProperty("ENABLE_REVERSE_DNS_LOOKUP", true);
            if (LG_ENABLE = Config.getBooleanProperty("ACTIONAL_INTERCEPTOR", LG_ENABLE)) {
                InterceptorManager.updateLGDynamicProperty("INTERCEPTOR_DEBUG", m_properties.get("INTERCEPTOR_DEBUG"));
                InterceptorManager.updateLGDynamicProperty("EVENTS_LOG_FILE", m_properties.get("EVENTS_LOG_FILE"));
                InterceptorManager.updateLGDynamicProperty("PAYLOAD_CAPTURE", m_properties.get("PAYLOAD_CAPTURE"));
            }
            if (ENABLE_COMPRESSION) {
                CompressionFactory.getInstance(COMPRESSION_FACTORY);
            }
            if (!failure) {
                success = true;
                CONFIGURED = true;
            }
        }
        catch (NumberFormatException e) {
            Config.logMessage(prAccessor.getString("STR079"), 2);
        }
        LOG_FILE_1 = LOG_PATH + "recoverylog1.bin";
        LOG_FILE_2 = LOG_PATH + "recoverylog2.bin";
        TXN_FILE_PATH = LOG_PATH;
        TXN_FILE_FULLPATH_PREFIX = TXN_FILE_PATH + TXN_FILENAME_PREFIX;
        return success;
    }

    private static int updatePingInterval(int pingIntervalParam, int timeout) {
        int pingInterval = pingIntervalParam;
        if (pingInterval > timeout >> 1) {
            pingInterval = timeout >> 1;
        }
        return pingInterval;
    }

    public static final void loadDebugParameters(Properties props) {
        DEBUG = Config.getBooleanProperty("DEBUG", DEBUG, props);
        DS_DEBUG = Config.getBooleanProperty("DS_DEBUG", false, props);
        DEBUG_FT_CONNECTIONS = Config.getBooleanProperty("DEBUG_FT_CONNECTIONS", DEBUG_FT_CONNECTIONS, props);
        DebugState.setDebugThreadName(Config.getBooleanProperty("DEBUG_THREAD_NAME", false, props));
        DEBUG_NAME = Config.getProperty("DEBUG_NAME", null, props);
        DebugState.setDiagnosticLevel(Config.getIntProperty("DEBUG_DIAGNOSTICS", 0, props));
        DEBUG_CALLBACK = Config.getProperty("DEBUG_CALLBACK", null, props);
        SessionConfig.DEBUG_FILTERS = Config.getProperty("DEBUG_FILTERS", "", props);
        SessionConfig.FLOW_DEBUG = Config.getBooleanProperty("FLOW_DEBUG", SessionConfig.FLOW_DEBUG, props);
        DebugState.parse(DEBUG_NAME);
        DebugState.parseCallbacks(DEBUG_CALLBACK);
    }

    public static final String getAdminPrefix(String user_id, String application_id) {
        return "$ISYS.admin." + user_id + "." + application_id;
    }

    public static final String getUidFromAdminSubject(ISubject sub) {
        String subject = sub.getSubjectString();
        return subject.substring(12, subject.indexOf(".", 12));
    }

    public static final String getAppidFromAdminSubject(ISubject sub) {
        String subject = sub.getSubjectString();
        int start = subject.indexOf(".", 12) + 1;
        return subject.substring(start, subject.indexOf(".", start));
    }

    public static final String getProperty(String name) {
        return Config.getProperty(name, m_properties);
    }

    public static final String getProperty(String name, Properties properties) {
        String value = properties.getProperty(name);
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    public static final String getProperty(String name, String defaultValue) {
        return Config.getProperty(name, defaultValue, m_properties);
    }

    public static final String getProperty(String name, String defaultValue, Properties properties) {
        String value = properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return value.trim();
    }

    public static final boolean getBooleanProperty(String name, boolean defaultValue) {
        return Config.getBooleanProperty(name, defaultValue, m_properties);
    }

    public static final boolean getBooleanProperty(String name, boolean defaultValue, Hashtable properties) {
        Object value = properties.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(((String)value).trim());
    }

    public static final float getFloatProperty(String name, float defaultValue) {
        return Config.getFloatProperty(name, defaultValue, m_properties);
    }

    public static final float getFloatProperty(String name, float defaultValue, Hashtable properties) {
        Object value = properties.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        try {
            return Float.parseFloat(String.valueOf(value).trim());
        }
        catch (NumberFormatException nfe) {
            throw Config.createInvalidNumericError(name, nfe, value);
        }
    }

    public static final int getIntProperty(String name, int defaultValue) {
        return Config.getIntProperty(name, defaultValue, m_properties);
    }

    public static final int getIntProperty(String name, int defaultValue, Hashtable properties) {
        Object value = properties.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(String.valueOf(value).trim());
        }
        catch (NumberFormatException nfe) {
            throw Config.createInvalidNumericError(name, nfe, value);
        }
    }

    public static final long getLongProperty(String name, long defaultValue) {
        return Config.getLongProperty(name, defaultValue, m_properties);
    }

    public static final long getLongProperty(String name, long defaultValue, Hashtable properties) {
        Object value = properties.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        try {
            return Long.parseLong(String.valueOf(value).trim());
        }
        catch (NumberFormatException nfe) {
            throw Config.createInvalidNumericError(name, nfe, value);
        }
    }

    private static NumberFormatException createInvalidNumericError(String name, NumberFormatException nfe, Object value) {
        Object[] obj = new String[]{name, value.toString()};
        Config.logMessage(prMessageFormat.format(prAccessor.getString("INVALID_NUMERIC_PROPERTY"), obj), 2);
        return nfe;
    }

    public static final Properties getProperties() {
        return m_properties;
    }

    public static final void setProperties(Properties props) {
        m_properties = props;
    }

    public static void getHTTPProperties(Hashtable properties) {
        if (HTTP_DEBUG != null) {
            properties.put("HTTP_DEBUG", HTTP_DEBUG);
        }
        if (HTTP_MIN_THREADS != null) {
            properties.put("HTTP_MIN_THREADS", HTTP_MIN_THREADS);
        }
        if (HTTP_MAX_THREADS != null) {
            properties.put("HTTP_MAX_THREADS", HTTP_MAX_THREADS);
        }
        if (HTTP_THREAD_IDLE_TIMEOUT != null) {
            properties.put("HTTP_THREAD_IDLE_TIMEOUT", HTTP_THREAD_IDLE_TIMEOUT);
        }
        if (HTTP_CLIENT_IDLE_TIMEOUT != null) {
            properties.put("HTTP_CLIENT_IDLE_TIMEOUT", HTTP_CLIENT_IDLE_TIMEOUT);
        }
        if (HTTP_CLIENT_READ_TIMEOUT != null) {
            properties.put("HTTP_CLIENT_READ_TIMEOUT", HTTP_CLIENT_READ_TIMEOUT);
        }
        if (HTTP_BROKER_READ_TIMEOUT != null) {
            properties.put("HTTP_BROKER_READ_TIMEOUT", HTTP_BROKER_READ_TIMEOUT);
        }
    }

    public static void getSSLProperties(Hashtable properties) {
        if (SSL_PROVIDER_CLASS != null) {
            properties.put("SSL_PROVIDER_CLASS", SSL_PROVIDER_CLASS);
        }
        if (SSL_DEBUG != null) {
            properties.put("SSL_DEBUG", SSL_DEBUG);
        }
        String property = null;
        property = SSL_CERTIFICATE_CHAIN;
        if (property != null) {
            properties.put("SSL_CERTIFICATE_CHAIN", property);
        }
        if ((property = SSL_CERTIFICATE_CHAIN_FORM) != null) {
            properties.put("SSL_CERTIFICATE_CHAIN_FORM", property);
        }
        if ((property = SSL_PRIVATE_KEY) != null) {
            properties.put("SSL_PRIVATE_KEY", property);
        }
        if ((property = SSL_PRIVATE_KEY_PASSWORD) != null) {
            properties.put("SSL_PRIVATE_KEY_PASSWORD", property);
        }
        if ((property = SSL_CA_CERTIFICATES_DIR) != null) {
            properties.put("SSL_CA_CERTIFICATES_DIR", property);
        }
        if ((property = SSL_CIPHER_SUITES) != null) {
            properties.put("SSL_CIPHER_SUITES", property);
        }
        if ((property = SSL_TLS_PREFERRED_PROTOCOLS) != null) {
            properties.put("SSL_TLS_PREFERRED_PROTOCOLS", property);
        }
        if ((property = JSSE_KEYSTORE_KEY_ALIAS) != null) {
            properties.put("JSSE_KEYSTORE_ALIAS", property);
        }
        if ((property = JSSE_KEYSTORE_KEY_PASSWORD) != null) {
            properties.put("JSSE_KEYSTORE_KEY_PASSWORD", property);
        }
        if ((property = JSSE_KEYSTORE_LOCATION) != null) {
            properties.put("JSSE_KEYSTORE_LOCATION", property);
        }
        if ((property = JSSE_KEYSTORE_PASSWORD) != null) {
            properties.put("JSSE_KEYSTORE_PASSWORD", property);
        }
        if ((property = JSSE_KEYSTORE_TYPE) != null) {
            properties.put("JSSE_KEYSTORE_TYPE", property);
        }
        if ((property = JSSE_TRUSTSTORE_LOCATION) != null) {
            properties.put("JSSE_TRUSTSTORE_LOCATION", property);
        }
        if ((property = JSSE_TRUSTSTORE_PASSWORD) != null) {
            properties.put("JSSE_TRUSTSTORE_PASSWORD", property);
        }
        if ((property = JSSE_TRUSTSTORE_TYPE) != null) {
            properties.put("JSSE_TRUSTSTORE_TYPE", property);
        }
        if ((property = JSSE_TRUSTMANAGER) != null) {
            properties.put("JSSE_TRUSTMANAGER", property);
        }
        if ((property = JSSE_KEYMANAGER) != null) {
            properties.put("JSSE_KEYMANAGER", property);
        }
        property = SSL_ENABLE_TLSV1_ONLY ? "true" : "false";
        properties.put("ENABLE_TLSV1_ONLY", property);
        property = SSL_ENABLE_SSLV3_ONLY ? "true" : "false";
        properties.put("ENABLE_SSLV3_ONLY", property);
    }

    public static void getConnectionProperties(Hashtable properties) {
        if (properties == null) {
            return;
        }
        Config.getSSLProperties(properties);
        Config.getHTTPProperties(properties);
        if (PROXY_HOST != null && PROXY_PORT != null) {
            properties.put("TUNNELING_PROXY_HOST", PROXY_HOST);
            properties.put("TUNNELING_PROXY_PORT", PROXY_PORT);
            properties.put("TUNNELING_PROXY_PROTOCOL", PROXY_PROTOCOL);
            if (PROXY_USER_NAME != null) {
                properties.put("PROXY_USER_NAME", PROXY_USER_NAME);
            }
            if (PROXY_PASSWORD != null) {
                properties.put("PROXY_PASSWORD", PROXY_PASSWORD);
            }
        }
        if (DOMAIN_SUFFIX_SEARCH_ORDER != null) {
            properties.put("DOMAIN_SUFFIX_SEARCH_ORDER", DOMAIN_SUFFIX_SEARCH_ORDER);
        }
        properties.put("TCP_NODELAY", new Boolean(TCP_NODELAY));
        properties.put("DISABLE_NIO", new Boolean(DISABLE_NIO));
        properties.put("SOCKET_MAX_RCV_BUFFER_SIZE", new Integer(SOCKET_MAX_RCV_BUFFER_SIZE));
        properties.put("SOCKET_INITIAL_RCV_BUFFER_SIZE", new Integer(SOCKET_INITIAL_RCV_BUFFER_SIZE));
        properties.put("SOCKET_MIN_RCV_BUFFER_SIZE", new Integer(SOCKET_MIN_RCV_BUFFER_SIZE));
        properties.put("SOCKET_MAX_SEND_BUFFER_SIZE", new Integer(SOCKET_MAX_SEND_BUFFER_SIZE));
        properties.put("SOCKET_INITIAL_SEND_BUFFER_SIZE", new Integer(SOCKET_INITIAL_SEND_BUFFER_SIZE));
        properties.put("SOCKET_MIN_SEND_BUFFER_SIZE", new Integer(SOCKET_MIN_SEND_BUFFER_SIZE));
    }

    public static void getHTTPXProperties(Hashtable properties, int index) {
        Config.getXHTTPProperties(properties, index);
    }

    public static void getXHTTPProperties(Hashtable properties, int index) {
        String[][] acceptorHttpXProtocols = ACCEPTOR_HTTP_X_PROTOCOLS;
        String[][] acceptorHttpXFactories = ACCEPTOR_HTTP_X_FACTORIES;
        String[][] acceptorHttpXPropfiles = ACCEPTOR_HTTP_X_PROPFILES;
        String[] httpXProtocols = null;
        String[] httpXFactories = null;
        String[] httpXPropfiles = null;
        if (acceptorHttpXProtocols != null && acceptorHttpXProtocols[index] != null && acceptorHttpXFactories != null && acceptorHttpXFactories[index] != null && acceptorHttpXPropfiles != null && acceptorHttpXPropfiles[index] != null) {
            httpXProtocols = acceptorHttpXProtocols[index];
            httpXFactories = acceptorHttpXFactories[index];
            httpXPropfiles = acceptorHttpXPropfiles[index];
            int numHttpXProtocols = httpXProtocols.length;
            if (httpXFactories.length != numHttpXProtocols || httpXPropfiles.length != numHttpXProtocols) {
                return;
            }
            properties.put("HTTP_X_PROTOCOLS", httpXProtocols);
            properties.put("HTTP_X_FACTORIES", httpXFactories);
            properties.put("HTTP_X_PROPFILES", httpXPropfiles);
        }
    }

    public static void setStandAlone(boolean dbtool) {
        standAlone = dbtool;
    }

    static {
        MAJOR_VERSION = (short)12;
        MINOR_VERSION = 0;
        SERIAL_NUMBER = 0;
        PRODUCT_NAME = "SonicMQ";
        PRODUCT_NUMBER = 0;
        RELEASE = SessionConfig.RELEASE;
        RELEASE_BANNER = SessionConfig.RELEASE_BANNER;
        COPYRIGHT1 = prAccessor.getString("COPYRIGHT1");
        COPYRIGHT2 = prAccessor.getString("COPYRIGHT2");
        APP_NAME = prAccessor.getString("STR273");
        CONFIGURED = false;
        ENABLE_SECURITY = false;
        INI_FILE = DEFAULT_INI_FILE;
        CONFIG_CLASS = "<default>";
        ENABLE_INTERBROKER = false;
        ENABLE_ROUTING = false;
        ENABLE_HTTP_DIRECT = false;
        EVALUATION_MODE = false;
        ENABLE_REVERSE_DNS_LOOKUP = true;
        USE_DYNAMIC_HOST_BINDING = false;
        DEFAULT_BROKER_SUBJECT_CACHE = 64;
        MAX_BROKER_SUBJECT_CACHE = 3000;
        ENABLE_QOPSECURITY = true;
        ENABLE_ACCESS_MEDIATION = true;
        SET_JMSXUSERID = false;
        ENABLE_ACL_CHECK_AT_RESTORE = false;
        REALM = "ProgressRealm";
        PRELOAD_SECURITY_POLICIES = true;
        DEFAULT_QOP = 0;
        USE_DEFAULT_QOP = false;
        FT_START_ACTIVE = false;
        FT_PREFERRED_ACTIVE = 0;
        DUAL_ACTIVE_RESOLUTION = null;
        DUAL_ACTIVE_RESOLUTION_METRICS_PARAM = null;
        FT_FAILURE_DETECT_CALLBACK = null;
        FT_PING_TIMEOUT_MIN = 5000;
        FT_START_ACTIVE_PROPERTY = "sonicsw.mq.startactive";
        FT_BIND_HOST_ONLY_PROPERTY = "sonicsw.mq.ft.bindhostonly";
        REPLICATION_CHUNK_SIZE = 102400;
        REPLICATED = false;
        PRIMARY = false;
        FT_REPLICATE_NON_PERSISTENT = false;
        MCAST_LISTENER = new String("224.0.0.1");
        BROKER_CONNECT_TIMEOUT = 30000;
        BROKER_PING_INTERVAL = 60000;
        BROKER_PING_TIMEOUT = 120000;
        BROKER_PING_TIMEOUT_MIN = 30000;
        CONNECT_PING_TIMEOUT = 30000;
        REMOTE_BROKER_CONNECT_TIMEOUT = 180;
        REMOTE_BROKER_MONITOR_TIMEOUT = 120;
        REMOTE_BROKER_MONITOR_INTERVAL = 30;
        CLUSTERED_Q_PREFETCH_COUNT = 1;
        CLUSTERED_Q_PREFETCH_THRESHOLD = 0;
        CLUSTERED_Q_AGGRESSIVE_PREFETCH_THRESHOLD = -1;
        RESTART_THRESHOLD_METADATA = new MgramQueueConfig.Metadata("PS_FLOW_CONTROL_RESTART_THRESHOLD", 1000);
        OUTPUT_QUEUE = new MgramQueueConfig(new MgramQueueConfig.Metadata("OUTGOING_MSG_BUFFER_SIZE", "Outgoing Buffer Size", 150000), new MgramQueueConfig.Metadata("OUTGOING_MSG_BUFFER_MIN_SIZE", 5000), new MgramQueueConfig.Metadata("PRIORITY_OUTGOING_MSG_BUFFER_SIZE", 20000), RESTART_THRESHOLD_METADATA);
        GUAR_QUEUE = new MgramQueueConfig(new MgramQueueConfig.Metadata("PS_GUAR_MSG_BUFFER_SIZE", "Guaranteed Buffer Size", 150000), new MgramQueueConfig.Metadata("PS_GUAR_MSG_BUFFER_MIN_SIZE", 5000), new MgramQueueConfig.Metadata("PRIORITY_PS_GUAR_MSG_BUFFER_SIZE", 20000), RESTART_THRESHOLD_METADATA);
        WAIT_QUEUE = new MgramQueueConfig(new MgramQueueConfig.Metadata("WAIT_MSG_BUFFER_SIZE", "Wait Buffer Size", 75000), new MgramQueueConfig.Metadata("WAIT_MSG_BUFFER_MIN_SIZE", 2500), new MgramQueueConfig.Metadata("PRIORITY_WAIT_MSG_BUFFER_SIZE", 20000), RESTART_THRESHOLD_METADATA);
        TARGET_MESSAGE_SIZE = 10240;
        PS_DB_QUEUE_SIZE = 500000;
        REDELIVERY_BATCH_SIZE = 100;
        LOG_QUEUE_SIZE = 500000;
        LOG_QUEUE_COUNT = LOG_QUEUE_SIZE / TARGET_MESSAGE_SIZE;
        LOG_FLUSH_PRIORITY_BOOST = 0;
        FLOW_TO_DISK = false;
        FLOW_TO_DISK_NOTIFY = true;
        FLOW_TO_DISK_DISCARDABLE = false;
        CHECK_DB_SIZE_ON_PUBLISH = false;
        PTP_GUAR_MSG_BUFFER_LIMIT_CHECK = false;
        MAX_TOPIC_DB_SIZE = 0;
        TOPIC_DB_SIZE_RESTART_THRESHOLD = 1;
        MAX_FTD_MEMORY_SIZE = 32;
        ACKNOWLEDGE_MONITOR_INTERVAL = 0;
        PENDING_RETRIEVE_THRESHOLD = 10000;
        PENDING_SAVE_THRESHOLD = 15000;
        PENDING_MAX_QUEUE_SIZE = 0x1FFFFF;
        DISCONNECTED_PENDING_RETRIEVE_THRESHOLD = 500;
        DISCONNECTED_PENDING_SAVE_THRESHOLD = 1000;
        DISCONNECTED_PENDING_MAX_QUEUE_SIZE = 0x1FFFFF;
        FLOW_CONTROLLED_PENDING_RETRIEVE_THRESHOLD = 10000;
        FLOW_CONTROLLED_PENDING_SAVE_THRESHOLD = 15000;
        FLOW_CONTROLLED_PENDING_MAX_QUEUE_SIZE = 0x1FFFFF;
        MAX_ADMINISTRATIVELY_CREATED_QUEUE_SIZE = 1000;
        MAX_TEMPORARY_QUEUE_SIZE = 1000;
        FLOW_CONTROL_DEFAULT_NOTIFY_SIZE = 1024;
        FLOW_CONTROL_NOTIFY_SIZE = 50000;
        DFLT_MAX_QMSG_SAVER_ASYNC_CACHE_SIZE = 0x100000;
        PTP_DB_QUEUE_SIZE = 500000;
        PTP_DB_DELETEOP_SIZE = 100;
        PTP_DB_ASYNC_RETRIEVEOP_SIZE = 250;
        DELAYED_DELIVERY_INTERVAL = 1000;
        DURABLE_SUBSCRIBER_EXPIRATION_POLL_INTERVAL = 60;
        EXP_MSG_CLEAN_POLL_INTERVAL = 0;
        SLOW_SUBSCRIBER_MONITOR_POLL_INTERVAL = 0;
        SLOW_SUBSCRIBER_NOTIFY_THRESHOLD = 0L;
        BROKER_APPID_SCODE = SubjectUtil.computeSCode(BROKER_APPID, 0, BROKER_APPID.length());
        BROKER_UID = BROKER_APPID;
        BROKER_PWD = "SonicMQ";
        BROKER_CONFIG_APPID_SCODE = SubjectUtil.computeSCode(BROKER_CONFIG_APPID, 0, BROKER_CONFIG_APPID.length());
        ERROR_MSG_FILES_DIR = new String("..\\messages");
        DEFAULT_LANGUAGE = new String("us");
        DEFAULT_ERROR_PREFIX = "oherr";
        DEFAULT_ERROR_CAUSE = prAccessor.getString("STR069");
        DEFAULT_ERROR_ACTION = prAccessor.getString("STR070");
        DEFAULT_ERROR_TEXT = prAccessor.getString("STR071");
        LICENSE_KEY = new String(prAccessor.getString("STR072"));
        DAYS_TILL_WARNING = 45;
        CONTROL_NUMBER = null;
        PROVISION_SPI_CLASSNAME = PROVISION_SPI_CLASSNAME_DEFAULT = null;
        PROVISION_SPI_INTERVAL = PROVISION_SPI_INTERVAL_DEFAULT = 60;
        DATABASE_STORE_TYPE_EMBEDDED = new String("Embedded");
        MQSTORE_DB_CONNECT = new String("./SonicMQStore");
        DB_FORCE_SYNC = true;
        DB_MSG_CLEAN_THRESHOLD = 5000;
        EXP_MSG_CLEAN_THRESHOLD = 5000;
        DB_COMMIT_BATCH_SIZE = 100;
        DB_CLEANUP_BATCH_SIZE = 100;
        THROTTLE_PUBS_DURING_RESTORE = true;
        RESTORE_MSGS_FC_COUNT = 100;
        RESTORE_MSGS_COUNT = 100;
        BROKER_MAX_DELIVERY_COUNT = 0;
        ENABLE_WSRM_FLOW_CONTROL_NOTIFICATION = true;
        CLUSTER_PING_INTERVAL = 30000;
        CLUSTER_BROKER_PING_INTERVAL = 0;
        CLUSTER_PING_TIMEOUT = 0;
        CLUSTER_PING_TIMEOUT_MIN = 5000;
        DISABLE_DYNAMIC_GROUP_SUBSCRIPTION_DISTRIBUTION = false;
        GROUP_SUBSCRIPTIONS_MAINTENANCE_INTERVAL = 60;
        GROUP_SUBSCRIPTIONS_CIRCULATION_INTERVAL = GROUP_SUBSCRIPTIONS_MAINTENANCE_INTERVAL * 2;
        GROUP_SUBSCRIPTIONS_RECEIVER_IDLE_TIMEOUT = GROUP_SUBSCRIPTIONS_CIRCULATION_INTERVAL * 2;
        GROUP_SUBSCRIPTIONS_CIRCULATION_TIME_LIMIT = Math.min(GROUP_SUBSCRIPTIONS_MAINTENANCE_INTERVAL, 30);
        CLIENT_DEFAULT_FC_MONITOR_INTERVAL = 60;
        CLIENT_DEFAULT_FC_MONITOR_INTERVAL_MIN = 5;
        LOG_BUFFERED_BLOCKS = 16;
        LOG_FORCE_SYNC = true;
        LOG_OPEN_MODE = "rwd";
        LOG_FLUSH_DELAY = 5;
        TXN_BUFFER_SIZE = 32768;
        SERVICE_START_LOCAL_NUM = 0;
        SERVICE_START_LOCALS = null;
        SERVICE_CONFIG_PATH = null;
        ENABLE_HTTP = false;
        HTTP_PORT = 80;
        HTTP_CONNECTION_TIMEOUT = 30;
        METRICS_MONITOR_INTERVAL = 0;
        METRICS_MONITOR_CONNECTION = true;
        METRICS_MONITOR_APPID_SCODE = SubjectUtil.computeSCode(METRICS_MONITOR_APPID, 0, METRICS_MONITOR_APPID.length());
        METRICS_MONITOR_EVENTS = false;
        METRICS_MONITOR_OUTPUT = null;
        ENABLE_PUBLISH_TIMES = false;
        DEFAULT_SOCKET_TYPE = prAccessor.getString("STR073");
        ALT_SOCKET_TYPE = null;
        ALT_SOCKET_PORT = 0;
        SSL_PROVIDER_CLASS = null;
        SSL_CERTIFICATE_CHAIN = null;
        SSL_CERTIFICATE_CHAIN_FORM = null;
        SSL_PRIVATE_KEY = null;
        SSL_PRIVATE_KEY_PASSWORD = null;
        SSL_CIPHER_SUITES = null;
        SSL_CA_CERTIFICATES_DIR = null;
        SSL_TLS_PREFERRED_PROTOCOLS = null;
        SSL_CLIENT_AUTHENTICATION = null;
        SSL_DEBUG = null;
        SSL_DO_CRL_CHECKING = false;
        SSL_ENABLE_TLSV1_ONLY = false;
        SSL_ENABLE_SSLV3_ONLY = false;
        TUNNELING_PROXY_URL = null;
        PROXY_HOST = null;
        PROXY_PORT = null;
        PROXY_PROTOCOL = null;
        PROXY_USER_NAME = null;
        PROXY_PASSWORD = null;
        WS_SECURITY_DSIG_PREFIXLIST_REQUIRED = false;
        WS_RM_SEQUENCE_CONTROL_THREADS = 5;
        HTTP_DEBUG = null;
        HTTP_DEBUG_DEFAULT = false;
        HTTP_MIN_THREADS = null;
        HTTP_MAX_THREADS = null;
        HTTP_THREAD_IDLE_TIMEOUT = null;
        HTTP_CONNECTION_CLEANUP_INTERVAL = null;
        HTTP_CLIENT_IDLE_TIMEOUT = null;
        HTTP_CLIENT_READ_TIMEOUT = null;
        HTTP_BROKER_READ_TIMEOUT = null;
        DOMAIN_SUFFIX_SEARCH_ORDER = null;
        DS_DEBUG = false;
        IP_OR_HOSTS = null;
        ACCEPTOR_PORTS = null;
        ACCEPTOR_PROTOCOLS = null;
        ACCEPTOR_NAMES = null;
        ACCEPTOR_HTTP_X_PROTOCOLS = null;
        ACCEPTOR_HTTP_X_FACTORIES = null;
        ACCEPTOR_HTTP_X_PROPFILES = null;
        INTERBROKER_ACCEPTOR = 1;
        MFR_SERVER_ID = prAccessor.getString("STR074");
        MAX_CONNECTIONS = -1;
        MAX_SESSIONS_PER_CONNECTION = -1;
        MAX_TEMPORARY_QUEUES_PER_SESSION = -1;
        CONNECTION_ID_BLOCK_SIZE = 256;
        PAYLOAD_CHUNK_SIZE = 65536;
        ASYNCHRONOUS_REPLICATION = false;
        DEBUG_FT_CONNECTIONS = false;
        XONCE_RECOVERY = true;
        TCP_NODELAY = true;
        DISABLE_NIO = true;
        BROKER_SEND_DELAY = 5L;
        standAlone = false;
        REMOTE_RESTORE_THREAD_CAP = 100;
        MAX_SEND_IO_BUFFER_SIZE = SessionConfig.MAX_SEND_IO_BUFFER_SIZE;
        MIN_SEND_IO_BUFFER_SIZE = SessionConfig.MIN_SEND_IO_BUFFER_SIZE;
        INITIAL_SEND_IO_BUFFER_SIZE = SessionConfig.INITIAL_SEND_IO_BUFFER_SIZE;
        SOCKET_MIN_SEND_BUFFER_SIZE = SessionConfig.SOCKET_MIN_SEND_BUFFER_SIZE;
        SOCKET_MAX_SEND_BUFFER_SIZE = SessionConfig.SOCKET_MAX_SEND_BUFFER_SIZE;
        SOCKET_INITIAL_SEND_BUFFER_SIZE = SessionConfig.SOCKET_INITIAL_SEND_BUFFER_SIZE;
        MAX_RCV_IO_BUFFER_SIZE = SessionConfig.MAX_RCV_IO_BUFFER_SIZE;
        MIN_RCV_IO_BUFFER_SIZE = SessionConfig.MIN_RCV_IO_BUFFER_SIZE;
        INITIAL_RCV_IO_BUFFER_SIZE = SessionConfig.INITIAL_RCV_IO_BUFFER_SIZE;
        SOCKET_MIN_RCV_BUFFER_SIZE = SessionConfig.SOCKET_MIN_RCV_BUFFER_SIZE;
        SOCKET_MAX_RCV_BUFFER_SIZE = SessionConfig.SOCKET_MAX_RCV_BUFFER_SIZE;
        SOCKET_INITIAL_RCV_BUFFER_SIZE = SessionConfig.SOCKET_INITIAL_RCV_BUFFER_SIZE;
        ENABLE_CHECKSUM = false;
        ENABLE_COMPRESSION = true;
        COMPRESSION_FACTORY = SessionConfig.COMPRESSION_FACTORY;
        LG_ENABLE = false;
        LG_SERVER_INTERCEPTOR_CLASS = "com.sonicsw.interceptor.impls.actional.LGJMSServerInterceptor";
        SHARED_SUBS_RECOVERY_TIMEOUT = SHARED_SUBS_RECOVERY_TIMEOUT_DEFAULT = 60000L;
        MAX_MESSAGE_GROUPS = 128;
        MQTT_DELIVERY_TIMEOUT = 30000L;
        NO_SECURITY_MSG = prAccessor.getString("STR086") + prAccessor.getString("STR087");
        NO_INTERBROKER_MSG = prAccessor.getString("STR284") + prAccessor.getString("STR285");
    }

    public static class MgramQueueConfig {
        public int SIZE;
        public final Metadata SIZE_METADATA;
        public int MIN_SIZE;
        public final Metadata MIN_SIZE_METADATA;
        public int PRIORITY_SIZE;
        public final Metadata PRIORITY_SIZE_METADATA;
        public int RESTART_THRESHOLD;
        public final Metadata RESTART_THRESHOLD_METADATA;

        MgramQueueConfig(Metadata size, Metadata minSize, Metadata prioritySize, Metadata restartThreshold) {
            this.SIZE_METADATA = size;
            this.SIZE = size.DFLT;
            this.MIN_SIZE_METADATA = minSize;
            this.MIN_SIZE = minSize.DFLT;
            this.PRIORITY_SIZE_METADATA = prioritySize;
            this.PRIORITY_SIZE = prioritySize.DFLT;
            this.RESTART_THRESHOLD_METADATA = restartThreshold;
            this.RESTART_THRESHOLD = restartThreshold.DFLT;
        }

        void loadConfig() {
            this.loadConfig(Config.getProperties());
        }

        void loadConfig(Properties props) {
            this.SIZE = this.SIZE_METADATA.loadConfig(props);
            this.MIN_SIZE = this.MIN_SIZE_METADATA.loadConfig(props);
            this.PRIORITY_SIZE = this.PRIORITY_SIZE_METADATA.loadConfig(props);
            this.RESTART_THRESHOLD = this.RESTART_THRESHOLD_METADATA.loadConfig(props);
        }

        public static class Metadata {
            public static final String GROUP = "BROKER_CONNECTION_BUFFERS";
            public final String NAME;
            public final String DISPLAY_NAME;
            public final int DFLT;

            Metadata(String name, int dflt) {
                this.NAME = name;
                this.DISPLAY_NAME = "BROKER_CONNECTION_BUFFERS." + name;
                this.DFLT = dflt;
            }

            Metadata(String name, String displayName, int dflt) {
                this.NAME = name;
                this.DISPLAY_NAME = displayName;
                this.DFLT = dflt;
            }

            int loadConfig(Properties props) {
                return Config.getIntProperty(this.NAME, this.DFLT, props);
            }
        }
    }
}

