/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import java.util.HashMap;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.IMinEnqueuePriorityListener;
import progress.message.broker.PublishLimiter;
import progress.message.util.Queue;
import progress.message.zclient.DebugThread;

final class FlowControlSender
extends DebugThread {
    private ArrayList<PublishLimiter> m_publishers;
    private HashMap<PublishLimiter, Integer> m_publishersToPrios;
    private Queue m_minEnqPrioListeners;
    AgentRegistrar m_reg = null;
    private int count;
    private int add;
    private boolean DEBUG1 = (this.debugFlags & 0x40) > 0;

    FlowControlSender() {
        super("FlowControlSender");
        this.m_publishers = new ArrayList();
        this.m_publishersToPrios = new HashMap();
        this.m_minEnqPrioListeners = new Queue();
        this.m_reg = AgentRegistrar.getAgentRegistrar();
    }

    synchronized void sendFlowControl(PublishLimiter publisher, Integer minPriority) {
        if (!publisher.isPublisherAdminClient()) {
            Integer obj = this.m_publishersToPrios.put(publisher, minPriority);
            if (obj == null) {
                this.m_publishers.add(publisher);
            }
            if (this.DEBUG1) {
                ++this.count;
                if (obj == null) {
                    ++this.add;
                }
                if (this.count % 100000 == 0) {
                    this.debug("sendFlowControlMgram: Count = " + this.count + "; add= " + this.add + "; replace= " + (this.count - this.add) + " numPubs= " + this.m_publishers.size());
                    this.count = 0;
                    this.add = 0;
                }
            }
            this.notifyAll();
        }
    }

    synchronized void notifyIMinEnqPrioListener(IMinEnqueuePriorityListener iMinEnqPrioListener) {
        this.m_minEnqPrioListeners.enqueue(iMinEnqPrioListener);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() {
        PublishLimiter pub = null;
        int prio = 0;
        IMinEnqueuePriorityListener iMinEnqPrioListener = null;
        try {
            while (!Broker.exiting && !this.isInterrupted()) {
                FlowControlSender flowControlSender = this;
                synchronized (flowControlSender) {
                    while (this.m_publishers.isEmpty() && !Broker.exiting && this.m_minEnqPrioListeners.isEmpty()) {
                        this.wait();
                    }
                    if (!this.m_publishers.isEmpty()) {
                        pub = this.m_publishers.remove(0);
                        prio = this.m_publishersToPrios.remove(pub);
                    }
                    if (!this.m_minEnqPrioListeners.isEmpty()) {
                        iMinEnqPrioListener = (IMinEnqueuePriorityListener)this.m_minEnqPrioListeners.dequeue();
                    }
                }
                if (pub != null) {
                    pub.sendFlowControl((byte)prio);
                    pub = null;
                }
                if (iMinEnqPrioListener == null) continue;
                iMinEnqPrioListener.notifyMinEnqueuePriorityChange();
                iMinEnqPrioListener = null;
            }
        }
        catch (InterruptedException ie) {
            return;
        }
        finally {
            if (this.DEBUG) {
                this.debug("threadMain: thread exiting, broker exiting = " + Broker.exiting);
            }
        }
    }
}

