/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.impl.MetricInfo;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.sonicmq.util.action.Action;
import com.sonicsw.sonicmq.util.action.Event;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.BrokerStatus;
import progress.message.broker.Config;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.EStartupFailure;
import progress.message.broker.LogEvent;
import progress.message.broker.LogFile;
import progress.message.broker.LogFlushThread;
import progress.message.broker.StatsMetrics;
import progress.message.broker.SyncpointLoc;
import progress.message.broker.SyncpointThread;
import progress.message.broker.prAccessor;
import progress.message.db.EDatabaseException;
import progress.message.ft.ActionManager;
import progress.message.ft.ReplicationManager;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.QueueLimiter;

public final class LogManager
extends DebugObject
implements BrokerStatus {
    private AgentRegistrar m_reg;
    private ReplicationManager m_replMgr = null;
    private ActionManager m_actionMgr;
    private BrokerStateManager m_bsm;
    private long m_nextSeqno;
    private long m_lastSeqnoFlushed;
    private LogFile m_logFile;
    private boolean m_started;
    private long m_startupSeqno;
    private IStateEvent m_lastUnflushedEvt = null;
    private final LogLinkedList m_flushQueue = new LogLinkedList();
    private final LogLinkedList m_hpFlushQueue = new LogLinkedList();
    private final LogLinkedList m_loggedHpQueue = new LogLinkedList();
    private final LogLinkedList m_loggedQueue = new LogLinkedList();
    private final QueueLimiter m_limiter;
    private LogFlushThread m_flushThread;
    private FlushScheduler m_scheduler;
    private volatile boolean m_isFlushThreadShutdown;
    private long m_flushPointer;
    private long m_lastSeqnoAdded = -1L;
    private long m_lastEvtSeqnoEnqueued = -1L;
    private int m_numLastAdded;
    private int m_numLastRemoved;
    private static IMetricsRegistrar m_metricsManager;
    public static final IMetricIdentity BROKER_LOG_FLUSHCOUNT_METRIC;
    public static final IMetricIdentity BROKER_LOG_ADDCOUNT_METRIC;
    public static final IMetricIdentity BROKER_LOG_EVENTCOUNT_METRIC;
    public static final IMetricIdentity BROKER_LOG_REMOVECOUNT_METRIC;
    public static final IMetricIdentity BROKER_LOG_ADDEDPERFLUSH_METRIC;
    public static final IMetricIdentity BROKER_LOG_EVENTSPERFLUSH_METRIC;
    public static final IMetricIdentity BROKER_LOG_REMOVEDPERFLUSH_METRIC;
    public static final IMetricIdentity BROKER_LOG_FLUSHPERSECOND_METRIC;
    public static final IMetricIdentity BROKER_LOG_ADDEDPERSECOND_METRIC;
    public static final IMetricIdentity BROKER_LOG_EVENTSPERSECOND_METRIC;
    public static final IMetricIdentity BROKER_LOG_REMOVEDPERSECOND_METRIC;
    public static final IMetricIdentity BROKER_LOG_QUEUEFULLCOUNT_METRIC;
    public static final IMetricIdentity BROKER_LOG_SYNCCOUNT_METRIC;
    public static final IMetricIdentity BROKER_LOG_SIZEPERSYNC_METRIC;
    public static final IMetricIdentity BROKER_LOG_SYNCPERMINUTE_METRIC;
    private static IStatistic m_addCountStat;
    private static IStatistic m_eventCountStat;
    private static IStatistic m_removeCountStat;
    private static IStatistic m_flushCountStat;
    private static IStatistic m_queueFullStat;
    private static IStatistic m_syncCountStat;
    private static IStatistic m_syncSizeStat;
    private SyncpointThread m_syncThread;
    private Object m_flushThreadSync = new Object();
    private Object m_addEventSync = new Object();
    private boolean DEBUG1 = (this.debugFlags & 0x40) > 0;
    private boolean DEBUG0 = (this.debugFlags & 0x20) > 0;
    private boolean DEBUG_STATS = (this.debugFlags & 2) > 0 && StatsMetrics.areStatsEnabled(2);
    private int m_postprocessCtr;

    LogManager(AgentRegistrar reg) throws EStartupFailure {
        super(DebugState.GLOBAL_DEBUG_ON ? "LogManager" : null);
        this.m_reg = reg;
        this.m_logFile = null;
        this.m_limiter = new QueueLimiter(Config.LOG_QUEUE_SIZE);
        this.m_syncThread = new SyncpointThread(this, reg);
        this.m_syncThread.setDaemon(true);
        if (this.DEBUG1) {
            this.debug("LOG_QUEUE_SIZE = " + Config.LOG_QUEUE_SIZE);
            this.debug("LOG_QUEUE_COUNT = " + Config.LOG_QUEUE_COUNT);
            this.debug("LOG_FLUSH_DELAY = " + Config.LOG_FLUSH_DELAY);
            this.debug("LOG_FLUSH_PRIORITY_BOOST = " + Config.LOG_FLUSH_PRIORITY_BOOST);
        }
        this.m_bsm = BrokerStateManager.getBrokerStateManager();
        if (!Config.REPLICATED) {
            this.m_actionMgr = new ActionManager();
            this.m_actionMgr.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initLog(boolean reset) throws IOException {
        if (this.DEBUG0) {
            LogManager logManager = this;
            synchronized (logManager) {
                if (this.m_limiter.m_size > 0) {
                    this.debug("***** initLog " + reset + ": m_isFlushThreadShutdown= " + this.m_isFlushThreadShutdown + " limiterSize= " + this.m_limiter.m_size);
                }
                Object object = this.m_flushThreadSync;
                synchronized (object) {
                    int ct = this.m_loggedQueue.getSize();
                    if (ct > 0) {
                        this.debug("***** initLog " + reset + ": num events on m_loggedQueue= " + ct);
                    }
                    if ((ct = this.m_loggedHpQueue.getSize()) > 0) {
                        this.debug("***** initLog " + reset + ": num events on m_loggedHpQueue= " + ct);
                    }
                    if ((ct = this.m_hpFlushQueue.getSize()) > 0) {
                        this.debug("***** initLog " + reset + ": num events on m_hpFlushQueue= " + ct);
                    }
                    if ((ct = this.m_flushQueue.getSize()) > 0) {
                        this.debug("***** initLog " + reset + ": num events on m_flushQueue= " + ct);
                    }
                }
            }
        }
        if (this.m_flushThread != null) {
            this.uninitLog();
        }
        this.m_logFile = new LogFile();
        if (reset) {
            this.m_logFile.reset(this.m_reg.getBrokerDatabase().getLogTime());
            this.m_logFile.beginRead(null);
        } else {
            this.m_logFile.open();
        }
        this.m_flushThread = new LogFlushThread(this.m_reg, this, this.m_logFile, this.m_syncThread);
        this.m_flushThread.setDaemon(true);
        this.m_isFlushThreadShutdown = false;
        this.m_scheduler = new FlushScheduler();
        int flushPrio = this.m_flushThread.getPriority() + Config.LOG_FLUSH_PRIORITY_BOOST;
        if (flushPrio > 10) {
            flushPrio = 10;
        }
        this.m_flushThread.setPriority(flushPrio);
        this.resetLastSyncAdded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninitLog() throws IOException {
        if (this.m_flushThread != null && this.m_flushThread.isAlive()) {
            this.m_flushThread.shutdown();
            try {
                this.m_flushThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.m_flushThread = null;
        }
        if (this.m_scheduler != null) {
            this.m_scheduler.shutdown();
            this.m_scheduler = null;
        }
        if (this.m_logFile != null) {
            this.m_logFile.close();
            this.m_logFile = null;
        }
        if (this.DEBUG0) {
            LogManager logManager = this;
            synchronized (logManager) {
                if (this.m_limiter.m_size > 0) {
                    this.debug("***** uninitLog: m_isFlushThreadShutdown= " + this.m_isFlushThreadShutdown + " limiterSize= " + this.m_limiter.m_size);
                }
                Object object = this.m_flushThreadSync;
                synchronized (object) {
                    int ct = this.m_loggedQueue.getSize();
                    if (ct > 0) {
                        this.debug("***** uninitLog: num events on m_loggedQueue= " + ct);
                    }
                    if ((ct = this.m_loggedHpQueue.getSize()) > 0) {
                        this.debug("***** uninitLog: num events on m_loggedHpQueue= " + ct);
                    }
                    if ((ct = this.m_hpFlushQueue.getSize()) > 0) {
                        this.debug("***** uninitLog: num events on m_hpFlushQueue= " + ct);
                    }
                    if ((ct = this.m_flushQueue.getSize()) > 0) {
                        this.debug("***** initLog: num events on m_flushQueue= " + ct);
                    }
                }
            }
        }
    }

    public void verifyTimestamps() throws EStartupFailure {
        try {
            if (this.m_logFile.getTimestamp() != this.m_reg.getBrokerDatabase().getLogTime()) {
                throw new EStartupFailure(prAccessor.getString("STR217") + new Date(this.m_logFile.getTimestamp()) + ", database was initialized " + new Date(this.m_reg.getBrokerDatabase().getLogTime()) + ".");
            }
        }
        catch (EDatabaseException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("STR218") + e);
        }
    }

    void startup(long nextSeqno) {
        this.m_nextSeqno = nextSeqno;
        if (this.DEBUG1) {
            this.debug("starting with seqno = " + this.m_nextSeqno);
        }
        this.m_flushThread.start();
        this.m_scheduler.start();
        this.m_started = true;
        this.beginFlush();
    }

    void startSyncThread() {
        this.m_syncThread.start();
    }

    void shutdown() {
        if (this.m_syncThread != null) {
            this.m_syncThread.shutdown();
        }
        if (this.m_flushThread != null) {
            this.m_flushThread.shutdown();
        }
        if (this.m_actionMgr != null) {
            this.m_actionMgr.shutdown();
        }
        try {
            this.joinThread(this.m_syncThread);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.joinThread(this.m_flushThread);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.m_scheduler != null) {
            this.m_scheduler.shutdown();
        }
    }

    private <T0 extends DebugThread> void joinThread(T0 m_flushThread) throws InterruptedException {
        if (m_flushThread != null) {
            m_flushThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(IStateEvent evt, boolean flush) {
        int size = evt.memsize();
        Object object = this.m_addEventSync;
        synchronized (object) {
            this.addEventInternal(evt, size, flush);
        }
    }

    public void tryAddEvent(IStateEvent evt, boolean flush) throws ECannotFlushEvents {
        if (this.m_isFlushThreadShutdown) {
            throw new ECannotFlushEvents();
        }
        this.addEvent(evt, flush);
    }

    private synchronized void addEventInternal(IStateEvent evt, int size, boolean flush) {
        long seqno = -1L;
        if (!this.m_started) {
            if (this.DEBUG) {
                this.debug("not started yet, ignoring event: " + evt);
            }
            return;
        }
        if (this.DEBUG1 && !this.m_started) {
            this.debug("******* Writing to the log before log is started evt= " + evt);
            Thread.currentThread();
            Thread.dumpStack();
        }
        if (this.m_bsm.isWaiting() || !this.m_bsm.isActive()) {
            if (this.DEBUG) {
                this.debug("not ready yet, ignoring event: " + evt);
            }
            return;
        }
        this.addLimiter(size);
        if (!evt.hasValidSeqNo()) {
            if (evt.getNumSeqNos() > 1) {
                evt.setSeqNo(this.allocMultipleSeqNos(evt.getNumSeqNos()));
            } else {
                evt.setSeqNo(this.allocSeqNo());
            }
        }
        seqno = evt.getSeqNo();
        if (this.DEBUG) {
            this.debug("adding event: " + evt);
        }
        if (this.m_lastSeqnoAdded >= 0L && seqno <= this.m_lastSeqnoAdded) {
            throw new EAssertFailure("Log event " + seqno + " not in sequence. Last added = " + this.m_lastSeqnoAdded);
        }
        this.m_lastSeqnoAdded = seqno;
        if (Config.REPLICATED) {
            this.initReplication();
            boolean track = false;
            if (this.m_actionMgr.isActive()) {
                long replTracking = this.m_replMgr.allocTracking();
                evt.setActionTrackingNum(replTracking);
                boolean tracked = this.trackReplicationAck(evt);
                if (tracked) {
                    boolean replicated;
                    if (this.DEBUG) {
                        this.debug("Replicating Event: " + evt);
                    }
                    if (!(replicated = this.m_replMgr.replicateEvent(evt))) {
                        this.m_actionMgr.firePrecondition(replTracking, (short)1);
                    }
                }
            }
        } else if (evt.utilizeActionProcessor()) {
            this.trackXonceEvt(evt);
        }
        this.addToQueue(evt, seqno, flush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReplicatedEvent(IStateEvent evt, boolean flush) {
        long seqno = evt.getSeqNo();
        int size = evt.memsize();
        LogManager logManager = this;
        synchronized (logManager) {
            if (evt.isHighPriority()) {
                BrokerComponent.getComponentContext().logMessage((Throwable)new EAssertFailure("Unexpected high priority event in replication stream: " + evt), 2);
            }
            this.m_lastSeqnoAdded = seqno;
            this.m_nextSeqno = seqno + (long)evt.getNumSeqNos();
            this.addLimiter(size);
            this.addToQueue(evt, seqno, flush);
        }
    }

    private synchronized void addLimiter(int size) {
        try {
            while (!this.m_limiter.hasRoom(size)) {
                if (this.m_isFlushThreadShutdown) {
                    if (this.DEBUG) {
                        this.debug(Thread.currentThread().getName() + ": allows queue overflow - log flush thread not available.");
                    }
                    break;
                }
                if (this.DEBUG) {
                    this.debug(Thread.currentThread().getName() + " (" + Thread.currentThread().getPriority() + ") " + System.currentTimeMillis() + ": Event Queue Full, starting flushing");
                }
                this.updateStatistic(m_queueFullStat, 1L);
                this.beginFlush();
                this.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.m_limiter.add(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(IStateEvent evt, long seqno, boolean flush) {
        Object object = this.m_flushThreadSync;
        synchronized (object) {
            this.m_flushQueue.addToTail(evt);
            evt.setInQueue(true);
            ++this.m_numLastAdded;
            if (this.DEBUG1 && this.m_lastEvtSeqnoEnqueued >= 0L && seqno <= this.m_lastEvtSeqnoEnqueued) {
                this.debug("***** Log events enqueued out of sequence: new evtSeqno= " + seqno + " Last enqueued = " + this.m_lastEvtSeqnoEnqueued);
            }
            this.m_lastEvtSeqnoEnqueued = seqno;
            if (this.DEBUG) {
                this.debug(Thread.currentThread().getName() + " (" + Thread.currentThread().getPriority() + ") " + System.currentTimeMillis() + ": added " + evt + (flush ? " *FLUSH*" : "*NO-FLUSH*"));
            }
            if (flush) {
                if (evt.canBeDelayed()) {
                    this.m_scheduler.scheduleDelayedFlush(evt.getSeqNo());
                } else {
                    this.updateFlushPointer(seqno);
                }
            }
        }
    }

    private void initReplication() {
        if (this.m_replMgr == null) {
            this.m_replMgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
            this.m_actionMgr = this.m_replMgr.getActionManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEvent(IStateEvent evt) {
        if (Config.REPLICATED) {
            return;
        }
        if (evt.isHighPriority()) {
            return;
        }
        LogManager logManager = this;
        synchronized (logManager) {
            Object object = this.m_flushThreadSync;
            synchronized (object) {
                if (!evt.cancelLog()) {
                    return;
                }
                this.m_flushQueue.removeEvent(evt);
            }
            this.m_limiter.add(-evt.memsize());
            this.notifyAll();
            ++this.m_numLastRemoved;
        }
        if (this.DEBUG) {
            this.debug(Thread.currentThread().getName() + " (" + Thread.currentThread().getPriority() + ") " + System.currentTimeMillis() + ": removed " + evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IStateEvent getNextEvent(boolean wait) throws InterruptedException {
        Object object = this.m_flushThreadSync;
        synchronized (object) {
            IStateEvent next = null;
            if (this.m_loggedHpQueue.isEmpty() && this.m_loggedQueue.isEmpty()) {
                this.m_lastUnflushedEvt = null;
            }
            while (true) {
                if (!this.m_hpFlushQueue.isEmpty()) {
                    next = this.m_hpFlushQueue.removeHead();
                    break;
                }
                if (!(this.m_flushQueue.isEmpty() || this.m_flushQueue.head().getSeqNo() > this.m_flushPointer && this.m_flushQueue.head().canBeDelayed())) {
                    next = this.m_flushQueue.removeHead();
                    break;
                }
                if (!this.m_loggedHpQueue.isEmpty() || !this.m_loggedQueue.isEmpty() && this.m_loggedQueue.head().getSeqNo() <= this.m_flushPointer) {
                    return null;
                }
                if (!this.m_flushQueue.isEmpty() && !this.m_flushQueue.head().canBeDelayed()) {
                    next = this.m_flushQueue.removeHead();
                    break;
                }
                if (!this.m_loggedQueue.isEmpty()) {
                    return null;
                }
                LogManager logManager = this;
                if (logManager.m_bsm.isFaultTolerant() && !this.m_bsm.isActive()) {
                    this.m_flushThreadSync.wait(5000L);
                    continue;
                }
                this.m_flushThreadSync.wait();
            }
            if (next != null) {
                this.m_lastUnflushedEvt = next;
                next.startLog();
            }
            return next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void postProcessFlushedEvents() {
        int removed;
        int added;
        int count = 0;
        while (!this.m_loggedHpQueue.isEmpty()) {
            this.flushEvent(this.m_loggedHpQueue.removeHead());
            ++count;
        }
        int flushedSize = 0;
        int deferredFlushSize = 0;
        if (!this.m_loggedQueue.isEmpty()) {
            for (IStateEvent next = this.m_loggedQueue.head(); next != null; next = next.getNext()) {
                ++count;
                if (Config.REPLICATED && next.delayLogLimiterRelease()) {
                    deferredFlushSize += next.memsize();
                    continue;
                }
                flushedSize += next.memsize();
            }
        }
        LogManager logManager = this;
        synchronized (logManager) {
            if (!this.m_loggedQueue.isEmpty()) {
                this.m_limiter.add(-flushedSize);
                this.m_lastSeqnoFlushed = this.m_loggedQueue.tail().getSeqNo();
                this.notifyAll();
                if (this.DEBUG1) {
                    ++this.m_postprocessCtr;
                    if (this.m_postprocessCtr % 1000 == 0) {
                        if (this.m_limiter.m_size > 0) {
                            this.debug("postProcessFlushedEvents: loglimiterSize = " + this.m_limiter.m_size);
                        }
                        this.m_postprocessCtr = 0;
                    }
                }
            }
            added = this.m_numLastAdded;
            removed = this.m_numLastRemoved;
            this.m_numLastAdded = 0;
            this.m_numLastRemoved = 0;
        }
        this.updateStatistic(m_eventCountStat, count);
        this.updateStatistic(m_removeCountStat, removed);
        this.updateStatistic(m_addCountStat, added);
        this.updateStatistic(m_flushCountStat, 1L);
        while (!this.m_loggedQueue.isEmpty()) {
            this.flushEvent(this.m_loggedQueue.removeHead());
        }
        if (this.DEBUG) {
            this.debug(Thread.currentThread().getName() + " (" + Thread.currentThread().getPriority() + ") " + System.currentTimeMillis() + ": #### flushed: " + count + " added: " + added + " removed: " + removed);
        }
    }

    private void flushEvent(IStateEvent evt) {
        if (this.DEBUG) {
            this.debug("flushed evt = " + evt);
        }
        if (evt.isAction()) {
            long tracking = evt.getActionTrackingNum();
            this.m_actionMgr.firePrecondition(tracking, (short)0);
        } else {
            evt.exec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLimiter(IStateEvent evt) {
        if (Config.REPLICATED && evt.delayLogLimiterRelease()) {
            LogManager logManager = this;
            synchronized (logManager) {
                this.m_limiter.add(-evt.memsize());
                this.notifyAll();
            }
        }
    }

    private boolean trackReplicationAck(IStateEvent evt) {
        evt.setAction(true);
        Event actionEvent = new Event((Action)((Object)evt), 2);
        actionEvent.addPreCondition(this.m_actionMgr.getPreCondition((short)0));
        actionEvent.addPreCondition(this.m_actionMgr.getPreCondition((short)1));
        boolean result = this.m_actionMgr.addEvent(actionEvent, evt.getActionTrackingNum(), false);
        if (!result) {
            evt.setAction(false);
        }
        return result;
    }

    private void trackXonceEvt(IStateEvent evt) {
        evt.setAction(true);
        Event actionEvent = new Event((Action)((Object)evt), 1);
        actionEvent.addPreCondition(this.m_actionMgr.getPreCondition((short)0));
        this.m_actionMgr.addEvent(actionEvent, evt.getSeqNo(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFlush(LogEvent evt) throws InterruptedException {
        if (this.m_isFlushThreadShutdown) {
            throw new InterruptedException();
        }
        if (!evt.isHighPriority()) {
            this.updateFlushPointer(evt.getSeqNo());
        }
        if (Config.REPLICATED || evt.isHighPriority()) {
            evt.waitForFlush();
        } else {
            LogManager logManager = this;
            synchronized (logManager) {
                if (this.DEBUG) {
                    this.debug(Thread.currentThread().getName() + " (" + Thread.currentThread().getPriority() + ") " + System.currentTimeMillis() + ": waitForFlush called, seqno " + evt.getSeqNo());
                }
                long seqno = evt.getSeqNo();
                this.waitForFlush(seqno);
            }
        }
    }

    public synchronized void waitForFlush(long seqno) throws InterruptedException {
        while (this.m_lastSeqnoFlushed < seqno) {
            if (this.m_isFlushThreadShutdown) {
                throw new InterruptedException();
            }
            this.wait();
        }
        if (this.DEBUG) {
            this.debug(System.currentTimeMillis() + ": waitForFlush done, seqno " + seqno);
        }
    }

    public synchronized long allocSeqNo() {
        return this.m_nextSeqno++;
    }

    synchronized long allocMultipleSeqNos(int count) {
        this.m_nextSeqno += (long)count;
        return this.m_nextSeqno - (long)count;
    }

    public synchronized long getSeqNo() {
        return this.m_nextSeqno;
    }

    synchronized void setStartupSeqNo() {
        this.m_startupSeqno = this.m_nextSeqno;
    }

    synchronized long getStartupSeqNo() {
        return this.m_startupSeqno;
    }

    public synchronized long setSeqNo(long seqNo) {
        if (seqNo > this.m_nextSeqno) {
            this.m_nextSeqno = seqNo;
        }
        return this.m_nextSeqno;
    }

    public synchronized void resetLastSyncAdded() {
        this.m_lastSeqnoAdded = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beginFlush() {
        Object object = this.m_flushThreadSync;
        synchronized (object) {
            this.updateFlushPointer(this.m_nextSeqno - 1L);
        }
    }

    public void flush() throws InterruptedException {
        this.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean nointerrupt) throws InterruptedException {
        if (this.DEBUG) {
            this.debug(Thread.currentThread().getName() + " (" + Thread.currentThread().getPriority() + ") " + System.currentTimeMillis() + ": flush synchronous");
        }
        IStateEvent lastEventToFlush = null;
        Object object = this.m_flushThreadSync;
        synchronized (object) {
            lastEventToFlush = !this.m_flushQueue.isEmpty() ? this.m_flushQueue.tail() : (!this.m_hpFlushQueue.isEmpty() ? this.m_hpFlushQueue.tail() : this.m_lastUnflushedEvt);
            if (lastEventToFlush == null) {
                return;
            }
            if (this.m_isFlushThreadShutdown) {
                lastEventToFlush.setFlushUnflushable();
            }
            lastEventToFlush.setWaitingForFlush();
        }
        this.beginFlush();
        boolean interrupted = false;
        while (true) {
            try {
                lastEventToFlush.waitForFlush();
            }
            catch (InterruptedException ex) {
                if (this.DEBUG0 && this.m_isFlushThreadShutdown) {
                    this.debug("***** LogManager.flush interrupted; m_isFlushThreadShutdown=true" + Thread.currentThread().getName());
                }
                if (!nointerrupt) {
                    throw ex;
                }
                if (this.m_isFlushThreadShutdown) {
                    throw new RuntimeException("Cannot flush log");
                }
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public SyncpointLoc endSyncpoint() {
        return this.m_logFile.endSyncpoint();
    }

    public void newDbSyncpointLoc(SyncpointLoc sp) {
        this.m_logFile.newDbSyncpointLoc(sp);
    }

    public SyncpointLoc getSyncpointLoc() {
        return this.m_logFile.getSyncpointLoc();
    }

    public ActionManager getActionMgr() {
        return this.m_actionMgr;
    }

    void forceSyncpoint() {
        try {
            this.forceSyncpoint(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void forceSyncpoint(boolean wait) throws InterruptedException {
        this.m_syncThread.doSyncpoint(wait);
    }

    void forceSyncpoint(boolean waitForStart, boolean waitToComplete) throws InterruptedException {
        this.m_syncThread.doSyncpoint(waitForStart, waitToComplete);
    }

    long getLogFileSize() {
        return this.m_logFile.getSize();
    }

    int getSyncCount() {
        return this.m_syncThread.getCount();
    }

    void resetSyncCount() {
        this.m_syncThread.resetCount();
    }

    LogFile getLogFile() {
        return this.m_logFile;
    }

    public long getLastSyncsize() {
        return this.m_flushThread.getLastSyncsize();
    }

    long getLastPubSubSyncsize() {
        return this.m_syncThread.getLastPubSubSyncsize();
    }

    long getLastQueueSyncsize() {
        return this.m_syncThread.getLastQueueSyncsize();
    }

    public long getMaxLogFileSize() {
        return this.m_logFile.LogicalSize(Config.MAX_LOG_FILE_SIZE);
    }

    public boolean isEventPostProcessorThread(Thread t) {
        boolean result = t.equals(this.m_flushThread) || this.m_actionMgr != null && this.m_actionMgr.isActionProcessor(t);
        return result;
    }

    public static List getMetricsInfo() {
        if (Config.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("LogManager - getMetricsInfo ", 3);
        }
        ArrayList<IMetricInfo> infos = new ArrayList<IMetricInfo>();
        IMetricInfo info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_ADDCOUNT_METRIC, (short)0, (String)"Total number of log events added.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_REMOVECOUNT_METRIC, (short)0, (String)"Total number of log events removed.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_EVENTCOUNT_METRIC, (short)0, (String)"Total number of events written.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_FLUSHCOUNT_METRIC, (short)0, (String)"Total number of log flushes (disk syncs).", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_QUEUEFULLCOUNT_METRIC, (short)0, (String)"Total number of times the memory log queue was full.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_EVENTSPERFLUSH_METRIC, (short)5, (String)"Average number of log events written to disk per flush.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_REMOVEDPERFLUSH_METRIC, (short)5, (String)"Average number of log events removed per flush.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_ADDEDPERFLUSH_METRIC, (short)5, (String)"Average number of log events added per flush.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_FLUSHPERSECOND_METRIC, (short)8, (String)"Rate per second of log flushes (= disk syncs).", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_ADDEDPERSECOND_METRIC, (short)8, (String)"Rate per second of log events added.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_EVENTSPERSECOND_METRIC, (short)8, (String)"Rate per second of log events flushed to disk.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_REMOVEDPERSECOND_METRIC, (short)8, (String)"Rate per second of log events removed.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_SIZEPERSYNC_METRIC, (short)5, (String)"Average size of sync point.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_SYNCCOUNT_METRIC, (short)0, (String)"Total number of log syncs.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        info = MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_LOG_SYNCPERMINUTE_METRIC, (short)10, (String)"Rate per minute of log syncs.", null, (boolean)false, (boolean)true);
        ((MetricInfo)info).setHidden(true);
        infos.add(info);
        return infos;
    }

    public static synchronized void enableMetrics(IMetricsRegistrar metricsManager, IMetricIdentity[] ids) {
        if (Config.DEBUG) {
            String s = "";
            for (int i = 0; i < ids.length; ++i) {
                s = s + "\n - " + ids[i].getName();
            }
            BrokerComponent.getComponentContext().logMessage("LogManager - enableMetrics : " + s, 3);
        }
        m_metricsManager = metricsManager;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(BROKER_LOG_ADDCOUNT_METRIC) || ids[i].equals(BROKER_LOG_ADDEDPERFLUSH_METRIC) || ids[i].equals(BROKER_LOG_ADDEDPERSECOND_METRIC)) {
                if (m_addCountStat == null) {
                    m_addCountStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)2);
                }
                metricsManager.registerMetric(ids[i], m_addCountStat);
                continue;
            }
            if (ids[i].equals(BROKER_LOG_EVENTCOUNT_METRIC) || ids[i].equals(BROKER_LOG_EVENTSPERFLUSH_METRIC) || ids[i].equals(BROKER_LOG_EVENTSPERSECOND_METRIC)) {
                if (m_eventCountStat == null) {
                    m_eventCountStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)2);
                }
                metricsManager.registerMetric(ids[i], m_eventCountStat);
                continue;
            }
            if (ids[i].equals(BROKER_LOG_REMOVECOUNT_METRIC) || ids[i].equals(BROKER_LOG_REMOVEDPERFLUSH_METRIC) || ids[i].equals(BROKER_LOG_REMOVEDPERSECOND_METRIC)) {
                if (m_removeCountStat == null) {
                    m_removeCountStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)2);
                }
                metricsManager.registerMetric(ids[i], m_removeCountStat);
                continue;
            }
            if (ids[i].equals(BROKER_LOG_FLUSHCOUNT_METRIC) || ids[i].equals(BROKER_LOG_FLUSHPERSECOND_METRIC)) {
                m_flushCountStat = LogManager.createStatisticRegisterMetric(m_flushCountStat, metricsManager, ids, i);
                continue;
            }
            if (ids[i].equals(BROKER_LOG_QUEUEFULLCOUNT_METRIC)) {
                if (m_queueFullStat == null) {
                    m_queueFullStat = StatisticsFactory.createStatistic((short)2, (boolean)false, null, (short)0);
                }
                metricsManager.registerMetric(ids[i], m_queueFullStat);
                continue;
            }
            if (ids[i].equals(BROKER_LOG_SYNCCOUNT_METRIC) || ids[i].equals(BROKER_LOG_SYNCPERMINUTE_METRIC)) {
                m_syncCountStat = LogManager.createStatisticRegisterMetric(m_syncCountStat, metricsManager, ids, i);
                continue;
            }
            if (!ids[i].equals(BROKER_LOG_SIZEPERSYNC_METRIC)) continue;
            if (m_syncSizeStat == null) {
                m_syncSizeStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)2);
            }
            metricsManager.registerMetric(ids[i], m_syncSizeStat);
        }
    }

    private static IStatistic createStatisticRegisterMetric(IStatistic m_syncCountStatParam, IMetricsRegistrar metricsManager, IMetricIdentity[] ids, int i) {
        IStatistic m_syncCountStat = m_syncCountStatParam;
        if (m_syncCountStat == null) {
            m_syncCountStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
        }
        metricsManager.registerMetric(ids[i], m_syncCountStat);
        return m_syncCountStat;
    }

    public static synchronized void disableMetrics(IMetricsRegistrar metricsManager, IMetricIdentity[] ids) {
        if (Config.DEBUG) {
            String s = "";
            for (int i = 0; i < ids.length; ++i) {
                s = s + "\n - " + ids[i].getName();
            }
            BrokerComponent.getComponentContext().logMessage("LogManager - disabling Metrics : " + s, 3);
        }
        for (int i = 0; i < ids.length; ++i) {
            if (!ids[i].equals(BROKER_LOG_FLUSHCOUNT_METRIC) && !ids[i].equals(BROKER_LOG_ADDCOUNT_METRIC) && !ids[i].equals(BROKER_LOG_EVENTCOUNT_METRIC) && !ids[i].equals(BROKER_LOG_REMOVECOUNT_METRIC) && !ids[i].equals(BROKER_LOG_ADDEDPERFLUSH_METRIC) && !ids[i].equals(BROKER_LOG_EVENTSPERFLUSH_METRIC) && !ids[i].equals(BROKER_LOG_REMOVEDPERFLUSH_METRIC) && !ids[i].equals(BROKER_LOG_FLUSHPERSECOND_METRIC) && !ids[i].equals(BROKER_LOG_ADDEDPERSECOND_METRIC) && !ids[i].equals(BROKER_LOG_EVENTSPERSECOND_METRIC) && !ids[i].equals(BROKER_LOG_REMOVEDPERSECOND_METRIC) && !ids[i].equals(BROKER_LOG_QUEUEFULLCOUNT_METRIC) && !ids[i].equals(BROKER_LOG_SYNCCOUNT_METRIC) && !ids[i].equals(BROKER_LOG_SIZEPERSYNC_METRIC) && !ids[i].equals(BROKER_LOG_SYNCPERMINUTE_METRIC)) continue;
            metricsManager.unregisterMetric(ids[i]);
        }
    }

    private void updateStatistic(IStatistic statistic, long value) {
        IStatistic s = statistic;
        if (s != null) {
            s.updateValue(value);
        }
    }

    void updateSyncStats(long syncSize) {
        if (this.DEBUG) {
            this.debug("Updating sync stat = " + syncSize);
        }
        this.updateStatistic(m_syncSizeStat, syncSize);
        this.updateStatistic(m_syncCountStat, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighPriorityEvt(IStateEvent evt, boolean flush) {
        if (Config.REPLICATED || evt.utilizeActionProcessor()) {
            this.addEvent(evt, flush);
            return;
        }
        evt.setHighPriority();
        Object object = this.m_flushThreadSync;
        synchronized (object) {
            this.m_hpFlushQueue.addToTail(evt);
            ++this.m_numLastAdded;
            this.m_flushThreadSync.notifyAll();
        }
    }

    final void addLoggedEvent(IStateEvent evt) {
        if (evt.isHighPriority()) {
            this.m_loggedHpQueue.addToTail(evt);
        } else {
            this.m_loggedQueue.addToTail(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlushPointer(long seqno) {
        Object object = this.m_flushThreadSync;
        synchronized (object) {
            if (seqno > this.m_flushPointer) {
                this.m_flushPointer = seqno;
                this.m_flushThreadSync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFlushThreadShutdown(IStateEvent lastEvent) {
        LogManager logManager = this;
        synchronized (logManager) {
            this.m_isFlushThreadShutdown = true;
            Object object = this.m_flushThreadSync;
            synchronized (object) {
                int ct = this.m_loggedQueue.setAllEventsUnflushable(false);
                if (this.DEBUG0 && ct > 0) {
                    this.debug("***** onFlushThreadShutdown: events on m_loggedQueue= " + ct);
                }
                ct = this.m_loggedHpQueue.setAllEventsUnflushable(false);
                if (this.DEBUG0 && ct > 0) {
                    this.debug("***** onFlushThreadShutdown: events on m_loggedHpQueue= " + ct);
                }
                ct = this.m_hpFlushQueue.setAllEventsUnflushable(false);
                if (this.DEBUG0 && ct > 0) {
                    this.debug("***** onFlushThreadShutdown: events on m_hpFlushQueue= " + ct);
                }
                ct = this.m_flushQueue.setAllEventsUnflushable(false);
                if (this.DEBUG0 && ct > 0) {
                    this.debug("***** onFlushThreadShutdown: events on m_flushQueue= " + ct);
                }
                if (lastEvent != null) {
                    lastEvent.setFlushUnflushable();
                    if (this.DEBUG0) {
                        this.debug("***** onFlushThreadShutdown: marking last event Unflushable " + lastEvent.toString());
                    }
                }
            }
            this.notifyAll();
        }
    }

    static {
        BROKER_LOG_FLUSHCOUNT_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "FlushCount"});
        BROKER_LOG_ADDCOUNT_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "AddCount"});
        BROKER_LOG_EVENTCOUNT_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "EventCount"});
        BROKER_LOG_REMOVECOUNT_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "RemoveCount"});
        BROKER_LOG_ADDEDPERFLUSH_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "AddedPerFlush"});
        BROKER_LOG_EVENTSPERFLUSH_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "EventsPerFlush"});
        BROKER_LOG_REMOVEDPERFLUSH_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "RemovedPerFlush"});
        BROKER_LOG_FLUSHPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "FlushPerSecond"});
        BROKER_LOG_ADDEDPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "AddedPerSecond"});
        BROKER_LOG_EVENTSPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "EventsPerSecond"});
        BROKER_LOG_REMOVEDPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "RemovedPerSecond"});
        BROKER_LOG_QUEUEFULLCOUNT_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "queueFullCount"});
        BROKER_LOG_SYNCCOUNT_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "SyncCount"});
        BROKER_LOG_SIZEPERSYNC_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "SizePerSync"});
        BROKER_LOG_SYNCPERMINUTE_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "log", "SyncPerMinute"});
    }

    private class FlushScheduler
    implements Runnable {
        private boolean m_waitingToDelay = false;
        private long m_requestDelaySeqNo = -1L;
        Thread m_thread = null;

        private FlushScheduler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void scheduleDelayedFlush(long seqno) {
            if (Config.LOG_FLUSH_DELAY <= 0) {
                LogManager.this.updateFlushPointer(seqno);
            }
            FlushScheduler flushScheduler = this;
            synchronized (flushScheduler) {
                if (this.m_thread == null) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)new EAssertFailure("Delay scheduled while flush scheduler is not started, seq=" + seqno), 2);
                }
                if (seqno > this.m_requestDelaySeqNo) {
                    this.m_requestDelaySeqNo = seqno;
                }
                if (this.m_waitingToDelay) {
                    this.m_waitingToDelay = false;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentDelaySeqNo = -1L;
            while (!Thread.currentThread().isInterrupted()) {
                FlushScheduler flushScheduler = this;
                synchronized (flushScheduler) {
                    while (currentDelaySeqNo >= this.m_requestDelaySeqNo) {
                        try {
                            this.m_waitingToDelay = true;
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        finally {
                            this.m_waitingToDelay = false;
                        }
                    }
                    currentDelaySeqNo = this.m_requestDelaySeqNo;
                    try {
                        if (Config.LOG_FLUSH_DELAY > 0) {
                            this.wait(Config.LOG_FLUSH_DELAY);
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        currentDelaySeqNo = this.m_requestDelaySeqNo;
                    }
                }
                LogManager.this.updateFlushPointer(currentDelaySeqNo);
            }
        }

        public synchronized void start() {
            if (this.m_thread == null) {
                this.m_thread = new Thread((Runnable)this, "LogFlushScheduler");
                this.m_thread.setDaemon(true);
                this.m_thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Thread flushThread = null;
            FlushScheduler flushScheduler = this;
            synchronized (flushScheduler) {
                if (this.m_thread == null) {
                    return;
                }
                flushThread = this.m_thread;
                this.m_thread = null;
            }
            flushThread.interrupt();
            boolean interrupted = false;
            while (flushThread.isAlive()) {
                try {
                    flushThread.join();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class LogLinkedList {
        private IStateEvent m_head = null;
        private IStateEvent m_tail = null;
        private int m_size = 0;

        LogLinkedList() {
        }

        LogLinkedList(LogLinkedList list) {
            this.m_head = list.m_head;
            this.m_tail = list.m_tail;
            this.m_size = list.m_size;
        }

        private final void addToHead(IStateEvent evt) {
            if (this.m_head == null) {
                this.m_head = this.m_tail = evt;
            } else {
                this.m_head.setPrev(evt);
                evt.setNext(this.m_head);
                this.m_head = evt;
            }
            ++this.m_size;
        }

        private final void addToTail(IStateEvent evt) {
            if (this.m_tail == null) {
                this.m_tail = this.m_head = evt;
            } else {
                this.m_tail.setNext(evt);
                evt.setPrev(this.m_tail);
                this.m_tail = evt;
            }
            ++this.m_size;
        }

        private final void prepend(LogLinkedList source) {
            if (source.isEmpty()) {
                return;
            }
            if (this.m_head == null) {
                this.m_head = source.m_head;
                this.m_tail = source.m_tail;
            } else {
                this.m_head.setPrev(source.m_tail);
                source.m_tail.setNext(this.m_head);
                this.m_head = source.m_head;
            }
            this.m_size += source.m_size;
            source.m_head = null;
            source.m_tail = null;
            source.m_size = 0;
        }

        private final boolean isEmpty() {
            return this.m_head == null;
        }

        private boolean removeEvent(IStateEvent evt) {
            IStateEvent next = evt.getNext();
            IStateEvent prev = evt.getPrev();
            if (this.m_head == evt) {
                this.m_head = next;
            } else if (prev != null) {
                prev.setNext(next);
            }
            if (this.m_tail == evt) {
                this.m_tail = prev;
            } else if (next != null) {
                next.setPrev(prev);
            }
            --this.m_size;
            evt.setNext(null);
            evt.setPrev(null);
            return true;
        }

        private final LogLinkedList clear() {
            try {
                LogLinkedList logLinkedList = new LogLinkedList(this);
                return logLinkedList;
            }
            finally {
                this.m_tail = null;
                this.m_head = null;
                this.m_size = 0;
            }
        }

        private final IStateEvent head() {
            return this.m_head;
        }

        private final IStateEvent tail() {
            return this.m_tail;
        }

        private final IStateEvent removeHead() {
            IStateEvent ret = this.m_head;
            this.m_head = ret.getNext();
            if (this.m_head == null) {
                this.m_tail = null;
            } else {
                this.m_head.setPrev(null);
            }
            ret.setNext(null);
            --this.m_size;
            return ret;
        }

        private final int getSize() {
            return this.m_size;
        }

        private final int setAllEventsUnflushable(boolean clear) {
            int ct = 0;
            IStateEvent last = this.m_tail;
            for (IStateEvent evt = this.m_head; evt != null; evt = evt.getNext()) {
                evt.setFlushUnflushable();
                ++ct;
            }
            if (clear) {
                this.clear();
            }
            return ct;
        }
    }
}

