/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public final class ReplyAckEvt
extends LogEvent {
    private long m_requestId;
    private long m_id;
    private short m_eventType = (short)101;

    public ReplyAckEvt(long id, long requestId) {
        this.m_id = id;
        this.m_requestId = requestId;
    }

    public ReplyAckEvt() {
    }

    public long getId() {
        return this.m_id;
    }

    public long getRequestId() {
        return this.m_requestId;
    }

    @Override
    public short type() {
        return this.m_eventType;
    }

    @Override
    protected int memSizeBody() {
        return 16;
    }

    @Override
    public int serializedSizeBody() {
        return this.streamSizeBody();
    }

    @Override
    public int streamSizeBody() {
        return 16;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
        StreamUtil.writeLong(this.m_requestId, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        this.m_requestId = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoReplyAck(this);
    }

    @Override
    public String toString() {
        return super.toString() + "Client " + this.m_id + " acknowledge of reply " + this.m_requestId;
    }
}

