/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt;

import java.io.IOException;
import javax.jms.JMSException;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.broker.mqtt.proto.MqttTopic;
import progress.message.broker.mqtt.proto.PublishMessage;
import progress.message.jclient.DeliveryMode;
import progress.message.jimpl.BytesMessage;
import progress.message.jimpl.Topic;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;

public class MqttJmsUtils {
    public static final String JMS_SINGLE_LEVEL_WILDCARD = "*";
    public static final String JMS_TOPIC_LEVEL_SEPARATOR = ".";

    public static String convertToJmsTopic(String mqttTopic) {
        return mqttTopic.replace("+", JMS_SINGLE_LEVEL_WILDCARD).replace("/", JMS_TOPIC_LEVEL_SEPARATOR);
    }

    public static String convertToMqttTopic(String jmsTopic) {
        return jmsTopic.replace(JMS_SINGLE_LEVEL_WILDCARD, "+").replace(JMS_TOPIC_LEVEL_SEPARATOR, "/");
    }

    public static PublishMessage createMqttMessage(Envelope envelope, MqttQoS qos) {
        ISubject subject = envelope.getMessage().getSubject();
        String mqttTopic = MqttJmsUtils.convertToMqttTopic(subject.getSubjectString());
        PublishMessage message = new PublishMessage();
        message.setTopic(new MqttTopic(mqttTopic));
        message.setQos(qos);
        message.setDupFlag(envelope.isSuccessor());
        message.setRetainFlag(false);
        try {
            message.setPayload(envelope.getMessage().getBody());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return message;
    }

    public static Envelope createJmsMessage(PublishMessage message) {
        try {
            String jmsTopic = MqttJmsUtils.convertToJmsTopic(message.getTopic().getName());
            BytesMessage bytesMessage = new BytesMessage();
            bytesMessage.setJMSDestination(new Topic(jmsTopic));
            bytesMessage.setJMSDeliveryMode(MqttJmsUtils.convertJmsDeliveryMode(message.getQos()));
            bytesMessage.writeBytes(message.getPayload());
            return bytesMessage.getEnvelope();
        }
        catch (JMSException ex) {
            throw new MqttException(ex);
        }
    }

    public static int convertJmsAckMode(MqttQoS mqttQos) {
        if (mqttQos == MqttQoS.AT_LEAST_ONCE || mqttQos == MqttQoS.EXACTLY_ONCE) {
            return 1004;
        }
        return 1;
    }

    public static int convertJmsDeliveryMode(MqttQoS mqttQos) {
        if (mqttQos == MqttQoS.AT_MOST_ONCE) {
            return DeliveryMode.DISCARDABLE;
        }
        return 2;
    }
}

