/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import progress.message.broker.mqtt.MqttBrokerConnection;
import progress.message.broker.mqtt.MqttSession;
import progress.message.broker.mqtt.proto.MqttConnectException;

public final class MqttRegistrar {
    private static final Map<String, MqttSession> SESSIONS = new ConcurrentHashMap<String, MqttSession>();
    private static final Object LOCK = new Object();

    public static boolean isSessionPresent(String clientId) {
        return SESSIONS.containsKey(clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSession(String clientId, boolean remove) {
        Object object = LOCK;
        synchronized (object) {
            MqttSession session = SESSIONS.get(clientId);
            if (session != null) {
                try {
                    session.close(remove);
                }
                finally {
                    if (remove) {
                        SESSIONS.remove(clientId);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSessionCount() {
        Object object = LOCK;
        synchronized (object) {
            return SESSIONS.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Object object = LOCK;
        synchronized (object) {
            try {
                for (MqttSession session : SESSIONS.values()) {
                    session.close(true);
                }
            }
            finally {
                SESSIONS.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MqttSession restoreSession(MqttBrokerConnection connection, String clientId, String username, String password) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            MqttSession session = SESSIONS.get(clientId);
            if (session == null) {
                throw new MqttConnectException("Can't restore session for client id = " + clientId, 5);
            }
            connection.getSender().reEnqueue(session.getConnection().getSender().getQueue());
            session.restore(connection, username, password);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MqttSession createSession(MqttBrokerConnection connection, String clientId, String username, String password) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            MqttRegistrar.clearSession(clientId, true);
            MqttSession session = MqttSession.createAgentSession(clientId);
            session.connect(connection, username, password);
            SESSIONS.put(clientId, session);
            return session;
        }
    }
}

