/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import progress.message.broker.parser.EvalException;
import progress.message.broker.parser.EvalNumberException;
import progress.message.broker.parser.Selector;
import progress.message.broker.parser.SimpleNode;
import progress.message.broker.parser.Token;
import progress.message.msg.IMgram;

public class NumericComparison
extends SimpleNode {
    Token operator;

    public NumericComparison(int id) {
        super(id);
    }

    public NumericComparison(Selector p, int id) {
        super(p, id);
    }

    @Override
    public Object eval(IMgram m) throws EvalException {
        Object value = ((SimpleNode)this.children[0]).eval(m);
        if (value == null) {
            return null;
        }
        Number lhs = (Number)value;
        value = ((SimpleNode)this.children[1]).eval(m);
        if (value == null) {
            return null;
        }
        Number rhs = (Number)value;
        try {
            if (this.operator.kind == 21) {
                if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                    return new Boolean(lhs.doubleValue() == rhs.doubleValue());
                }
                return new Boolean(lhs.longValue() == rhs.longValue());
            }
            if (this.operator.kind == 22) {
                if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                    return new Boolean(lhs.doubleValue() != rhs.doubleValue());
                }
                return new Boolean(lhs.longValue() != rhs.longValue());
            }
            if (this.operator.kind == 23) {
                if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                    return new Boolean(lhs.doubleValue() > rhs.doubleValue());
                }
                return new Boolean(lhs.longValue() > rhs.longValue());
            }
            if (this.operator.kind == 24) {
                if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                    return new Boolean(lhs.doubleValue() >= rhs.doubleValue());
                }
                return new Boolean(lhs.longValue() >= rhs.longValue());
            }
            if (this.operator.kind == 25) {
                if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                    return new Boolean(lhs.doubleValue() < rhs.doubleValue());
                }
                return new Boolean(lhs.longValue() < rhs.longValue());
            }
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                return new Boolean(lhs.doubleValue() <= rhs.doubleValue());
            }
            return new Boolean(lhs.longValue() <= rhs.longValue());
        }
        catch (NumberFormatException ne) {
            throw new EvalNumberException(this.makeErrorMessage(lhs, rhs));
        }
    }

    private String makeErrorMessage(Number l, Number r) {
        StringBuffer sb = new StringBuffer("Error in Numeric Comparison. lhs: ");
        sb.append(this.getType(l)).append(this.getValueString(l));
        sb.append("; rhs: ").append(this.getType(r)).append(this.getValueString(r));
        return sb.toString();
    }

    private String getType(Number n) {
        if (n instanceof Byte) {
            return "Byte ";
        }
        if (n instanceof Double) {
            return "Double ";
        }
        if (n instanceof Float) {
            return "Float ";
        }
        if (n instanceof Integer) {
            return "Integer ";
        }
        if (n instanceof Long) {
            return "Long ";
        }
        if (n instanceof Short) {
            return "Short ";
        }
        if (n instanceof BigInteger) {
            return "BigInteger ";
        }
        if (n instanceof BigDecimal) {
            return "BigDecimal ";
        }
        return "unknown type ";
    }

    private String getValueString(Number n) {
        try {
            if (n instanceof Byte) {
                return ((Byte)n).toString();
            }
            if (n instanceof Double) {
                return ((Double)n).toString();
            }
            if (n instanceof Float) {
                return ((Float)n).toString();
            }
            if (n instanceof Integer) {
                return ((Integer)n).toString();
            }
            if (n instanceof Long) {
                return ((Long)n).toString();
            }
            if (n instanceof Short) {
                return ((Short)n).toString();
            }
            if (n instanceof BigInteger) {
                return ((BigInteger)n).toString();
            }
            if (n instanceof BigDecimal) {
                return ((BigDecimal)n).toString();
            }
            return "unknown value ";
        }
        catch (Exception e) {
            return "Exception in getting number string " + e.getMessage();
        }
    }
}

