/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse;

import com.odi.Database;
import com.odi.Session;
import com.odi.util.IndexIterator;
import com.odi.util.OSHashtable;
import java.util.Iterator;
import progress.message.dbsc.pse.ILog;
import progress.message.dbsc.pse.pc.gr.PSERouteHolder;
import progress.message.dbsc.pse.pc.gr.PSERouteInfo;
import progress.message.ps.util.Sorter;
import progress.message.util.EAssertFailure;

public class DbSchemaCheckGr {
    Database m_db;
    ILog m_logger;

    public DbSchemaCheckGr(Database db, ILog log) {
        this.m_db = db;
        this.m_logger = log;
    }

    public void checkDb() {
        Session sess = Session.getCurrent();
        if (sess == null) {
            throw new EAssertFailure("No current Session");
        }
        if (!sess.inTransaction()) {
            throw new EAssertFailure("No current Transaction");
        }
        this.m_logger.logln("\nChecking Gr Schema...");
        this.dumpRoutingInfo();
        this.m_logger.logln("\nCompleted Checking Gr Schema.");
    }

    private void dumpRoutingInfo() {
        OSHashtable ht = (OSHashtable)this.m_db.getRoot("RouteInfo");
        Iterator itk = ht.keySet().iterator();
        String[] strkeys = new String[ht.keySet().size()];
        int j = 0;
        while (itk.hasNext()) {
            strkeys[j] = (String)itk.next();
            ++j;
        }
        this.m_logger.logln("Got array of keys; ct= " + strkeys.length);
        Sorter.sort(strkeys);
        IndexIterator it = ht.elements();
        int routeCt = 0;
        int numDetail = 0;
        for (int i = 0; i < strkeys.length; ++i) {
            PSERouteHolder rh = (PSERouteHolder)ht.get((Object)strkeys[i]);
            routeCt += rh.getCountRoutes();
            StringBuffer buf = new StringBuffer();
            buf.append("key= " + strkeys[i]);
            buf.append(" GlobalName= " + rh.getGlobalName() + " rn= " + rh.getRoutingNodeName() + " Brokers= ");
            this.m_logger.logln(buf.toString());
            Iterator itr = rh.getRoutes();
            while (itr.hasNext()) {
                PSERouteInfo pri = (PSERouteInfo)itr.next();
                String bn = pri.getBrokerName();
                if (pri.getBrokerName() == null) {
                    bn = "<null>";
                }
                buf.append(bn);
                buf.append(", ");
                this.m_logger.logln(pri.toStringAll());
            }
        }
        this.m_logger.logln("count of RouteHolders= " + strkeys.length + " countRoutes= " + routeCt + " numDetail= " + numDetail);
    }
}

