/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse.pc.gr;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectReference;
import java.util.Date;
import progress.message.db.pse.PSEBrokerDb;

public class PSERouteInfo
implements IPersistent,
IPersistentHooks {
    private String _BrokerName;
    private String _ConnectionURLs;
    private String _UserName;
    private byte[] _UserPassword;
    private boolean _LoadBalance;
    private boolean _Sequential;
    private int _Timeout;
    private boolean _ForwardRoutings;
    private boolean _StaticRouting;
    private String _ConnectionBrokerName;
    private long _CreateTime;
    private int _NetworkHops;
    private String _SendingBrokerName;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = PSERouteInfo.getClassInfoInstance();

    public PSERouteInfo(String brokerName) {
        this._BrokerName = new String(brokerName);
    }

    public String getBrokerName() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._BrokerName;
    }

    public void setConnectionURLs(String connectionURLs) {
        PSERouteInfo pSERouteInfo;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        String oldS = this._ConnectionURLs;
        String newS = connectionURLs;
        if (oldS != null) {
            if (oldS.equals(newS)) {
                return;
            }
            ObjectStore.destroy((Object)oldS);
        }
        if (((pSERouteInfo = this).ODIObjectState & 2) != 0) {
            pSERouteInfo = pSERouteInfo;
            ObjectStore.dirty((IPersistent)pSERouteInfo);
        }
        pSERouteInfo._ConnectionURLs = new String(connectionURLs);
    }

    public void setUserName(String userName) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        String oldS = this._UserName;
        String newS = userName;
        if (oldS != null) {
            if (oldS.equals(newS)) {
                return;
            }
            ObjectStore.destroy((Object)oldS);
        }
        if (newS != null) {
            PSERouteInfo pSERouteInfo;
            if (((pSERouteInfo = this).ODIObjectState & 2) != 0) {
                pSERouteInfo = pSERouteInfo;
                ObjectStore.dirty((IPersistent)pSERouteInfo);
            }
            pSERouteInfo._UserName = new String(newS);
        } else {
            PSERouteInfo pSERouteInfo;
            if (((pSERouteInfo = this).ODIObjectState & 2) != 0) {
                pSERouteInfo = pSERouteInfo;
                ObjectStore.dirty((IPersistent)pSERouteInfo);
            }
            pSERouteInfo._UserName = null;
        }
    }

    public void setUserPassword(byte[] pw) {
        PSERouteInfo pSERouteInfo;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        byte[] newBytes = null;
        if (pw != null) {
            newBytes = new byte[pw.length];
            if (pw.length > 0) {
                ObjectStore.fetch((Object)pw);
                ObjectStore.dirty((Object)newBytes);
                System.arraycopy(pw, 0, newBytes, 0, pw.length);
            }
        }
        if (this._UserPassword != null) {
            ObjectStore.destroy((Object)this._UserPassword);
        }
        if (((pSERouteInfo = this).ODIObjectState & 2) != 0) {
            pSERouteInfo = pSERouteInfo;
            ObjectStore.dirty((IPersistent)pSERouteInfo);
        }
        pSERouteInfo._UserPassword = newBytes;
    }

    public void setLoadBalance(boolean loadBalance) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._LoadBalance = loadBalance;
    }

    public void setSequential(boolean sequential) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._Sequential = sequential;
    }

    public void setTimeout(int timeout) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._Timeout = timeout;
    }

    public void setForwardRoutings(boolean forwardRoutings) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._ForwardRoutings = forwardRoutings;
    }

    public void setStaticRouting(boolean staticRouting) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._StaticRouting = staticRouting;
    }

    public void setConnectionBrokerName(String connectionBrokerName) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        String oldS = this._ConnectionBrokerName;
        String newS = connectionBrokerName;
        if (oldS != null) {
            if (oldS.equals(newS)) {
                return;
            }
            ObjectStore.destroy((Object)oldS);
        }
        if (newS != null) {
            PSERouteInfo pSERouteInfo;
            if (((pSERouteInfo = this).ODIObjectState & 2) != 0) {
                pSERouteInfo = pSERouteInfo;
                ObjectStore.dirty((IPersistent)pSERouteInfo);
            }
            pSERouteInfo._ConnectionBrokerName = new String(connectionBrokerName);
        } else {
            PSERouteInfo pSERouteInfo;
            if (((pSERouteInfo = this).ODIObjectState & 2) != 0) {
                pSERouteInfo = pSERouteInfo;
                ObjectStore.dirty((IPersistent)pSERouteInfo);
            }
            pSERouteInfo._ConnectionBrokerName = null;
        }
    }

    public void setCreateTime(Date createTime) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (createTime == null) {
            PSERouteInfo pSERouteInfo;
            if (((pSERouteInfo = this).ODIObjectState & 2) != 0) {
                pSERouteInfo = pSERouteInfo;
                ObjectStore.dirty((IPersistent)pSERouteInfo);
            }
            pSERouteInfo._CreateTime = PSEBrokerDb.PSE_NULL_DATE;
        } else {
            PSERouteInfo pSERouteInfo;
            if (((pSERouteInfo = this).ODIObjectState & 2) != 0) {
                pSERouteInfo = pSERouteInfo;
                ObjectStore.dirty((IPersistent)pSERouteInfo);
            }
            pSERouteInfo._CreateTime = createTime.getTime();
        }
    }

    public void setNetworkHops(int networkHops) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._NetworkHops = networkHops;
    }

    public void setSendingBrokerName(String sendingBrokerName) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        String oldS = this._SendingBrokerName;
        String newS = sendingBrokerName;
        if (oldS != null) {
            if (oldS.equals(newS)) {
                return;
            }
            ObjectStore.destroy((Object)oldS);
        }
        if (newS != null) {
            PSERouteInfo pSERouteInfo;
            if (((pSERouteInfo = this).ODIObjectState & 2) != 0) {
                pSERouteInfo = pSERouteInfo;
                ObjectStore.dirty((IPersistent)pSERouteInfo);
            }
            pSERouteInfo._SendingBrokerName = new String(newS);
        } else {
            PSERouteInfo pSERouteInfo;
            if (((pSERouteInfo = this).ODIObjectState & 2) != 0) {
                pSERouteInfo = pSERouteInfo;
                ObjectStore.dirty((IPersistent)pSERouteInfo);
            }
            pSERouteInfo._SendingBrokerName = null;
        }
    }

    public String getConnectionURLs() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._ConnectionURLs;
    }

    public String getUserName() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._UserName;
    }

    public byte[] getUserPassword() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._UserPassword;
    }

    public boolean getLoadBalance() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._LoadBalance;
    }

    public boolean getSequential() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._Sequential;
    }

    public int getTimeout() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._Timeout;
    }

    public boolean getForwardRoutings() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._ForwardRoutings;
    }

    public boolean getStaticRouting() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._StaticRouting;
    }

    public String getConnectionBrokerName() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._ConnectionBrokerName;
    }

    public Date getCreateTime() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this._CreateTime == PSEBrokerDb.PSE_NULL_DATE) {
            return null;
        }
        return new Date(this._CreateTime);
    }

    public int getNetworkHops() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._NetworkHops;
    }

    public String getSendingBrokerName() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._SendingBrokerName;
    }

    public void postInitializeContents() {
        if (this._UserPassword != null) {
            ObjectStore.fetch((byte[])this._UserPassword);
        }
    }

    public void preDestroyPersistent() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ObjectStore.destroy((Object)this._BrokerName);
        ObjectStore.destroy((Object)this._ConnectionURLs);
        ObjectStore.destroy((Object)this._UserName);
        ObjectStore.destroy((Object)this._UserPassword);
        ObjectStore.destroy((Object)this._ConnectionBrokerName);
        ObjectStore.destroy((Object)this._SendingBrokerName);
    }

    public String toStringAll() {
        StringBuffer buf = new StringBuffer("PSERouteInfo: ");
        buf.append("\tBrokerName: " + this.getBrokerName());
        buf.append("\tConnURLS: " + this.getConnectionURLs());
        buf.append("\n\tUserName: " + this.getUserName());
        buf.append("\tPW: " + (this.getUserPassword() == null ? null : "Size= " + this.getUserPassword().length));
        buf.append("\tLB: " + this.getLoadBalance());
        buf.append("\tSeq: " + this.getSequential());
        buf.append("\tTimeout: " + this.getTimeout());
        buf.append("\n\tForwardRoutings: " + this.getForwardRoutings());
        buf.append("\tStaticRouting: " + this.getStaticRouting());
        buf.append("\tConnBrokerName: " + this.getConnectionBrokerName());
        buf.append("\tCreateTime: " + this.getCreateTime());
        buf.append("\tNetworkHops: " + this.getNetworkHops());
        buf.append("\tSendingBrokerName: " + this.getSendingBrokerName());
        return buf.toString();
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((PSERouteInfo)super.clone()).ODIref = null;
        ((PSERouteInfo)super.clone()).ODIObjectState = 0;
        return (PSERouteInfo)super.clone();
    }

    public void preFlushContents() {
    }

    public void preClearContents() {
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this._BrokerName = genericObject.getStringField(1, classInfo);
        this._ConnectionURLs = genericObject.getStringField(2, classInfo);
        this._UserName = genericObject.getStringField(3, classInfo);
        this._UserPassword = (byte[])genericObject.getArrayField(4, classInfo);
        this._LoadBalance = genericObject.getBooleanField(5, classInfo);
        this._Sequential = genericObject.getBooleanField(6, classInfo);
        this._Timeout = genericObject.getIntField(7, classInfo);
        this._ForwardRoutings = genericObject.getBooleanField(8, classInfo);
        this._StaticRouting = genericObject.getBooleanField(9, classInfo);
        this._ConnectionBrokerName = genericObject.getStringField(10, classInfo);
        this._CreateTime = genericObject.getLongField(11, classInfo);
        this._NetworkHops = genericObject.getIntField(12, classInfo);
        this._SendingBrokerName = genericObject.getStringField(13, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setStringField(1, this._BrokerName, classInfo);
        genericObject.setStringField(2, this._ConnectionURLs, classInfo);
        genericObject.setStringField(3, this._UserName, classInfo);
        genericObject.setArrayField(4, (Object)this._UserPassword, classInfo);
        genericObject.setBooleanField(5, this._LoadBalance, classInfo);
        genericObject.setBooleanField(6, this._Sequential, classInfo);
        genericObject.setIntField(7, this._Timeout, classInfo);
        genericObject.setBooleanField(8, this._ForwardRoutings, classInfo);
        genericObject.setBooleanField(9, this._StaticRouting, classInfo);
        genericObject.setStringField(10, this._ConnectionBrokerName, classInfo);
        genericObject.setLongField(11, this._CreateTime, classInfo);
        genericObject.setIntField(12, this._NetworkHops, classInfo);
        genericObject.setStringField(13, this._SendingBrokerName, classInfo);
    }

    public void clearContents() {
        this._BrokerName = null;
        this._ConnectionURLs = null;
        this._UserName = null;
        this._UserPassword = null;
        this._LoadBalance = false;
        this._Sequential = false;
        this._Timeout = 0;
        this._ForwardRoutings = false;
        this._StaticRouting = false;
        this._ConnectionBrokerName = null;
        this._CreateTime = 0L;
        this._NetworkHops = 0;
        this._SendingBrokerName = null;
    }

    public PSERouteInfo(ClassInfo classInfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        try {
            return ClassInfo.get(Class.forName("progress.message.dbsc.pse.pc.gr.PSERouteInfo"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

