/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.IClientContext;
import progress.message.broker.fc.FCEvent;

public class IBFCEvent
extends FCEvent {
    IClientContext m_sendingSideCC;

    public IBFCEvent(boolean resumed, short version) {
        super(resumed, version);
    }

    public IBFCEvent(boolean resumed) {
        super(resumed);
    }

    public void setSendingSideCC(IClientContext blockedCC) {
        this.m_sendingSideCC = blockedCC;
    }

    @Override
    public void writeCommonData(DataOutput out) throws IOException {
        out.writeLong(AgentRegistrar.getAgentRegistrar().getId());
        out.writeUTF(Config.BROKER_NAME);
        out.writeUTF(this.m_sendingSideCC.getUid());
        out.writeUTF(this.m_sendingSideCC.getAppid());
        out.writeUTF(this.m_sendingSideCC.getUid());
    }

    @Override
    public void readCommonData(DataInput in) throws IOException {
        this.m_receiverSideCid = in.readLong();
        this.blockedBroker = in.readUTF();
        this.blockedUser = in.readUTF();
        this.blockedConnectId = in.readUTF();
        this.receivingBroker = in.readUTF();
    }

    @Override
    public void writeEventData(DataOutput out) throws IOException {
        super.writeEventData(out);
        if (!this.isResumedEvt) {
            if (this.blockedPendingQueue != null) {
                out.writeUTF(this.blockedPendingQueue);
            } else {
                out.writeUTF("");
            }
        }
    }

    @Override
    public void readEventData(DataInput in) throws IOException {
        super.readEventData(in);
        if (!this.isResumedEvt) {
            this.blockedPendingQueue = this.m_version >= 1 ? in.readUTF() : "";
        }
    }
}

