/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import progress.message.jclient.AdministeredObjectFactory;
import progress.message.jclient.ConnectionFactory;
import progress.message.jimpl.QueueConnection;
import progress.message.net.ProgressInetAddress;
import progress.message.zclient.SessionConfig;

public class QueueConnectionFactory
extends ConnectionFactory
implements javax.jms.QueueConnectionFactory,
Referenceable,
Serializable {
    static final long serialVersionUID = -6308106383889074651L;

    public QueueConnectionFactory() throws JMSException {
        super(ProgressInetAddress.getLocalHostName());
    }

    protected QueueConnectionFactory(Hashtable env) throws JMSException {
        super(env);
    }

    public QueueConnectionFactory(String brokerlist) throws JMSException {
        super(brokerlist);
    }

    public QueueConnectionFactory(String brokerlist, String connectID) throws JMSException {
        super(brokerlist, connectID);
    }

    public QueueConnectionFactory(String brokerlist, String defaultUserName, String defaultPassword) throws JMSException {
        super(brokerlist, defaultUserName, defaultPassword);
    }

    public QueueConnectionFactory(String brokerlist, String connectID, String defaultUserName, String defaultPassword) throws JMSException {
        super(brokerlist, connectID, defaultUserName, defaultPassword);
    }

    @Deprecated
    public QueueConnectionFactory(String brokerHostName, int brokerPort, String brokerProtocol, String defaultUserName, String defaultPassword) throws JMSException {
        super(brokerHostName, brokerPort, brokerProtocol, defaultUserName, defaultPassword);
    }

    @Deprecated
    public QueueConnectionFactory(String brokerHostName, int brokerPort, String brokerProtocol, String connectID, String defaultUserName, String defaultPassword) throws JMSException {
        super(brokerHostName, brokerPort, brokerProtocol, connectID, defaultUserName, defaultPassword);
    }

    @Override
    public javax.jms.QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(this.getDefaultUser(), this.getDefaultPassword());
    }

    @Override
    public javax.jms.QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        this.checkSPILoginBind();
        SessionConfig.initHTTPSProxySetting();
        this.resolveConnectionURLs();
        return new QueueConnection(this.getConnectID(), userName, password, this.getApplet(), this.getClientID(), this.getEnv());
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(QueueConnectionFactory.class.getName(), AdministeredObjectFactory.class.getName(), null);
        this.addReferences(ref);
        return ref;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF("12.0");
        stream.writeObject(this.getBrokerURL());
        String brokerHost = this.getBrokerHostName() == null ? ProgressInetAddress.getLocalHostName() : this.getBrokerHostName();
        stream.writeUTF(brokerHost);
        stream.writeUTF(this.getBrokerProtocol());
        stream.writeInt(this.getBrokerPort());
        stream.writeUTF(this.getDefaultUser());
        stream.writeUTF(this.getDefaultPassword());
        stream.writeObject(this.getConnectID());
        stream.writeObject(this.getClientID());
        stream.writeBoolean(this.getSequential());
        stream.writeBoolean(this.getLoadBalancing());
        stream.writeObject(this.getConnectionURLs());
        stream.writeBoolean(this.getPersistentDelivery());
        stream.writeInt(this.getMonitorInterval());
        stream.writeLong(this.getPingInterval());
        stream.writeInt(this.getPrefetchCount());
        stream.writeInt(this.getPrefetchThreshold());
        stream.writeInt(this.getDefaultTxnBatchSize());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
    }
}

