/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.parser;

import java.math.BigInteger;
import javax.jms.JMSException;
import javax.jms.Message;
import progress.message.jimpl.parser.Selector;
import progress.message.jimpl.parser.SimpleNode;
import progress.message.jimpl.parser.Token;

public class NumericComparison
extends SimpleNode {
    Token operator;

    public NumericComparison(int id) {
        super(id);
    }

    public NumericComparison(Selector p, int id) {
        super(p, id);
    }

    @Override
    public Object eval(Message m) throws JMSException {
        Object value = ((SimpleNode)this.children[0]).eval(m);
        if (value == null) {
            return null;
        }
        Number lhs = (Number)value;
        value = ((SimpleNode)this.children[1]).eval(m);
        if (value == null) {
            return null;
        }
        Number rhs = (Number)value;
        if (this.operator.kind == 21) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                return new Boolean(lhs.doubleValue() == rhs.doubleValue());
            }
            return new Boolean(lhs.longValue() == rhs.longValue());
        }
        if (this.operator.kind == 22) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                return new Boolean(lhs.doubleValue() != rhs.doubleValue());
            }
            return new Boolean(lhs.longValue() != rhs.longValue());
        }
        if (this.operator.kind == 23) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                return new Boolean(lhs.doubleValue() > rhs.doubleValue());
            }
            return new Boolean(lhs.longValue() > rhs.longValue());
        }
        if (this.operator.kind == 24) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                return new Boolean(lhs.doubleValue() >= rhs.doubleValue());
            }
            return new Boolean(lhs.longValue() >= rhs.longValue());
        }
        if (this.operator.kind == 25) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
                return new Boolean(lhs.doubleValue() < rhs.doubleValue());
            }
            return new Boolean(lhs.longValue() < rhs.longValue());
        }
        if (lhs instanceof Double || rhs instanceof Double || lhs instanceof BigInteger || rhs instanceof BigInteger) {
            return new Boolean(lhs.doubleValue() <= rhs.doubleValue());
        }
        return new Boolean(lhs.longValue() <= rhs.longValue());
    }
}

