/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.msg.v24.DefaultDynamicHeader;
import progress.message.msg.v24.DynamicHeader;
import progress.message.msg.v24.Mgram;
import progress.message.util.ArrayUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.SecurityLogic;

public final class SecureDynamicHeader
extends DynamicHeader {
    private byte m_securityAttributeByte = SecurityLogic.getQueryAttribs();
    private short m_subjKeyLen;
    private short m_digestLen;
    private int m_messageLenPad = 0;
    private IMessageProtection m_mp = null;
    private byte[] m_messageKey = null;
    private byte[] m_digest = null;
    private byte[] m_db = null;
    private DynamicHeader m_dynamicHeader = null;
    private boolean m_dbDirty = true;

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        SecureDynamicHeader sdh = (SecureDynamicHeader)super.clone(m);
        sdh.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.clone(m);
        if (!this.m_dbDirty) {
            sdh.m_db = new byte[this.m_db.length];
            System.arraycopy(this.m_db, 0, sdh.m_db, 0, this.m_db.length);
        }
        if (this.m_messageKey != null) {
            sdh.m_messageKey = new byte[this.m_messageKey.length];
            System.arraycopy(this.m_messageKey, 0, sdh.m_messageKey, 0, this.m_messageKey.length);
        }
        if (this.m_digest != null) {
            sdh.m_digest = new byte[this.m_digest.length];
            System.arraycopy(this.m_digest, 0, sdh.m_digest, 0, this.m_digest.length);
        }
        return sdh;
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        SecureDynamicHeader sdh = (SecureDynamicHeader)super.clone(m);
        sdh.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.clone(m);
        return sdh;
    }

    public SecureDynamicHeader(IMessageProtection mp, DynamicHeader dn) {
        super(dn.m_mgram);
        this.m_mp = mp;
        this.m_dynamicHeader = dn;
        this.m_dbDirty = true;
    }

    public SecureDynamicHeader(Mgram m, IMessageProtection mp) throws IOException {
        super(m);
        this.m_dynamicHeader = new DefaultDynamicHeader(m);
        this.m_mp = mp;
    }

    private SecureDynamicHeader() throws IOException {
        super(null);
        this.m_dynamicHeader = new DefaultDynamicHeader(null);
    }

    public void setMessageProtection(IMessageProtection mp) {
        this.m_mp = mp;
    }

    @Override
    public int getMessageLength() {
        return this.m_dynamicHeader.getMessageLength();
    }

    @Override
    public int getMessagePad() {
        return this.m_messageLenPad;
    }

    @Override
    public byte getSecurity() {
        return this.m_securityAttributeByte;
    }

    @Override
    public byte[] getMessageKey() {
        return this.m_messageKey;
    }

    @Override
    public int getSubjKeyLen() {
        return this.m_subjKeyLen;
    }

    @Override
    public int getDigestLen() {
        return this.m_digestLen;
    }

    @Override
    public byte[] getDigest() {
        return this.m_digest;
    }

    @Override
    public void setMessageDigest(byte[] digest) {
        this.m_digest = digest;
        this.m_digestLen = digest != null ? (short)digest.length : (short)0;
        this.m_dbDirty = true;
    }

    @Override
    public void setMessageLength(int length) {
        this.m_dynamicHeader.setMessageLength(length);
    }

    @Override
    byte[] toByteArray() {
        return this.toByteArray(null);
    }

    @Override
    byte[] toByteArray(IMessageProtection mp) {
        this.sync();
        byte[] result = new byte[this.m_db.length];
        System.arraycopy(this.m_db, 0, result, 0, this.m_db.length);
        int messageLength = this.m_dynamicHeader.getMessageLength();
        ArrayUtil.writeInt(result, this.m_db.length - 4, messageLength);
        return result;
    }

    @Override
    int length() {
        this.sync();
        return this.m_db.length;
    }

    @Override
    public void setSecurityAttributeByte(byte value) {
        if (this.m_securityAttributeByte != value) {
            this.m_securityAttributeByte = value;
            this.m_dbDirty = true;
        }
    }

    @Override
    public void setMessageKey(byte[] messageKey) {
        this.m_messageKey = messageKey;
        this.m_dbDirty = true;
    }

    @Override
    public void setMessagePad(int pad) {
        this.m_messageLenPad = pad;
    }

    @Override
    void sync() {
        if (this.m_dbDirty) {
            this.syncInternalData();
        }
    }

    private void syncInternalData() {
        ByteArrayOutputStream bos = this.m_db != null ? new ByteArrayOutputStream(this.m_db.length) : new ByteArrayOutputStream();
        Object result = null;
        try {
            this.writeToStream(bos, this.m_mp);
            bos.flush();
            this.m_dbDirty = false;
            this.m_db = bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToStream(OutputStream os, IMessageProtection mp) throws IOException {
        if (this.m_dbDirty) {
            os.write(this.m_securityAttributeByte);
            if (this.m_subjKeyLen == 0 && mp != null) {
                this.m_subjKeyLen = (short)mp.getSecretKeyLength();
            }
            StreamUtil.writeShort(this.m_subjKeyLen, os);
            if (this.m_messageKey != null) {
                os.write(this.m_messageKey);
            } else {
                this.writeFiller(this.m_subjKeyLen, os);
            }
            if (this.m_digestLen == 0 && mp != null) {
                this.m_digestLen = (short)mp.getHashSize();
            }
            StreamUtil.writeShort(this.m_digestLen, os);
            if (this.m_digest != null) {
                os.write(this.m_digest);
            } else {
                this.writeFiller(this.m_digestLen, os);
            }
        } else {
            int messageLength = this.m_dynamicHeader.getMessageLength();
            os.write(this.m_db, 0, this.m_db.length - 4);
            StreamUtil.writeInt(messageLength, os);
            return;
        }
        this.m_dynamicHeader.writeToStream(os);
    }

    private void writeFiller(short m_digestLen, OutputStream os) throws IOException {
        if (m_digestLen > 0) {
            byte[] filler = new byte[m_digestLen];
            os.write(filler);
        }
    }

    @Override
    void initDynamicHeaderFromStream(InputStream is) throws IOException {
        this.m_securityAttributeByte = StreamUtil.readByte(is);
        this.m_subjKeyLen = StreamUtil.readShort(is);
        this.m_messageKey = new byte[this.m_subjKeyLen];
        StreamUtil.readBytes(is, this.m_messageKey, 0, this.m_subjKeyLen);
        this.m_digestLen = StreamUtil.readShort(is);
        if (this.m_digestLen > 0) {
            this.m_digest = new byte[this.m_digestLen];
            StreamUtil.readBytes(is, this.m_digest, 0, this.m_digestLen);
        } else {
            this.m_digest = null;
        }
        this.m_dynamicHeader.initDynamicHeaderFromStream(is);
        if (this.m_mp != null) {
            int cipherTextSize = this.m_mp.getOutputSize(this.m_dynamicHeader.getMessageLength());
            this.m_messageLenPad = cipherTextSize - this.m_dynamicHeader.getMessageLength();
        }
        this.m_mgram.setStatus(2);
    }

    @Override
    DynamicHeader getSecureDynamicHeader(IMessageProtection mp) {
        return this;
    }

    @Override
    DynamicHeader getNonSecureDynamicHeader() {
        return this.m_dynamicHeader;
    }
}

