/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import progress.message.msg.v25.DefaultPayload;
import progress.message.util.EAssertFailure;
import progress.message.zclient.SessionConfig;

public class DefaultPayloadOutputWrapper
implements ObjectOutput {
    private DataOutputStream m_os;
    private SneakyByteArrayOutputStream m_baos;
    private ObjectOutputStream m_oos;
    private ByteArrayOutputStream m_obaos;
    private int m_oboasPos = 0;
    private DefaultPayload m_pay;

    public DefaultPayloadOutputWrapper(DefaultPayload pay) {
        this.m_pay = pay;
        this.m_baos = new SneakyByteArrayOutputStream();
        this.m_os = new DataOutputStream(this.m_baos);
    }

    @Override
    public void flush() throws IOException {
        this.synchronizeUnderlyingByteArrayReference();
    }

    public void synchronizeUnderlyingByteArrayReference() throws IOException {
        if (this.m_obaos != null) {
            this.m_oos.flush();
            byte[] byteInfo = this.m_obaos.toByteArray();
            int objectSize = byteInfo.length - this.m_oboasPos;
            this.m_baos.write(byteInfo, this.m_oboasPos, objectSize);
            this.m_oboasPos = byteInfo.length;
        }
        this.m_os.flush();
        byte[] latest = this.m_baos.getUnderlyingByteArray();
        int len = this.m_baos.size();
        this.m_pay.setBody(latest, len);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.m_os.writeShort(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    public void writeShort(short val) throws IOException {
        this.m_os.writeShort(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.m_os.writeInt(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.m_os.writeLong(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void write(int val) throws IOException {
        this.m_os.write(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void write(byte[] val) throws IOException {
        this.m_os.write(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.m_os.write(b, off, len);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.m_os.writeBoolean(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.m_os.writeByte(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.m_os.writeChar(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.m_os.writeFloat(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.m_os.writeDouble(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeBytes(String val) throws IOException {
        this.m_os.writeBytes(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeChars(String val) throws IOException {
        this.m_os.writeChars(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeUTF(String val) throws IOException {
        this.m_os.writeUTF(val);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (!SessionConfig.IN_BROKER) {
            throw new EAssertFailure("Cannot use mgram object serialization from client");
        }
        if (this.m_obaos == null) {
            this.m_obaos = new ByteArrayOutputStream();
            this.m_oos = new ObjectOutputStream(this.m_obaos);
        }
        this.m_oos.writeObject(obj);
        this.synchronizeUnderlyingByteArrayReference();
    }

    @Override
    public void close() throws IOException {
        if (this.m_obaos != null) {
            this.m_oos.flush();
            byte[] byteInfo = this.m_obaos.toByteArray();
            this.m_baos.write(byteInfo);
        }
        byte[] b = this.m_baos.toByteArray();
        this.m_pay.setBody(b, b.length);
        this.m_os.close();
        this.m_oos.close();
    }

    class SneakyByteArrayOutputStream
    extends ByteArrayOutputStream {
        SneakyByteArrayOutputStream() {
        }

        public byte[] getUnderlyingByteArray() {
            return this.buf;
        }
    }
}

