/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.MgramConverter25;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.SecurityLogic;

public class MgramConverter24
extends DebugObject
implements IMgramConverter {
    private IMgramConverter m_converter;
    private MgramConverter25 m_converter25;
    private progress.message.msg.v25.MgramConverter24 m_converter24;
    private ClientSecurityContext m_csc;
    private ISecureInputStream m_sis;
    private ISecureOutputStream m_sos;
    private boolean m_tteTTLConvert;
    private IMessageProtection m_mp;
    private IMgramStatusListener m_listener;
    private boolean m_canBeEncrypted;
    private byte[] m_encryptedMessageKey;
    private IMessageProtection m_decryptMp;

    public MgramConverter24() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        super(DebugState.GLOBAL_DEBUG_ON ? "MgramConverter24" : null);
        Class<?> converterClass = Class.forName("progress.message.msg.v24.MgramCreator");
        this.m_converter = (IMgramConverter)converterClass.newInstance();
        this.m_converter25 = new MgramConverter25();
        this.m_converter24 = new progress.message.msg.v25.MgramConverter24();
    }

    @Override
    public IMgram createMgram(InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        progress.message.msg.v25.Mgram v25Mgram = (progress.message.msg.v25.Mgram)this.m_converter24.createMgram(is);
        Mgram result = new Mgram(false);
        this.configHeaderToV26(result, v25Mgram);
        return result;
    }

    @Override
    public IMgram createMgram(byte version, InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return null;
    }

    private void writeMgramToNetworkStream(IMgram m, int channel, OutputStream os) throws IOException {
        if (m.getVersion() != 24) {
            progress.message.msg.v25.Mgram oldMgram = new progress.message.msg.v25.Mgram(false);
            byte[] oldSh = this.m_converter25.createV25sh(m, channel);
            oldMgram.setStaticHeader(oldSh);
            IMgramConverterHandle.IDynamicHeader newDh = m.getMgramConverterHandle().getInternalDynamicHeader();
            boolean isSecure = m.isSecure();
            if (isSecure) {
                m.getMgramConverterHandle().recalculatePad(this.m_mp);
            }
            oldMgram.setDynamicHeader(this.m_converter25.createV25dh(isSecure, this.m_mp, newDh, null, null, oldMgram));
            this.m_converter25.setV25Payload(oldMgram, m);
            this.addSidebandData(oldMgram);
            this.m_converter24.writeMgramToNetworkStream(oldMgram, channel, os);
        } else {
            m.writeMgramToStream(os, this.m_csc, this.m_sos, this.m_mp, this.m_tteTTLConvert);
        }
    }

    public void writeMgramToStreamNonSecure(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
    }

    private void messageKeySlicedDelivery(IMgram mParam, int channel, OutputStream os) throws IOException {
        IMgram m = mParam;
        if (SecurityLogic.isMKeyEncryption(m.getSecurity()) || m.getBrokerHandle().isGuarFormatIncorrect()) {
            try {
                m = (IMgram)m.protectedClone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        if (SecurityLogic.isMKeyEncryption(m.getSecurity())) {
            m.getBrokerHandle().decryptMessageWithMessageKey(this.m_decryptMp);
        }
        if (m.getBrokerHandle().isGuarFormatIncorrect()) {
            m.getBrokerHandle().setGuarFormatIncorrect(false);
            if (!m.isGuarenteed()) {
                m.setGuarenteed(m.getBrokerHandle().getDbTracking());
            } else {
                m.setReliable();
            }
        }
        progress.message.msg.v25.Mgram oldMgram = new progress.message.msg.v25.Mgram(false);
        byte[] sh = this.m_converter25.createV25sh(m, channel);
        oldMgram.setStaticHeader(sh);
        IMgramConverterHandle.IDynamicHeader newDh = m.getMgramConverterHandle().getInternalDynamicHeader();
        progress.message.msg.v25.DynamicHeader oldDh = this.m_converter25.createV25dh(true, this.m_mp, newDh, null, null, oldMgram);
        oldMgram.setDynamicHeader(oldDh);
        this.m_converter25.setV25Payload(oldMgram, m);
        this.addSidebandData(oldMgram);
        IMgramConverterHandle mch = oldMgram.getMgramConverterHandle();
        if (SecurityLogic.isMKeyDigest(oldMgram.getSecurity())) {
            oldMgram.getBrokerHandle().macMessageWithMessageKey(this.m_mp);
            if (SecurityLogic.isMKeyEncryption(oldMgram.getSecurity())) {
                oldMgram.getBrokerHandle().encryptMessageWithMessageKey(this.m_mp);
            }
        }
        this.m_converter24.messageKeySlicedDelivery(oldMgram, channel, os);
    }

    private void sessionKeySlicedDelivery(IMgram m, int channel, ClientSecurityContext csc, OutputStream os) throws IOException {
        progress.message.msg.v25.Mgram oldMgram = new progress.message.msg.v25.Mgram(false);
        byte[] sh = this.m_converter25.createV25sh(m, channel);
        oldMgram.setStaticHeader(sh);
        IMgramConverterHandle.IDynamicHeader newDh = m.getMgramConverterHandle().getInternalDynamicHeader();
        progress.message.msg.v25.DynamicHeader oldDh = this.m_converter25.createV25dh(true, this.m_mp, newDh, null, null, oldMgram);
        oldMgram.setDynamicHeader(oldDh);
        this.m_converter25.setV25Payload(oldMgram, m);
        this.addSidebandData(oldMgram);
        this.m_converter24.sessionKeySlicedDelivery(oldMgram, channel, csc, os);
    }

    @Override
    public void secureDeliver(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        if (m == null) {
            return;
        }
        this.assertOperationMgram(m);
        if (m.getType() == 27) {
            Iterator iter = m.getBatchHandle().getBatchIterator();
            while (iter.hasNext()) {
                this.secureDeliver((IMgram)iter.next(), channel, csc, os, ctx);
            }
        } else {
            if (ctx != null && ctx.protocolAdapter != null && ctx.protocolAdapter.makeProtocolCorrections(m, ctx)) {
                while (ctx.protocolAdapter.hasCorrected()) {
                    this.secureDeliver(ctx.protocolAdapter.getNextCorrected(), channel, csc, os, null);
                }
                return;
            }
            if (m.isSecure() && (SecurityLogic.isMKeyMacHeader(m.getSecurity()) || SecurityLogic.isMKeyDigest(m.getSecurity()))) {
                this.messageKeySlicedDelivery(m, channel, os);
            } else if (m.isSecure() && (SecurityLogic.isSKeyDigest(m.getSecurity()) || SecurityLogic.isSKeyEncryption(m.getSecurity()))) {
                this.sessionKeySlicedDelivery(m, channel, csc, os);
            } else {
                this.writeMgramToNetworkStream(m, channel, os);
            }
        }
    }

    @Override
    public void deliver(IMgram m, OutputStream os) throws IOException {
        this.deliver(m, -1, os, null);
    }

    @Override
    public void deliver(IMgram m, int channel, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        if (m == null) {
            return;
        }
        this.assertOperationMgram(m);
        if (m.getType() == 27) {
            Iterator iter = m.getBatchHandle().getBatchIterator();
            while (iter.hasNext()) {
                this.deliver((IMgram)iter.next(), channel, os, ctx);
            }
        } else {
            if (ctx != null && ctx.protocolAdapter != null && ctx.protocolAdapter.makeProtocolCorrections(m, ctx)) {
                while (ctx.protocolAdapter.hasCorrected()) {
                    this.deliver(ctx.protocolAdapter.getNextCorrected(), channel, os, null);
                }
                return;
            }
            this.writeMgramToNetworkStream(m, channel, os);
        }
    }

    @Override
    public IMgram unserialize(InputStream in, boolean tteTTLConvert) throws IOException {
        return this.unserialize(in);
    }

    public IMgram unserialize(InputStream in) throws IOException {
        progress.message.msg.v25.Mgram v25Mgram = (progress.message.msg.v25.Mgram)this.m_converter24.unserialize(in);
        Mgram result = new Mgram(false);
        boolean isSecure = v25Mgram.isSecure();
        if (isSecure && SecurityLogic.isMKeyEncryption(v25Mgram.getSecurity()) && this.m_canBeEncrypted) {
            v25Mgram.getBrokerHandle().decryptMessageWithMessageKey(this.m_decryptMp);
        }
        this.configHeaderToV26(result, v25Mgram);
        result.setStatus(3);
        if (isSecure && SecurityLogic.isMKeyDigest(v25Mgram.getSecurity())) {
            result.getBrokerHandle().macMessageWithMessageKey(this.m_mp);
        }
        if (isSecure && SecurityLogic.isMKeyEncryption(v25Mgram.getSecurity()) && this.m_canBeEncrypted) {
            result.getBrokerHandle().encryptMessageWithMessageKey(this.m_mp);
        }
        return result;
    }

    private void configHeaderToV26(Mgram result, progress.message.msg.v25.Mgram v25Mgram) throws IOException {
        byte[] newSh = this.m_converter25.createV26sh(v25Mgram.getMgramConverterHandle().getInternalStaticHeader());
        result.setStaticHeader(newSh);
        DynamicHeader newDh = this.m_converter25.createV26dh(v25Mgram.isSecure(), this.m_mp, v25Mgram.getMgramConverterHandle().getInternalDynamicHeader(), null, null, result);
        result.setDynamicHeader(newDh);
        this.m_converter25.setV26Payload(v25Mgram, result);
    }

    @Override
    public void serialize(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
        throw new EAssertFailure("Unable to serialize v24 mgrams to the log or database");
    }

    @Override
    public void initializeConverter(Hashtable properties) {
        this.m_csc = (ClientSecurityContext)properties.get(MgramConstants.CLIENT_SECURITY_CONTEXT);
        this.m_sis = (ISecureInputStream)properties.get(MgramConstants.SECURE_INPUT_STREAM);
        this.m_sos = (ISecureOutputStream)properties.get(MgramConstants.SECURE_OUTPUT_STREAM);
        this.m_mp = (IMessageProtection)properties.get(MgramConstants.MESSAGE_PROTECTION);
        if (this.m_mp != null) {
            this.m_encryptedMessageKey = new byte[this.m_mp.getOutputSize(this.m_mp.getSecretKeyLength())];
        }
        this.m_decryptMp = (IMessageProtection)properties.get(MgramConstants.DECRYPT_MESSAGE_PROTECTION);
        this.m_listener = (IMgramStatusListener)properties.get(MgramConstants.MGRAM_STATUS_LISTENER);
        Boolean tteTTL = (Boolean)properties.get(MgramConstants.TTE_TTL_CONVERT);
        this.m_tteTTLConvert = tteTTL != null ? tteTTL : false;
        Boolean canBeEncrypted = (Boolean)properties.get(MgramConstants.CAN_BE_ENCRYPTED);
        this.m_canBeEncrypted = canBeEncrypted != null ? canBeEncrypted : false;
        this.m_converter.initializeConverter(properties);
        this.m_converter24.initializeConverter(properties);
        this.m_converter25.initializeConverter(properties);
    }

    private void addSidebandData(progress.message.msg.v25.Mgram oldMgram) {
        if (!(oldMgram.getType() != 2 && oldMgram.getType() != 12 || oldMgram.hasSidebandData())) {
            oldMgram.createSidebandDataIfNeeded();
        }
    }

    private void assertOperationMgram(IMgram m) {
        if (m.getType() == 25) {
            throw new EAssertFailure("Unable to send Operation Mgram to version 24 client");
        }
    }

    @Override
    public byte getVersion() {
        return 24;
    }
}

