/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.interceptor;

import com.sonicsw.interceptor.IAdvisor;
import com.sonicsw.interceptor.IInterceptor;
import com.sonicsw.interceptor.advisors.AgentAdvisor;
import com.sonicsw.interceptor.advisors.HTTPAdvisor;
import com.sonicsw.interceptor.advisors.JMSAdvisor;
import com.sonicsw.interceptor.advisors.SOAPAdvisor;
import com.sonicsw.interceptor.impls.actional.Config;
import com.sonicsw.interceptor.pointcuts.AgentPointCut;
import com.sonicsw.interceptor.pointcuts.HTTPPointCut;
import com.sonicsw.interceptor.pointcuts.JMSPointCut;
import com.sonicsw.interceptor.pointcuts.SOAPPointCut;
import com.sonicsw.mq.components.BrokerComponent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;

public class AdvisorRegistrar {
    private static DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);

    public static IAdvisor getInstance(int type) {
        if (type == 101) {
            return JMSAdvisor.getInstance();
        }
        if (type == 1) {
            return AgentAdvisor.getInstance();
        }
        if (type == 2) {
            return HTTPAdvisor.getInstance();
        }
        if (type == 3) {
            return SOAPAdvisor.getInstance();
        }
        new IllegalArgumentException("Failed to load advisor of type " + type).printStackTrace();
        return null;
    }

    public static boolean loadInterceptor(String classname, Properties props) {
        Properties params;
        Object obj = null;
        try {
            Class<?> clazz = Class.forName(classname);
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage("Unable to load Inteceptor code for " + classname, (Throwable)e, 2);
            return false;
        }
        boolean ret = false;
        Properties properties = params = props == null ? new Properties() : props;
        if (obj instanceof IInterceptor && ((IInterceptor)obj).init(params)) {
            if (obj instanceof JMSPointCut) {
                ret = JMSAdvisor.getInstance().addInterceptor(obj);
            } else if (obj instanceof AgentPointCut) {
                ret = AgentAdvisor.getInstance().addInterceptor(obj);
            } else if (obj instanceof HTTPPointCut) {
                ret = HTTPAdvisor.getInstance().addInterceptor(obj);
            } else if (obj instanceof SOAPPointCut) {
                ret = SOAPAdvisor.getInstance().addInterceptor(obj);
            } else {
                BrokerComponent.getComponentContext().logMessage((Throwable)new IllegalArgumentException("Failed to load interceptor of " + classname), 2);
            }
        }
        return ret;
    }

    public static void updateDynamicProperty(String property, Object newvalue) {
        Config.setDynamicProperty(property, newvalue);
    }

    public static String getDynamicProperty(String property) {
        return Config.getDynamicProperty(property);
    }

    static {
        if (DATE_FORMAT instanceof SimpleDateFormat) {
            ((SimpleDateFormat)DATE_FORMAT).applyPattern("yy/MM/dd kk:mm:ss");
        }
    }
}

