/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mq.components.ConfigPropertiesPopulator;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import java.util.Hashtable;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundProtocolHolder;

public class AddNewAcceptorDirectProtocolHandler
implements IAttributeChangeHandler {
    private static boolean TRACE = false;
    private static volatile IComponentContext s_context = null;
    private static volatile ConfigurationChangeBindHelper s_bindHelper = null;
    private HTTPAcceptor m_httpAcceptor = null;
    private Hashtable m_names;

    public static void init(IComponentContext context) {
        if (TRACE) {
            if (context == null) {
                System.out.println("Null context");
            } else {
                System.out.println("not null context");
            }
        }
        s_context = context;
    }

    public AddNewAcceptorDirectProtocolHandler(ConfigurationChangeBindHelper bindHelper, HTTPAcceptor httpAcceptor, Hashtable names) {
        s_bindHelper = bindHelper;
        this.m_httpAcceptor = httpAcceptor;
        this.m_names = names;
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        if (TRACE) {
            System.out.println("AddNewAcceptorDirectProtocolHandler.itemModified:  " + this.m_httpAcceptor.getURL());
        }
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newProtocols = this.retrieveProtocols(delta);
        for (int i = 0; i < newProtocols.length; ++i) {
            String attributeName = newProtocols[i];
            this.populateProtocolEntryAndNames(attributeName, delta);
        }
    }

    private void populateProtocolEntryAndNames(String attributeName, IDeltaAttributeSet delta) {
        block4: {
            try {
                Object obj = delta.getNewValue(attributeName);
                Reference protocolRef = (Reference)obj;
                String protocolCID = protocolRef.getElementName();
                if (TRACE) {
                    System.out.println("protocolCID: " + protocolCID);
                    System.out.println("s_context: " + s_context);
                }
                if (s_context != null) {
                    IElement protocolConfigElem = s_context.getConfiguration(protocolCID, true);
                    HTTPDirectInboundProtocolHolder iph = ConfigPropertiesPopulator.processHTTPDirectProtocol(s_context, protocolConfigElem, this.m_httpAcceptor);
                    this.m_httpAcceptor.addProtocolEntry(iph);
                    this.m_names.put(attributeName, iph.getEntryName());
                }
            }
            catch (NotModifiedAttException nmae) {
                if (!TRACE) break block4;
                System.out.println("AddNewAcceptorDirectURLHandler.itemModified:");
            }
        }
    }

    private String[] retrieveProtocols(IDeltaAttributeSet delta) {
        String[] newProtocols = delta.getNewAttributesNames();
        String[] oldProtocols = delta.getDeletedAttributesNames();
        for (int i = 0; i < oldProtocols.length; ++i) {
            String eName;
            String attributeName = oldProtocols[i];
            if (s_context == null || (eName = (String)this.m_names.get(attributeName)) == null) continue;
            this.m_httpAcceptor.removeProtocolEntry(eName);
            this.m_names.remove(attributeName);
        }
        return newProtocols;
    }
}

