/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mq.components.ConfigPropertiesPopulator;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundEntry;

public class AddNewAcceptorDirectURLHandler
implements IAttributeChangeHandler {
    private boolean TRACE = false;
    private static volatile IComponentContext s_context = null;
    private static volatile ConfigurationChangeBindHelper s_bindHelper = null;
    private HTTPAcceptor m_httpAcceptor = null;
    private String m_handlerName = null;
    private String m_handlerType = null;

    public static void init(IComponentContext context) {
        s_context = context;
    }

    public AddNewAcceptorDirectURLHandler(ConfigurationChangeBindHelper bindHelper, String parentName, String handlerType, HTTPAcceptor httpAcceptor) {
        s_bindHelper = bindHelper;
        this.m_httpAcceptor = httpAcceptor;
        this.m_handlerName = parentName;
        this.m_handlerType = handlerType;
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        if (this.TRACE) {
            System.out.println("AddNewAcceptorDirectURLHandler.itemModified: handlerName = " + this.m_handlerName);
        }
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newURLs = delta.getNewAttributesNames();
        for (int i = 0; i < newURLs.length; ++i) {
            String attributeName = newURLs[i];
            if (this.TRACE) {
                System.out.println("AddNewAcceptorDirectURLHandler.itemModified: attributeName = " + attributeName);
            }
            try {
                Object obj = delta.getNewValue(attributeName);
                Reference urlRef = (Reference)obj;
                String urlCID = urlRef.getElementName();
                IElement urlConfigElem = s_context.getConfiguration(urlCID, true);
                HTTPDirectInboundEntry entry = null;
                try {
                    if (this.m_handlerType.equals("DIRECT")) {
                        entry = ConfigPropertiesPopulator.processDirectURLEntry(s_context, urlConfigElem, this.m_handlerName, this.m_httpAcceptor);
                    } else if (this.m_handlerType.equals("SOAP") || this.m_handlerType.equals("WS")) {
                        entry = ConfigPropertiesPopulator.processSOAPURLEntry(s_context, urlConfigElem, this.m_handlerName, this.m_httpAcceptor);
                    } else if (this.m_handlerType.equals("JMS")) {
                        entry = ConfigPropertiesPopulator.processJMSURLEntry(s_context, urlConfigElem, this.m_handlerName, this.m_httpAcceptor);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_httpAcceptor.addURLEntry(entry, this.m_handlerName);
                continue;
            }
            catch (NotModifiedAttException nmae) {
                if (!this.TRACE) continue;
                System.out.println("AddNewAcceptorDirectURLHandler.itemModified: exception");
            }
        }
    }
}

