/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.direct;

import com.sonicsw.net.http.ConfigurationException;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpOutRequest;
import com.sonicsw.net.http.HttpOutResponse;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.HttpServiceException;
import com.sonicsw.net.http.direct.DirectHttpOutRequest;
import com.sonicsw.net.http.direct.DirectHttpOutResponse;
import com.sonicsw.net.http.soap.SoapHttpOutboundHandler;
import java.net.URLConnection;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.msg.IMgram;
import progress.message.zclient.ISidebandData;

public class DirectHttpOutboundHandler
extends HttpOutboundHandler {
    SoapHttpOutboundHandler m_soapDelegate = null;

    public DirectHttpOutboundHandler(RoutingConnectionInfo connectInfo, HttpConfigInfo config, boolean suppressDelegate) throws ConfigurationException, HttpServiceException {
        super(connectInfo, config);
        if (!suppressDelegate) {
            this.m_soapDelegate = new SoapHttpOutboundHandler(connectInfo, config);
        }
    }

    public DirectHttpOutboundHandler(RoutingConnectionInfo connectInfo, HttpConfigInfo config) throws ConfigurationException, HttpServiceException {
        super(connectInfo, config);
        this.m_soapDelegate = new SoapHttpOutboundHandler(connectInfo, config);
    }

    @Override
    public void sendMgram(IMgram m, Thread dispatchThread) {
        if (this.delegatesToSoap(m)) {
            this.m_soapDelegate.sendMgram(m, dispatchThread);
        } else {
            super.sendMgram(m, dispatchThread);
        }
    }

    @Override
    protected HttpOutRequest getHttpOutRequest(IMgram m) {
        if (this.delegatesToSoap(m)) {
            return this.m_soapDelegate.getHttpOutRequest(m);
        }
        return new DirectHttpOutRequest();
    }

    @Override
    protected HttpOutResponse getHttpOutResponse(IMgram m) {
        if (this.delegatesToSoap(m)) {
            return this.m_soapDelegate.getHttpOutResponse(m);
        }
        return new DirectHttpOutResponse();
    }

    @Override
    public void handleResponse(HttpLock lock, IMgram mgram, URLConnection connection, HttpOutResponse response) {
        boolean isContentReply;
        int responseCode = lock.getErrorType();
        boolean sendResponse = isContentReply = lock.getContentReplyExpected();
        if (DirectHttpOutboundHandler.isHttpErrorCode(responseCode)) {
            this.buildErrorResponse(lock, mgram, connection, response);
            sendResponse = true;
        } else if (isContentReply) {
            try {
                response.buildResponse(response, connection, this);
            }
            catch (Exception e) {
                int errCode = 610;
                String errMsg = e.getMessage();
                if (HttpHelper.isMsgTooBigException(e)) {
                    errCode = 413;
                    errMsg = "Message size larger than configured limit (max message size).";
                    DirectHttpOutboundHandler.logLargeMessageWarning(response, connection);
                }
                lock.setError(errCode);
                lock.setMessage(errMsg);
                response.setResponseCode(errCode);
                response.setResponseMessage(errMsg);
                response.setProperty("Content-Type", "text/plain");
                response.setProperty("Content-Length", "0");
                response.setIsInternal(true);
                this.buildErrorResponse(lock, mgram, null, response);
            }
        }
        if (sendResponse) {
            try {
                this.processContentReply(mgram, response);
                lock.setError(200);
            }
            catch (ConfigurationException e) {
                String key = e.getConfigKey();
                if (key == null) {
                    lock.setError(610);
                }
                if (key != null && key.equals("ContentReplyUser")) {
                    lock.setError(612);
                }
                lock.setMessage(e.getMessage());
            }
            catch (Exception e) {
                lock.setError(610);
                lock.setMessage(e.getMessage());
            }
        }
    }

    public void buildErrorResponse(HttpLock lock, IMgram mgram, URLConnection connection, HttpOutResponse response) {
        if (this.delegatesToSoap(mgram)) {
            this.m_soapDelegate.buildErrorResponse(lock, mgram, connection, response);
            return;
        }
        if (!this.shouldReplySimpleMessage(lock, mgram)) {
            return;
        }
        try {
            response.buildResponse(response, connection, this);
            response.setUndeliverdReason(lock.getDmqReason());
            response.setUndeliverdExplanation(lock.getDmqMessage());
        }
        catch (HttpServiceException e) {
            lock.setError(610);
            lock.setMessage(e.getMessage());
        }
    }

    @Override
    public boolean shouldReplyFault(HttpLock lock, IMgram m) {
        if (this.delegatesToSoap(m)) {
            return this.m_soapDelegate.shouldReplyFault(lock, m);
        }
        return super.shouldReplyFault(lock, m);
    }

    private boolean delegatesToSoap(IMgram m) {
        if (this.m_soapDelegate == null || m == null) {
            return false;
        }
        ISidebandData sd = m.getSidebandData();
        if (sd == null) {
            return false;
        }
        Boolean replyAsSoap = (Boolean)sd.getProperty("X-HTTP-ReplyAsSOAP");
        String wspolicy = (String)sd.getProperty("X-WS-MessagePolicy");
        return wspolicy != null || replyAsSoap != null && replyAsSoap != false;
    }

    @Override
    public boolean shouldReplySimpleMessage(HttpLock lock, IMgram m) {
        if (this.shouldReplyFault(lock, m)) {
            return false;
        }
        return lock.getContentReplyExpected() && lock.getErrorType() != 612;
    }
}

