/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.ssl;

import java.applet.Applet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class SSLUtil {
    public static String getProperty(Object properties, String key, String defaultValue) {
        String retValue = null;
        if (properties == null) {
            try {
                retValue = System.getProperty(key, defaultValue);
            }
            catch (SecurityException securityException) {}
        } else if (properties instanceof Hashtable) {
            retValue = (String)((Hashtable)properties).get(key);
        } else if (properties instanceof HashMap) {
            retValue = (String)((HashMap)properties).get(key);
        } else if (properties instanceof Applet) {
            retValue = ((Applet)properties).getParameter(key);
        }
        if (retValue == null && properties != null) {
            try {
                retValue = System.getProperty(key);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return retValue == null ? defaultValue : retValue;
    }

    public static Boolean getBooleanProperty(Object properties, String key, Boolean defaultValue) {
        Boolean retValue = null;
        if (properties == null) {
            retValue = SSLUtil.checkPropertyKey(key, retValue);
        } else if (properties instanceof Hashtable) {
            Object o = ((Hashtable)properties).get(key);
            retValue = SSLUtil.retrieveRetValueCheckingKey(o, retValue);
        } else if (properties instanceof HashMap) {
            Object o = ((HashMap)properties).get(key);
            retValue = SSLUtil.retrieveRetValueCheckingKey(o, retValue);
        } else if (properties instanceof Applet) {
            String o = ((Applet)properties).getParameter(key);
            retValue = SSLUtil.retrieveRetValueCheckingKey(o, retValue);
        }
        if (retValue == null && properties != null) {
            retValue = SSLUtil.checkPropertyKey(key, retValue);
        }
        return retValue == null ? defaultValue : retValue;
    }

    private static Boolean retrieveRetValueCheckingKey(Object o, Boolean retValueParam) {
        Boolean retValue = retValueParam;
        if (o != null) {
            if (o instanceof String) {
                String s = (String)o;
                retValue = SSLUtil.checkRetValueTreu(retValue, s);
            } else if (o instanceof Boolean) {
                retValue = (Boolean)o;
            }
        }
        return retValue;
    }

    private static Boolean checkPropertyKey(String key, Boolean retValueParam) {
        Boolean retValue = retValueParam;
        try {
            String s = System.getProperty(key);
            retValue = SSLUtil.checkRetValueTreu(retValue, s);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return retValue;
    }

    private static Boolean checkRetValueTreu(Boolean retValueParam, String s) {
        Boolean retValue = retValueParam;
        if (s != null && "true".equalsIgnoreCase(s.trim())) {
            retValue = Boolean.TRUE;
        }
        return retValue;
    }

    public static Vector getCipherSuites(String sslCipherSuites) {
        return SSLUtil.getCipherSuites(sslCipherSuites, false);
    }

    public static Vector getCipherSuites(String sslCipherSuites, boolean trace) {
        Vector<String> cs = null;
        if (sslCipherSuites != null && sslCipherSuites.trim().length() != 0) {
            cs = new Vector<String>();
            StringTokenizer st = new StringTokenizer(sslCipherSuites, ",");
            int count = st.countTokens() == 0 ? 1 : st.countTokens();
            for (int i = 0; i < count; ++i) {
                String cipher = st.nextToken().trim();
                if (cipher.length() == 0) continue;
                if (trace) {
                    System.out.println("Adding cipher suites " + cipher);
                }
                cs.addElement(cipher);
            }
        }
        return cs;
    }

    public synchronized Properties getPropertiesFromParams(Applet applet) {
        if (applet == null) {
            return null;
        }
        Properties props = new Properties();
        String[][] paramInfo = applet.getParameterInfo();
        try {
            for (int i = 0; i < paramInfo.length; ++i) {
                String propertyName = paramInfo[i][0];
                String value = applet.getParameter(propertyName);
                if (value == null) continue;
                props.put(propertyName, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }
}

