/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.api;

import java.util.HashMap;
import javax.jms.Destination;
import javax.xml.soap.SOAPEnvelope;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.handler.AddressingHandler;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.JMSEndpoint;
import org.apache.axis.types.URI;
import progress.message.jclient.Queue;

public class JMSServiceAddressingHandler
extends AddressingHandler {
    public void init() {
        super.init();
    }

    protected void forwardMessage(EndpointReferenceType epr, Message msg) throws Exception {
        AttributedURI address = epr.getAddress();
        AddressingHeaders headers = null;
        JMSConnector c = null;
        MessageContext mc = msg.getMessageContext();
        if (mc != null) {
            c = (JMSConnector)mc.getProperty("JMS_CONNECTOR");
            if (c == null) {
                super.forwardMessage(epr, msg);
                return;
            }
        } else {
            super.forwardMessage(epr, msg);
            return;
        }
        headers = (AddressingHeaders)mc.getProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS");
        if (headers == null) {
            headers = new AddressingHeaders();
        }
        headers.setTo(address);
        headers.setReferenceProperties(epr.getProperties());
        headers.setReferenceParameters(epr.getParameters());
        headers.toEnvelope((SOAPEnvelope)msg.getSOAPEnvelope());
        URI u = new URI(address.getScheme(), null, address.getHost(), address.getPort(), null, null, null);
        JMSEndpoint ep = c.createEndpoint((Destination)new Queue("sonic.http::" + address.toString()));
        HashMap props = (HashMap)mc.getProperty("transport.jms.msgProps");
        props.put("X-HTTP-ReplyAsSOAP", new Boolean(true));
        props.put("X-WS-MessagePolicy", "");
        ep.send(msg.getSOAPPartAsBytes(), props);
    }
}

