/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.wss4j;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.ws.WSHttpInRequest;
import com.sonicsw.net.http.ws.WSHttpOutRequest;
import com.sonicsw.security.cert.BrokerCertificateStore;
import com.sonicsw.security.cert.BrokerKeyStore;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.action.Action;
import com.sonicsw.ws.security.action.Encryption;
import com.sonicsw.ws.security.action.Signature;
import com.sonicsw.ws.security.action.SupportingToken;
import com.sonicsw.ws.security.action.TransportBindingAction;
import com.sonicsw.ws.security.policy.SSPConstants;
import com.sonicsw.ws.security.policy.SecurityPolicyAlternative;
import com.sonicsw.ws.security.policy.WSSPUtils;
import com.sonicsw.ws.security.policy.model.SonicAlgorithmSuiteUtils;
import com.sonicsw.ws.security.processingresult.TransportBindingResult;
import com.sonicsw.ws.security.wss4j.SonicWSOutboundCallback;
import com.sonicsw.ws.security.wss4j.SonicWSOutboundCallbackImpl;
import com.sonicsw.ws.security.wss4j.SonicWSSecurityEngine;
import com.sonicsw.wsp.OperationContext;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wsp.SecurityPolicyException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.message.WSAddTimestamp;
import org.apache.ws.security.message.WSBaseMessage;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.message.WSSAddUsernameToken;
import org.apache.ws.security.message.WSSignEnvelope;
import org.apache.ws.security.policy.model.AlgorithmSuite;
import org.apache.ws.security.util.StringUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import progress.message.broker.Config;
import progress.message.broker.RoutingConnectionInfo;

public class WSSOutboundHandler {
    static final SonicWSSecurityEngine secEngine = (SonicWSSecurityEngine)SonicWSSecurityEngine.getInstance();
    private static final String ENC_CRYPTO_KEYSTORE_PSW_VALUE = "interop";
    private static final String ENC_CRYPTO_CERT_ALIAS = "com_sonicsw_ws_security_wss4j_outbound_enc_cert_alias";
    private static final String REQUEST_DATA = "com.sonicsw.ws.security.wss4j.WSSOutboundHandler.RequestData";
    private static final String THROWING_AXIS_FAULT_MESSAGE = "Throwing AxisFault: ";
    private static final String ISSUER_NAME = "issuerName";
    private static final String SERIAL_NO = "serialNo";
    private static KeyStore s_emptyKeyStore = null;
    private static Crypto s_crypto = null;
    private boolean DEBUG = DebugObjects.getHandlerDebug().getDebug();

    private void debug(String s) {
        DebugObjects.getHandlerDebug().debug(s);
    }

    private void debug(String msg, Throwable th) {
        DebugObjects.getHandlerDebug().debug(msg, th);
    }

    private RequestData initializeReqData() {
        RequestData reqData = new RequestData();
        return reqData;
    }

    public void handleClientRequest(MessageContext mc) throws AxisFault {
        this.handleMessage(mc);
    }

    public void handleServerResponse(MessageContext mc) throws AxisFault {
        if (this.DEBUG) {
            this.debug("Server response being created...");
        }
        this.handleMessage(mc);
    }

    private void handleMessage(MessageContext mc) throws AxisFault {
        this.preprocessMessageContext(mc);
        RequestData[] requestDataList = (RequestData[])mc.getProperty(REQUEST_DATA);
        if (requestDataList == null) {
            if (this.DEBUG) {
                this.debug("WSSOutboundHandler: Nothing to do, returning.");
            }
            if (this.DEBUG) {
                try {
                    Message message = mc.getCurrentMessage();
                    if (message != null) {
                        SOAPPart sPart = (SOAPPart)message.getSOAPPart();
                        SOAPEnvelope se = (SOAPEnvelope)sPart.getEnvelope();
                        if (se.isDirty()) {
                            se.setRecorder(null);
                        }
                        Document doc = se.getAsDocument();
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
                        sPart.setCurrentMessage((Object)os.toByteArray(), 4);
                        this.configOsStr(os);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return;
        }
        if (this.DEBUG) {
            this.debug("WSSOutboundHandler: Processing SOAP message");
        }
        try {
            for (int i = 0; i < requestDataList.length; ++i) {
                this.handleMessage(mc, requestDataList[i]);
            }
        }
        catch (Throwable ex) {
            if (this.DEBUG) {
                ex.printStackTrace();
            }
            if (ex instanceof AxisFault) {
                AxisFault fault = (AxisFault)ex;
                throw fault;
            }
            AxisFault fault = new AxisFault("WSSOutboundHandler: Error in processing SOAP message.", ex);
            if (this.DEBUG) {
                ex.printStackTrace();
                this.debug(THROWING_AXIS_FAULT_MESSAGE + fault.getMessage());
            }
            throw fault;
        }
        finally {
            this.cleanup(mc);
        }
    }

    private void preprocessMessageContext(MessageContext mc) throws AxisFault {
        SecurityPolicyAlternative policy = (SecurityPolicyAlternative)mc.getProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative");
        if (policy == null) {
            return;
        }
        Action[] actionList = policy.getActions();
        if (actionList == null) {
            if (this.DEBUG) {
                this.debug("assertionList is null");
            }
            return;
        }
        if (actionList.length == 0) {
            if (this.DEBUG) {
                this.debug("assertionList is empty");
            }
            return;
        }
        BrokerKeyStore keyStore = BrokerKeyStore.getInstance("JKS");
        String brokerX509TokenAlias = null;
        String brokerX509TokenPassword = null;
        if (keyStore != null) {
            brokerX509TokenAlias = keyStore.getDefaultAlias();
            char[] psw = keyStore.getDefaultKeyPassword();
            if (psw != null) {
                brokerX509TokenPassword = new String(psw);
            }
        }
        HttpOutboundHandler outboundHandler = (HttpOutboundHandler)mc.getProperty("com.sonicsw.net.http.HttpOutboundHandler");
        RoutingConnectionInfo routingConnInfo = null;
        if (outboundHandler != null) {
            routingConnInfo = outboundHandler.getRoutingConnectionInfo();
        }
        if (this.DEBUG) {
            this.debug("Brokerwide WS properties");
            this.debug("\tUSERNAMETOKEN_USERNAME: " + Config.WS_SECURITY_UT_USER);
            this.debug("\tUSERNAMETOKEN_PASSWORD: " + Config.WS_SECURITY_UT_PASSWORD);
            this.debug("\tX509TOKEN_ALIAS: " + brokerX509TokenAlias);
            this.debug("\tX509TOKEN_PASSWORD: " + brokerX509TokenPassword);
            if (routingConnInfo != null) {
                this.debug("Routing Defination WS properties");
                this.debug("\tUSERNAMETOKEN_USERNAME: " + routingConnInfo.getUsernameTokenName());
                if (routingConnInfo.getUsernameTokenPassword() != null) {
                    this.debug("\tUSERNAMETOKEN_PASSWORD: " + new String(routingConnInfo.getUsernameTokenPassword()));
                } else {
                    this.debug("\tUSERNAMETOKEN_PASSWORD: null");
                }
                this.debug("\tX509TOKEN_ALIAS: " + routingConnInfo.getX509Alias());
                if (routingConnInfo.getX509Password() != null) {
                    this.debug("\tX509TOKEN_PASSWORD: " + new String(routingConnInfo.getX509Password()));
                }
            }
        }
        ArrayList requestDataList = new ArrayList();
        for (int i = 0; i < actionList.length; ++i) {
            RequestData reqData;
            Action asn = actionList[i];
            if (asn == null) continue;
            int type = asn.getType();
            if (type == 4) {
                reqData = this.processSupportingToken((SupportingToken)asn, routingConnInfo, Config.WS_SECURITY_UT_USER, Config.WS_SECURITY_UT_PASSWORD);
                WSSOutboundHandler.addReqData(reqData, requestDataList);
                continue;
            }
            if (type == 2 || type == 99) {
                reqData = this.processEncryption((Encryption)asn, routingConnInfo, mc);
                WSSOutboundHandler.addReqData(reqData, requestDataList);
                continue;
            }
            if (type == 1) {
                reqData = this.processSignature((Signature)asn, routingConnInfo, brokerX509TokenAlias, brokerX509TokenPassword, mc);
                WSSOutboundHandler.addReqData(reqData, requestDataList);
                continue;
            }
            if (type == 3) {
                reqData = this.processTimestamp();
                WSSOutboundHandler.addReqData(reqData, requestDataList);
                continue;
            }
            if (type == 5) {
                this.processTransportBinding((TransportBindingAction)asn, mc);
                continue;
            }
            AxisFault fault = new AxisFault("WSSOutboundHandler: Invalid Assertion: " + type + ".");
            throw this.debugFaultMessage(fault);
        }
        RequestData[] reqData = new RequestData[requestDataList.size()];
        reqData = requestDataList.toArray(reqData);
        mc.setProperty(REQUEST_DATA, (Object)reqData);
    }

    private static void addReqData(RequestData reqData, ArrayList requestDataList) {
        if (reqData != null) {
            requestDataList.add(reqData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(MessageContext mc, RequestData reqDataParam) throws AxisFault {
        RequestData reqData = reqDataParam;
        if (this.DEBUG) {
            this.debug("WSSOutboundHandler: enter invoke() with msg type: " + mc.getCurrentMessage().getMessageType());
            if (mc != null && mc.getCurrentMessage() != null) {
                this.debug("\r ---------------- \r" + new String(mc.getCurrentMessage().getSOAPPartAsBytes()) + "\r ---------------- \r");
            }
        }
        try {
            Vector actions = new Vector();
            String action = reqData.action;
            if (action == null) {
                AxisFault fault = new AxisFault("WSSOutboundHandler: No action defined");
                throw this.debugFaultMessage(fault);
            }
            int doAction = 0;
            try {
                doAction = WSSecurityUtil.decodeAction((String)action, actions);
            }
            catch (WSSecurityException ex) {
                throw new AxisFault(ex.getMessage(), (Throwable)ex);
            }
            if (this.DEBUG) {
                this.debug("action: " + action + ", int value is: " + doAction + (doAction == 0 ? ". WSConstants.NO_SECURITY" : ". SECURITY enabled"));
            }
            if (doAction == 0) {
                return;
            }
            boolean mu = reqData.mustUnderstand;
            if (this.DEBUG) {
                this.debug("reqData.actor: " + reqData.actor);
                this.debug("reqData.username: " + reqData.username);
                this.debug("reqData.userPassword: " + reqData.userPassword);
                this.debug("reqData.key: " + reqData.key);
            }
            if ((doAction & 0x43) != 0 && (reqData.username == null || "".equals(reqData.username))) {
                AxisFault fault = new AxisFault("WSSOutboundHandler: Empty username for specified action");
                throw this.debugFaultMessage(fault);
            }
            Document doc = null;
            Message message = mc.getCurrentMessage();
            SOAPPart sPart = (SOAPPart)message.getSOAPPart();
            doc = reqData.sndSecurity;
            if (doc == null) {
                try {
                    doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
                }
                catch (Exception ex) {
                    AxisFault fault = new AxisFault("WSSOutboundHandler: cannot get SOAP envlope from message" + ex, (Throwable)ex);
                    throw this.debugFault(fault);
                }
            }
            reqData.soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
            if ((doAction & 1) == 1) {
                if (this.DEBUG) {
                    this.debug("UsernameToken...decoding param...WSConstants.UT");
                }
                this.decodeUTParameter(reqData);
            }
            if ((doAction & 0x40) == 64) {
                if (this.DEBUG) {
                    this.debug("UsernameToken...decoding param...WSConstants.UT_SIGN");
                }
                this.decodeUTParameter(reqData);
                if (this.DEBUG) {
                    this.debug("Signature (with UT secrect key)...decoding param");
                }
                this.decodeSignatureParameter(reqData);
            }
            if ((doAction & 2) == 2) {
                if (this.DEBUG) {
                    this.debug("loading Signature Crypto");
                }
                reqData.sigCrypto = this.loadSignatureCrypto(reqData);
                if (this.DEBUG) {
                    this.debug("Signature...decoding param...WSConstants.SIGN");
                }
                this.decodeSignatureParameter(reqData);
            }
            if ((doAction & 0x10) == 16) {
                if (this.DEBUG) {
                    this.debug("SAMLToken signed...decoding param...WSConstants.ST_SIGNED");
                }
                this.decodeSignatureParameter(reqData);
            }
            if ((doAction & 4) == 4) {
                if (this.DEBUG) {
                    this.debug("Encryption...decoding param...WSConstants.ENCR");
                }
                this.decodeEncryptionParameter(mc, reqData);
            }
            block18: for (int i = 0; i < actions.size(); ++i) {
                int actionToDo = (Integer)actions.get(i);
                if (this.DEBUG) {
                    this.debug("Performing Action: " + actionToDo);
                }
                switch (actionToDo) {
                    case 1: {
                        if (this.DEBUG) {
                            this.debug("Perform UsernameToken...WSConstants.UT");
                        }
                        this.performUTAction(actionToDo, mu, doc, reqData, mc);
                        continue block18;
                    }
                    case 4: {
                        if (this.DEBUG) {
                            this.debug("Perform Encryption...WSConstants.ENCR");
                        }
                        this.performENCRAction(mu, actionToDo, doc, reqData, mc);
                        continue block18;
                    }
                    case 2: {
                        if (this.DEBUG) {
                            this.debug("Perform Signature...WSConstants.SIGN");
                        }
                        this.performSIGNAction(actionToDo, mu, doc, reqData, mc);
                        continue block18;
                    }
                    case 16: {
                        if (this.DEBUG) {
                            this.debug("Perform SAMLToken signed...WSConstants.ST_SIGNED");
                        }
                        this.performST_SIGNAction(actionToDo, mu, doc, reqData);
                        continue block18;
                    }
                    case 8: {
                        if (this.DEBUG) {
                            this.debug("Perform SAMLToken unsigned...WSConstants.ST_UNSIGNED");
                        }
                        this.performSTAction(actionToDo, mu, doc, reqData);
                        continue block18;
                    }
                    case 32: {
                        if (this.DEBUG) {
                            this.debug("Insert Timestamp...WSConstants.TS");
                        }
                        this.performTSAction(actionToDo, mu, doc, reqData);
                        continue block18;
                    }
                    case 64: {
                        if (this.DEBUG) {
                            this.debug("Perform sinagture with UT secrect key...WSConstants.UT_SIGN");
                        }
                        this.performUT_SIGNAction(actionToDo, mu, doc, reqData, mc);
                        continue block18;
                    }
                    case 256: {
                        if (this.DEBUG) {
                            this.debug("WSConstants.NO_SERIALIZE: true");
                        }
                        reqData.noSerialization = true;
                    }
                }
            }
            if (reqData.noSerialization) {
                reqData.sndSecurity = doc;
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
                sPart.setCurrentMessage((Object)os.toByteArray(), 4);
                if (this.DEBUG) {
                    this.configOsStr(os);
                }
                reqData.sndSecurity = null;
            }
            if (this.DEBUG) {
                this.debug("WSSOutboundHandler: exit invoke()");
            }
        }
        finally {
            reqData.clear();
            reqData = null;
        }
        if (this.DEBUG) {
            this.debug("\r ---------------- \r DONE handling " + (mc.isClient() ? "client request" : "service response") + " \r ---------------- \r");
        }
    }

    private void configOsStr(ByteArrayOutputStream os) {
        String osStr = null;
        try {
            osStr = os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            osStr = os.toString();
        }
        if (this.DEBUG) {
            this.debug("Send request:");
            this.debug("\r ---------------- \r" + osStr + "\r ---------------- \r");
        }
    }

    private void performSIGNAction(int actionToDo, boolean mu, Document doc, RequestData reqData, MessageContext mc) throws AxisFault {
        WSSignEnvelope wsSign = new WSSignEnvelope(reqData.actor, mu);
        if (this.DEBUG) {
            this.debug("reqData.sigKeyId: " + reqData.sigKeyId);
            this.debug("reqData.sigAlgorithm: " + reqData.sigAlgorithm);
            this.debug("set setUserInfo, uid: " + reqData.username + ", psw: " + reqData.userPassword);
            this.debug("sey sign parts, if size > 0: reqData.signatureParts.size(): " + reqData.signatureParts.size());
        }
        if (reqData.sigKeyId != 0) {
            wsSign.setKeyIdentifierType(reqData.sigKeyId);
        }
        if (reqData.sigAlgorithm != null) {
            wsSign.setSignatureAlgorithm(reqData.sigAlgorithm);
        }
        this.populateSigCanonicalization(reqData, wsSign);
        wsSign.setUserInfo(reqData.username, reqData.userPassword);
        if (mc.isClient()) {
            WSHttpOutRequest request = (WSHttpOutRequest)mc.getProperty("com.sonicsw.net.http.HttpOutRequest");
            request.setSigningCertificate(reqData.username, reqData.userPassword.toCharArray());
            OperationContext oc = (OperationContext)mc.getProperty("COM_SONIC_WS_OPERATION_CONTEXT");
            if (oc != null) {
                oc.setSigningCertAlias(reqData.username);
                oc.setSigningCertPassword(reqData.userPassword);
            }
        }
        this.buildWithRetry((WSBaseMessage)wsSign, doc, reqData.signatureParts, reqData.sigCrypto);
    }

    private void performENCRAction(boolean mu, int actionToDo, Document doc, RequestData reqData, MessageContext mc) throws AxisFault {
        WSEncryptBody wsEncrypt = new WSEncryptBody(reqData.actor, mu);
        if (reqData.encKeyId != 0) {
            wsEncrypt.setKeyIdentifierType(reqData.encKeyId);
        }
        if (this.DEBUG) {
            this.debug("set reqData.encKeyId: " + reqData.encKeyId);
            this.debug("using reqData.encKeyId: " + reqData.encKeyId + " --> " + (reqData.encKeyId == 5 ? "EMBEDDED_KEYNAME" : "not EMBEDDED_KEYNAME"));
        }
        if (reqData.encKeyId == 5) {
            if (this.DEBUG) {
                this.debug("MessageContext prop is WSHandlerConstants.ENC_KEY_NAME");
            }
            String encKeyName = reqData.encKeyName;
            if (this.DEBUG) {
                this.debug("encKeyName: " + encKeyName);
            }
            wsEncrypt.setEmbeddedKeyName(encKeyName);
            WSPasswordCallback callback = this.getPassword(reqData.encUser, reqData.userPassword, reqData.key, actionToDo, "EmbeddedKeyCallbackClass", "EmbeddedKeyCallbackRef", reqData, mc);
            byte[] embeddedKey = callback.getKey();
            if (this.DEBUG) {
                this.debug("embeddedKey: " + embeddedKey);
            }
            wsEncrypt.setKey(embeddedKey);
        }
        if (this.DEBUG) {
            this.debug("set Encryption Algo: reqData.encSymmAlgo: " + reqData.encSymmAlgo);
            this.debug("set KeyTransport: reqData.encKeyTransport: " + reqData.encKeyTransport);
            this.debug("set userInfo: reqData.encUser: " + reqData.encUser);
            this.debug("set cert to use: reqData.encCert: " + reqData.encCert);
            this.debug("set encParts, if size > 0: reqData.encryptParts.size(): " + reqData.encryptParts.size());
        }
        if (reqData.encSymmAlgo != null) {
            wsEncrypt.setSymmetricEncAlgorithm(reqData.encSymmAlgo);
        }
        if (reqData.encKeyTransport != null) {
            wsEncrypt.setKeyEnc(reqData.encKeyTransport);
        }
        wsEncrypt.setUserInfo(reqData.encUser);
        wsEncrypt.setUseThisCert(reqData.encCert);
        this.buildWithRetry((WSBaseMessage)wsEncrypt, doc, reqData.encryptParts, reqData.encCrypto);
    }

    private void performUTAction(int actionToDo, boolean mu, Document doc, RequestData reqData, MessageContext mc) throws AxisFault {
        WSPasswordCallback callback = this.getPassword(reqData.username, reqData.userPassword, reqData.key, actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData, mc);
        String password = callback.getPassword();
        if (this.DEBUG) {
            this.debug("password: " + password);
            this.debug("password type: reqData.pwType: " + reqData.pwType);
        }
        WSSAddUsernameToken builder = new WSSAddUsernameToken(reqData.actor, mu);
        builder.setPasswordType(reqData.pwType);
        builder.build(doc, reqData.username, password);
        if (reqData.utElements != null && reqData.utElements.length > 0) {
            for (int j = 0; j < reqData.utElements.length; ++j) {
                reqData.utElements[j].trim();
                if ("Nonce".equals(reqData.utElements[j])) {
                    builder.addNonce(doc);
                }
                if ("Created".equals(reqData.utElements[j])) {
                    builder.addCreated(doc);
                }
                reqData.utElements[j] = null;
            }
        }
    }

    private void performUT_SIGNAction(int actionToDo, boolean mu, Document doc, RequestData reqData, MessageContext mc) throws AxisFault {
        WSPasswordCallback callback = this.getPassword(reqData.username, reqData.userPassword, reqData.key, actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData, mc);
        String password = callback.getPassword();
        if (this.DEBUG) {
            this.debug("password: " + password);
            this.debug("setPasswordType: WSConstants.PASSWORD_TEXT");
            this.debug("reqData.username: " + reqData.username);
            this.debug("reqData.signatureParts: " + reqData.signatureParts);
        }
        WSSAddUsernameToken builder = new WSSAddUsernameToken(reqData.actor, mu);
        builder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        builder.preSetUsernameToken(doc, reqData.username, password);
        builder.addCreated(doc);
        builder.addNonce(doc);
        WSSignEnvelope sign = new WSSignEnvelope(reqData.actor, mu);
        if (reqData.signatureParts.size() > 0) {
            sign.setParts(reqData.signatureParts);
        }
        if (this.DEBUG) {
            this.debug("builder: " + builder);
        }
        sign.setUsernameToken(builder);
        sign.setKeyIdentifierType(7);
        if (reqData.sigAlgorithm != null) {
            sign.setSignatureAlgorithm(reqData.sigAlgorithm);
        } else {
            sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        }
        this.populateSigCanonicalization(reqData, sign);
        try {
            sign.build(doc, null);
        }
        catch (Exception ex) {
            AxisFault fault = new AxisFault("WSSOutboundHandler: Error during Signatur with UsernameToken secret" + ex, (Throwable)ex);
            throw this.debugFault(fault);
        }
        builder.build(doc, null, null);
    }

    private void populateSigCanonicalization(RequestData reqData, WSSignEnvelope sign) {
        if (reqData.sigCanonAlgo != null) {
            sign.setSigCanonicalization(reqData.sigCanonAlgo);
        }
    }

    private void performSTAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws AxisFault {
        AxisFault fault = new AxisFault("WSSOutboundHandler: SAML not supported.");
        throw this.debugFaultMessage(fault);
    }

    private void performST_SIGNAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws AxisFault {
        AxisFault fault = new AxisFault("WSSOutboundHandler: SAML not supported.");
        throw this.debugFaultMessage(fault);
    }

    private void performTSAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws AxisFault {
        int ttl_i = reqData.timeToLive;
        WSAddTimestamp timeStampBuilder = new WSAddTimestamp(reqData.actor, mu);
        if (this.DEBUG) {
            this.debug("Final ttl_i: " + ttl_i);
        }
        timeStampBuilder.build(doc, ttl_i);
    }

    protected Crypto loadSignatureCrypto(RequestData reqData) throws AxisFault {
        Crypto crypto = null;
        KeyStore ks = reqData.sigKeyStore;
        try {
            crypto = this.retrieveCrypto(ks, crypto);
        }
        catch (Exception ex) {
            AxisFault fault = new AxisFault("WSSOutboundHandler: Signature: No key store for signature: " + ex.getMessage(), (Throwable)ex);
            throw this.debugFault(fault);
        }
        if (crypto == null) {
            AxisFault fault = new AxisFault("WSSOutboundHandler: Signature: No key store for signature. Null found.");
            throw this.debugFaultMessage(fault);
        }
        return crypto;
    }

    protected Crypto loadEncryptionCrypto(RequestData reqData) throws AxisFault {
        Crypto crypto = null;
        KeyStore ks = reqData.encKeyStore;
        try {
            crypto = this.retrieveCrypto(ks, crypto);
        }
        catch (Exception ex) {
            AxisFault fault = new AxisFault("WSSOutboundHandler: Encryption: No key store for encryption: " + ex.getMessage(), (Throwable)ex);
            throw this.debugFault(fault);
        }
        if (crypto == null) {
            AxisFault fault = new AxisFault("WSSOutboundHandler: Encryption: No key store for encryption. Null found.");
            throw this.debugFaultMessage(fault);
        }
        return crypto;
    }

    private Crypto retrieveCrypto(KeyStore ks, Crypto cryptoParam) throws Exception {
        Crypto crypto = cryptoParam;
        if (ks != null) {
            crypto = new Crypto(ks);
        }
        return crypto;
    }

    private AxisFault debugFault(AxisFault fault) {
        if (this.DEBUG) {
            this.debug(THROWING_AXIS_FAULT_MESSAGE + fault.getMessage(), fault);
        }
        return fault;
    }

    private void decodeUTParameter(RequestData reqData) throws AxisFault {
        if (reqData.pwType.equals("PasswordText")) {
            reqData.pwType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
        } else if (reqData.pwType.equals("PasswordDigest")) {
            reqData.pwType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
        }
        if (this.DEBUG) {
            this.debug("reqData.pwType: " + reqData.pwType);
        }
        String tmpS = null;
        String[] utElements = reqData.utElements;
        if (utElements != null) {
            for (int i = 0; i < utElements.length; ++i) {
                if (utElements[i] == null) continue;
                tmpS = utElements[i] + " ";
            }
        }
        if (this.DEBUG) {
            this.debug("WSHandlerConstants.ADD_UT_ELEMENTS: " + tmpS);
        }
        if (tmpS != null) {
            reqData.utElements = StringUtil.split(tmpS, (char)' ');
        }
    }

    private void decodeSignatureParameter(RequestData reqData) throws AxisFault {
        if (reqData.sigKeyIdInString == null || reqData.sigKeyIdInString.length() == 0) {
            reqData.sigKeyId = 1;
        } else if (reqData.sigKeyIdInString.equalsIgnoreCase("KeyIdentifier")) {
            reqData.sigKeyId = 4;
        } else if (reqData.sigKeyIdInString.equalsIgnoreCase("IssuerSerial")) {
            reqData.sigKeyId = 2;
        } else if (reqData.sigKeyIdInString.equalsIgnoreCase("Include token")) {
            reqData.sigKeyId = 1;
        } else {
            AxisFault fault = new AxisFault("WSSOutboundHandler: Unsupported token reference for signing - " + reqData.sigKeyIdInString);
            throw this.debugFaultMessage(fault);
        }
        if (this.DEBUG) {
            String s = null;
            switch (reqData.sigKeyId) {
                case 2: {
                    s = "WSConstants.ISSUER_SERIAL";
                    break;
                }
                case 1: {
                    s = "WSConstants.BST_DIRECT_REFERENCE";
                    break;
                }
                case 3: {
                    s = "WSConstants.X509_KEY_IDENTIFIER";
                    break;
                }
                case 4: {
                    s = "WSConstants.SKI_KEY_IDENTIFIER";
                }
            }
            if (this.DEBUG) {
                this.debug("reqData.sigKeyId: " + reqData.sigKeyId + " : " + s);
            }
        }
        if (this.DEBUG) {
            this.debug("reqData.sigAlgorithm: " + reqData.sigAlgorithm);
        }
        String tmpS = reqData.sigPartsInString;
        if (this.DEBUG) {
            this.debug("SIGNATURE_PARTS: " + tmpS);
        }
        if (tmpS != null) {
            this.splitEncParts(tmpS, reqData.signatureParts, reqData);
        }
    }

    private void decodeEncryptionParameter(MessageContext mc, RequestData reqData) throws AxisFault {
        String tmpS = null;
        if (reqData.encCert == null) {
            this.throwAxisFault("WSSOutboundHandler: Encryption certificate not found for the request.");
        }
        if (reqData.encKeyIdInString == null || reqData.encKeyIdInString.isEmpty()) {
            this.updateEncKeyWhenNoKeyId(reqData);
        } else if ("KeyIdentifier".equalsIgnoreCase(reqData.encKeyIdInString)) {
            this.updateEncKeyWhenKeyIdentifier(reqData);
        } else if ("IssuerSerial".equalsIgnoreCase(reqData.encKeyIdInString)) {
            reqData.encKeyId = 2;
        } else if ("Include token".equalsIgnoreCase(reqData.encKeyIdInString)) {
            reqData.encKeyId = 1;
        } else {
            this.throwAxisFault("WSSOutboundHandler: Unsupported token reference - " + reqData.encKeyIdInString);
        }
        this.debug("reqData.encSymmAlgo: " + reqData.encSymmAlgo);
        tmpS = reqData.encPartsInString;
        if (this.DEBUG) {
            this.debug("ENCRYPTION_PARTS: " + tmpS);
        }
        if (tmpS != null) {
            this.splitEncParts(tmpS, reqData.encryptParts, reqData);
        }
    }

    private void updateEncKeyWhenKeyIdentifier(RequestData reqData) throws AxisFault {
        reqData.encKeyId = 4;
        if (reqData.encKeySKI != null) {
            try {
                byte[] skiBytes = Base64.decode((String)reqData.encKeySKI);
                CryptoSKI crypto = new CryptoSKI(s_emptyKeyStore);
                crypto.setSKIBytes(skiBytes);
                reqData.encCrypto = crypto;
            }
            catch (Exception ex) {
                throw new AxisFault("Invalid subject key identifier: " + ex, (Throwable)ex);
            }
        }
        try {
            if (s_crypto != null) {
                byte[] ski = s_crypto.getSKIBytesFromCert(reqData.encCert);
                if (ski == null) {
                    throw new AxisFault("SKI un-available");
                }
                reqData.encCrypto = s_crypto;
            }
        }
        catch (RuntimeException | AxisFault | WSSecurityException ex) {
            throw new AxisFault("Failed to retrieve the subject key identifier from the encryption certificate: " + ex, ex);
        }
    }

    private void updateEncKeyWhenNoKeyId(RequestData reqData) {
        byte[] ski;
        block5: {
            ski = null;
            try {
                if (s_crypto != null) {
                    ski = s_crypto.getSKIBytesFromCert(reqData.encCert);
                }
            }
            catch (RuntimeException | WSSecurityException ex) {
                if (!this.DEBUG) break block5;
                this.debug(ex.getMessage(), ex);
            }
        }
        if (ski != null) {
            reqData.encKeyId = 4;
            reqData.encCrypto = s_crypto;
        } else {
            reqData.encKeyId = 2;
        }
    }

    private WSPasswordCallback getPassword(String username, String defaultPassword, byte[] key, int doAction, String clsProp, String refProp, RequestData reqData, MessageContext mc) throws AxisFault {
        WSPasswordCallback pwCb = null;
        String password = null;
        String callback = null;
        CallbackHandler cbHandler = null;
        if (this.DEBUG) {
            this.debug("MessageContext prop is: " + clsProp);
        }
        callback = reqData.pwCallbackClass;
        if (this.DEBUG) {
            this.debug("callback: " + callback + ", got from property " + clsProp);
            this.debug("cbHandler: " + mc.getProperty(refProp) + ", got from property " + refProp);
        }
        if (callback != null) {
            pwCb = this.readPwViaCallbackClass(callback, username, defaultPassword, key, doAction);
            if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                AxisFault fault = new AxisFault("WSSOutboundHandler: password callback class provided null or empty password");
                throw this.debugFaultMessage(fault);
            }
        } else {
            cbHandler = (CallbackHandler)mc.getProperty(refProp);
            if (cbHandler != null) {
                if (this.DEBUG) {
                    this.debug("cbHandler: " + cbHandler);
                }
                if ((pwCb = this.performCallback(cbHandler, username, doAction)).getPassword() == null && pwCb.getKey() == null) {
                    AxisFault fault = new AxisFault("WSSOutboundHandler: password callback provided null or empty password");
                    throw this.debugFaultMessage(fault);
                }
            } else {
                password = mc.getPassword();
                if (password == null) {
                    AxisFault fault = new AxisFault("WSSOutboundHandler: application provided null or empty password");
                    throw this.debugFaultMessage(fault);
                }
                mc.setPassword(null);
                pwCb = new WSPasswordCallback("", 0);
                if (this.DEBUG) {
                    this.debug("default - password: " + password);
                }
                pwCb.setPassword(password);
            }
        }
        if (this.DEBUG) {
            this.debug("WSPasswordCallback: " + pwCb);
        }
        return pwCb;
    }

    private WSPasswordCallback readPwViaCallbackClass(String callback, String username, String password, byte[] key, int doAction) throws AxisFault {
        Class<?> cbClass = null;
        CallbackHandler cbHandler = null;
        try {
            if (this.DEBUG) {
                this.debug("callback handler class: " + callback);
            }
            cbClass = Class.forName(callback);
        }
        catch (ClassNotFoundException ex) {
            AxisFault fault = new AxisFault("WSSOutboundHandler: cannot load password callback class: " + callback, (Throwable)ex);
            throw this.debugFaultMessage(fault);
        }
        try {
            cbHandler = (CallbackHandler)cbClass.newInstance();
            if (cbHandler instanceof SonicWSOutboundCallback) {
                if (password != null) {
                    ((SonicWSOutboundCallback)((Object)cbHandler)).setPassword(username, password);
                }
                if (key != null) {
                    ((SonicWSOutboundCallback)((Object)cbHandler)).setKey(key);
                }
            }
        }
        catch (Exception ex) {
            AxisFault fault = new AxisFault("WSSOutboundHandler: cannot create instance of password callback: " + callback, (Throwable)ex);
            throw this.debugFaultMessage(fault);
        }
        return this.performCallback(cbHandler, username, doAction);
    }

    private WSPasswordCallback performCallback(CallbackHandler cbHandler, String username, int doAction) throws AxisFault {
        if (this.DEBUG) {
            this.debug("callback -  user: " + username + ", action: " + doAction);
        }
        WSPasswordCallback pwCb = null;
        int reason = 0;
        switch (doAction) {
            case 1: 
            case 64: {
                if (this.DEBUG) {
                    this.debug("reason: WSPasswordCallback.USERNAME_TOKEN");
                }
                reason = 2;
                break;
            }
            case 2: {
                if (this.DEBUG) {
                    this.debug("reason: WSPasswordCallback.SIGNATURE");
                }
                reason = 3;
                break;
            }
            case 4: {
                if (this.DEBUG) {
                    this.debug("reason: WSPasswordCallback.KEY_NAME");
                }
                reason = 4;
            }
        }
        pwCb = new WSPasswordCallback(username, reason);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cbHandler.handle(callbacks);
        }
        catch (Exception ex) {
            AxisFault fault = new AxisFault("WSSOutboundHandler: password callback failed", (Throwable)ex);
            throw this.debugFaultMessage(fault);
        }
        return pwCb;
    }

    private void splitEncParts(String tmpS, Vector parts, RequestData reqData) throws AxisFault {
        WSEncryptionPart encPart = null;
        String[] rawParts = StringUtil.split((String)tmpS, (char)';');
        for (int i = 0; i < rawParts.length; ++i) {
            String[] partDef = StringUtil.split((String)rawParts[i], (char)'}');
            if (partDef.length == 1) {
                if (this.DEBUG) {
                    this.debug("single partDef: '" + partDef[0] + "'");
                }
                encPart = new WSEncryptionPart(partDef[0].trim(), reqData.soapConstants.getEnvelopeURI(), "Content");
            } else if (partDef.length == 2) {
                String nmSpace = partDef[0].trim();
                nmSpace = this.retrieveNmSpace(nmSpace, reqData);
                String element = partDef[1].trim();
                if (this.DEBUG) {
                    this.debug("partDefs: '" + nmSpace + "' ,'" + element + "'");
                }
                encPart = new WSEncryptionPart(element, nmSpace, "Content");
            } else if (partDef.length == 3) {
                String mode = partDef[0].trim();
                mode = mode.length() <= 1 ? "Content" : mode.substring(1);
                String nmSpace = partDef[1].trim();
                nmSpace = this.retrieveNmSpace(nmSpace, reqData);
                String element = partDef[2].trim();
                if (this.DEBUG) {
                    this.debug("partDefs: '" + mode + "' ,'" + nmSpace + "' ,'" + element + "'");
                }
                encPart = new WSEncryptionPart(element, nmSpace, mode);
            } else {
                AxisFault fault = new AxisFault("WSSOutboundHandler: wrong part definition: " + tmpS);
                throw this.debugFaultMessage(fault);
            }
            parts.add(encPart);
        }
    }

    private String retrieveNmSpace(String nmSpaceParam, RequestData reqData) {
        String nmSpace = nmSpaceParam;
        nmSpace = nmSpace.length() <= 1 ? reqData.soapConstants.getEnvelopeURI() : nmSpace.substring(1);
        return nmSpace;
    }

    private RequestData processSupportingToken(SupportingToken supportingToken, RoutingConnectionInfo routingConnInfo, String brokerUT_Username, String brokerUT_Password) {
        String password;
        String username;
        RequestData reqData = this.initializeReqData();
        reqData.action = "UsernameToken";
        reqData.mustUnderstand = true;
        reqData.actor = null;
        reqData.sndSecurity = null;
        QName qName = supportingToken.getPasswordType();
        if (qName != null) {
            if (qName.getLocalPart().equals("PasswordText")) {
                reqData.pwType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
            } else if (qName.getLocalPart().equals("PasswordDigest")) {
                reqData.pwType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
            }
            if (this.DEBUG) {
                this.debug("Password type FROM Assertion: " + reqData.pwType);
            }
        } else if (this.DEBUG) {
            this.debug("No password type from Assertion: " + reqData.pwType);
        }
        if (this.DEBUG) {
            this.debug("Password type: reqData.pwType: " + reqData.pwType);
        }
        reqData.pwCallbackClass = SonicWSOutboundCallbackImpl.class.getName();
        reqData.pwCallbackRef = null;
        if (brokerUT_Username != null && brokerUT_Password != null && brokerUT_Username.trim().length() > 0 && brokerUT_Password.trim().length() > 0) {
            reqData.username = brokerUT_Username;
            reqData.userPassword = brokerUT_Password;
            if (this.DEBUG) {
                this.debug("Using Broker Setting: " + brokerUT_Username + ", " + brokerUT_Password);
            }
        }
        if (routingConnInfo != null) {
            if (this.DEBUG) {
                this.debug("RoutingConnectionInfo: " + routingConnInfo.getConnectionURLs());
            }
            username = routingConnInfo.getUsernameTokenName();
            password = null;
            char[] c = routingConnInfo.getUsernameTokenPassword();
            if (c != null) {
                password = new String(c);
            }
            if (username != null && password != null && username.trim().length() > 0 && password.trim().length() > 0) {
                reqData.username = username;
                reqData.userPassword = password;
                if (this.DEBUG) {
                    this.debug("Using Routing Setting: " + username + ", " + password);
                }
            }
        }
        username = supportingToken.getSubjectName();
        password = supportingToken.getPassword();
        if (username != null && password != null && username.trim().length() > 0 && password.trim().length() > 0) {
            reqData.username = username;
            reqData.userPassword = password;
            if (this.DEBUG) {
                this.debug("Using Override Setting: " + username + ", " + password);
            }
        }
        return reqData;
    }

    private RequestData processSignature(Signature sig, RoutingConnectionInfo routingConnInfo, String brokerX509TokenAlias, String brokerX509TokenPassword, MessageContext mc) throws AxisFault {
        try {
            String password;
            String username;
            BrokerKeyStore keyStore;
            RequestData reqData = this.initializeReqData();
            reqData.action = "Signature";
            reqData.sigKeyIdInString = null;
            if (sig.isSP2005()) {
                reqData.sigKeyIdInString = WSSPUtils.getOutboundTokenRef(sig, mc);
            }
            if ((keyStore = BrokerKeyStore.getInstance("JKS")) != null) {
                reqData.sigKeyStore = keyStore.getKeyStore();
            }
            reqData.pwCallbackClass = SonicWSOutboundCallbackImpl.class.getName();
            reqData.sigAlgorithm = sig.getAlgSignature();
            reqData.sigCanonAlgo = sig.getAlgCanonicalization();
            reqData.sigPartsInString = sig.getPartsAsString();
            WSSOutboundHandler.configReqDataUsernamePassword(brokerX509TokenPassword, reqData, brokerX509TokenAlias);
            if (routingConnInfo != null) {
                username = routingConnInfo.getX509Alias();
                password = null;
                char[] c = routingConnInfo.getX509Password();
                if (c != null) {
                    password = new String(c);
                }
                WSSOutboundHandler.configReqDataUsernamePassword(password, reqData, username);
            }
            username = sig.getX509TokenAlias();
            password = sig.getX509TokenPrivateKeyPassword();
            WSSOutboundHandler.configReqDataUsernamePassword(password, reqData, username);
            if (!(reqData.username != null && reqData.username.length() != 0 || mc.isClient())) {
                WSHttpInRequest request = (WSHttpInRequest)mc.getProperty("com.sonicsw.net.http.HttpInRequest");
                reqData.username = request.getServiceAlias();
                reqData.userPassword = new String(request.getServicePrivateKeyPwd());
            }
            return reqData;
        }
        catch (SecurityPolicyException e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    private static void configReqDataUsernamePassword(String password, RequestData reqData, String username) {
        if (username != null && password != null && username.trim().length() > 0 && password.trim().length() > 0) {
            reqData.username = username;
            reqData.userPassword = password;
        }
    }

    private RequestData processEncryption(Encryption enc, RoutingConnectionInfo routingConnInfo, MessageContext mc) throws AxisFault {
        try {
            RequestData reqData = this.fillRequestData(enc, mc);
            String issuerName = enc.getX509TokenRefIssuer();
            String serialNo = enc.getX509TokenRefSerialNumber();
            if (issuerName == null || issuerName.trim().isEmpty() || serialNo == null || serialNo.trim().isEmpty()) {
                if (mc.isClient()) {
                    issuerName = routingConnInfo.getDestinationX509IssuerName();
                    serialNo = routingConnInfo.getDestinationX509SerialNumber();
                    if (this.DEBUG) {
                        this.debug("reqData.encCert: Using routing configuration. Per-message override was not found.");
                    }
                } else {
                    this.processRequestSigningCertificate(mc, reqData);
                    return reqData;
                }
            }
            this.checkRequiredValue(issuerName, ISSUER_NAME);
            this.checkRequiredValue(serialNo, SERIAL_NO);
            BrokerCertificateStore certStore = this.getCertStore();
            this.checkCertStore(certStore);
            X509Certificate cert = certStore.findCertificateByIssuerAndSerialNumber(issuerName, WSSOutboundHandler.parseSerialNo(serialNo));
            this.checkCertificate(issuerName, serialNo, cert);
            reqData.encCert = cert;
            return reqData;
        }
        catch (SecurityPolicyException e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    private RequestData fillRequestData(Encryption enc, MessageContext mc) throws AxisFault, SecurityPolicyException {
        RequestData reqData = this.initializeReqData();
        reqData.action = "Encrypt";
        if (enc.isSP2002() && enc.getX509TokenRef() != null) {
            QName tokenRefModel = enc.getX509TokenRef();
            if (!"http://www.sonicsw.com/2005/06/wssp-ext".equals(tokenRefModel.getNamespaceURI())) {
                AxisFault fault = new AxisFault("WSSOutboundHandler: Unsupported token reference - " + tokenRefModel);
                return this.throwAxisFault(fault);
            }
            reqData.encKeyIdInString = tokenRefModel.getLocalPart();
            if (tokenRefModel.equals(SSPConstants.QN_TOKEN_REF_MODEL_KEYIDENTIFIER)) {
                reqData.encKeySKI = enc.getSubjectKeyIdentifier();
            }
        } else if (enc.isSP2005()) {
            reqData.encKeyIdInString = WSSPUtils.getOutboundTokenRef(enc, mc);
            if (reqData.encKeyIdInString.equals("KeyIdentifier")) {
                reqData.encKeySKI = enc.getSubjectKeyIdentifier();
            }
        }
        reqData.encKeyTransport = enc.getKeyEncryptionAlgorithm() != null ? enc.getKeyEncryptionAlgorithm() : "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        reqData.encSymmAlgo = enc.getEncryptionAlgorithm();
        reqData.encPartsInString = enc.getPartsAsString();
        return reqData;
    }

    private RequestData throwAxisFault(AxisFault fault) throws AxisFault {
        this.debugMessage(fault);
        throw fault;
    }

    private void processRequestSigningCertificate(MessageContext mc, RequestData reqData) throws AxisFault {
        WSHttpInRequest request = (WSHttpInRequest)mc.getProperty("com.sonicsw.net.http.HttpInRequest");
        reqData.encCert = request.getSigningCert();
        if (reqData.encCert == null) {
            this.throwAxisFault("WSSOutboundHandler: No certificate available for encrypting the response.");
        }
        if (this.DEBUG) {
            this.debug("Request signing certificate is used for encrypting the response.");
        }
    }

    private void throwAxisFault(String message) throws AxisFault {
        AxisFault fault = new AxisFault(message);
        this.debugMessage(fault);
        throw fault;
    }

    private void debugMessage(AxisFault fault) {
        if (this.DEBUG) {
            this.debug(THROWING_AXIS_FAULT_MESSAGE + fault.getMessage());
        }
    }

    private void checkRequiredValue(String value, String valueName) throws AxisFault {
        if (value == null || value.trim().isEmpty()) {
            this.throwAxisFault(String.format("WSSOutboundHandler: Invalid %s: %s", valueName, value));
        } else if (this.DEBUG) {
            this.debug(String.format("reqData.encCert: %s: %s", valueName, value));
        }
    }

    private static BigInteger parseSerialNo(String serialNo) {
        BigInteger serialNoBigInt = null;
        if (serialNo != null) {
            try {
                serialNoBigInt = new BigInteger(serialNo);
            }
            catch (NumberFormatException ex) {
                serialNoBigInt = new BigInteger(serialNo, 16);
            }
        }
        return serialNoBigInt;
    }

    private BrokerCertificateStore getCertStore() {
        BrokerCertificateStore certStore;
        block2: {
            certStore = null;
            try {
                certStore = BrokerCertificateStore.getInstance();
            }
            catch (KeyStoreException ex) {
                if (!this.DEBUG) break block2;
                this.debug("Got exception on getCertStore", ex);
            }
        }
        return certStore;
    }

    private void checkCertStore(BrokerCertificateStore certStore) throws AxisFault {
        if (certStore == null) {
            this.throwAxisFault("WSSOutboundHandler: unable to get BrokerCertificateStore.");
        }
    }

    private void checkCertificate(String issuerName, String serialNo, X509Certificate cert) throws AxisFault {
        if (cert == null) {
            this.throwAxisFault(String.format("WSSOutboundHandler: unable to get certificate issuer: %s, Serial Number: %s", issuerName, serialNo));
        }
    }

    private void processTransportBinding(TransportBindingAction transport, MessageContext mc) throws AxisFault {
        try {
            AlgorithmSuite algorithmSuite;
            TransportBindingResult result = new TransportBindingResult(mc);
            if (!result.validate(transport)) {
                String err = "WSSInboundHandler: processing TransportBinding Actions. Protocol Check failed: " + result.getStatus();
                AxisFault fault = new AxisFault(err);
                if (this.DEBUG) {
                    this.debug(err);
                }
                throw fault;
            }
            if (HttpHelper.ENABLE_TRANSPORTBINDING_SUITE_CHECKING && (algorithmSuite = transport.getAlgorithmSuite()) != null) {
                mc.setProperty("X-HTTPS-WS-BindingCipherSuite", (Object)SonicAlgorithmSuiteUtils.getAlgorithmSuiteName(algorithmSuite));
            }
        }
        catch (PolicyException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    private String getDefaultMessageParts(boolean protectToken) {
        if (protectToken) {
            return "{}{http://schemas.xmlsoap.org/soap/envelope/}Body; Token";
        }
        return "{}{http://schemas.xmlsoap.org/soap/envelope/}Body";
    }

    private String getSignatureEncryptionPart() {
        return "{Element}{http://www.w3.org/2000/09/xmldsig#}Signature";
    }

    private RequestData processTimestamp() {
        RequestData reqData = this.initializeReqData();
        reqData.action = "Timestamp";
        return reqData;
    }

    private boolean removeMissingParts(Document doc, Vector parts) {
        boolean partRemoved = false;
        Iterator itor = parts.iterator();
        while (itor.hasNext()) {
            WSEncryptionPart part = (WSEncryptionPart)itor.next();
            NodeList nodes = doc.getElementsByTagNameNS(part.getNamespace(), part.getName());
            if (nodes.getLength() != 0) continue;
            itor.remove();
            partRemoved = true;
        }
        return partRemoved;
    }

    private void buildWithRetry(WSBaseMessage action, Document doc, Vector parts, Crypto crypto) throws AxisFault {
        boolean encrypt;
        block11: {
            encrypt = false;
            if (!parts.isEmpty()) {
                action.setParts(parts);
            }
            try {
                if (action instanceof WSEncryptBody) {
                    encrypt = true;
                    ((WSEncryptBody)action).build(doc, (org.apache.ws.security.components.crypto.Crypto)crypto);
                    break block11;
                }
                if (action instanceof WSSignEnvelope) {
                    ((WSSignEnvelope)action).build(doc, (org.apache.ws.security.components.crypto.Crypto)crypto);
                    break block11;
                }
                throw new Exception("Invalid action type: " + action.getClass().getName());
            }
            catch (Exception ex) {
                boolean doRetry;
                Exception throwMe = ex;
                if (ex.getMessage().indexOf("Element to encrypt/sign not found") != -1 && (doRetry = this.removeMissingParts(doc, parts))) {
                    try {
                        if (encrypt) {
                            ((WSEncryptBody)action).build(doc, (org.apache.ws.security.components.crypto.Crypto)crypto);
                        } else {
                            ((WSSignEnvelope)action).build(doc, (org.apache.ws.security.components.crypto.Crypto)crypto);
                        }
                        throwMe = null;
                    }
                    catch (Exception retryEx) {
                        throwMe = retryEx;
                    }
                }
                if (throwMe == null) break block11;
                AxisFault fault = new AxisFault("WSSOutboundHandler: " + (encrypt ? "Encryption" : "Signature") + ": error during message processing. " + throwMe);
                throw this.debugFaultMessage(fault);
            }
        }
        if (this.DEBUG && this.DEBUG) {
            this.debug("WSSOutboundHandler: SOAP Message after " + (encrypt ? "encryption" : "signing") + ":\n" + org.apache.ws.security.util.XMLUtils.PrettyDocumentToString((Document)doc));
        }
    }

    private AxisFault debugFaultMessage(AxisFault fault) {
        if (this.DEBUG) {
            this.debug(THROWING_AXIS_FAULT_MESSAGE + fault.getMessage());
        }
        return fault;
    }

    private void cleanup(MessageContext mc) {
        mc.removeProperty(REQUEST_DATA);
        mc.removeProperty("com.sonicsw.ws.security.policy.SecurityPolicyAlternative");
    }

    private static KeyStore getEncKeyStore(X509Certificate encCert) {
        KeyStore encKeyStore = null;
        try {
            encKeyStore = KeyStore.getInstance("JKS");
            encKeyStore.load(null, ENC_CRYPTO_KEYSTORE_PSW_VALUE.toCharArray());
            if (encCert != null) {
                encKeyStore.setCertificateEntry(ENC_CRYPTO_CERT_ALIAS, encCert);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return encKeyStore;
    }

    static {
        try {
            s_emptyKeyStore = WSSOutboundHandler.getEncKeyStore(null);
            s_crypto = new Crypto(s_emptyKeyStore);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class CryptoSKI
    extends Crypto {
        private byte[] skiBytes;

        CryptoSKI(KeyStore keyStore) throws Exception {
            super(keyStore);
            this.skiBytes = null;
        }

        public void setSKIBytes(byte[] ski) {
            this.skiBytes = ski;
        }

        @Override
        public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
            return this.skiBytes;
        }
    }

    private static class Crypto
    extends Merlin {
        Crypto(KeyStore keyStore) throws Exception {
            super(null);
            this.keystore = keyStore;
        }

        public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
            if (cert.getVersion() < 3) {
                throw new RuntimeException("SKI not available - certificate version (<3)");
            }
            byte[] derEncodedValue = cert.getExtensionValue("2.5.29.14");
            if (derEncodedValue == null) {
                throw new RuntimeException("SKI not available from certificate:\n" + cert);
            }
            byte[] abyte0 = new byte[derEncodedValue.length - 4];
            System.arraycopy(derEncodedValue, 4, abyte0, 0, abyte0.length);
            return abyte0;
        }
    }

    private class RequestData {
        boolean noSerialization = false;
        SOAPConstants soapConstants;
        String actor;
        String username;
        String pwType = "PasswordText";
        String[] utElements;
        Crypto sigCrypto;
        int sigKeyId;
        String sigAlgorithm;
        Vector signatureParts = new Vector();
        Crypto encCrypto;
        int encKeyId;
        String encSymmAlgo;
        String encKeyTransport;
        String encUser;
        Vector encryptParts = new Vector();
        X509Certificate encCert;
        int timeToLive = 300;
        String action;
        boolean mustUnderstand = true;
        Document sndSecurity;
        String pwCallbackClass;
        String pwCallbackRef;
        String userPassword;
        byte[] key;
        KeyStore encKeyStore;
        String encKeyIdInString;
        String encKeyName;
        String encPartsInString;
        String encKeySKI = null;
        KeyStore sigKeyStore;
        String sigKeyIdInString;
        String sigPartsInString;
        String sigCanonAlgo;

        private RequestData() {
        }

        void clear() {
            this.soapConstants = null;
            this.encUser = null;
            this.encKeyTransport = null;
            this.encSymmAlgo = null;
            this.sigAlgorithm = null;
            this.pwType = null;
            this.username = null;
            this.actor = null;
            this.encCrypto = null;
            this.sigCrypto = null;
            this.signatureParts.clear();
            this.encryptParts.clear();
            this.encryptParts = null;
            this.signatureParts = null;
            this.encCert = null;
            this.utElements = null;
            this.userPassword = null;
            this.pwCallbackRef = null;
            this.pwCallbackClass = null;
            this.action = null;
            this.encPartsInString = null;
            this.encKeyName = null;
            this.encKeyIdInString = null;
            this.sigCanonAlgo = null;
            this.sigPartsInString = null;
            this.sigKeyIdInString = null;
            this.mustUnderstand = true;
            this.sndSecurity = null;
            this.key = null;
            this.encKeyStore = null;
            this.sigKeyStore = null;
        }
    }
}

