/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.Serializable;
import java.util.Enumeration;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.SubjectDeleteTracker;
import progress.message.broker.SyncDeleteMsgEvt;
import progress.message.util.DebugState;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;
import progress.message.zclient.FastVector;

class DeleteMsgManager
extends DebugObject {
    private LongHashTable<LongHashTable<SubjectDeleteTracker>> m_pubSubDeletes = new LongHashTable();
    private LongHashTable<Long> m_queueDeletes = new LongHashTable();
    private static final SubjectDeleteTracker FULLY_ACKED = new SubjectDeleteTracker();

    DeleteMsgManager() {
        super(DebugState.GLOBAL_DEBUG_ON ? "DeleteMsgManager" : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPubSubDelete(long messageId, long clientId, boolean subjectAck, short subjectTracking) {
        this.debugAddingPubsubDelete(messageId);
        LongHashTable<LongHashTable<SubjectDeleteTracker>> longHashTable = this.m_pubSubDeletes;
        synchronized (longHashTable) {
            LongHashTable<SubjectDeleteTracker> cids = this.m_pubSubDeletes.get(messageId);
            if (cids == null) {
                cids = new LongHashTable();
                this.m_pubSubDeletes.put(messageId, cids);
            }
            if (subjectAck) {
                SubjectDeleteTracker tracker = cids.get(clientId);
                if (tracker == FULLY_ACKED) {
                    return;
                }
                if (tracker == null) {
                    tracker = new SubjectDeleteTracker(messageId, clientId);
                    cids.put(clientId, tracker);
                }
                tracker.addDeletedSubject(subjectTracking);
            } else {
                cids.put(clientId, FULLY_ACKED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPubSubDelete(long messageId, long clientId) {
        if (this.DEBUG) {
            this.debug("checking for PubSub delete: " + messageId);
        }
        boolean ret = false;
        LongHashTable<LongHashTable<SubjectDeleteTracker>> longHashTable = this.m_pubSubDeletes;
        synchronized (longHashTable) {
            SubjectDeleteTracker tracker;
            LongHashTable<SubjectDeleteTracker> cids = this.m_pubSubDeletes.get(messageId);
            if (cids != null && (tracker = cids.get(clientId)) == FULLY_ACKED) {
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePubSubDelete(long messageId, long clientId, boolean subjectAck, short subjectTracking) {
        this.debugAddingPubsubDelete(messageId);
        LongHashTable<LongHashTable<SubjectDeleteTracker>> longHashTable = this.m_pubSubDeletes;
        synchronized (longHashTable) {
            LongHashTable<SubjectDeleteTracker> cids = this.m_pubSubDeletes.get(messageId);
            if (cids != null) {
                if (subjectAck) {
                    SubjectDeleteTracker tracker = cids.get(clientId);
                    if (tracker == null || tracker == FULLY_ACKED) {
                        return;
                    }
                    if (tracker.removeDeletedSubject(subjectTracking)) {
                        cids.remove(clientId);
                    }
                } else {
                    cids.remove(clientId);
                }
                if (cids.isEmpty()) {
                    this.m_pubSubDeletes.remove(messageId);
                }
            }
        }
    }

    private void debugAddingPubsubDelete(long messageId) {
        if (this.DEBUG) {
            this.debug("Adding PubSub delete: " + messageId);
        }
    }

    public void addQueueDelete(long messageId) {
        if (this.DEBUG) {
            this.debug("Adding Queue delete: " + messageId);
        }
        this.m_queueDeletes.put(messageId, (Long)messageId);
    }

    public void removeQueueDelete(long messageId) {
        if (this.DEBUG) {
            this.debug("Removing Queue delete: " + messageId);
        }
        this.m_queueDeletes.remove(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSyncRecords() throws ECannotFlushEvents {
        LongHashTable pubSubRecords = null;
        LongHashTable queueRecords = null;
        FastVector subjectAcks = null;
        int subjectAckLength = 0;
        LongHashTable<Serializable> longHashTable = this.m_pubSubDeletes;
        synchronized (longHashTable) {
            pubSubRecords = new LongHashTable(this.m_pubSubDeletes.size());
            Enumeration<Long> deletes = this.m_pubSubDeletes.keys();
            while (deletes.hasMoreElements()) {
                Long key = deletes.nextElement();
                LongHashTable<SubjectDeleteTracker> lht = this.m_pubSubDeletes.get(key);
                LongHashTable<SubjectDeleteTracker> lhtClone = new LongHashTable<SubjectDeleteTracker>(lht.size());
                Enumeration<Long> keys = lht.keys();
                Enumeration<SubjectDeleteTracker> elems = lht.elements();
                while (keys.hasMoreElements()) {
                    long cid = keys.nextElement();
                    SubjectDeleteTracker tracker = elems.nextElement();
                    if (tracker != FULLY_ACKED) {
                        if (subjectAcks == null) {
                            subjectAcks = new FastVector(lht.size() / 2);
                        }
                        subjectAcks.addElement(tracker.protectedClone());
                        subjectAckLength += tracker.serializedLength();
                        continue;
                    }
                    lhtClone.put(cid, tracker);
                }
                pubSubRecords.put((long)key, lhtClone);
            }
            if (this.DEBUG) {
                this.debug("Writing: " + pubSubRecords.size() + " PubSub records");
            }
        }
        longHashTable = this.m_queueDeletes;
        synchronized (longHashTable) {
            queueRecords = (LongHashTable)this.m_queueDeletes.clone();
            if (this.DEBUG) {
                this.debug("Writing: " + queueRecords.size() + " Queue records");
            }
        }
        if (pubSubRecords.size() > 0 || queueRecords.size() > 0 || subjectAcks != null) {
            SyncDeleteMsgEvt evt = new SyncDeleteMsgEvt(pubSubRecords, queueRecords, subjectAcks, subjectAckLength);
            AgentRegistrar.getAgentRegistrar().getLogManager().tryAddEvent(evt, false);
        }
    }
}

