/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.BrokerJob;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.Config;
import progress.message.broker.DeleteSubscriptionManager;
import progress.message.broker.DurableCCTracker;
import progress.message.broker.EBrokerAborted;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EOperationCancelled;
import progress.message.broker.ETrackingNumNotFound;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.GroupSubscriptions;
import progress.message.broker.IClientContext;
import progress.message.broker.IDBUpdRedelivListener;
import progress.message.broker.IPostponedOperation;
import progress.message.broker.IReplicateableSaverOp;
import progress.message.broker.ISaverPostProcessor;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.MgramSerializer;
import progress.message.broker.MsgSaverOp;
import progress.message.broker.PublishLimiter;
import progress.message.broker.StatsManager;
import progress.message.broker.StatsMetrics;
import progress.message.broker.TrackedSubjectFilter;
import progress.message.broker.durable.DurableRemoveOp;
import progress.message.broker.durable.DurableTrimOp;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.prAccessor;
import progress.message.broker.stats.LMaxStatsObj;
import progress.message.broker.stats.LTotStatsObj;
import progress.message.broker.stats.LValueStatsObj;
import progress.message.db.EDatabaseException;
import progress.message.ft.DurableMsgDynSyncer;
import progress.message.ft.DurableSyncReplicationMgr;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.IFTEventProcessor;
import progress.message.ft.MsgSaveEvt;
import progress.message.ft.ReplicationManager;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.util.IndexedList;
import progress.message.util.LongHashTable;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.DebugThread;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.FastVector;
import progress.message.zclient.QueueLimiter;
import progress.message.zclient.xonce.MgramTrace;

public class MsgSaver
extends DebugThread {
    private static final int UNDELMSGS_DBSIZE = 100;
    private BrokerDatabase m_db;
    private ReplicationManager m_replMgr;
    private DurableSyncReplicationMgr m_durSyncReplMgr;
    private StatsManager m_statsMgr;
    private FastVector m_todolist;
    private long m_msgSaverOpNum = 0L;
    private LongHashTable m_idsToSaveOpsQueued;
    private LongHashTable m_idsToSaveOpsInProgress;
    private FastVector m_prevTodolist;
    private QueueLimiter m_limiter;
    private volatile boolean m_shutdown = false;
    private int m_queueSize;
    private LTotStatsObj numQueueWaits1;
    private LTotStatsObj dbOperations1;
    private LMaxStatsObj maxCommitSize1;
    private LTotStatsObj numCommits1;
    private LTotStatsObj totTxMSecs1;
    private LTotStatsObj bdbWaitTimeMSecs;
    private int numSaves;
    private int numDeletes;
    private int numUpdates;
    private int numDurable;
    private long m_dbSpaceQueued = 0L;
    private long m_dbSpaceInProgress = 0L;
    private boolean debugStatsEnabled = false;
    private boolean DEBUG1 = (this.debugFlags & 0x40) > 0;
    private int m_flushState;
    private static int s_cdiRequestMaxSize = Math.max(1, Config.REPLICATION_CHUNK_SIZE);
    private static int s_cdiRequestFixedSize = 37;
    private static int s_updateRedelivMemSize = MemoryUtil.estimateBaseSize(MsgUpdRedelivOp.class);

    MsgSaver(AgentRegistrar reg) {
        super("MsgSaver");
        this.m_db = reg.getBrokerDatabase();
        this.m_statsMgr = reg.getStatsManager();
        this.m_todolist = new FastVector();
        this.m_prevTodolist = new FastVector();
        this.m_idsToSaveOpsQueued = new LongHashTable();
        this.m_idsToSaveOpsInProgress = new LongHashTable();
        this.m_limiter = new QueueLimiter(Config.PS_DB_QUEUE_SIZE >>> 1);
        if (this.DEBUG1) {
            this.debug("Config.PS_DB_QUEUE_SIZE= " + Config.PS_DB_QUEUE_SIZE);
        }
        boolean bl = this.debugStatsEnabled = (this.debugFlags & 2) > 0 && StatsMetrics.areStatsEnabled(3);
        if (this.debugStatsEnabled) {
            this.numQueueWaits1 = new LTotStatsObj(3, "MsgSaver numQueueWaits", 1);
            this.m_statsMgr.registerStat(this.numQueueWaits1);
            this.dbOperations1 = new LTotStatsObj(3, "MsgSaver dbOperations", 1);
            this.dbOperations1.outputStatistic("MsgSaver avgDbOps", 6);
            this.m_statsMgr.registerStat(this.dbOperations1);
            this.maxCommitSize1 = new LMaxStatsObj(3, "MsgSaver maxCommitSize", 4);
            this.m_statsMgr.registerStat(this.maxCommitSize1);
            this.numCommits1 = new LTotStatsObj(3, "MsgSaver numCommits", 1);
            this.m_statsMgr.registerStat(this.numCommits1);
            this.totTxMSecs1 = new LTotStatsObj(3, "MsgSaver thread Utilization", 8);
            this.m_statsMgr.registerStat(this.totTxMSecs1);
            this.bdbWaitTimeMSecs = new LTotStatsObj(3, "MsgSaver bdbWaitTimeMSec", 1);
            this.m_statsMgr.registerStat(this.bdbWaitTimeMSecs);
        }
        if ((this.debugFlags & 2) > 0 && StatsMetrics.areStatsEnabled(1)) {
            this.m_statsMgr.registerStat(new LValueStatsObj(1, "MsgSaver QSize (Bytes)", 2){

                @Override
                public synchronized long getCurrentValue() {
                    this.update(((MsgSaver)MsgSaver.this).m_limiter.m_size);
                    return super.getCurrentValue();
                }
            });
            this.m_statsMgr.registerStat(new LValueStatsObj(1, "MsgSaver QSize (numOperations)", 2){

                @Override
                public synchronized long getCurrentValue() {
                    this.update(MsgSaver.this.m_queueSize);
                    return super.getCurrentValue();
                }
            });
        }
    }

    private int saveOpDbSpace(IMgram msg, int numRecipients) {
        int undelMsgsSize = numRecipients * 87;
        if (msg.getBrokerHandle().isDBSaveRequested()) {
            return undelMsgsSize;
        }
        return 124 + msg.getBrokerHandle().getTrackedSize() + undelMsgsSize;
    }

    synchronized void save(IMgram msg, IClientContext toParam, boolean jms_redelivery, boolean inDoubt, boolean postpone) throws RuntimeException {
        IClientContext to = toParam;
        if (!msg.isGuarenteed() && (msg.getType() != 27 || msg.getBatchHandle().isAtomic())) {
            throw new EAssertFailure("Attempted to save unguaranteed message", null);
        }
        if (to.isGroupSubscriptionMember()) {
            msg.getBrokerHandle().clearMsgHeader(to.getId());
            to = to.getGroupSubscriptionCC();
            to.notifySave(msg, postpone);
        }
        int size = 0;
        if (msg.getBrokerHandle().isDBSaveRequested()) {
            size = 100;
        } else {
            size = msg.memoryLength();
            msg.getBrokerHandle().setDBSaveRequested(true);
        }
        MsgSaveOp op = new MsgSaveOp(msg, to, jms_redelivery, inDoubt, size, postpone);
        this.m_dbSpaceQueued += (long)this.saveOpDbSpace(msg, 1);
        if (!postpone) {
            this.waitForQueueSpace(size);
            if (!this.m_shutdown) {
                this.m_todolist.addElement(op);
                this.m_limiter.add(size);
                ++this.m_queueSize;
            } else {
                throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
            }
            this.notifyAll();
        } else {
            AgentRegistrar.getAgentRegistrar().getPostponedMsgSaver().performPostponedOperation(op);
        }
    }

    public synchronized void enqueue(MsgSaverOp op, int size) {
        this.waitForQueueSpace(size);
        if (!this.m_shutdown) {
            this.m_todolist.addElement(op);
            this.m_limiter.add(size);
            ++this.m_queueSize;
        } else {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        this.notifyAll();
    }

    synchronized void save(IndexedList msgs, IClientContext to, boolean jms_redelivery, boolean inDoubt, boolean postPone) throws RuntimeException {
        Enumeration elements = msgs.elements();
        while (elements.hasMoreElements()) {
            IMgram m = (IMgram)elements.nextElement();
            if (m.getBrokerHandle().isFromDB()) continue;
            this.save(m, to, jms_redelivery, inDoubt, postPone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long save(IMgram msg, PublishLimiter pubLimiter, FastVector to, FastVector proxying, LongHashTable lbsProxyRecips, AgentGuarMsgTracker track, boolean jms_redelivery, boolean inDoubt, boolean offloaded, boolean nonGuarOk) throws RuntimeException {
        long localMsgSaverOpNum;
        MsgSaver msgSaver = this;
        synchronized (msgSaver) {
            FastVector toClone = to;
            this.replaceCCIdsWithGroupCCIds(to, msg, false);
            if (!(offloaded || nonGuarOk || msg.isGuarenteed() || msg.getType() == 27 && !msg.getBatchHandle().isAtomic())) {
                throw new EAssertFailure("Attempted to save unguaranteed message", null);
            }
            if (!MsgSaver.isDbTrackingSet(msg)) {
                String err = "Attempted to save a message w/o the db tracking number";
                EAssertFailure t = new EAssertFailure(err);
                BrokerComponent.getComponentContext().logMessage(MgramTrace.diagnosticString(err, null, msg), (Throwable)t, 2);
                throw t;
            }
            int size = 0;
            if (msg.getBrokerHandle().isDBSaveRequested()) {
                size = 100;
            } else {
                size = msg.memoryLength();
                if (!offloaded) {
                    msg.getBrokerHandle().setDBSaveRequested(true);
                }
            }
            this.waitForQueueSpace(size);
            if (this.m_shutdown) {
                throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
            }
            if (offloaded) {
                toClone = (FastVector)to.clone();
            }
            MsgSaveOp op = new MsgSaveOp(msg, toClone, proxying, lbsProxyRecips, track, jms_redelivery, inDoubt, size);
            if (offloaded) {
                ++this.m_msgSaverOpNum;
                this.m_idsToSaveOpsQueued.put(this.m_msgSaverOpNum, op);
            }
            localMsgSaverOpNum = this.m_msgSaverOpNum;
            this.m_todolist.addElement(op);
            this.m_limiter.add(size);
            ++this.m_queueSize;
            this.m_dbSpaceQueued += (long)this.saveOpDbSpace(msg, to.m_count);
            this.notifyAll();
        }
        if (pubLimiter != null) {
            this.m_db.blockPublisherOnDbSpace(to, pubLimiter);
        }
        return localMsgSaverOpNum;
    }

    synchronized void retrieveSubjectAckMappings(IClientContext cc, long highestInDoubt) {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        this.m_todolist.addElement(new RetrieveSubjectAckTrackingsOp(cc, highestInDoubt));
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMgram retrieveMessageForRecipient(long msgSaverOpIndx, IClientContext recipient) {
        MsgSaveOp saveOp = null;
        IMgram message = null;
        boolean foundInQueued = false;
        boolean recipientCanceledNow = false;
        boolean saveOpCanceledBefore = false;
        boolean saveOpCanceledNow = false;
        MsgSaver msgSaver = this;
        synchronized (msgSaver) {
            saveOp = (MsgSaveOp)this.m_idsToSaveOpsInProgress.get(msgSaverOpIndx);
            if (saveOp == null) {
                foundInQueued = true;
                saveOp = (MsgSaveOp)this.m_idsToSaveOpsQueued.get(msgSaverOpIndx);
            }
            if (saveOp == null) {
                return null;
            }
            MsgSaveOp msgSaveOp = saveOp;
            synchronized (msgSaveOp) {
                if (!saveOp.m_canceled) {
                    recipientCanceledNow = saveOp.cancelSaveForRecipient(recipient);
                    if (saveOp.m_canceled) {
                        saveOpCanceledNow = true;
                    }
                } else {
                    saveOpCanceledBefore = true;
                }
                message = saveOp.m_msg;
            }
            if (recipientCanceledNow || saveOpCanceledBefore) {
                if (recipientCanceledNow && foundInQueued && saveOpCanceledNow) {
                    this.m_idsToSaveOpsQueued.remove(msgSaverOpIndx);
                    this.m_limiter.add(-saveOp.m_size);
                    saveOp.m_msg = null;
                    this.notifyAll();
                }
            } else if (message != null) {
                try {
                    message = (IMgram)message.protectedClone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                if (message.getType() != 27) {
                    message.getBrokerHandle().setFromDB(true);
                } else {
                    message.getBrokerHandle().setFromDB(true);
                    Iterator iter = message.getBatchHandle().getBatchIterator();
                    while (iter.hasNext()) {
                        IMgram subMgram = (IMgram)iter.next();
                        subMgram.getBrokerHandle().setFromDB(true);
                    }
                }
            }
        }
        if (recipientCanceledNow && message != null) {
            recipient.msgSaveDone(message, saveOp.m_postponed);
        }
        return message;
    }

    public void deleteMsg(IClientContext cc, long tracking, int size, boolean notify, boolean syncPersist) throws RuntimeException {
        this.deleteMsg(cc, tracking, size, notify, syncPersist, false, (short)-1);
    }

    public synchronized void deleteMsg(IClientContext cc, long tracking, int size, boolean notify, boolean syncPersist, boolean subjectAck, short subjectTracking) throws RuntimeException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        IClientContext target = cc;
        if (cc.isGroupSubscriptionMember()) {
            target = cc.getGroupSubscriptionCC();
        }
        if (syncPersist) {
            AgentRegistrar.getAgentRegistrar().getDeleteMsgManager().addPubSubDelete(tracking, target.getId(), subjectAck, subjectTracking);
        }
        this.m_todolist.addElement(new MsgDeleteOp(target, tracking, size, notify, syncPersist, subjectAck, subjectTracking));
        this.m_dbSpaceQueued -= 87L;
        this.notifyAll();
    }

    public synchronized void deleteMsg(IClientContext cc, IMgram msg, boolean notify, boolean syncPersist) throws RuntimeException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        IClientContext target = cc;
        if (cc.isGroupSubscriptionMember()) {
            target = cc.getGroupSubscriptionCC();
        }
        if (msg.getType() != 27) {
            this.deleteMsg(target, msg.getGuarenteedTrackingNum(), msg.getBrokerHandle().getTrackedSize(), notify, syncPersist);
        } else {
            IMgram subMgram = null;
            Iterator it = msg.getBatchHandle().getBatchIterator();
            while (it.hasNext()) {
                subMgram = (IMgram)it.next();
                long tracking = subMgram.getGuarenteedTrackingNum();
                if (syncPersist) {
                    AgentRegistrar.getAgentRegistrar().getDeleteMsgManager().addPubSubDelete(tracking, target.getId(), false, (short)-1);
                }
                this.m_todolist.addElement(new MsgDeleteOp(target, tracking, subMgram.getBrokerHandle().getTrackedSize(), notify && !it.hasNext(), syncPersist, false, -1));
                this.m_dbSpaceQueued -= 87L;
            }
            this.notifyAll();
        }
    }

    public void deleteMsgFlushPostponedSaves(long clientId, long tracking, int size, boolean syncPersist) throws RuntimeException, InterruptedException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        IClientContext cc = null;
        try {
            cc = AgentRegistrar.getAgentRegistrar().getClient(clientId);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        if (cc != null && cc.getPostponedMessageSaves() > 0L) {
            AgentRegistrar.getAgentRegistrar().getPostponedMsgSaver().flush();
        }
        this.deleteMsg(clientId, tracking, size, syncPersist);
    }

    public void deleteMsg(long clientId, long tracking, int size, boolean syncPersist) throws RuntimeException {
        this.deleteMsg(clientId, tracking, size, syncPersist, false, (short)-1);
    }

    public synchronized void deleteMsg(long clientId, long tracking, int size, boolean syncPersist, boolean subjectAck, short subjectTracking) throws RuntimeException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        if (syncPersist) {
            AgentRegistrar.getAgentRegistrar().getDeleteMsgManager().addPubSubDelete(tracking, clientId, subjectAck, subjectTracking);
        }
        this.m_todolist.addElement(new MsgDeleteOp(clientId, tracking, size, syncPersist, subjectAck, subjectTracking));
        this.m_dbSpaceQueued -= 87L;
        this.notifyAll();
    }

    public synchronized void deleteAllMsgs(long id, long maxMessageId, boolean persistent, boolean replicateOnly) {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        AgentRegistrar.getAgentRegistrar().getPostponedMsgSaver().performPostponedOperation(new MsgDeleteAllOp(id, maxMessageId, persistent, replicateOnly, Config.RESTORE_MSGS_COUNT));
    }

    public synchronized void trimMessages(DurableTrimOp op, long maxMessageId) {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        AgentRegistrar.getAgentRegistrar().getPostponedMsgSaver().performPostponedOperation(new TrimMessagesOp(op, maxMessageId, 0, Config.RESTORE_MSGS_COUNT));
    }

    public synchronized void updateMsg(long cid, long tracking, long id, IDBUpdRedelivListener listener, boolean successor) throws RuntimeException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        this.m_todolist.addElement(new MsgUpdRedelivOp(cid, tracking, id, listener, successor));
        this.notifyAll();
    }

    public synchronized void performDurableOperation(IDurableOperation op) throws RuntimeException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        if (op.isReplicateable()) {
            this.performReplicateableDurableOperation((IReplicateableSaverOp)((Object)op));
        } else {
            this.m_todolist.addElement(new MsgDurableOperationOp(op));
        }
        this.notifyAll();
    }

    private synchronized void performReplicateableDurableOperation(IReplicateableSaverOp op) throws RuntimeException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        this.m_todolist.addElement(new MsgDurableOperationOp(op));
        this.notifyAll();
    }

    public synchronized void replicateUndelMsgs(long minTrackingNumber, long maxTrackingNumber, BrokerJob job) throws RuntimeException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        this.m_todolist.addElement(new ReplicateUndelMsgsOp(minTrackingNumber, maxTrackingNumber, job));
        this.notifyAll();
    }

    public synchronized void replicateMsgs(List msgIdList, boolean lastChunk) throws RuntimeException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        this.m_todolist.addElement(new ReplicateMsgsOp(msgIdList, lastChunk));
        this.notifyAll();
    }

    public synchronized void saveUndelMsgs(List msgs, long replyTracking) throws RuntimeException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        this.m_todolist.addElement(new SaveUndelMsgsOp(msgs, replyTracking));
        this.notifyAll();
    }

    public synchronized void saveReplicatedMsgs(List msgs, int size) throws RuntimeException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        this.waitForQueueSpace(size);
        this.m_todolist.addElement(new SaveReplicatedMsgsOp(msgs));
        this.notifyAll();
    }

    public synchronized void performPostponedOperation(IPostponedOperation op) throws InterruptedException {
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
        this.waitForQueueSpace(op.memsize());
        op.preProcess();
        if (op.getOperation() != null) {
            this.m_todolist.addElement(op.getOperation());
        }
        this.notifyAll();
    }

    public synchronized void flush() throws InterruptedException, RuntimeException {
        this.m_flushState = 2;
        this.notifyAll();
        while (this.m_flushState > 0 && !this.m_shutdown) {
            this.wait();
        }
        if (this.m_shutdown) {
            throw new RuntimeException(prAccessor.getString("MSGSAVER_ERROR"));
        }
    }

    private synchronized FastVector getTodolist() throws InterruptedException {
        this.m_idsToSaveOpsInProgress.clear();
        while (this.m_todolist.m_count == 0 && !Broker.exiting) {
            if (this.m_flushState > 0) {
                this.m_flushState = 0;
                this.notifyAll();
            }
            do {
                this.wait();
            } while (this.m_todolist.m_count == 0 && this.m_flushState == 0 && !Broker.exiting);
        }
        FastVector ret = this.m_todolist;
        this.m_todolist = this.m_prevTodolist;
        this.m_prevTodolist = ret;
        LongHashTable temp = this.m_idsToSaveOpsInProgress;
        this.m_idsToSaveOpsInProgress = this.m_idsToSaveOpsQueued;
        this.m_idsToSaveOpsQueued = temp;
        this.m_dbSpaceInProgress = this.m_dbSpaceQueued;
        this.m_dbSpaceQueued = 0L;
        this.m_limiter.reset();
        this.m_queueSize = 0;
        if (this.m_flushState > 0) {
            --this.m_flushState;
        }
        this.notifyAll();
        return ret;
    }

    synchronized void resetDbSpace() {
        this.m_dbSpaceInProgress = 0L;
    }

    synchronized long getDbSpace() {
        return this.m_dbSpaceQueued + this.m_dbSpaceInProgress;
    }

    private synchronized void waitForQueueSpace(int size) {
        try {
            while (!this.m_limiter.hasRoom(size) && !this.m_shutdown) {
                if (this.debugStatsEnabled) {
                    this.numQueueWaits1.add(1L);
                }
                this.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void replaceCCIdsWithGroupCCIds(FastVector to, IMgram msg, boolean postpone) {
        for (int i = 0; i < to.m_count; ++i) {
            GroupSubscriptionClientContext groupcc;
            IClientContext cc = (IClientContext)to.m_data[i];
            if (!cc.isGroupSubscriptionMember() || (groupcc = cc.getGroupSubscriptionCC()) == null) continue;
            msg.getBrokerHandle().clearMsgHeader(cc.getId());
            groupcc.notifySave(msg, postpone);
            to.m_data[i] = groupcc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() throws InterruptedException {
        try {
            if (this.DEBUG1) {
                this.debug("starting");
            }
            BrokerStateManager bsm = BrokerStateManager.getBrokerStateManager();
            int numTx = 0;
            while (!Broker.exiting) {
                FastVector todolist = this.getTodolist();
                if (Broker.exiting) {
                    break;
                }
                if (this.DEBUG) {
                    this.debug("beginning message saves/deletes");
                }
                long start = System.currentTimeMillis();
                long waitTime = 0L;
                boolean isActive = bsm.isActive();
                this.doTodoList(todolist, isActive);
                ++numTx;
                if (this.m_shutdown) {
                    return;
                }
                if (this.debugStatsEnabled) {
                    long currentTime = System.currentTimeMillis();
                    waitTime = currentTime - start;
                }
                long now = System.currentTimeMillis();
                if (this.debugStatsEnabled) {
                    this.bdbWaitTimeMSecs.add(waitTime);
                    this.totTxMSecs1.add(now - start);
                    this.dbOperations1.add(todolist.m_count);
                    this.maxCommitSize1.update(todolist.m_count);
                    this.numCommits1.add(1L);
                    this.maxCommitSize1.update(0L);
                }
                if (this.DEBUG) {
                    this.debug("message saves/deletes committed");
                }
                if (this.DEBUG1 && numTx % 100 == 0) {
                    this.debug("txCount= 100 numSaves= " + this.numSaves + " numDeletes= " + this.numDeletes + " numUpdates= " + this.numUpdates + " numDurable= " + this.numDurable);
                    this.numSaves = 0;
                    this.numDeletes = 0;
                    this.numUpdates = 0;
                    this.numDurable = 0;
                    numTx = 0;
                }
                for (int i = 0; i < todolist.m_count; ++i) {
                    ((MsgSaverOp)todolist.m_data[i]).postProcess();
                    todolist.m_data[i] = null;
                }
                todolist.m_count = 0;
                if (!this.DEBUG) continue;
                this.debug("post_processing done");
            }
        }
        catch (InterruptedException e) {
            if (!Broker.exiting) {
                throw e;
            }
        }
        finally {
            if (this.DEBUG) {
                this.debug("Thread Exiting; Broker.exiting= " + Broker.exiting);
            }
        }
    }

    private void commitStandby() throws InterruptedException {
        this.initReplication();
        this.m_replMgr.replicateSaverOp(new MsgCommitOp(this.m_db.getMaxAddedMessageId()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTodoList(FastVector todolist, boolean isActive) throws InterruptedException {
        block26: {
            boolean needRelease = false;
            try {
                this.m_db.beginPubSubDBTran();
                needRelease = true;
                this.doTodo(todolist);
                if (Config.REPLICATED && isActive) {
                    this.commitStandby();
                }
                this.m_db.commitPubSubTran(true);
            }
            catch (EOperationCancelled e) {
                if (Broker.exiting) {
                    Thread.currentThread().interrupt();
                }
                try {
                    this.m_db.rollbackPubSubTran();
                }
                catch (EDatabaseException de) {
                    if (this.DEBUG) {
                        this.debug("A database exception occurred during roll back.", de);
                    }
                    this.checkIsBrokerExiting(de);
                }
                MsgSaver de = this;
                synchronized (de) {
                    this.m_shutdown = true;
                    this.notifyAll();
                }
            }
            catch (IOException e) {
                if (Broker.exiting) {
                    Thread.currentThread().interrupt();
                }
                if (needRelease) {
                    try {
                        this.m_db.rollbackPubSubTran();
                    }
                    catch (EDatabaseException de) {
                        if (this.DEBUG) {
                            this.debug("A database exception occurred during roll back.");
                        }
                        this.checkIsBrokerExiting(de);
                    }
                }
                MsgSaver de = this;
                synchronized (de) {
                    this.m_shutdown = true;
                    this.notifyAll();
                }
                if (Broker.exiting) break block26;
                try {
                    BrokerComponent.getBrokerComponent().abort(prAccessor.getString("ERROR_SAVE_DELETE"), e, 1);
                }
                catch (EBrokerAborted eba) {
                    return;
                }
            }
            finally {
                if (needRelease) {
                    this.m_db.releasePubSubDBTran();
                }
            }
        }
    }

    private void checkIsBrokerExiting(EDatabaseException de) {
        if (!Broker.exiting) {
            BrokerComponent.getComponentContext().logMessage((Throwable)de, 2);
        }
    }

    private void doTodo(FastVector todolist) throws IOException {
        for (int i = 0; i < todolist.m_count; ++i) {
            boolean opCanceled;
            MsgSaverOp op = (MsgSaverOp)todolist.m_data[i];
            boolean bl = opCanceled = !op.markProcessedBySaver();
            if (opCanceled) continue;
            if (Config.REPLICATED) {
                this.initReplication();
                if (op.isReplicateable() && !op.replicatePostDoit() && this.m_replMgr.okToReplicate()) {
                    this.suppressDynamicSyncOperation(op);
                }
            }
            try {
                op.doit(this.m_db);
            }
            catch (NullPointerException ex) {
                BrokerComponent.getComponentContext().logMessage("NullPointerException in MsgSaver; op= " + op.getClass().getName(), 1);
                throw ex;
            }
            if (Config.REPLICATED) {
                this.initReplication();
                if (op.isReplicateable() && op.replicatePostDoit() && this.m_replMgr.okToReplicate()) {
                    this.suppressDynamicSyncOperation(op);
                }
            }
            if (!this.CALLBACK) continue;
            this.callback("MsgSaver operation performed", 1, op);
        }
    }

    private void suppressDynamicSyncOperation(MsgSaverOp op) {
        if (!this.m_durSyncReplMgr.suppressSynchronization(op.getMessageId())) {
            this.m_replMgr.replicateSaverOp((IReplicateableSaverOp)((Object)op));
        } else if (this.DEBUG) {
            this.debug("Suppressing: " + op);
        }
    }

    private void initReplication() {
        if (this.m_replMgr == null) {
            this.m_replMgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
            this.m_durSyncReplMgr = AgentRegistrar.getAgentRegistrar().getDurableSyncReplicationMgr();
        }
    }

    public synchronized void exiting() {
        this.notifyAll();
    }

    @Override
    protected void callback(String text, int method, Object params) {
        super.callback(text, method, params);
    }

    public static FastVector handleProxySaves(IMgram msg, IClientContext proxy, boolean inDoubt, boolean postponedSaver) {
        FastVector proxyingRecips = null;
        if (msg.getBrokerHandle().getProxyRecipsTable() != null && proxy.getProxyHandle() != null && msg.getBrokerHandle().getProxyRecipsTable().containsKey(proxy.getId())) {
            proxyingRecips = (FastVector)msg.getBrokerHandle().getProxyRecipsTable().get(proxy.getId());
            for (int i = 0; i < proxyingRecips.m_count; ++i) {
                IClientContext proxying = (IClientContext)proxyingRecips.m_data[i];
                proxying.notifySave(msg, postponedSaver);
                if (!inDoubt) continue;
                proxying.getProxyingHandle().notifyProxyInDoubt(proxy);
                proxying.getGuarDoubtManager().setMessageInDoubt(msg.getGuarenteedTrackingNum());
            }
            if (inDoubt) {
                if (msg.getType() != 27) {
                    proxy.getProxyHandle().setProxyRecips(msg.getGuarenteedTrackingNum(), proxyingRecips);
                } else {
                    Iterator iter = msg.getBatchHandle().getBatchIterator();
                    while (iter.hasNext()) {
                        IMgram subMgram = (IMgram)iter.next();
                        proxy.getProxyHandle().setProxyRecips(subMgram.getGuarenteedTrackingNum(), proxyingRecips);
                    }
                }
            }
        }
        return proxyingRecips;
    }

    public MsgSaverOp buildMsgSaverOp(byte type, InputStream is) throws IOException, EMgramFormatError {
        AbstractMsgSaverOp result = null;
        switch (type) {
            case 4: {
                result = new MsgDeleteAllOp();
                break;
            }
            case 5: {
                result = new MsgDeleteOp();
                break;
            }
            case 3: {
                result = new MsgSaveOp();
                break;
            }
            case 6: {
                result = new MsgUpdRedelivOp();
                break;
            }
            case 7: {
                result = new MsgCommitOp();
                break;
            }
            case 8: {
                result = new MsgDurableOperationOp();
                break;
            }
            case 13: {
                result = new TrimMessagesOp();
                break;
            }
        }
        if (result != null) {
            result.readFromStream(is);
        }
        return result;
    }

    private static void updateRecipWithLBSTrackingInfo(IClientContext recip, IMgram m, LBSTrackingInfo lbsInfo) {
        if (m.getType() == 27) {
            Iterator it = m.getBatchHandle().getBatchIterator();
            while (it.hasNext()) {
                IMgram subMgram = (IMgram)it.next();
                MsgSaver.updateRecipWithLBSTrackingInfo(recip, subMgram, lbsInfo);
            }
        } else {
            recip.addLBSWrapperInfo(m.getGuarenteedTrackingNum(), lbsInfo.getTargetGroups());
        }
    }

    public static final IMgram removeLBSWrapper(IMgram m) {
        IMgram unwrapped = m;
        if (GroupSubscriptions.isLBSWrappedMessage(m)) {
            unwrapped = (IMgram)m.getOperationHandle().getMgramList().get(0);
            unwrapped.getBrokerHandle().setFromDB(m.getBrokerHandle().isFromDB());
            if (!unwrapped.isSuccessor() && m.isSuccessor()) {
                unwrapped.setSuccessor(true);
            }
            unwrapped.getBrokerHandle().setSubjectFilters(m.getBrokerHandle().getSubjectFilters());
        }
        return unwrapped;
    }

    private static final boolean isDbTrackingSet(IMgram m) {
        if (m.getType() != 27) {
            return m.getBrokerHandle().isDbTrackingSet();
        }
        Iterator it = m.getBatchHandle().getBatchIterator();
        IMgram subMgram = null;
        while (it.hasNext()) {
            subMgram = (IMgram)it.next();
            if (subMgram.getBrokerHandle().isDbTrackingSet()) continue;
            return false;
        }
        return true;
    }

    class MsgDurableOperationOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    ISaverPostProcessor,
    IReplicateableSaverOp {
        private IDurableOperation m_durableOp;
        private IReplicateableSaverOp m_replSaverOp;

        MsgDurableOperationOp(IDurableOperation op) {
            this.m_durableOp = op;
            this.setPostProcessor(this);
        }

        MsgDurableOperationOp(IReplicateableSaverOp op) {
            this.m_durableOp = (IDurableOperation)((Object)op);
            this.m_replSaverOp = op;
            this.setPostProcessor(this);
        }

        MsgDurableOperationOp() {
        }

        @Override
        public void doit(BrokerDatabase db) throws IOException {
            if (MsgSaver.this.CALLBACK) {
                MsgSaver.this.callback("Doing durable operation", 7, this);
            }
            this.m_durableOp.doit(db);
            ++MsgSaver.this.numDurable;
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
            this.m_durableOp.postProcess();
        }

        @Override
        public boolean isReplicateable() {
            return this.m_replSaverOp != null;
        }

        @Override
        public boolean replicatePostDoit() {
            if (this.isReplicateable()) {
                return this.m_replSaverOp.replicatePostDoit();
            }
            return false;
        }

        @Override
        public byte getType() {
            return 8;
        }

        @Override
        public int length() {
            if (this.m_replSaverOp != null) {
                return this.m_replSaverOp.length();
            }
            return 0;
        }

        @Override
        public int memsize() {
            if (this.m_replSaverOp != null) {
                return this.m_replSaverOp.memsize();
            }
            return 0;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            if (this.m_replSaverOp != null) {
                StreamUtil.writeByte(this.m_replSaverOp.getType(), os);
                this.m_replSaverOp.writeToStream(os);
            }
        }

        @Override
        public void readFromStream(InputStream is) throws IOException, EMgramFormatError {
            byte type = StreamUtil.readByte(is);
            if (type != 10) {
                throw new EAssertFailure("Unknown DurableOperation type: " + type);
            }
            this.m_replSaverOp = new DurableRemoveOp();
            this.m_durableOp = (IDurableOperation)((Object)this.m_replSaverOp);
            this.m_replSaverOp.readFromStream(is);
        }

        @Override
        public long getMessageId() {
            if (this.m_replSaverOp != null) {
                return this.m_replSaverOp.getTracking();
            }
            return -1L;
        }
    }

    class MsgUpdRedelivOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    IReplicateableSaverOp,
    ISaverPostProcessor {
        private long m_clientId;
        private long m_tracking;
        private long m_id;
        private IDBUpdRedelivListener m_listener;
        private boolean m_successor;

        MsgUpdRedelivOp() {
        }

        MsgUpdRedelivOp(long clientId, long tracking, long id, IDBUpdRedelivListener listener, boolean successor) {
            this.m_clientId = clientId;
            try {
                IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(clientId);
                if (cc.isGroupSubscriptionMember()) {
                    this.m_clientId = cc.getId();
                }
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
            this.m_tracking = tracking;
            this.m_id = id;
            this.m_listener = listener;
            this.m_successor = successor;
            this.setPostProcessor(this);
        }

        @Override
        public void doit(BrokerDatabase db) throws EDatabaseException {
            if (MsgSaver.this.DEBUG) {
                MsgSaver.this.debug("updating msg " + this.m_tracking + " for client " + this.m_clientId);
            }
            if (MsgSaver.this.CALLBACK) {
                Object[] params = new Object[]{this, new Boolean(this.m_successor)};
                MsgSaver.this.callback("Saver Opdate Op", 6, params);
            }
            db.doUpdateRedelivery(this.m_tracking, this.m_clientId, this.m_successor);
            ++MsgSaver.this.numUpdates;
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
            if (this.m_listener != null) {
                this.m_listener.updRedelivDone(this.m_id);
            }
        }

        public String toString() {
            return "update msg " + this.m_tracking + " for client " + this.m_clientId;
        }

        @Override
        public boolean isReplicateable() {
            return true;
        }

        @Override
        public byte getType() {
            return 6;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte((byte)0, os);
            StreamUtil.writeLong(this.m_tracking, os);
            StreamUtil.writeLong(this.m_clientId, os);
            StreamUtil.writeBoolean(this.m_successor, os);
        }

        @Override
        public void readFromStream(InputStream is) throws IOException {
            StreamUtil.readByte(is);
            this.m_tracking = StreamUtil.readLong(is);
            this.m_clientId = StreamUtil.readLong(is);
            this.m_successor = StreamUtil.readBoolean(is);
        }

        @Override
        public int memsize() {
            return s_updateRedelivMemSize;
        }

        @Override
        public int length() {
            return 18;
        }

        @Override
        public long getMessageId() {
            return this.m_tracking;
        }
    }

    class ReplicateMsgsOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    ISaverPostProcessor {
        private List m_msgIds;
        private ReplicationManager m_replMgr;
        private boolean m_lastChunk;

        ReplicateMsgsOp(List msgIds, boolean lastChunk) {
            this.m_msgIds = msgIds;
            this.m_replMgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
            this.m_lastChunk = lastChunk;
            this.setPostProcessor(this);
        }

        @Override
        public void doit(BrokerDatabase db) throws EDatabaseException {
            IMgram replicationOp;
            if (MsgSaver.this.CALLBACK) {
                MsgSaver.this.callback("Replicate Messages", 11, this);
            }
            LinkedList<IMgram> mgramList = null;
            if (this.m_msgIds != null) {
                Iterator mgramIter = this.m_msgIds.iterator();
                int size = 0;
                while (mgramIter.hasNext()) {
                    Long idToReplicate = (Long)mgramIter.next();
                    IMgram mgramToReplicate = null;
                    try {
                        mgramToReplicate = db.getIPubSubDbSyncSupport().getMgramTx(idToReplicate);
                    }
                    catch (InterruptedIOException e) {
                        return;
                    }
                    if (mgramToReplicate == null) continue;
                    size += mgramToReplicate.networkLength();
                    if (mgramList == null) {
                        mgramList = new LinkedList<IMgram>();
                    }
                    mgramList.add(MgramFactory.getMgramFactory().buildReplicatedMgram(mgramToReplicate, true));
                    try {
                        if (size <= Config.REPLICATION_CHUNK_SIZE) continue;
                        IMgram replicationOp2 = FTMgramFactory.createReplicateDurMgramsOp(false, mgramList);
                        this.m_replMgr.replicateMgramSynchronously(replicationOp2);
                        mgramList = null;
                        size = 0;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
            if (this.m_lastChunk && mgramList == null) {
                replicationOp = FTMgramFactory.createReplicateDurMgramsOp(true, null);
                this.m_replMgr.replicateMgram(replicationOp);
            } else {
                replicationOp = FTMgramFactory.createReplicateDurMgramsOp(this.m_lastChunk, mgramList);
                this.m_replMgr.replicateMgram(replicationOp);
            }
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
            if (this.m_lastChunk) {
                MsgSaver.this.m_durSyncReplMgr.dynamicSyncComplete();
            }
        }

        public String toString() {
            return "replicating Messages";
        }

        @Override
        public boolean isReplicateable() {
            return false;
        }
    }

    class SaveReplicatedMsgsOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    ISaverPostProcessor {
        private List m_msgs;

        SaveReplicatedMsgsOp(List msgs) {
            this.m_msgs = msgs;
            this.setPostProcessor(this);
        }

        @Override
        public void doit(BrokerDatabase db) throws IOException {
            for (IMgram mgramToSave : this.m_msgs) {
                mgramToSave = mgramToSave.getReplicatedMgramHandle().getReplicatedMgram();
                if (MsgSaver.this.CALLBACK) {
                    MsgSaver.this.callback("Message Replicated", 2, mgramToSave);
                }
                if (MsgSaver.this.DEBUG) {
                    MsgSaver.this.debug("Saving replicated message: " + mgramToSave.getGuarenteedTrackingNum());
                }
                boolean success = db.getIPubSubDbSyncSupport().saveMgramTx(mgramToSave);
                if (!MsgSaver.this.DEBUG) continue;
                MsgSaver.this.debug("Save success: " + success);
            }
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
        }

        public String toString() {
            return "replicating Messages";
        }

        @Override
        public boolean isReplicateable() {
            return false;
        }
    }

    class SaveUndelMsgsOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    ISaverPostProcessor {
        private List m_undelMsgs;
        private long m_replyTracking;
        private ReplicationManager m_replMgr;

        SaveUndelMsgsOp(List undelMsgs, long replyTracking) {
            this.m_undelMsgs = undelMsgs;
            this.m_replyTracking = replyTracking;
            this.m_replMgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
            this.setPostProcessor(this);
        }

        @Override
        public void doit(BrokerDatabase db) throws IOException {
            if (this.m_undelMsgs != null && !this.m_undelMsgs.isEmpty()) {
                if (MsgSaver.this.CALLBACK) {
                    MsgSaver.this.callback("Saving syncd message", 9, new Integer(this.m_undelMsgs.size()));
                }
                ArrayList<Long> idsToRequest = new ArrayList<Long>();
                for (BrokerDatabase.ClientDeliveryInfo cdi : this.m_undelMsgs) {
                    Long tracking = new Long(cdi.messageid);
                    boolean existsInDB = db.getIPubSubDbSyncSupport().mgamExistsTx(tracking);
                    if (existsInDB || idsToRequest.contains(tracking)) continue;
                    if (MsgSaver.this.DEBUG) {
                        MsgSaver.this.debug("requesting pub/sub mgram, tracking = " + tracking);
                    }
                    idsToRequest.add(tracking);
                    if (!MsgSaver.this.CALLBACK) continue;
                    MsgSaver.this.callback("requesting pub/sub mgram, tracking = " + tracking, 3, null);
                }
                this.m_replMgr.sendReply(this.m_replyTracking, FTMgramFactory.createReplicateUndelReplyPayload(idsToRequest));
                if (MsgSaver.this.DEBUG) {
                    MsgSaver.this.debug("Saving replicated undelMsgs, count = " + this.m_undelMsgs.size());
                }
                db.getIPubSubDbSyncSupport().saveUndelMessagesTx(this.m_undelMsgs);
            }
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
        }

        public String toString() {
            return "Saving replicated UndelMsgs, count = " + this.m_undelMsgs.size();
        }

        @Override
        public boolean isReplicateable() {
            return false;
        }
    }

    class RetrieveSubjectAckTrackingsOp
    extends AbstractMsgSaverOp
    implements ISaverPostProcessor {
        IClientContext m_cc;
        long highestIndoubt;
        LongHashTable m_mappings;

        RetrieveSubjectAckTrackingsOp(IClientContext cc, long highestIndoubt) {
            this.m_cc = null;
            this.m_mappings = null;
            this.highestIndoubt = highestIndoubt;
            this.m_cc = cc;
            this.setPostProcessor(this);
        }

        @Override
        public void doit(BrokerDatabase database) throws EDatabaseException {
            IClientContext cc = this.m_cc;
            if (this.m_cc.isGroupSubscriptionMember()) {
                cc = this.m_cc.getGroupSubscriptionCC();
            }
            this.m_mappings = MsgSaver.this.m_db.retrieveSubjectAckMappings(cc.getId(), this.highestIndoubt);
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
            this.m_cc.setLegacySubjectAckMappings(this.m_mappings);
        }

        @Override
        public boolean isReplicateable() {
            return false;
        }
    }

    class ReplicateUndelMsgsOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    ISaverPostProcessor {
        private long m_minTrackingNumber;
        private long m_maxTrackingNumber;
        private BrokerJob m_job;

        ReplicateUndelMsgsOp(long minTrackingNumber, long maxTrackingNumber, BrokerJob job) {
            this.m_minTrackingNumber = minTrackingNumber;
            this.m_maxTrackingNumber = maxTrackingNumber;
            this.m_job = job;
            this.setPostProcessor(this);
        }

        @Override
        public void doit(BrokerDatabase db) throws EDatabaseException {
            if (MsgSaver.this.CALLBACK) {
                MsgSaver.this.callback("Replicate undel msgs", 10, this);
            }
            DurableMsgDynSyncer.ReplicatedUndelMsgInfo result = new DurableMsgDynSyncer.ReplicatedUndelMsgInfo();
            List undelInfo = null;
            try {
                undelInfo = db.getIPubSubDbSyncSupport().getSyncUndelMessagesTx(this.m_minTrackingNumber, this.m_maxTrackingNumber, s_cdiRequestFixedSize, s_cdiRequestMaxSize);
            }
            catch (InterruptedIOException e) {
                this.m_job.cancel();
                this.m_job.enqueueReply(result);
                return;
            }
            int resultSize = undelInfo.size();
            if (MsgSaver.this.DEBUG) {
                MsgSaver.this.debug("Replicating: " + resultSize + " elements");
            }
            if (resultSize > 0) {
                byte[] payload = FTMgramFactory.createReplicateUndelRequest_V2_Payload(undelInfo);
                try {
                    long maxTrackingNumber;
                    ReplicationManager.ReplicationRequest request;
                    if (MsgSaver.this.DEBUG) {
                        MsgSaver.this.debug("Sending request to standby");
                    }
                    if ((request = AgentRegistrar.getAgentRegistrar().getReplicationManager().sendRequest("PUBSUB_DB_SYNC_EXCHANGE1", payload)) == null) {
                        if (MsgSaver.this.DEBUG) {
                            MsgSaver.this.debug("Request to standby failed!");
                        }
                        this.m_job.cancel();
                        this.m_job.enqueueReply(result);
                        return;
                    }
                    if (MsgSaver.this.DEBUG) {
                        MsgSaver.this.debug("Infoming DurableMsgDynSync that request is complete");
                    }
                    result.m_request = request;
                    result.m_maxTrackingNumberReplicated = maxTrackingNumber = ((BrokerDatabase.ClientDeliveryInfo)undelInfo.get((int)(resultSize - 1))).messageid;
                    MsgSaver.this.m_durSyncReplMgr.setCurrentTrackingNum(maxTrackingNumber);
                }
                catch (InterruptedException e) {
                    this.m_job.cancel();
                    Thread.currentThread().interrupt();
                }
            } else {
                result.m_isComplete = true;
                MsgSaver.this.m_durSyncReplMgr.setUndelMsgsComplete();
            }
            this.m_job.enqueueReply(result);
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
        }

        public String toString() {
            return "replicating UndelMsgs";
        }

        @Override
        public boolean isReplicateable() {
            return false;
        }
    }

    public class MsgDeleteOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    IReplicateableSaverOp,
    ISaverPostProcessor {
        private long m_clientId;
        private IClientContext m_cc;
        private long m_tracking;
        private boolean m_notify;
        private int m_size;
        private boolean m_syncPersist;
        private boolean m_subjectAck;
        private short m_subjectTracking;

        MsgDeleteOp() {
            this.m_tracking = -1L;
            this.m_subjectAck = false;
            this.m_subjectTracking = (short)-1;
        }

        MsgDeleteOp(IClientContext cc, long tracking, int size, boolean notify, boolean syncPersist, boolean subjectAck, short subjectTracking) {
            this.m_tracking = -1L;
            this.m_subjectAck = false;
            this.m_subjectTracking = (short)-1;
            this.m_cc = cc.isGroupSubscriptionMember() ? cc.getGroupSubscriptionCC() : cc;
            this.m_clientId = this.m_cc.getId();
            this.m_tracking = tracking;
            if (!subjectAck) {
                this.m_notify = notify;
            }
            this.m_size = size;
            this.m_syncPersist = syncPersist;
            this.m_subjectAck = subjectAck;
            this.m_subjectTracking = subjectTracking;
            this.setPostProcessor(this);
        }

        MsgDeleteOp(long clientId, long tracking, int size, boolean syncPersist, boolean subjectAck, short subjectTracking) {
            this.m_tracking = -1L;
            this.m_subjectAck = false;
            this.m_subjectTracking = (short)-1;
            this.m_clientId = clientId;
            try {
                this.m_cc = AgentRegistrar.getAgentRegistrar().getClient(clientId);
                if (this.m_cc.isGroupSubscriptionMember()) {
                    this.m_cc = this.m_cc.getGroupSubscriptionCC();
                    this.m_clientId = this.m_cc.getId();
                }
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
            this.m_tracking = tracking;
            this.m_notify = false;
            this.m_subjectAck = subjectAck;
            this.m_subjectTracking = subjectTracking;
            this.m_size = size;
            this.m_syncPersist = syncPersist;
            this.setPostProcessor(this);
        }

        @Override
        public void doit(BrokerDatabase db) throws EDatabaseException, EOperationCancelled {
            if (MsgSaver.this.CALLBACK) {
                MsgSaver.this.callback("Msg Deleted", 5, this);
            }
            if (MsgSaver.this.DEBUG) {
                MsgSaver.this.debug("deleting msg " + this.m_tracking + " for client " + this.m_clientId + " subject ack: " + this.m_subjectTracking);
            }
            if (this.m_subjectAck) {
                db.delSubjecTracking(this.m_clientId, this.m_tracking, this.m_subjectTracking);
            } else {
                db.delMsg(this.m_clientId, this.m_tracking, this.m_size);
            }
            ++MsgSaver.this.numDeletes;
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
            if (this.m_notify) {
                this.m_cc.getGuarDoubtManager().msgDeleteDone(this.m_tracking);
            }
            if (this.m_syncPersist) {
                AgentRegistrar.getAgentRegistrar().getDeleteMsgManager().removePubSubDelete(this.m_tracking, this.m_clientId, this.m_subjectAck, this.m_subjectTracking);
            }
        }

        public String toString() {
            return "delete msg " + this.m_tracking + " for client " + this.m_clientId;
        }

        @Override
        public boolean isReplicateable() {
            return this.m_syncPersist;
        }

        @Override
        public byte getType() {
            return 5;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte((byte)0, os);
            StreamUtil.writeLong(this.m_clientId, os);
            StreamUtil.writeLong(this.m_tracking, os);
            StreamUtil.writeInt(this.m_size, os);
            if (this.m_subjectAck) {
                StreamUtil.writeBoolean(true, os);
                StreamUtil.writeShort(this.m_subjectTracking, os);
            } else {
                StreamUtil.writeBoolean(false, os);
            }
        }

        @Override
        public void readFromStream(InputStream is) throws IOException {
            StreamUtil.readByte(is);
            this.m_clientId = StreamUtil.readLong(is);
            this.m_tracking = StreamUtil.readLong(is);
            this.m_size = StreamUtil.readInt(is);
            this.m_subjectAck = StreamUtil.readBoolean(is);
            if (this.m_subjectAck) {
                this.m_subjectTracking = StreamUtil.readShort(is);
            }
        }

        @Override
        public int memsize() {
            return 0;
        }

        @Override
        public int length() {
            return 22 + (this.m_subjectAck ? 2 : 0);
        }

        @Override
        public long getMessageId() {
            return this.m_tracking;
        }

        public long getClientId() {
            return this.m_clientId;
        }

        public boolean isSubjectAck() {
            return this.m_subjectAck;
        }

        public short getSubjectTracking() {
            return this.m_subjectTracking;
        }
    }

    class MsgCommitOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    IReplicateableSaverOp {
        private long m_messageId;

        MsgCommitOp() {
        }

        MsgCommitOp(long messageId) {
            this.m_messageId = messageId;
        }

        @Override
        public void doit(BrokerDatabase db) throws EDatabaseException, EOperationCancelled {
            MsgSaver.this.m_db.updateMaxAddedMessageId(this.m_messageId);
        }

        public void doPostProcessing() throws InterruptedException {
        }

        public String toString() {
            return "committing MsgSaver transaction";
        }

        @Override
        public boolean isReplicateable() {
            return true;
        }

        @Override
        public byte getType() {
            return 7;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte((byte)0, os);
            StreamUtil.writeLong(this.m_messageId, os);
        }

        @Override
        public void readFromStream(InputStream is) throws IOException {
            StreamUtil.readByte(is);
            this.m_messageId = StreamUtil.readLong(is);
        }

        @Override
        public int memsize() {
            return 0;
        }

        @Override
        public int length() {
            return 9;
        }
    }

    abstract class AbstractMsgSaverOp
    implements MsgSaverOp {
        private ISaverPostProcessor m_postProcessor = null;

        AbstractMsgSaverOp() {
        }

        @Override
        public final void setPostProcessor(ISaverPostProcessor pp) {
            this.m_postProcessor = pp;
        }

        @Override
        public void postProcess() throws InterruptedException {
            this.m_postProcessor.doPostProcessing();
        }

        @Override
        public boolean hasFTMetaState() {
            return false;
        }

        @Override
        public void updateFTMetaState(IFTEventProcessor ft) throws InterruptedException {
        }

        @Override
        public long getMessageId() {
            return -1L;
        }

        public long getTracking() {
            return this.getMessageId();
        }

        @Override
        public boolean replicatePostDoit() {
            return false;
        }

        @Override
        public boolean markProcessedBySaver() {
            return true;
        }
    }

    class TrimMessagesOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    IPostponedOperation,
    IReplicateableSaverOp,
    ISaverPostProcessor {
        private long m_clientId;
        private long m_maxMessageId;
        private boolean m_postProcessed = false;
        private boolean m_persistent = true;
        private boolean m_replicateOnly = false;
        private int m_batchSize = Config.RESTORE_MSGS_COUNT;
        private int m_deleted;
        private int m_totalDeleted = 0;
        private DurableCCTracker m_tracker = null;
        private IClientContext m_cc = null;
        private long m_trimtime;
        private DurableTrimOp m_op;

        TrimMessagesOp() {
        }

        TrimMessagesOp(DurableTrimOp op, long maxMessageId, int previousCount, int batchSize) {
            this.m_op = op;
            this.m_clientId = this.m_op.getClientID();
            try {
                this.m_cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_clientId);
                if (this.m_cc.isGroupSubscriptionMember()) {
                    this.m_clientId = this.m_cc.getId();
                }
                this.m_tracker = this.m_cc.getDurableCCTracker();
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
            this.m_maxMessageId = maxMessageId;
            this.m_batchSize = batchSize;
            this.m_trimtime = this.m_op.getTrimTimestamp();
            this.m_totalDeleted = previousCount;
            this.setPostProcessor(this);
        }

        @Override
        public void doit(BrokerDatabase db) throws EDatabaseException, EOperationCancelled {
            if (MsgSaver.this.CALLBACK) {
                MsgSaver.this.callback("Trimming Messages from Durable ", 12, this);
            }
            if (this.m_cc == null || this.m_tracker == null) {
                try {
                    this.m_cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_clientId);
                    this.m_tracker = this.m_cc.getDurableCCTracker();
                    if (this.m_tracker == null) {
                        return;
                    }
                }
                catch (EClientNotRegistered ex) {
                    return;
                }
            }
            if (MsgSaver.this.DEBUG) {
                MsgSaver.this.debug("Trimming msgs for client " + this.m_clientId + " up to MaxMessageId: " + this.m_maxMessageId);
            }
            BrokerDatabase.SavedMsgStats stats = db.trimMessages(this.m_clientId, this.m_maxMessageId, this.m_batchSize);
            this.m_deleted = (int)stats.count;
            this.m_totalDeleted += this.m_deleted;
            if (MsgSaver.this.DEBUG) {
                MsgSaver.this.debug("batchsize = " + this.m_batchSize + " this delete = " + this.m_deleted + " total deleted " + this.m_totalDeleted);
            }
            try {
                this.m_tracker.messagesDeleted((int)stats.count, (int)stats.size);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void preProcess() {
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
            this.m_postProcessed = true;
            DeleteSubscriptionManager dsm = AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager();
            if (this.m_batchSize == 0) {
                if (this.m_persistent) {
                    dsm.endDeleteSubscription(this.m_clientId, this.m_maxMessageId, this.m_replicateOnly);
                }
                this.m_op.sendDBMsgDeleteNotification(this.m_totalDeleted);
            } else if (this.m_deleted == this.m_batchSize) {
                TrimMessagesOp op = new TrimMessagesOp(this.m_op, this.m_maxMessageId, this.m_totalDeleted, this.m_batchSize);
                AgentRegistrar.getAgentRegistrar().getPostponedMsgSaver().performPostponedOperation(op);
            } else {
                TrimMessagesOp op = new TrimMessagesOp(this.m_op, this.m_maxMessageId, this.m_totalDeleted, 0);
                AgentRegistrar.getAgentRegistrar().getPostponedMsgSaver().performPostponedOperation(op);
            }
        }

        @Override
        public long getId() {
            return -1L;
        }

        @Override
        public MsgSaverOp getOperation() {
            return this;
        }

        @Override
        public boolean isPostProcessed() {
            return this.m_postProcessed;
        }

        @Override
        public int memsize() {
            return 0;
        }

        @Override
        public boolean isReplicateable() {
            return true;
        }

        @Override
        public byte getType() {
            return 13;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte((byte)0, os);
            StreamUtil.writeLong(this.m_clientId, os);
            StreamUtil.writeLong(this.m_maxMessageId, os);
            StreamUtil.writeLong(this.m_trimtime, os);
            StreamUtil.writeInt(this.m_batchSize, os);
            StreamUtil.writeBoolean(this.m_persistent, os);
            StreamUtil.writeBoolean(this.m_replicateOnly, os);
        }

        @Override
        public void readFromStream(InputStream is) throws IOException {
            StreamUtil.readByte(is);
            this.m_clientId = StreamUtil.readLong(is);
            this.m_maxMessageId = StreamUtil.readLong(is);
            this.m_trimtime = StreamUtil.readLong(is);
            this.m_batchSize = StreamUtil.readInt(is);
            this.m_persistent = StreamUtil.readBoolean(is);
            this.m_replicateOnly = StreamUtil.readBoolean(is);
        }

        @Override
        public int length() {
            return 31;
        }

        @Override
        public boolean hasFTMetaState() {
            return false;
        }

        @Override
        public void updateFTMetaState(IFTEventProcessor ft) {
        }

        public String toString() {
            return "TrimMessagesOp for client " + this.m_clientId + " maxMessageId = " + this.m_maxMessageId + " trimtime = " + this.m_trimtime;
        }
    }

    public class MsgDeleteAllOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    IPostponedOperation,
    IReplicateableSaverOp,
    ISaverPostProcessor {
        private long m_clientId;
        private long m_maxMessageId;
        private boolean m_postProcessed = false;
        private boolean m_persistent = false;
        private boolean m_replicateOnly = false;
        private int m_batchSize;
        private int m_deleted;

        MsgDeleteAllOp() {
        }

        MsgDeleteAllOp(long id, long maxMessageId, boolean persistent, boolean replicateOnly, int batchSize) {
            this.m_clientId = id;
            try {
                IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_clientId);
                if (cc.isGroupSubscriptionMember()) {
                    this.m_clientId = cc.getId();
                }
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
            this.m_maxMessageId = maxMessageId;
            this.m_persistent = persistent;
            this.m_replicateOnly = replicateOnly;
            this.m_batchSize = batchSize;
            this.setPostProcessor(this);
        }

        @Override
        public void doit(BrokerDatabase db) throws EDatabaseException, EOperationCancelled {
            if (MsgSaver.this.CALLBACK) {
                MsgSaver.this.callback("Deleting all msgs", 8, this);
            }
            if (MsgSaver.this.DEBUG) {
                MsgSaver.this.debug("deleting all msgs for client " + this.m_clientId + " MaxMessageId: " + this.m_maxMessageId);
            }
            this.m_deleted = db.delMsgs(this.m_clientId, this.m_maxMessageId, this.m_batchSize);
            MsgSaver.this.numDeletes = MsgSaver.this.numDeletes + this.m_deleted;
        }

        @Override
        public void preProcess() {
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
            this.m_postProcessed = true;
            DeleteSubscriptionManager dsm = AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager();
            if (this.m_batchSize == 0) {
                if (this.m_persistent) {
                    dsm.endDeleteSubscription(this.m_clientId, this.m_maxMessageId, this.m_replicateOnly);
                }
            } else if (this.m_deleted == this.m_batchSize) {
                MsgDeleteAllOp op = new MsgDeleteAllOp(this.m_clientId, this.m_maxMessageId, this.m_persistent, this.m_replicateOnly, this.m_batchSize);
                AgentRegistrar.getAgentRegistrar().getPostponedMsgSaver().performPostponedOperation(op);
            } else {
                MsgDeleteAllOp op = new MsgDeleteAllOp(this.m_clientId, this.m_maxMessageId, this.m_persistent, this.m_replicateOnly, 0);
                AgentRegistrar.getAgentRegistrar().getPostponedMsgSaver().performPostponedOperation(op);
            }
        }

        @Override
        public long getId() {
            return -1L;
        }

        @Override
        public MsgSaverOp getOperation() {
            return this;
        }

        @Override
        public boolean isPostProcessed() {
            return this.m_postProcessed;
        }

        @Override
        public int memsize() {
            return 0;
        }

        @Override
        public boolean isReplicateable() {
            return this.m_persistent;
        }

        @Override
        public byte getType() {
            return 4;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte((byte)0, os);
            StreamUtil.writeLong(this.m_clientId, os);
            StreamUtil.writeLong(this.m_maxMessageId, os);
            StreamUtil.writeInt(this.m_batchSize, os);
        }

        @Override
        public void readFromStream(InputStream is) throws IOException {
            StreamUtil.readByte(is);
            this.m_clientId = StreamUtil.readLong(is);
            this.m_maxMessageId = StreamUtil.readLong(is);
            this.m_batchSize = StreamUtil.readInt(is);
        }

        @Override
        public int length() {
            return 21;
        }

        @Override
        public boolean hasFTMetaState() {
            return false;
        }

        @Override
        public void updateFTMetaState(IFTEventProcessor ft) {
        }

        public String toString() {
            return "MsgDeleteAllOp for client " + this.m_clientId;
        }

        public long getMaxMessageId() {
            return this.m_maxMessageId;
        }

        public long getClientId() {
            return this.m_clientId;
        }

        public boolean getReplicateOnly() {
            return this.m_replicateOnly;
        }
    }

    final class MsgSaveOp
    extends AbstractMsgSaverOp
    implements MsgSaverOp,
    IPostponedOperation,
    IReplicateableSaverOp,
    ISaverPostProcessor {
        private byte m_VERSION = 1;
        private IMgram m_msg;
        private IClientContext m_recipient;
        private FastVector m_recipients;
        private FastVector m_proxyingRecips;
        private LongHashTable m_lbsProxyRecips;
        private AgentGuarMsgTracker m_tracker;
        private boolean m_jmsredelivery;
        private boolean m_inDoubt;
        private int m_size;
        private boolean m_isPostProcessed;
        private boolean m_postponed;
        private FastVector m_trackers = null;
        private boolean m_processedBySaver = false;
        private boolean m_canceled = false;
        private BrokerDatabase.UndelClientInfo[] m_replicatedRecipients;
        private BrokerDatabase.UndelClientInfo[] m_replicatedProxyingRecipients;
        private Long m_replicatedRecipient;
        private boolean m_fromRemoteBroker;
        private int m_length = -1;
        private long m_tracking = -1L;

        MsgSaveOp() {
        }

        MsgSaveOp(IMgram msg, FastVector to, FastVector proxying, LongHashTable lbsProxyRecips, AgentGuarMsgTracker tracker, boolean jms_redelivery, boolean inDoubt, int size) {
            this.m_msg = MsgSaver.removeLBSWrapper(msg);
            this.m_recipients = to;
            this.m_proxyingRecips = proxying;
            this.m_lbsProxyRecips = lbsProxyRecips;
            if (msg.getBrokerHandle().isDbTrackingSet()) {
                this.m_tracking = msg.getBrokerHandle().getDbTracking();
            }
            this.m_tracker = tracker;
            this.m_jmsredelivery = jms_redelivery;
            this.m_inDoubt = inDoubt;
            this.m_size = size;
            this.m_postponed = false;
            if (this.m_lbsProxyRecips != null) {
                for (int i = 0; i < this.m_recipients.m_count; ++i) {
                    IClientContext recip = (IClientContext)this.m_recipients.m_data[i];
                    this.updateRecipWithLBSTrackingInfo(recip);
                }
            }
            this.setPostProcessor(this);
            if (MsgSaver.this.CALLBACK) {
                MsgSaver.this.callback("MsgSaver", 0, new Object[]{null, msg});
            }
        }

        MsgSaveOp(IMgram msg, IClientContext to, boolean jms_redelivery, boolean inDoubt, int size, boolean postponed) {
            this.m_msg = msg;
            this.m_jmsredelivery = jms_redelivery;
            this.m_inDoubt = inDoubt;
            this.m_size = size;
            this.m_recipient = to;
            this.m_postponed = postponed;
            this.m_tracking = msg.getGuarenteedTrackingNum();
            try {
                this.m_tracker = AgentGuarMsgTracker.getTracker(this.m_tracking);
            }
            catch (ETrackingNumNotFound eTrackingNumNotFound) {
                // empty catch block
            }
            boolean lbsWithOutLookup = false;
            if (GroupSubscriptions.isLBSWrappedMessage(msg)) {
                boolean lbsWrapped = false;
                if (msg.getOperationHandle().getOperationType() == 14) {
                    lbsWithOutLookup = true;
                    lbsWrapped = true;
                } else if (msg.getOperationHandle().getOperationType() == 13) {
                    lbsWrapped = true;
                }
                if (lbsWrapped) {
                    if (to.isInterbroker()) {
                        this.m_lbsProxyRecips = new LongHashTable(1);
                        this.m_lbsProxyRecips.put(to.getId(), LBSTrackingInfo.unmarshalLBTargetWrapper(this.m_msg));
                    }
                    this.m_msg = MsgSaver.removeLBSWrapper(this.m_msg);
                }
            }
            if (!lbsWithOutLookup) {
                this.m_proxyingRecips = MsgSaver.handleProxySaves(this.m_msg, this.m_recipient, inDoubt, postponed);
            }
            this.updateRecipWithLBSTrackingInfo(this.m_recipient);
            this.setPostProcessor(this);
            if (MsgSaver.this.CALLBACK) {
                AgentConnection conn = this.m_recipient.getConnection();
                MsgSaver.this.callback("MsgSaver", 0, new Object[]{conn, msg});
            }
        }

        private void updateRecipWithLBSTrackingInfo(IClientContext m_recipient) {
            LBSTrackingInfo info;
            if (m_recipient.isInterbroker() && this.m_lbsProxyRecips != null && (info = (LBSTrackingInfo)this.m_lbsProxyRecips.get(m_recipient.getId())) != null) {
                MsgSaver.updateRecipWithLBSTrackingInfo(m_recipient, this.m_msg, info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancelSaveForRecipient(IClientContext canceledRecipient) {
            boolean msgSaveCanceled = false;
            boolean recipientCanceled = false;
            MsgSaveOp msgSaveOp = this;
            synchronized (msgSaveOp) {
                if (this.m_processedBySaver) {
                    return false;
                }
                if (this.m_canceled) {
                    return true;
                }
                if (this.m_recipients != null) {
                    for (int i = 0; i < this.m_recipients.m_count; ++i) {
                        IClientContext recip = (IClientContext)this.m_recipients.m_data[i];
                        if (recip != canceledRecipient) continue;
                        recipientCanceled = true;
                        this.m_recipients.removeElementAt(i);
                        break;
                    }
                    if (this.m_recipients.m_count == 0) {
                        msgSaveCanceled = true;
                        this.m_recipients = null;
                    }
                } else if (this.m_recipient != null && canceledRecipient == this.m_recipient) {
                    recipientCanceled = true;
                    msgSaveCanceled = true;
                    this.m_recipient = null;
                }
                if (msgSaveCanceled) {
                    this.m_canceled = true;
                }
            }
            return recipientCanceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean markProcessedBySaver() {
            MsgSaveOp msgSaveOp = this;
            synchronized (msgSaveOp) {
                if (this.m_canceled) {
                    return false;
                }
                this.m_processedBySaver = true;
            }
            return true;
        }

        @Override
        public void doit(BrokerDatabase db) throws IOException {
            if (MsgSaver.this.DEBUG) {
                MsgSaver.this.debug("saving message " + this.m_tracking);
            }
            if (MsgSaver.this.CALLBACK) {
                Object[] arguments = new Object[]{this, this.m_msg};
                MsgSaver.this.callback("MsgSaver", 4, arguments);
            }
            if (this.m_msg.getType() != 27) {
                if (this.m_recipients != null) {
                    db.saveMsg(this.m_recipients, this.m_proxyingRecips, this.m_msg, this.m_jmsredelivery, this.isReplicateable(), this.m_msg.getBrokerHandle().getSubjectFilters());
                } else if (this.m_recipient != null) {
                    db.saveMsg(this.m_recipient.getId(), this.m_proxyingRecips, this.m_msg, this.m_jmsredelivery, this.isReplicateable(), this.m_msg.getBrokerHandle().getSubjectFilters());
                } else if (this.m_replicatedRecipients != null) {
                    db.saveMsg(this.m_replicatedRecipients, this.m_replicatedProxyingRecipients, this.m_msg, this.m_jmsredelivery, this.m_fromRemoteBroker, this.isReplicateable(), this.m_msg.getBrokerHandle().getSubjectFilters());
                } else {
                    db.saveMsg(this.m_replicatedRecipient, this.m_replicatedProxyingRecipients, this.m_msg, this.m_jmsredelivery, this.m_fromRemoteBroker, this.isReplicateable(), this.m_msg.getBrokerHandle().getSubjectFilters());
                }
                ++MsgSaver.this.numSaves;
            } else {
                Iterator it = this.m_msg.getBatchHandle().getBatchIterator();
                boolean isAtomic = this.m_msg.getBatchHandle().isAtomic();
                IMgram subMgram = null;
                if (!isAtomic) {
                    this.m_trackers = new FastVector();
                    if (MsgSaver.this.DEBUG && this.m_tracker != null) {
                        MsgSaver.this.debug("tracker exists for a non-atomic batch mgram itself, batch mgram = " + this.m_msg);
                    }
                }
                while (it.hasNext()) {
                    subMgram = (IMgram)it.next();
                    if (!isAtomic) {
                        AgentGuarMsgTracker tracker;
                        block23: {
                            tracker = null;
                            try {
                                tracker = AgentGuarMsgTracker.getTracker(subMgram.getGuarenteedTrackingNum());
                            }
                            catch (ETrackingNumNotFound e) {
                                if (!MsgSaver.this.DEBUG) break block23;
                                MsgSaver.this.debug("tracker does not exist for the sub mgram of a non-atomic batch, sub mgram = " + subMgram, e);
                            }
                        }
                        if (tracker != null) {
                            this.m_trackers.addElement(tracker);
                        }
                    }
                    if (this.m_recipients != null) {
                        db.saveMsg(this.m_recipients, this.m_proxyingRecips, subMgram, this.m_jmsredelivery, this.isReplicateable(), this.m_msg.getBrokerHandle().getSubjectFilters());
                    } else if (this.m_recipient != null) {
                        db.saveMsg(this.m_recipient.getId(), this.m_proxyingRecips, subMgram, this.m_jmsredelivery, this.isReplicateable(), this.m_msg.getBrokerHandle().getSubjectFilters());
                    } else if (this.m_replicatedRecipients != null) {
                        db.saveMsg(this.m_replicatedRecipients, this.m_replicatedProxyingRecipients, subMgram, this.m_jmsredelivery, this.m_fromRemoteBroker, this.isReplicateable(), this.m_msg.getBrokerHandle().getSubjectFilters());
                    } else {
                        db.saveMsg(this.m_replicatedRecipient, this.m_replicatedProxyingRecipients, subMgram, this.m_jmsredelivery, this.m_fromRemoteBroker, this.isReplicateable(), this.m_msg.getBrokerHandle().getSubjectFilters());
                    }
                    ++MsgSaver.this.numSaves;
                }
            }
        }

        @Override
        public void preProcess() {
        }

        @Override
        public void doPostProcessing() throws InterruptedException {
            this.m_isPostProcessed = true;
            if (this.m_recipient != null) {
                int i;
                if (this.m_proxyingRecips != null) {
                    for (i = 0; i < this.m_proxyingRecips.m_count; ++i) {
                        IClientContext cc = (IClientContext)this.m_proxyingRecips.m_data[i];
                        cc.msgSaveDone(this.m_msg, this.m_postponed);
                        this.m_msg.getBrokerHandle().clearMsgHeader(cc.getId());
                    }
                }
                if (this.m_trackers != null) {
                    for (i = 0; i < this.m_trackers.m_count; ++i) {
                        if (this.m_msg.isJMSPersistent()) {
                            ((AgentGuarMsgTracker)this.m_trackers.m_data[i]).msgSavedForXOnceClient(this.m_recipient.getId(), this.m_inDoubt);
                            continue;
                        }
                        ((AgentGuarMsgTracker)this.m_trackers.m_data[i]).msgSaved(1, true);
                    }
                } else if (this.m_tracker != null && !this.m_msg.getBrokerHandle().isFromDB()) {
                    if (this.m_msg.isJMSPersistent()) {
                        this.m_tracker.msgSavedForXOnceClient(this.m_recipient.getId(), this.m_inDoubt);
                    } else {
                        this.m_tracker.msgSaved(1, true);
                    }
                }
                this.m_recipient.msgSaveDone(this.m_msg, this.m_postponed);
                this.m_msg.getBrokerHandle().clearMsgHeader(this.m_recipient.getId());
            } else if (this.m_recipients != null) {
                int i;
                LongHashTable proxyTable = null;
                if (this.m_proxyingRecips != null) {
                    proxyTable = this.m_msg.getBrokerHandle().getProxyRecipsTable();
                }
                for (i = 0; i < this.m_recipients.m_count; ++i) {
                    FastVector proxying;
                    IClientContext recip = (IClientContext)this.m_recipients.m_data[i];
                    if (proxyTable != null && recip.getProxyHandle() != null && (proxying = (FastVector)proxyTable.get(recip.getId())) != null) {
                        for (int p = 0; p < proxying.m_count; ++p) {
                            IClientContext cc = (IClientContext)proxying.m_data[p];
                            cc.msgSaveDone(this.m_msg, this.m_postponed);
                            this.m_msg.getBrokerHandle().clearMsgHeader(cc.getId());
                        }
                    }
                    recip.msgSaveDone(this.m_msg, this.m_postponed);
                    this.m_msg.getBrokerHandle().clearMsgHeader(recip.getId());
                }
                if (this.m_trackers != null) {
                    for (int k = 0; k < this.m_trackers.m_count; ++k) {
                        if (this.m_msg.isJMSPersistent()) {
                            for (int i2 = 0; i2 < this.m_recipients.m_count; ++i2) {
                                ((AgentGuarMsgTracker)this.m_trackers.m_data[k]).msgSavedForXOnceClient(((IClientContext)this.m_recipients.m_data[i2]).getId(), this.m_inDoubt);
                            }
                            continue;
                        }
                        ((AgentGuarMsgTracker)this.m_trackers.m_data[k]).msgSaved(this.m_recipients.m_count, true);
                    }
                } else if (this.m_tracker != null && !this.m_msg.getBrokerHandle().isFromDB()) {
                    if (this.m_msg.isJMSPersistent()) {
                        for (i = 0; i < this.m_recipients.m_count; ++i) {
                            this.m_tracker.msgSavedForXOnceClient(((IClientContext)this.m_recipients.m_data[i]).getId(), this.m_inDoubt);
                        }
                    } else {
                        this.m_tracker.msgSaved(this.m_recipients.m_count, true);
                    }
                }
            }
        }

        @Override
        public MsgSaverOp getOperation() {
            return this;
        }

        @Override
        public long getId() {
            if (this.m_recipient != null) {
                return this.m_recipient.getId();
            }
            return -1L;
        }

        @Override
        public long getMessageId() {
            if (this.m_msg.getType() != 27) {
                return this.m_tracking;
            }
            if (this.m_msg.getBrokerHandle().isDbTrackingSet()) {
                return this.m_tracking + (long)this.m_msg.getBatchHandle().getBatchSize();
            }
            return -1L;
        }

        @Override
        public int memsize() {
            return this.m_size;
        }

        @Override
        public int length() {
            if (this.m_length == -1) {
                try {
                    ByteArrayOutputStream boas = new ByteArrayOutputStream();
                    this.writeToStream(boas);
                    this.m_length = boas.size();
                }
                catch (IOException e) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    this.m_length = 0;
                }
            }
            return this.m_length;
        }

        @Override
        public boolean isPostProcessed() {
            return this.m_isPostProcessed;
        }

        public String toString() {
            return "MsgSaveOp " + this.m_tracking;
        }

        @Override
        public boolean isReplicateable() {
            return this.m_msg.isJMSPersistent() && this.m_msg.isGuarenteed() && (this.m_recipients != null || this.m_recipient != null || this.m_replicatedRecipient != null || this.m_replicatedRecipients != null);
        }

        @Override
        public byte getType() {
            return 3;
        }

        @Override
        public void writeToStream(OutputStream os) throws IOException {
            StreamUtil.writeByte(this.m_VERSION, os);
            StreamUtil.writeBoolean(this.m_recipients != null || this.m_replicatedRecipients != null, os);
            boolean fromRemoteBroker = false;
            if (InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(this.m_msg.getBrokerHandle().getSenderID())) {
                fromRemoteBroker = true;
            }
            StreamUtil.writeBoolean(fromRemoteBroker, os);
            if (this.m_recipients != null) {
                this.writeClients(this.m_recipients, os);
            } else if (this.m_recipient != null) {
                this.write1Client(this.m_recipient, os);
            } else if (this.m_replicatedRecipients != null) {
                this.writeReplicatedClients(this.m_replicatedRecipients, os);
            } else {
                this.write1ReplicatedClient(this.m_replicatedRecipient, os);
            }
            StreamUtil.writeBoolean(this.m_proxyingRecips != null || this.m_replicatedProxyingRecipients != null, os);
            if (this.m_proxyingRecips != null) {
                this.writeClients(this.m_proxyingRecips, os);
            } else if (this.m_replicatedProxyingRecipients != null) {
                this.writeReplicatedClients(this.m_replicatedProxyingRecipients, os);
            }
            MgramSerializer.getMgramSerializer().serialize(os, this.m_msg, true);
            StreamUtil.writeBoolean(this.m_jmsredelivery, os);
        }

        @Override
        public void readFromStream(InputStream is) throws IOException, EMgramFormatError {
            LongHashTable ht = new LongHashTable();
            byte vers = StreamUtil.readByte(is);
            boolean hasRecipients = StreamUtil.readBoolean(is);
            this.m_fromRemoteBroker = StreamUtil.readBoolean(is);
            if (hasRecipients) {
                this.m_replicatedRecipients = this.readClients(is, ht, vers);
            } else {
                this.m_replicatedRecipient = this.readClient(is, ht, vers);
            }
            boolean hasProxyRecipients = StreamUtil.readBoolean(is);
            if (hasProxyRecipients) {
                this.m_replicatedProxyingRecipients = this.readClients(is, ht, vers);
            }
            this.m_msg = MgramSerializer.getMgramSerializer().unserialize(is, true);
            this.m_tracking = this.m_msg.getGuarenteedTrackingNum();
            this.m_jmsredelivery = StreamUtil.readBoolean(is);
            if (!ht.isEmpty()) {
                this.m_msg.getBrokerHandle().setSubjectFilters(ht);
            }
        }

        private void writeClients(FastVector clients, OutputStream os) throws IOException {
            StreamUtil.writeInt(clients.m_count, os);
            for (int i = 0; i < clients.m_count; ++i) {
                IClientContext cc = (IClientContext)clients.m_data[i];
                StreamUtil.writeLong(cc.getId(), os);
                StreamUtil.writeLong(cc.maxDeletedMsgId(), os);
                Collection undelSubjectIds = BrokerDatabase.retrieveUndelSubjectIds(cc.getId(), this.m_msg.getSubject(), this.m_msg.getBrokerHandle().getSubjectFilters());
                this.writeUndelSubjectIds(os, undelSubjectIds);
            }
        }

        private void writeReplicatedClients(BrokerDatabase.UndelClientInfo[] clients, OutputStream os) throws IOException {
            StreamUtil.writeInt(clients.length, os);
            for (int i = 0; i < clients.length; ++i) {
                BrokerDatabase.UndelClientInfo ci = clients[i];
                StreamUtil.writeLong(ci.m_cid, os);
                StreamUtil.writeLong(ci.m_maxDelMessageId, os);
                Collection undelSubjectIds = BrokerDatabase.retrieveUndelSubjectIds(ci.m_cid, this.m_msg.getSubject(), this.m_msg.getBrokerHandle().getSubjectFilters());
                this.writeUndelSubjectIds(os, undelSubjectIds);
            }
        }

        private void write1Client(IClientContext cc, OutputStream os) throws IOException {
            StreamUtil.writeLong(cc.getId(), os);
            Collection undelSubjectIds = BrokerDatabase.retrieveUndelSubjectIds(cc.getId(), this.m_msg.getSubject(), this.m_msg.getBrokerHandle().getSubjectFilters());
            this.writeUndelSubjectIds(os, undelSubjectIds);
        }

        private void write1ReplicatedClient(long cid, OutputStream os) throws IOException {
            StreamUtil.writeLong(cid, os);
            Collection undelSubjectIds = BrokerDatabase.retrieveUndelSubjectIds(cid, this.m_msg.getSubject(), this.m_msg.getBrokerHandle().getSubjectFilters());
            this.writeUndelSubjectIds(os, undelSubjectIds);
        }

        private void writeUndelSubjectIds(OutputStream os, Collection undelSubjectIds) throws IOException {
            StreamUtil.writeBoolean(undelSubjectIds != null, os);
            if (undelSubjectIds != null) {
                StreamUtil.writeInt(undelSubjectIds.size(), os);
                Iterator itr = undelSubjectIds.iterator();
                while (itr.hasNext()) {
                    StreamUtil.writeShort((Short)itr.next(), os);
                }
            }
        }

        private BrokerDatabase.UndelClientInfo[] readClients(InputStream is, LongHashTable ht, byte version) throws IOException {
            int size = StreamUtil.readInt(is);
            BrokerDatabase.UndelClientInfo[] cinfo = new BrokerDatabase.UndelClientInfo[size];
            for (int count = 0; count < size; ++count) {
                boolean hasUndelSubjectIds;
                BrokerDatabase.UndelClientInfo ci = new BrokerDatabase.UndelClientInfo();
                ci.m_cid = StreamUtil.readLong(is);
                ci.m_maxDelMessageId = StreamUtil.readLong(is);
                cinfo[count] = ci;
                if (version < 1 || !(hasUndelSubjectIds = StreamUtil.readBoolean(is))) continue;
                HashSet ids = this.cloneSzUndelSubjIds(is);
                ht.put(ci.m_cid, new TrackedSubjectFilter(ids));
            }
            return cinfo;
        }

        private Long readClient(InputStream is, LongHashTable ht, byte version) throws IOException {
            boolean hasUndelSubjectIds;
            long cid = StreamUtil.readLong(is);
            if (version >= 1 && (hasUndelSubjectIds = StreamUtil.readBoolean(is))) {
                HashSet ids = this.cloneSzUndelSubjIds(is);
                ht.put(cid, new TrackedSubjectFilter(ids));
            }
            return new Long(cid);
        }

        private HashSet cloneSzUndelSubjIds(InputStream is) throws IOException {
            int szUndelSubjIds = StreamUtil.readInt(is);
            HashSet<Short> ids = new HashSet<Short>(szUndelSubjIds);
            for (int i = 0; i < szUndelSubjIds; ++i) {
                ids.add(new Short(StreamUtil.readShort(is)));
            }
            return ids;
        }

        @Override
        public boolean hasFTMetaState() {
            return true;
        }

        @Override
        public void updateFTMetaState(IFTEventProcessor ft) throws InterruptedException {
            if (this.m_replicatedRecipients != null) {
                int size = this.m_replicatedRecipients.length;
                if (this.m_replicatedProxyingRecipients != null) {
                    size += this.m_replicatedProxyingRecipients.length;
                }
                long[] ids = new long[size];
                this.addIds(ids, this.m_replicatedRecipients, 0);
                if (this.m_replicatedProxyingRecipients != null) {
                    this.addIds(ids, this.m_replicatedProxyingRecipients, this.m_replicatedRecipients.length);
                }
                MsgSaveEvt msdEvt = new MsgSaveEvt(this.m_msg.getGuarenteedTrackingNum(), ids);
                ft.addEventNoLog(msdEvt);
            } else if (this.m_replicatedProxyingRecipients != null) {
                int size = this.m_replicatedProxyingRecipients.length;
                long[] ids = new long[++size];
                ids[0] = this.m_msg.getGuarenteedTrackingNum();
                this.addIds(ids, this.m_replicatedProxyingRecipients, 1);
                MsgSaveEvt msdEvt = new MsgSaveEvt(this.m_msg.getGuarenteedTrackingNum(), ids);
                ft.addEventNoLog(msdEvt);
            } else {
                MsgSaveEvt msdEvt = new MsgSaveEvt(this.m_msg.getGuarenteedTrackingNum(), this.m_replicatedRecipient);
                ft.addEventNoLog(msdEvt);
            }
        }

        private void addIds(long[] targetIds, BrokerDatabase.UndelClientInfo[] sourceIds, int offset) {
            for (int count = 0; count < sourceIds.length; ++count) {
                targetIds[count + offset] = sourceIds[count].m_cid;
            }
        }
    }
}

