/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Iterator;
import progress.message.msg.IMgram;
import progress.message.util.MemoryUtil;

public class OffloadedPubSubMessage {
    private static final int s_OffloadedPubSubMessageSize = MemoryUtil.estimateBaseSize(OffloadedPubSubMessage.class);
    private long m_tracking;
    private long[] m_trackingNums = null;
    private int m_batchSize;
    private int m_trackedSize;
    private int[] m_trackedSizes = null;
    private long m_msgSaverOpIndx;
    private int m_memorySize = 0;
    private boolean m_guaranteed = false;
    private long m_senderID = -1L;
    private byte m_priority;

    OffloadedPubSubMessage(IMgram message, long msgSaverOpIndx) {
        this.repopulate(message, msgSaverOpIndx);
    }

    final synchronized void repopulate(IMgram message, long msgSaverOpIndx) {
        if (message.getType() != 27) {
            this.m_tracking = message.getBrokerHandle().getDbTracking();
            this.m_guaranteed = message.isGuarenteed();
            this.m_batchSize = 1;
            this.m_trackingNums = null;
            this.m_trackedSize = message.getBrokerHandle().getTrackedSize();
        } else {
            Iterator iter = message.getBatchHandle().getBatchIterator();
            IMgram subMgram = null;
            boolean firstSubMgram = true;
            int ii = 0;
            this.m_batchSize = message.getBatchHandle().getBatchSize();
            this.m_trackingNums = null;
            if (this.m_batchSize > 1) {
                this.m_trackedSizes = new int[this.m_batchSize];
            }
            while (iter.hasNext()) {
                subMgram = (IMgram)iter.next();
                if (this.m_batchSize > 1) {
                    this.m_trackedSizes[ii] = subMgram.getBrokerHandle().getTrackedSize();
                }
                if (firstSubMgram) {
                    firstSubMgram = false;
                    this.m_tracking = subMgram.getBrokerHandle().getDbTracking();
                    this.m_guaranteed = subMgram.isGuarenteed();
                    if (this.m_batchSize == 1) {
                        this.m_trackedSize = subMgram.getBrokerHandle().getTrackedSize();
                    }
                } else if (this.m_trackingNums == null) {
                    if ((this.m_tracking + (long)ii & 0xFFFFFFFFFFFFL) != subMgram.getBrokerHandle().getDbTracking()) {
                        this.m_trackingNums = new long[this.m_batchSize];
                        for (int jj = 0; jj < ii; ++jj) {
                            this.m_trackingNums[jj] = this.m_tracking + (long)jj & 0xFFFFFFFFFFFFL;
                        }
                        this.m_trackingNums[ii] = subMgram.getBrokerHandle().getDbTracking();
                    }
                } else {
                    this.m_trackingNums[ii] = subMgram.getBrokerHandle().getDbTracking();
                }
                ++ii;
            }
        }
        this.m_msgSaverOpIndx = msgSaverOpIndx;
        this.m_memorySize = message.memoryLength();
        this.m_senderID = message.getBrokerHandle().getSenderID();
        this.m_priority = message.getPriority();
    }

    int memoryLength() {
        int result = s_OffloadedPubSubMessageSize;
        if (this.m_trackingNums != null) {
            result += this.m_trackingNums.length * 8;
        }
        if (this.m_trackedSizes != null) {
            result += this.m_trackedSizes.length * 4;
        }
        return result;
    }

    public void cleanup() {
        this.m_tracking = 0L;
        this.m_trackingNums = null;
        this.m_batchSize = 0;
        this.m_trackedSize = 0;
        this.m_trackedSizes = null;
        this.m_msgSaverOpIndx = 0L;
        this.m_memorySize = 0;
        this.m_guaranteed = false;
        this.m_senderID = -1L;
        this.m_priority = 0;
    }

    public long getTracking() {
        return this.m_tracking;
    }

    public long[] getTrackingNums() {
        return this.m_trackingNums;
    }

    public int getBatchSize() {
        return this.m_batchSize;
    }

    public int getTrackedSize() {
        return this.m_trackedSize;
    }

    public int[] getTrackedSizes() {
        return this.m_trackedSizes;
    }

    public long getMsgSaverOpIndx() {
        return this.m_msgSaverOpIndx;
    }

    public int getMemorySize() {
        return this.m_memorySize;
    }

    public boolean isGuaranteed() {
        return this.m_guaranteed;
    }

    public long getSenderID() {
        return this.m_senderID;
    }

    public byte getPriority() {
        return this.m_priority;
    }
}

