/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.IOException;
import java.util.ArrayList;
import progress.message.broker.Config;
import progress.message.broker.FlowControlSender;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.IClientContext;
import progress.message.zclient.FastVector;
import progress.message.zclient.SessionConfig;

public abstract class PublishLimiter {
    protected static FlowControlSender s_flowSender;
    private static final Integer[] PRIORITIES;
    private static final IClientContext[] EMPTY_CLIENTCONTEXT_ARRAY;
    private int m_minPublishPriority = 0;
    private FastVector m_subscribers = new FastVector();
    private FastVector m_minPriorities = new FastVector();
    private boolean m_reinstateMinPublishPriority = false;

    protected static Integer[] getPrioritites() {
        return PRIORITIES;
    }

    public abstract IClientContext getPublisherCC();

    public abstract boolean isPublisherAdminClient();

    public abstract void sendFlowControl(int var1);

    public static FlowControlSender getFlowControlSender() {
        return s_flowSender;
    }

    int getMinPublishPriority() {
        return this.m_minPublishPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateUnblockedEvent(String connectID) throws IOException {
        IClientContext pub = this.getPublisherCC();
        if (pub != null) {
            PublishLimiter publishLimiter = this;
            synchronized (publishLimiter) {
                BrokerManagementNotificationsHelper.sendFlowControlPubResumeNotification(Config.BROKER_NAME, pub, connectID);
            }
        }
    }

    void generateUnblockedEvent() throws IOException {
        IClientContext pub = this.getPublisherCC();
        if (pub != null) {
            this.generateUnblockedEvent(SessionConfig.getConnectIDFromSessionAppID(pub.getAppid()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBlockedEvent(int publisherMinPriority, String connectID) throws IOException {
        IClientContext pub = this.getPublisherCC();
        if (pub == null) {
            return;
        }
        PublishLimiter publishLimiter = this;
        synchronized (publishLimiter) {
            ArrayList blockingDurableSubs = new ArrayList();
            ArrayList blockingNondurableSubs = new ArrayList();
            this.addBlockingSubscribers(publisherMinPriority, blockingDurableSubs, blockingNondurableSubs);
            BrokerManagementNotificationsHelper.sendFlowControlPubPauseNotification(Config.BROKER_NAME, pub, connectID, blockingDurableSubs.toArray(EMPTY_CLIENTCONTEXT_ARRAY), blockingNondurableSubs.toArray(EMPTY_CLIENTCONTEXT_ARRAY));
        }
    }

    void generateBlockedEvent(int publisherMinPriority) throws IOException {
        IClientContext pub = this.getPublisherCC();
        if (pub != null) {
            this.generateBlockedEvent(publisherMinPriority, SessionConfig.getConnectIDFromSessionAppID(pub.getAppid()));
        }
    }

    synchronized void addSubscriber(IClientContext subscriber, int prio) {
        this.m_subscribers.addElement(subscriber);
        this.m_minPriorities.addElement(PRIORITIES[prio]);
        if (prio > this.m_minPublishPriority) {
            this.m_minPublishPriority = prio;
            s_flowSender.sendFlowControl(this, PRIORITIES[prio]);
        }
    }

    synchronized void setReinstateMinPublishPriority(boolean b) {
        this.m_reinstateMinPublishPriority = b;
    }

    synchronized void reinstateMinPublishPriority(IClientContext subscriber, int prio) {
        if (!this.m_reinstateMinPublishPriority) {
            return;
        }
        int i = this.findSubscriberIndex(subscriber);
        if (i != this.m_subscribers.m_count) {
            this.m_minPriorities.m_data[i] = PRIORITIES[prio];
            if (prio > this.m_minPublishPriority) {
                this.m_minPublishPriority = prio;
            }
            s_flowSender.sendFlowControl(this, PRIORITIES[this.m_minPublishPriority]);
            this.m_reinstateMinPublishPriority = false;
        }
    }

    protected synchronized void subscriberPrioChange(IClientContext subscriber, int prio) {
        boolean recalcMin;
        int i = this.findSubscriberIndex(subscriber);
        if (i == this.m_subscribers.m_count) {
            return;
        }
        boolean bl = recalcMin = (Integer)this.m_minPriorities.m_data[i] == this.m_minPublishPriority;
        if (prio == 0) {
            this.m_subscribers.removeElementAt(i);
            this.m_minPriorities.removeElementAt(i);
        } else {
            this.m_minPriorities.m_data[i] = PRIORITIES[prio];
        }
        if (recalcMin) {
            int newmin = 0;
            for (int j = 0; j < this.m_minPriorities.m_count; ++j) {
                newmin = Math.max(newmin, (Integer)this.m_minPriorities.m_data[j]);
            }
            if (newmin != this.m_minPublishPriority) {
                GroupSubscriptionClientContext groupcc;
                this.m_minPublishPriority = newmin;
                s_flowSender.sendFlowControl(this, PRIORITIES[newmin]);
                if (subscriber.isGroupSubscriptionMember() && (groupcc = subscriber.getGroupSubscriptionCC()) != null) {
                    groupcc.notifyGroupRestoreThreads();
                }
            }
        }
    }

    private int findSubscriberIndex(IClientContext subscriber) {
        int i;
        for (i = 0; i < this.m_subscribers.m_count && this.m_subscribers.m_data[i] != subscriber; ++i) {
        }
        return i;
    }

    public synchronized ArrayList getBlockingSubscribers() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.m_minPublishPriority > 0) {
            for (int i = 0; i < this.m_subscribers.m_count; ++i) {
                if (this.m_minPriorities.m_data[i] != PRIORITIES[this.m_minPublishPriority]) continue;
                result.add(this.m_subscribers.m_data[i]);
            }
        }
        return result;
    }

    public synchronized void addBlockingSubscribers(int publisherMinPriority, ArrayList durCCs, ArrayList nondurCCs) {
        for (int i = 0; i < this.m_subscribers.m_count; ++i) {
            if (this.m_minPriorities.m_data[i] != PRIORITIES[publisherMinPriority]) continue;
            IClientContext sub = (IClientContext)this.m_subscribers.m_data[i];
            if (sub.isDurable()) {
                durCCs.add(sub);
                continue;
            }
            nondurCCs.add(sub);
        }
    }

    static {
        PRIORITIES = new Integer[13];
        EMPTY_CLIENTCONTEXT_ARRAY = new IClientContext[0];
        for (int i = 0; i <= 12; ++i) {
            PublishLimiter.PRIORITIES[i] = new Integer(i);
        }
        s_flowSender = new FlowControlSender();
        s_flowSender.start();
    }
}

